/* This file is part of libccc
 *
 * AUTHORS
 *     Sven Herzberg  <herzi@gnome-de.org>
 *
 * Copyright (C) 2007  Sven Herzberg
 *
 * This work is provided "as is"; redistribution and modification
 * in whole or in part, in any medium, physical or electronic is
 * permitted without restriction.
 *
 * This work is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * In no event shall the authors or contributors be liable for any
 * direct, indirect, incidental, special, exemplary, or consequential
 * damages (including, but not limited to, procurement of substitute
 * goods or services; loss of use, data, or profits; or business
 * interruption) however caused and on any theory of liability, whether
 * in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even
 * if advised of the possibility of such damage.
 */

#define G_LOG_DOMAIN "TestCcc"

#include "s-item-view.h"

#include <ccc/cc-item-view.h>
#include "mock-logger.h"

/* snip: CcItemViewImpl */
typedef GObject      CcItemViewImpl;
typedef GObjectClass CcItemViewImplClass;

GType cc_item_view_impl_get_type (void);

static void cc_item_view_impl (CcItemViewIface* iface);
G_DEFINE_TYPE_WITH_CODE (CcItemViewImpl, cc_item_view_impl, G_TYPE_OBJECT,
			 G_IMPLEMENT_INTERFACE (CC_TYPE_ITEM_VIEW, cc_item_view_impl));

static void
cc_item_view_impl_init (CcItemViewImpl* self) {}

static void
cc_item_view_impl_class_init (CcItemViewImplClass* self_class) {}

static void
item_view_impl_item_added (CcItemView* self,
			   CcItem    * parent,
			   gint        position,
			   CcItem    * child)
{
	g_message ("item_added (%p, %p, %d, %p)",
		   self, parent, position, child);
}

static void
cc_item_view_impl (CcItemViewIface* iface)
{
	iface->item_added = item_view_impl_item_added;
}
/* snap: CcItemViewImpl */

static GLogFunc log_func = NULL;

START_TEST(test_clean_implementation)
{
	/* prepare */
	gboolean passed;
	log_func = g_log_set_default_handler (mock_logger_log_fail, &passed);

	/* check */
	passed = TRUE;
	cc_item_view_impl_get_type ();
	fail_unless (passed);

	/* cleanup */
	g_log_set_default_handler (log_func, NULL);
}
END_TEST

START_TEST(test_no_children)
{
	/* prepare */
	gboolean implemented = FALSE;

	/* check */
	fail_unless (implemented);

	/* cleanup */
	/* FIXME */
}
END_TEST

START_TEST(test_one_level)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);
	/* FIXME */
}
END_TEST

START_TEST(test_no_recurse)
{
	gboolean implemented = FALSE;
	fail_unless (implemented);
	/* FIXME */
}
END_TEST

TCase*
tcase_item_view_added (void)
{
	TCase* self = tcase_create ("CcViewWidget::item_added");
	tcase_add_test (self, test_clean_implementation);
	tcase_add_test (self, test_no_children);
	tcase_add_test (self, test_one_level);
	tcase_add_test (self, test_no_recurse);
	return self;
}

