/* -*- mode: C; c-file-style: "gnu" -*- */
/*
 * Copyright (C) 2003 Richard Hult <richard@imendio.com>
 * Copyright (C) 2003 Johan Dahlin <jdahlin@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gtk/gtkmain.h>
#include <libgnome/gnome-init.h>
#include <libgnome/gnome-i18n.h>
#include <libgnomeui/gnome-ui-init.h>
#include <gconf/gconf-client.h>
#include <gst/gst.h>
#include "main-window.h"
#include "query.h"
#include "song-db.h"
#include "stock-icons.h"
#include "utils.h"


GConfClient *gconf_client;
gboolean disable_gst;

static void
ensure_dir (void)
{
  char *dir;

  dir = g_build_filename (g_get_home_dir (), ".gnome2", NULL);

  if (!g_file_test (dir, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR))
    mkdir (dir, 0755);
  g_free (dir);

  dir = g_build_filename (g_get_home_dir (), ".gnome2", "jamboree", NULL);

  if (!g_file_test (dir, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_DIR))
    mkdir (dir, 0755);
  g_free (dir);
  
  dir = g_build_filename (g_get_home_dir (), ".gnome2", "jamboree",
			  "playlists.xml", NULL);

  if (!g_file_test (dir, G_FILE_TEST_EXISTS))
    query_create_default_queries ();
  
  g_free (dir);
}

int
main (int argc, char **argv)
{
  SongDB *db;
  GtkWidget *window;
  char *filename;

  bindtextdomain (GETTEXT_PACKAGE, JAMBOREE_LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  g_random_set_seed (time (NULL));
  
  gtk_init (&argc, &argv);

  stock_icons_register ();

  disable_gst = (g_getenv ("DISABLE_GST") != NULL);
  
  /* To run with valgrind. */
  if (!disable_gst)
    {
      /* Disable annoying gstreamer spew :) */
      gst_info_set_categories (GST_CAT_GST_INIT);
      gst_init (&argc, &argv);
      gst_scheduler_factory_set_default_name ("opt");
    }
      
  ensure_dir ();
    
  if (argc > 1 && g_str_has_suffix (argv[1], ".db"))
    filename = g_strdup (argv[1]);
  else
    filename = g_build_filename (g_get_home_dir (),
				 ".gnome2", "jamboree", "songs.db",
				 NULL);

  db = song_db_new (filename);
  if (!db)
    {
      g_warning ("File \"%s\" not found.", filename);
      return 1;
    }

  if (song_db_get_version (db) < SONG_DB_VERSION)
    {
      /*g_print (_("Database format changed. Reading files...\n"));*/
      song_db_rebuild (db);
      song_db_set_version (db, SONG_DB_VERSION);
    }

  song_db_read_songs (db);
  
  /*song_db_dump (db);*/
  g_free (filename);

  gconf_client = gconf_client_get_default ();
  gconf_client_add_dir (gconf_client, GCONF_PATH,
			GCONF_CLIENT_PRELOAD_ONELEVEL,
			NULL);

  window = main_window_new (db);

  gtk_window_set_default_size (GTK_WINDOW (window), 800, 600);
  gtk_widget_show (window);

  gtk_main ();

  g_object_unref (gconf_client);
  
  return 0;
}
