/* -*- tab-width: 4; c-basic-offset: 4 -*- */

/* Mode of a page-cache with no data */

// FIXME: just have a list of block -> bool for now.

using System;
using System.Collections.Generic;
using FS;

public class BIO
{
    SimEvent  ev;
    DiskModel disk;
    FSModel   fsModel;
    SimProcess proc;
    struct Vec {
        public long BlkStart;
        public long BlkLen;
    }
    List<Vec> ioVec;

    public BIO(SimProcess proc, FSModel fsModel, DiskModel disk, SimEvent ev)
    {
        this.proc = proc;
        this.fsModel = fsModel;
        this.disk = disk;
        this.ev = ev;
        Clear();
    }
    // very noddy coalescing
    public void AddBlk (long fsBlk)
    {
        int diskBlksPerFsBlk = (this.fsModel.BlockSize / this.disk.SectorSize);
        long diskBlk = fsBlk * diskBlksPerFsBlk;

//        Console.WriteLine ("AddFsBlk 0x{0:x}", fsBlk);

        int last = this.ioVec.Count - 1;
        if (last >= 0 &&
            this.ioVec [last].BlkStart + this.ioVec[last].BlkLen == diskBlk) {
            Vec v = this.ioVec[last];
            v.BlkLen += diskBlksPerFsBlk;
            this.ioVec[last] = v;
        } else {
            Vec v = new Vec();
            v.BlkStart = diskBlk;
            v.BlkLen = diskBlksPerFsBlk;
            this.ioVec.Add (v);
        }
    }
    public void Clear()
    {
        this.ioVec = new List<Vec>();
    }

    public void Submit ()
    {
        PageCache pc = this.proc.PageCache;

        foreach (Vec v in this.ioVec) {
            // FIXME: of course this only elides missing leading data,
            //        not internal holes ... ;-)
            // This is a mess ...
            long start = v.BlkStart;
            int i, count = (int)v.BlkLen;
            for (i = 0; i < count; i++) {
                if (!pc.HasBlock (start + i)) {
//                    Console.WriteLine ("blk 0x{0:x} not in cache", (start+i));
                    break;
                }
            }
            count -= i;
            start += i;
            if (count == 0)
                continue;
            // end mess ...

            // FIXME: tweakable - read ahead 64k ...
            // q->backing_dev_info.ra_pages = (VM_MAX_READAHEAD * 1024) / PAGE_CACHE_SIZE; ?
            {
                int ncount = Math.Max (64 * 1024 / this.disk.SectorSize, count);
//                if (ncount > count)
//                    Console.WriteLine ("Grow io " + count + " -> " + ncount);
                count = ncount;
            }
            this.disk.ReadBlocks (this.proc, ev, start, count);

            { // FIXME: hmm - stay in fsblocks until later ? ... -> disk ?
                int diskBlksPerFsBlk = (this.fsModel.BlockSize / this.disk.SectorSize);
                this.proc.AddBlocks (ev, start/diskBlksPerFsBlk, count/diskBlksPerFsBlk);
            }

            for (i = 0; i < count; i++) {
                pc.AddBlock (start + i);
//                Console.WriteLine ("add blk 0x{0:x} to cache", (start+i));
            }
        }
    }
    public int FSBlockSize { get { return this.fsModel.BlockSize; } }
}

public class PageCache
{
    int pageSize;

    public int PageSize { get { return this.pageSize; } }

    public PageCache (int pageSize)
    {
        // FIXME we have infinite memory so far ...
        this.cache = new Dictionary<long, bool>();
        this.pageSize = pageSize;
    }

    // This is a sector, not page cache (for now)
    Dictionary<long, bool> cache;
    public bool HasBlock (long blkId)
    {
        return this.cache.ContainsKey (blkId);
    }
    public void AddBlock (long blkId)
    {
        this.cache[blkId] = true;
    }

    public delegate bool GetBlock (BIO bio, File fi, long blkInFile);

    public void ReadPages (BIO bio, File fi, GetBlock fnGetBlock,
                           long pageOffset, long pageCount)
    {
        int fsBlksPerPage = this.pageSize / bio.FSBlockSize;
        long fsBlkPos = pageOffset * fsBlksPerPage;
//        Console.WriteLine("Read " + pageCount + " pages from " + fi.GetPath() + " at "
//                          + pageOffset + " -> " + fsBlkPos + " blksperpage " + fsBlksPerPage);
        for (int i = 0; i < pageCount; i++) {
            for (int j = 0; j < fsBlksPerPage; j++) {
                if (!fnGetBlock (bio, fi, fsBlkPos))
                    Console.WriteLine("read over the end of file " + fi.Name);
                fsBlkPos++;
            }
        }
        bio.Submit ();
    }

    // FIXME: understand how the page cache handles inode &
    // indirect block caching.
    public void ReadINode (BIO bio, File fi)
    {
        bio.AddBlk (fi.INodeBlock);
        bio.Submit();
    }
}
