/* Hipo - iPod management tool
 *
 * Pedro Villavicencio Garrido <pvillavi@gnome.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * (C) Copyright 2006 Pedro Villavicencio Garrido <pvillavi@gnome.org>.
 */


using System;
using System.IO;
using System.Threading;
using TagLib;
using IPod;
using Gtk;
using Gnome.Vfs;
using Mono.Unix;

namespace Hipo
{
	public class TracksView
	{
		private Gtk.ListStore store;
		
		public TracksView ()
		{
			store = new Gtk.ListStore (typeof (string), typeof (string),
						   typeof (string), typeof (string),
						   typeof (long));

			store.SetSortFunc (0, StoreSortFunc);
			store.SetSortColumnId (0, SortType.Ascending);
		}

		public Gtk.ListStore GetModel ()
		{
			return this.store;
		}

		private int StoreSortFunc (TreeModel model, TreeIter a, TreeIter b)
		{
			string artista = (string) store.GetValue (a, 0);
			string artistb = (string) store.GetValue (b, 0);
			
			return String.Compare(artista.ToLower(), artistb.ToLower ());
		}
		
		public void AddTrackToStore (Track track)
		{
			Gtk.Application.Invoke (delegate {
					store.AppendValues (track.Artist, track.Album,
							    track.Title, track.Genre,
							    track.Id);
				});
		}
		
		public void AddTrack (TrackDatabase db, string path)
		{
			TagLib.File file = TagLib.File.Create (path);

			Track track = db.CreateTrack ();

			if ((file.Tag.FirstArtist == null) || (file.Tag.Title == String.Empty))
				track.Artist = "Unknown";
			else
				track.Artist = file.Tag.FirstArtist;

			if ((file.Tag.Title == null) || (file.Tag.Title == String.Empty))
				track.Title = "Unknown";
			else
				track.Title = file.Tag.Title;

			if ((file.Tag.Album == null) || (file.Tag.Title == String.Empty))
				track.Album = "Unknown";
			else
				track.Album = file.Tag.Album;

			if ((file.Tag.FirstGenre == null) || (file.Tag.FirstGenre == String.Empty))
				track.Genre = "Unknown";
			else
				track.Genre = file.Tag.FirstGenre;
			
			track.FileName = path;
			track.Duration = file.AudioProperties.Duration;
			track.TrackNumber = (int) file.Tag.Track;

			lock (db)
			{
				db.Save ();
			}

			AddTrackToStore (track);
		}

		public void AddFolder (TrackDatabase db, string[] dirs)
		{
			foreach (string path in dirs)
			{
				System.Uri uri = new System.Uri (path);

				UnixDirectoryInfo info = new UnixDirectoryInfo (uri.LocalPath);
				foreach (UnixFileSystemInfo file in info.GetFileSystemEntries ())
				{
					if (!file.IsDirectory) {
						string ext = Path.GetExtension (file.FullName);

						if ((ext.ToLower () == ".mp3") || (ext.ToLower () == ".mp4")) {
							AddTrack (db, file.FullName);
						}
						else {
							// FIXME.
							Console.WriteLine (file.FullName);
						}
					}
				}
			}
		}

		public bool RemoveTracks (TrackDatabase db, long tracksId, Gtk.TreeIter iter)
		{
			foreach (Track track in db.Tracks)
			{
				if (track.Id == tracksId) {
					db.RemoveTrack (track);

					lock (db) {
						db.Save ();
					}
					
					this.store.Remove (ref iter);
					return true;
				}
			}

			return false;
		}

		public Track GetTrackbyId (TrackDatabase db, long trackId)
		{
			 foreach (Track track in db.Tracks)
			 {
				 if (track.Id == trackId)
					 return track;
			 }

			 return null;
		}
	}
}