/* SerializableObjectModel.c generated by valac 0.28.1, the Vala compiler
 * generated from SerializableObjectModel.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 0; tab-width: 2 -*- */
/* ObjectModel.vala
 *
 * Copyright (C) 2013-2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_ATTRIBUTE (gxml_attribute_get_type ())
#define GXML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttribute))
#define GXML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTRIBUTE))
#define GXML_ATTRIBUTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttributeIface))

typedef struct _GXmlAttribute GXmlAttribute;
typedef struct _GXmlAttributeIface GXmlAttributeIface;

#define GXML_TYPE_SERIALIZABLE_OBJECT_MODEL (gxml_serializable_object_model_get_type ())
#define GXML_SERIALIZABLE_OBJECT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel))
#define GXML_SERIALIZABLE_OBJECT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelClass))
#define GXML_IS_SERIALIZABLE_OBJECT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL))
#define GXML_IS_SERIALIZABLE_OBJECT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL))
#define GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelClass))

typedef struct _GXmlSerializableObjectModel GXmlSerializableObjectModel;
typedef struct _GXmlSerializableObjectModelClass GXmlSerializableObjectModelClass;
typedef struct _GXmlSerializableObjectModelPrivate GXmlSerializableObjectModelPrivate;

#define GXML_TYPE_TW_NODE (gxml_tw_node_get_type ())
#define GXML_TW_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TW_NODE, GXmlTwNode))
#define GXML_TW_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_TW_NODE, GXmlTwNodeClass))
#define GXML_IS_TW_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TW_NODE))
#define GXML_IS_TW_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_TW_NODE))
#define GXML_TW_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_TW_NODE, GXmlTwNodeClass))

typedef struct _GXmlTwNode GXmlTwNode;
typedef struct _GXmlTwNodeClass GXmlTwNodeClass;

#define GXML_TYPE_TW_DOCUMENT (gxml_tw_document_get_type ())
#define GXML_TW_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TW_DOCUMENT, GXmlTwDocument))
#define GXML_TW_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_TW_DOCUMENT, GXmlTwDocumentClass))
#define GXML_IS_TW_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TW_DOCUMENT))
#define GXML_IS_TW_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_TW_DOCUMENT))
#define GXML_TW_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_TW_DOCUMENT, GXmlTwDocumentClass))

typedef struct _GXmlTwDocument GXmlTwDocument;
typedef struct _GXmlTwDocumentClass GXmlTwDocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ELEMENT, GXmlElementIface))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementIface GXmlElementIface;
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

#define GXML_TYPE_TEXT (gxml_text_get_type ())
#define GXML_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TEXT, GXmlText))
#define GXML_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TEXT))
#define GXML_TEXT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_TEXT, GXmlTextIface))

typedef struct _GXmlText GXmlText;
typedef struct _GXmlTextIface GXmlTextIface;

#define GXML_TYPE_SERIALIZABLE_PROPERTY (gxml_serializable_property_get_type ())
#define GXML_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty))
#define GXML_IS_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY))
#define GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializablePropertyIface))

typedef struct _GXmlSerializableProperty GXmlSerializableProperty;
typedef struct _GXmlSerializablePropertyIface GXmlSerializablePropertyIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GXML_TYPE_SERIALIZABLE_CONTAINER (gxml_serializable_container_get_type ())
#define GXML_SERIALIZABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainer))
#define GXML_SERIALIZABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainerClass))
#define GXML_IS_SERIALIZABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER))
#define GXML_IS_SERIALIZABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_CONTAINER))
#define GXML_SERIALIZABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainerClass))

typedef struct _GXmlSerializableContainer GXmlSerializableContainer;
typedef struct _GXmlSerializableContainerClass GXmlSerializableContainerClass;

#define GXML_TYPE_SERIALIZABLE_COLLECTION (gxml_serializable_collection_get_type ())
#define GXML_SERIALIZABLE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION, GXmlSerializableCollection))
#define GXML_IS_SERIALIZABLE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION))
#define GXML_SERIALIZABLE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION, GXmlSerializableCollectionIface))

typedef struct _GXmlSerializableCollection GXmlSerializableCollection;
typedef struct _GXmlSerializableCollectionIface GXmlSerializableCollectionIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (GXmlNamespace* self);
	const gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_X_UNKNOWN = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_childs) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	const gchar* (*get_name) (GXmlNode* self);
	const gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
};

struct _GXmlAttributeIface {
	GTypeInterface parent_iface;
};

struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializable* self);
	gboolean (*set_namespace) (GXmlSerializable* self, GXmlNode* node);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializable* self);
	gchar* (*node_name) (GXmlSerializable* self);
	gboolean (*property_use_nick) (GXmlSerializable* self);
	GXmlNode* (*serialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializable* self, GXmlNode* element, GParamSpec* prop, GError** error);
	GXmlNode* (*deserialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializable* self, GXmlNode* property_node, GError** error);
	GParamSpec* (*find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec* (*default_find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	void (*init_properties) (GXmlSerializable* self);
	void (*default_init_properties) (GXmlSerializable* self);
	GParamSpec** (*list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GParamSpec** (*default_list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	void (*get_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*default_get_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*set_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*default_set_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	gboolean (*transform_from_string) (GXmlSerializable* self, const gchar* str, GValue* dest, GError** error);
	gboolean (*transform_to_string) (GXmlSerializable* self, GValue* val, gchar** str, GError** error);
	GParamSpec** (*get_properties) (GXmlSerializable* self, int* result_length1);
	void (*set_properties) (GXmlSerializable* self, GParamSpec** value, int value_length1);
	GHashTable* (*get_ignored_serializable_properties) (GXmlSerializable* self);
	void (*set_ignored_serializable_properties) (GXmlSerializable* self, GHashTable* value);
	GeeMap* (*get_unknown_serializable_properties) (GXmlSerializable* self);
	GeeCollection* (*get_unknown_serializable_nodes) (GXmlSerializable* self);
	const gchar* (*get_serialized_xml_node_value) (GXmlSerializable* self);
	void (*set_serialized_xml_node_value) (GXmlSerializable* self, const gchar* value);
};

struct _GXmlSerializableObjectModel {
	GObject parent_instance;
	GXmlSerializableObjectModelPrivate * priv;
	GXmlTwDocument* _doc;
};

struct _GXmlSerializableObjectModelClass {
	GObjectClass parent_class;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializableObjectModel* self);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializableObjectModel* self);
	gboolean (*property_use_nick) (GXmlSerializableObjectModel* self);
	gboolean (*set_namespace) (GXmlSerializableObjectModel* self, GXmlNode* node);
	gchar* (*node_name) (GXmlSerializableObjectModel* self);
	GParamSpec* (*find_property_spec) (GXmlSerializableObjectModel* self, const gchar* property_name);
	void (*init_properties) (GXmlSerializableObjectModel* self);
	GParamSpec** (*list_serializable_properties) (GXmlSerializableObjectModel* self, int* result_length1);
	void (*get_property_value) (GXmlSerializableObjectModel* self, GParamSpec* spec, GValue* val);
	void (*set_property_value) (GXmlSerializableObjectModel* self, GParamSpec* spec, GValue* val);
	gboolean (*transform_from_string) (GXmlSerializableObjectModel* self, const gchar* str, GValue* dest, GError** error);
	gboolean (*transform_to_string) (GXmlSerializableObjectModel* self, GValue* val, gchar** str, GError** error);
	GXmlNode* (*serialize) (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error);
	GXmlNode* (*deserialize) (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error);
	gchar* (*to_string) (GXmlSerializableObjectModel* self);
};

struct _GXmlSerializableObjectModelPrivate {
	GParamSpec** _properties;
	gint _properties_length1;
	gint __properties_size_;
	GHashTable* _ignored_serializable_properties;
	gchar* _serialized_xml_node_value;
};

struct _GXmlElementIface {
	GTypeInterface parent_iface;
	void (*normalize) (GXmlElement* self);
	void (*set_attr) (GXmlElement* self, const gchar* name, const gchar* value);
	GXmlNode* (*get_attr) (GXmlElement* self, const gchar* name);
	void (*finalize_attr) (GXmlElement* self);
	const gchar* (*get_tag_name) (GXmlElement* self);
	gchar* (*get_content) (GXmlElement* self);
	void (*set_content) (GXmlElement* self, const gchar* value);
};

struct _GXmlTextIface {
	GTypeInterface parent_iface;
	const gchar* (*get_str) (GXmlText* self);
};

struct _GXmlSerializablePropertyIface {
	GTypeInterface parent_iface;
	gchar* (*get_serializable_property_value) (GXmlSerializableProperty* self);
	void (*set_serializable_property_value) (GXmlSerializableProperty* self, const gchar* val);
	gboolean (*deserialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
};

typedef enum  {
	GXML_ENUMERATION_ERROR_INVALID_VALUE,
	GXML_ENUMERATION_ERROR_INVALID_TEXT
} GXmlEnumerationError;
#define GXML_ENUMERATION_ERROR gxml_enumeration_error_quark ()
struct _GXmlSerializableCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*is_collection) (GXmlSerializableCollection* self);
};

typedef enum  {
	GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR,
	GXML_SERIALIZABLE_ERROR_STR_TO_VALUE_ERROR
} GXmlSerializableError;
#define GXML_SERIALIZABLE_ERROR gxml_serializable_error_quark ()

static gpointer gxml_serializable_object_model_parent_class = NULL;
static GXmlSerializableIface* gxml_serializable_object_model_gxml_serializable_parent_iface = NULL;

GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_attribute_get_type (void) G_GNUC_CONST;
GType gxml_serializable_get_type (void) G_GNUC_CONST;
GType gxml_serializable_object_model_get_type (void) G_GNUC_CONST;
GType gxml_tw_node_get_type (void) G_GNUC_CONST;
GType gxml_tw_document_get_type (void) G_GNUC_CONST;
#define GXML_SERIALIZABLE_OBJECT_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelPrivate))
enum  {
	GXML_SERIALIZABLE_OBJECT_MODEL_DUMMY_PROPERTY,
	GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES,
	GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE,
	GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_PROPERTIES,
	GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_NODES
};
gboolean gxml_serializable_object_model_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self);
static gboolean gxml_serializable_object_model_real_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self);
static void gxml_serializable_object_model_init_unknown_doc (GXmlSerializableObjectModel* self);
GXmlTwDocument* gxml_tw_document_new (void);
GXmlTwDocument* gxml_tw_document_construct (GType object_type);
GXmlNode* gxml_document_create_element (GXmlDocument* self, const gchar* name);
GeeBidirList* gxml_tw_node_get_childs (GXmlTwNode* self);
gboolean gxml_serializable_object_model_serialize_use_xml_node_value (GXmlSerializableObjectModel* self);
static gboolean gxml_serializable_object_model_real_serialize_use_xml_node_value (GXmlSerializableObjectModel* self);
gboolean gxml_serializable_object_model_property_use_nick (GXmlSerializableObjectModel* self);
static gboolean gxml_serializable_object_model_real_property_use_nick (GXmlSerializableObjectModel* self);
gboolean gxml_serializable_object_model_set_namespace (GXmlSerializableObjectModel* self, GXmlNode* node);
static gboolean gxml_serializable_object_model_real_set_namespace (GXmlSerializableObjectModel* self, GXmlNode* node);
gchar* gxml_serializable_object_model_node_name (GXmlSerializableObjectModel* self);
static gchar* gxml_serializable_object_model_real_node_name (GXmlSerializableObjectModel* self);
gchar* gxml_serializable_object_model_default_node_name (GXmlSerializableObjectModel* self);
GParamSpec* gxml_serializable_object_model_find_property_spec (GXmlSerializableObjectModel* self, const gchar* property_name);
static GParamSpec* gxml_serializable_object_model_real_find_property_spec (GXmlSerializableObjectModel* self, const gchar* property_name);
GParamSpec* gxml_serializable_default_find_property_spec (GXmlSerializable* self, const gchar* property_name);
void gxml_serializable_object_model_init_properties (GXmlSerializableObjectModel* self);
static void gxml_serializable_object_model_real_init_properties (GXmlSerializableObjectModel* self);
void gxml_serializable_default_init_properties (GXmlSerializable* self);
GParamSpec** gxml_serializable_object_model_list_serializable_properties (GXmlSerializableObjectModel* self, int* result_length1);
static GParamSpec** gxml_serializable_object_model_real_list_serializable_properties (GXmlSerializableObjectModel* self, int* result_length1);
GParamSpec** gxml_serializable_default_list_serializable_properties (GXmlSerializable* self, int* result_length1);
void gxml_serializable_object_model_get_property_value (GXmlSerializableObjectModel* self, GParamSpec* spec, GValue* val);
static void gxml_serializable_object_model_real_get_property_value (GXmlSerializableObjectModel* self, GParamSpec* spec, GValue* val);
void gxml_serializable_default_get_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
void gxml_serializable_object_model_set_property_value (GXmlSerializableObjectModel* self, GParamSpec* spec, GValue* val);
static void gxml_serializable_object_model_real_set_property_value (GXmlSerializableObjectModel* self, GParamSpec* spec, GValue* val);
void gxml_serializable_default_set_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
gboolean gxml_serializable_object_model_transform_from_string (GXmlSerializableObjectModel* self, const gchar* str, GValue* dest, GError** error);
static gboolean gxml_serializable_object_model_real_transform_from_string (GXmlSerializableObjectModel* self, const gchar* str, GValue* dest, GError** error);
gboolean gxml_serializable_object_model_transform_to_string (GXmlSerializableObjectModel* self, GValue* val, gchar** str, GError** error);
static gboolean gxml_serializable_object_model_real_transform_to_string (GXmlSerializableObjectModel* self, GValue* val, gchar** str, GError** error);
GXmlNode* gxml_serializable_object_model_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
static GXmlNode* gxml_serializable_object_model_real_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
GType gxml_element_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_serializable_object_model_default_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
const gchar* gxml_node_get_name (GXmlNode* self);
GXmlDocument* gxml_node_get_document (GXmlNode* self);
GeeBidirList* gxml_node_get_childs (GXmlNode* self);
GXmlNode* gxml_serializable_object_model_serialize_property (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error);
GeeMap* gxml_serializable_get_unknown_serializable_properties (GXmlSerializable* self);
void gxml_element_set_attr (GXmlElement* self, const gchar* name, const gchar* value);
const gchar* gxml_node_get_value (GXmlNode* self);
GeeCollection* gxml_serializable_get_unknown_serializable_nodes (GXmlSerializable* self);
gboolean gxml_node_copy (GXmlDocument* doc, GXmlNode* node, GXmlNode* source, gboolean deep);
GType gxml_text_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_document_create_text (GXmlDocument* self, const gchar* text);
const gchar* gxml_serializable_get_serialized_xml_node_value (GXmlSerializable* self);
void gxml_element_set_content (GXmlElement* self, const gchar* value);
static GXmlNode* gxml_serializable_object_model_real_serialize_property (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error);
GXmlNode* gxml_serializable_object_model_default_serialize_property (GXmlSerializableObjectModel* self, GXmlElement* element, GParamSpec* prop, GError** error);
GType gxml_serializable_property_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_serializable_property_serialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
GXmlNode* gxml_serializable_serialize (GXmlSerializable* self, GXmlNode* node, GError** error);
gchar* gxml_enumeration_get_nick_camelcase (GType enumeration, gint val, GError** error);
GQuark gxml_enumeration_error_quark (void);
GXmlNode* gxml_element_get_attr (GXmlElement* self, const gchar* name);
void gxml_node_set_value (GXmlNode* self, const gchar* value);
GXmlNode* gxml_serializable_object_model_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
static GXmlNode* gxml_serializable_object_model_real_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
GXmlNode* gxml_serializable_object_model_default_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
GXmlNode* gxml_document_get_root (GXmlDocument* self);
GeeMap* gxml_node_get_attrs (GXmlNode* self);
gboolean gxml_serializable_object_model_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error);
GType gxml_serializable_container_get_type (void) G_GNUC_CONST;
void gxml_serializable_container_init_containers (GXmlSerializableContainer* self);
GType gxml_serializable_collection_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_serializable_deserialize (GXmlSerializable* self, GXmlNode* node, GError** error);
gchar* gxml_serializable_node_name (GXmlSerializable* self);
void gxml_serializable_set_serialized_xml_node_value (GXmlSerializable* self, const gchar* value);
static gboolean gxml_serializable_object_model_real_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error);
gboolean gxml_serializable_object_model_default_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error);
gboolean gxml_serializable_property_deserialize_property (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
GEnumValue* gxml_enumeration_parse (GType enumeration, const gchar* val, GError** error);
GQuark gxml_serializable_error_quark (void);
gboolean gxml_serializable_string_to_gvalue (const gchar* str, GValue* dest, GError** error);
gchar* gxml_serializable_object_model_to_string (GXmlSerializableObjectModel* self);
static gchar* gxml_serializable_object_model_real_to_string (GXmlSerializableObjectModel* self);
gboolean gxml_serializable_object_model_equals (GXmlSerializableObjectModel* a, GXmlSerializableObjectModel* b);
GParamSpec** gxml_serializable_list_serializable_properties (GXmlSerializable* self, int* result_length1);
GParamSpec* gxml_serializable_find_property_spec (GXmlSerializable* self, const gchar* property_name);
void gxml_serializable_get_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
static gboolean _g_value_equal (const GValue* s1, const GValue* s2);
GXmlSerializableObjectModel* gxml_serializable_object_model_construct (GType object_type);
static GParamSpec** _vala_array_dup4 (GParamSpec** self, int length);
static GObject * gxml_serializable_object_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void gxml_init_init (void);
static void gxml_serializable_object_model_finalize (GObject* obj);
GHashTable* gxml_serializable_get_ignored_serializable_properties (GXmlSerializable* self);
static void _vala_gxml_serializable_object_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gxml_serializable_set_ignored_serializable_properties (GXmlSerializable* self, GHashTable* value);
static void _vala_gxml_serializable_object_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean gxml_serializable_object_model_real_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_object_model_get_enable_unknown_serializable_property (GXmlSerializableObjectModel* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->get_enable_unknown_serializable_property (self);
}


static void gxml_serializable_object_model_init_unknown_doc (GXmlSerializableObjectModel* self) {
	GXmlTwDocument* _tmp0_ = NULL;
	GXmlNode* r = NULL;
	GXmlTwDocument* _tmp1_ = NULL;
	GXmlNode* _tmp2_ = NULL;
	GXmlTwDocument* _tmp3_ = NULL;
	GeeBidirList* _tmp4_ = NULL;
	GeeBidirList* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gxml_tw_document_new ();
	_g_object_unref0 (self->_doc);
	self->_doc = _tmp0_;
	_tmp1_ = self->_doc;
	_tmp2_ = gxml_document_create_element ((GXmlDocument*) _tmp1_, "root");
	r = _tmp2_;
	_tmp3_ = self->_doc;
	_tmp4_ = gxml_tw_node_get_childs ((GXmlTwNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	gee_collection_add ((GeeCollection*) _tmp5_, r);
	_g_object_unref0 (r);
}


static gboolean gxml_serializable_object_model_real_serialize_use_xml_node_value (GXmlSerializableObjectModel* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_object_model_serialize_use_xml_node_value (GXmlSerializableObjectModel* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->serialize_use_xml_node_value (self);
}


static gboolean gxml_serializable_object_model_real_property_use_nick (GXmlSerializableObjectModel* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_object_model_property_use_nick (GXmlSerializableObjectModel* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->property_use_nick (self);
}


static gboolean gxml_serializable_object_model_real_set_namespace (GXmlSerializableObjectModel* self, GXmlNode* node) {
	gboolean result = FALSE;
	g_return_val_if_fail (node != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean gxml_serializable_object_model_set_namespace (GXmlSerializableObjectModel* self, GXmlNode* node) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->set_namespace (self, node);
}


static gchar* gxml_serializable_object_model_real_node_name (GXmlSerializableObjectModel* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	_tmp0_ = gxml_serializable_object_model_default_node_name (self);
	result = _tmp0_;
	return result;
}


gchar* gxml_serializable_object_model_node_name (GXmlSerializableObjectModel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->node_name (self);
}


gchar* gxml_serializable_object_model_default_node_name (GXmlSerializableObjectModel* self) {
	gchar* result = NULL;
	GType _tmp0_ = 0UL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp1_ = g_type_name (_tmp0_);
	_tmp2_ = g_utf8_strdown (_tmp1_, (gssize) (-1));
	result = _tmp2_;
	return result;
}


static GParamSpec* gxml_serializable_object_model_real_find_property_spec (GXmlSerializableObjectModel* self, const gchar* property_name) {
	GParamSpec* result = NULL;
	const gchar* _tmp0_ = NULL;
	GParamSpec* _tmp1_ = NULL;
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp0_ = property_name;
	_tmp1_ = gxml_serializable_default_find_property_spec ((GXmlSerializable*) self, _tmp0_);
	result = _tmp1_;
	return result;
}


GParamSpec* gxml_serializable_object_model_find_property_spec (GXmlSerializableObjectModel* self, const gchar* property_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->find_property_spec (self, property_name);
}


static void gxml_serializable_object_model_real_init_properties (GXmlSerializableObjectModel* self) {
	gxml_serializable_default_init_properties ((GXmlSerializable*) self);
}


void gxml_serializable_object_model_init_properties (GXmlSerializableObjectModel* self) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->init_properties (self);
}


static GParamSpec** gxml_serializable_object_model_real_list_serializable_properties (GXmlSerializableObjectModel* self, int* result_length1) {
	GParamSpec** result = NULL;
	gint _tmp0_ = 0;
	GParamSpec** _tmp1_ = NULL;
	GParamSpec** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	_tmp1_ = gxml_serializable_default_list_serializable_properties ((GXmlSerializable*) self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


GParamSpec** gxml_serializable_object_model_list_serializable_properties (GXmlSerializableObjectModel* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->list_serializable_properties (self, result_length1);
}


static void gxml_serializable_object_model_real_get_property_value (GXmlSerializableObjectModel* self, GParamSpec* spec, GValue* val) {
	GParamSpec* _tmp0_ = NULL;
	g_return_if_fail (spec != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = spec;
	gxml_serializable_default_get_property_value ((GXmlSerializable*) self, _tmp0_, val);
}


void gxml_serializable_object_model_get_property_value (GXmlSerializableObjectModel* self, GParamSpec* spec, GValue* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->get_property_value (self, spec, val);
}


static void gxml_serializable_object_model_real_set_property_value (GXmlSerializableObjectModel* self, GParamSpec* spec, GValue* val) {
	GParamSpec* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	g_return_if_fail (spec != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = spec;
	_tmp1_ = *val;
	gxml_serializable_default_set_property_value ((GXmlSerializable*) self, _tmp0_, &_tmp1_);
}


void gxml_serializable_object_model_set_property_value (GXmlSerializableObjectModel* self, GParamSpec* spec, GValue* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->set_property_value (self, spec, val);
}


static gboolean gxml_serializable_object_model_real_transform_from_string (GXmlSerializableObjectModel* self, const gchar* str, GValue* dest, GError** error) {
	gboolean result = FALSE;
	g_return_val_if_fail (str != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean gxml_serializable_object_model_transform_from_string (GXmlSerializableObjectModel* self, const gchar* str, GValue* dest, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->transform_from_string (self, str, dest, error);
}


static gboolean gxml_serializable_object_model_real_transform_to_string (GXmlSerializableObjectModel* self, GValue* val, gchar** str, GError** error) {
	gboolean result = FALSE;
	g_return_val_if_fail (val != NULL, FALSE);
	g_return_val_if_fail (*str != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean gxml_serializable_object_model_transform_to_string (GXmlSerializableObjectModel* self, GValue* val, gchar** str, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->transform_to_string (self, val, str, error);
}


static GXmlNode* gxml_serializable_object_model_real_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	GXmlNode* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GXmlNode* _tmp2_ = NULL;
	GXmlNode* _tmp3_ = NULL;
	GXmlNode* _tmp4_ = NULL;
	GXmlNode* _tmp5_ = NULL;
	GXmlNode* _tmp6_ = NULL;
	GXmlNode* _tmp7_ = NULL;
	GXmlNode* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", NULL);
	_tmp2_ = node;
	_tmp3_ = node;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GXML_TYPE_DOCUMENT) || G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GXML_TYPE_ELEMENT), "node is GXml.Document || node is GXml.Element", NULL);
	_tmp5_ = node;
	_tmp6_ = gxml_serializable_object_model_default_serialize (self, _tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp1_);
	_tmp4_ = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp8_ = _tmp4_;
	_tmp4_ = NULL;
	result = _tmp8_;
	_g_object_unref0 (_tmp4_);
	return result;
}


GXmlNode* gxml_serializable_object_model_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GXmlNode* _tmp2_ = NULL;
	GXmlNode* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", NULL);
	_tmp2_ = node;
	_tmp3_ = node;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GXML_TYPE_DOCUMENT) || G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GXML_TYPE_ELEMENT), "node is GXml.Document || node is GXml.Element", NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->serialize (self, node, error);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_param_spec_ref0 (gpointer self) {
	return self ? g_param_spec_ref (self) : NULL;
}


GXmlNode* gxml_serializable_object_model_default_serialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	GXmlNode* result = NULL;
	GXmlNode* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GXmlDocument* doc = NULL;
	GXmlNode* _tmp3_ = NULL;
	GXmlElement* element = NULL;
	GXmlDocument* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GXmlNode* _tmp13_ = NULL;
	GXmlElement* _tmp14_ = NULL;
	GXmlNode* _tmp15_ = NULL;
	GeeBidirList* _tmp16_ = NULL;
	GeeBidirList* _tmp17_ = NULL;
	GXmlElement* _tmp18_ = NULL;
	GXmlElement* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GParamSpec** _tmp21_ = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp85_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = gxml_node_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ != NULL, "node.name != null");
	_tmp3_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GXML_TYPE_DOCUMENT)) {
		GXmlNode* _tmp4_ = NULL;
		GXmlDocument* _tmp5_ = NULL;
		_tmp4_ = node;
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GXML_TYPE_DOCUMENT, GXmlDocument));
		_g_object_unref0 (doc);
		doc = _tmp5_;
	} else {
		GXmlNode* _tmp6_ = NULL;
		GXmlDocument* _tmp7_ = NULL;
		GXmlDocument* _tmp8_ = NULL;
		GXmlDocument* _tmp9_ = NULL;
		_tmp6_ = node;
		_tmp7_ = gxml_node_get_document (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (doc);
		doc = _tmp9_;
	}
	_tmp10_ = doc;
	_tmp11_ = gxml_serializable_object_model_node_name (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = gxml_document_create_element (_tmp10_, _tmp12_);
	_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GXML_TYPE_ELEMENT, GXmlElement);
	_g_free0 (_tmp12_);
	element = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = gxml_node_get_childs (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = element;
	gee_collection_add ((GeeCollection*) _tmp17_, (GXmlNode*) _tmp18_);
	_tmp19_ = element;
	gxml_serializable_object_model_set_namespace (self, (GXmlNode*) _tmp19_);
	_tmp21_ = gxml_serializable_object_model_list_serializable_properties (self, &_tmp20_);
	{
		GParamSpec** spec_collection = NULL;
		gint spec_collection_length1 = 0;
		gint _spec_collection_size_ = 0;
		gint spec_it = 0;
		spec_collection = _tmp21_;
		spec_collection_length1 = _tmp20_;
		for (spec_it = 0; spec_it < _tmp20_; spec_it = spec_it + 1) {
			GParamSpec* _tmp22_ = NULL;
			GParamSpec* spec = NULL;
			_tmp22_ = _g_param_spec_ref0 (spec_collection[spec_it]);
			spec = _tmp22_;
			{
				GXmlElement* _tmp23_ = NULL;
				GParamSpec* _tmp24_ = NULL;
				GXmlNode* _tmp25_ = NULL;
				GXmlNode* _tmp26_ = NULL;
				_tmp23_ = element;
				_tmp24_ = spec;
				_tmp25_ = gxml_serializable_object_model_serialize_property (self, (GXmlNode*) _tmp23_, _tmp24_, &_inner_error_);
				_tmp26_ = _tmp25_;
				_g_object_unref0 (_tmp26_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_param_spec_unref0 (spec);
					spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					_g_object_unref0 (element);
					_g_object_unref0 (doc);
					return NULL;
				}
				_g_param_spec_unref0 (spec);
			}
		}
		spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	}
	_tmp27_ = gxml_serializable_object_model_get_enable_unknown_serializable_property (self);
	if (_tmp27_) {
		{
			GeeIterator* _attr_it = NULL;
			GeeMap* _tmp28_ = NULL;
			GeeMap* _tmp29_ = NULL;
			GeeCollection* _tmp30_ = NULL;
			GeeCollection* _tmp31_ = NULL;
			GeeCollection* _tmp32_ = NULL;
			GeeIterator* _tmp33_ = NULL;
			GeeIterator* _tmp34_ = NULL;
			_tmp28_ = gxml_serializable_get_unknown_serializable_properties ((GXmlSerializable*) self);
			_tmp29_ = _tmp28_;
			_tmp30_ = gee_map_get_values (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = _tmp31_;
			_tmp33_ = gee_iterable_iterator ((GeeIterable*) _tmp32_);
			_tmp34_ = _tmp33_;
			_g_object_unref0 (_tmp32_);
			_attr_it = _tmp34_;
			while (TRUE) {
				GeeIterator* _tmp35_ = NULL;
				gboolean _tmp36_ = FALSE;
				GXmlAttribute* attr = NULL;
				GeeIterator* _tmp37_ = NULL;
				gpointer _tmp38_ = NULL;
				GXmlElement* _tmp39_ = NULL;
				GXmlAttribute* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				GXmlAttribute* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				_tmp35_ = _attr_it;
				_tmp36_ = gee_iterator_next (_tmp35_);
				if (!_tmp36_) {
					break;
				}
				_tmp37_ = _attr_it;
				_tmp38_ = gee_iterator_get (_tmp37_);
				attr = (GXmlAttribute*) _tmp38_;
				_tmp39_ = element;
				_tmp40_ = attr;
				_tmp41_ = gxml_node_get_name ((GXmlNode*) _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = attr;
				_tmp44_ = gxml_node_get_value ((GXmlNode*) _tmp43_);
				_tmp45_ = _tmp44_;
				gxml_element_set_attr (_tmp39_, _tmp42_, _tmp45_);
				_g_object_unref0 (attr);
			}
			_g_object_unref0 (_attr_it);
		}
		{
			GeeIterator* _n_it = NULL;
			GeeCollection* _tmp46_ = NULL;
			GeeCollection* _tmp47_ = NULL;
			GeeIterator* _tmp48_ = NULL;
			_tmp46_ = gxml_serializable_get_unknown_serializable_nodes ((GXmlSerializable*) self);
			_tmp47_ = _tmp46_;
			_tmp48_ = gee_iterable_iterator ((GeeIterable*) _tmp47_);
			_n_it = _tmp48_;
			while (TRUE) {
				GeeIterator* _tmp49_ = NULL;
				gboolean _tmp50_ = FALSE;
				GXmlNode* n = NULL;
				GeeIterator* _tmp51_ = NULL;
				gpointer _tmp52_ = NULL;
				GXmlNode* _tmp53_ = NULL;
				GXmlNode* _tmp68_ = NULL;
				_tmp49_ = _n_it;
				_tmp50_ = gee_iterator_next (_tmp49_);
				if (!_tmp50_) {
					break;
				}
				_tmp51_ = _n_it;
				_tmp52_ = gee_iterator_get (_tmp51_);
				n = (GXmlNode*) _tmp52_;
				_tmp53_ = n;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, GXML_TYPE_ELEMENT)) {
					GXmlNode* e = NULL;
					GXmlDocument* _tmp54_ = NULL;
					GXmlNode* _tmp55_ = NULL;
					const gchar* _tmp56_ = NULL;
					const gchar* _tmp57_ = NULL;
					GXmlNode* _tmp58_ = NULL;
					GXmlNode* _tmp59_ = NULL;
					GXmlDocument* _tmp60_ = NULL;
					GXmlDocument* _tmp61_ = NULL;
					GXmlNode* _tmp62_ = NULL;
					GXmlNode* _tmp63_ = NULL;
					GXmlElement* _tmp64_ = NULL;
					GeeBidirList* _tmp65_ = NULL;
					GeeBidirList* _tmp66_ = NULL;
					GXmlNode* _tmp67_ = NULL;
					_tmp54_ = doc;
					_tmp55_ = n;
					_tmp56_ = gxml_node_get_name (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = gxml_document_create_element (_tmp54_, _tmp57_);
					e = _tmp58_;
					_tmp59_ = node;
					_tmp60_ = gxml_node_get_document (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = e;
					_tmp63_ = n;
					gxml_node_copy (_tmp61_, _tmp62_, _tmp63_, TRUE);
					_tmp64_ = element;
					_tmp65_ = gxml_node_get_childs ((GXmlNode*) _tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = e;
					gee_collection_add ((GeeCollection*) _tmp66_, _tmp67_);
					_g_object_unref0 (e);
				}
				_tmp68_ = n;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, GXML_TYPE_TEXT)) {
					GXmlNode* _tmp69_ = NULL;
					const gchar* _tmp70_ = NULL;
					const gchar* _tmp71_ = NULL;
					GXmlNode* _tmp73_ = NULL;
					const gchar* _tmp74_ = NULL;
					const gchar* _tmp75_ = NULL;
					GXmlNode* t = NULL;
					GXmlDocument* _tmp76_ = NULL;
					GXmlNode* _tmp77_ = NULL;
					const gchar* _tmp78_ = NULL;
					const gchar* _tmp79_ = NULL;
					GXmlNode* _tmp80_ = NULL;
					GXmlElement* _tmp81_ = NULL;
					GeeBidirList* _tmp82_ = NULL;
					GeeBidirList* _tmp83_ = NULL;
					GXmlNode* _tmp84_ = NULL;
					_tmp69_ = n;
					_tmp70_ = gxml_node_get_value (_tmp69_);
					_tmp71_ = _tmp70_;
					if (_tmp71_ == NULL) {
						const gchar* _tmp72_ = NULL;
						_tmp72_ = _ ("Text node with NULL or none text");
						g_warning ("SerializableObjectModel.vala:173: %s", _tmp72_);
					}
					_tmp73_ = n;
					_tmp74_ = gxml_node_get_value (_tmp73_);
					_tmp75_ = _tmp74_;
					if (g_strcmp0 (_tmp75_, "") == 0) {
						_g_object_unref0 (n);
						continue;
					}
					_tmp76_ = doc;
					_tmp77_ = n;
					_tmp78_ = gxml_node_get_value (_tmp77_);
					_tmp79_ = _tmp78_;
					_tmp80_ = gxml_document_create_text (_tmp76_, _tmp79_);
					t = _tmp80_;
					_tmp81_ = element;
					_tmp82_ = gxml_node_get_childs ((GXmlNode*) _tmp81_);
					_tmp83_ = _tmp82_;
					_tmp84_ = t;
					gee_collection_add ((GeeCollection*) _tmp83_, _tmp84_);
					_g_object_unref0 (t);
				}
				_g_object_unref0 (n);
			}
			_g_object_unref0 (_n_it);
		}
	}
	_tmp85_ = gxml_serializable_object_model_serialize_use_xml_node_value (self);
	if (_tmp85_) {
		gchar* t = NULL;
		gchar* _tmp86_ = NULL;
		const gchar* _tmp87_ = NULL;
		const gchar* _tmp88_ = NULL;
		GXmlElement* _tmp92_ = NULL;
		const gchar* _tmp93_ = NULL;
		_tmp86_ = g_strdup ("");
		t = _tmp86_;
		_tmp87_ = gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self);
		_tmp88_ = _tmp87_;
		if (_tmp88_ != NULL) {
			const gchar* _tmp89_ = NULL;
			const gchar* _tmp90_ = NULL;
			gchar* _tmp91_ = NULL;
			_tmp89_ = gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self);
			_tmp90_ = _tmp89_;
			_tmp91_ = g_strdup (_tmp90_);
			_g_free0 (t);
			t = _tmp91_;
		}
		_tmp92_ = element;
		_tmp93_ = t;
		gxml_element_set_content (_tmp92_, _tmp93_);
		_g_free0 (t);
	}
	result = (GXmlNode*) element;
	_g_object_unref0 (doc);
	return result;
}


static GXmlNode* gxml_serializable_object_model_real_serialize_property (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error) {
	GXmlNode* result = NULL;
	GXmlNode* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = element;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_ELEMENT)) {
		GXmlNode* _tmp1_ = NULL;
		GXmlNode* _tmp2_ = NULL;
		GParamSpec* _tmp3_ = NULL;
		GXmlNode* _tmp4_ = NULL;
		GXmlNode* _tmp5_ = NULL;
		_tmp2_ = element;
		_tmp3_ = prop;
		_tmp4_ = gxml_serializable_object_model_default_serialize_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GXML_TYPE_ELEMENT, GXmlElement), _tmp3_, &_inner_error_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_tmp5_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp5_;
		_g_object_unref0 (_tmp1_);
		return result;
	}
	result = NULL;
	return result;
}


GXmlNode* gxml_serializable_object_model_serialize_property (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->serialize_property (self, element, prop, error);
}


GXmlNode* gxml_serializable_object_model_default_serialize_property (GXmlSerializableObjectModel* self, GXmlElement* element, GParamSpec* prop, GError** error) {
	GXmlNode* result = NULL;
	gboolean _tmp0_ = FALSE;
	GParamSpec* _tmp1_ = NULL;
	GType _tmp2_ = 0UL;
	gboolean _tmp3_ = FALSE;
	GValue oval = {0};
	GParamSpec* _tmp27_ = NULL;
	GType _tmp28_ = 0UL;
	gboolean _tmp29_ = FALSE;
	GParamSpec* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	gchar* val = NULL;
	gchar* _tmp38_ = NULL;
	GParamSpec* _tmp39_ = NULL;
	GType _tmp40_ = 0UL;
	gboolean _tmp41_ = FALSE;
	gchar* attr_name = NULL;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	GXmlNode* attr = NULL;
	GXmlElement* _tmp72_ = NULL;
	const gchar* _tmp73_ = NULL;
	GXmlNode* _tmp74_ = NULL;
	GXmlNode* _tmp75_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = prop;
	_tmp2_ = _tmp1_->value_type;
	_tmp3_ = g_type_is_a (_tmp2_, GXML_TYPE_SERIALIZABLE);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GParamSpec* _tmp4_ = NULL;
		GType _tmp5_ = 0UL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = prop;
		_tmp5_ = _tmp4_->value_type;
		_tmp6_ = g_type_is_a (_tmp5_, GXML_TYPE_SERIALIZABLE_PROPERTY);
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		GValue v = {0};
		GValue _tmp7_ = {0};
		GParamSpec* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GObject* obj = NULL;
		GObject* _tmp10_ = NULL;
		GObject* _tmp11_ = NULL;
		GObject* _tmp12_ = NULL;
		g_value_init (&_tmp7_, G_TYPE_OBJECT);
		v = _tmp7_;
		_tmp8_ = prop;
		_tmp9_ = _tmp8_->name;
		g_object_get_property ((GObject*) self, _tmp9_, &v);
		_tmp10_ = g_value_get_object (&v);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		obj = _tmp11_;
		_tmp12_ = obj;
		if (_tmp12_ != NULL) {
			GObject* _tmp13_ = NULL;
			GObject* _tmp21_ = NULL;
			_tmp13_ = obj;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GXML_TYPE_SERIALIZABLE_PROPERTY)) {
				GXmlNode* _tmp14_ = NULL;
				GObject* _tmp15_ = NULL;
				GXmlElement* _tmp16_ = NULL;
				GParamSpec* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				GXmlNode* _tmp19_ = NULL;
				GXmlNode* _tmp20_ = NULL;
				_tmp15_ = obj;
				_tmp16_ = element;
				_tmp17_ = prop;
				_tmp18_ = gxml_serializable_object_model_property_use_nick (self);
				_tmp19_ = gxml_serializable_property_serialize_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty), (GXmlNode*) _tmp16_, _tmp17_, _tmp18_, &_inner_error_);
				_tmp14_ = _tmp19_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (obj);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					return NULL;
				}
				_tmp20_ = _tmp14_;
				_tmp14_ = NULL;
				result = _tmp20_;
				_g_object_unref0 (_tmp14_);
				_g_object_unref0 (obj);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return result;
			}
			_tmp21_ = obj;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, GXML_TYPE_SERIALIZABLE)) {
				GXmlNode* _tmp22_ = NULL;
				GObject* _tmp23_ = NULL;
				GXmlElement* _tmp24_ = NULL;
				GXmlNode* _tmp25_ = NULL;
				GXmlNode* _tmp26_ = NULL;
				_tmp23_ = obj;
				_tmp24_ = element;
				_tmp25_ = gxml_serializable_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) _tmp24_, &_inner_error_);
				_tmp22_ = _tmp25_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (obj);
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					return NULL;
				}
				_tmp26_ = _tmp22_;
				_tmp22_ = NULL;
				result = _tmp26_;
				_g_object_unref0 (_tmp22_);
				_g_object_unref0 (obj);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
				return result;
			}
		}
		_g_object_unref0 (obj);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	}
	_tmp27_ = prop;
	_tmp28_ = _tmp27_->value_type;
	_tmp29_ = g_type_is_a (_tmp28_, G_TYPE_ENUM);
	if (_tmp29_) {
		GValue _tmp30_ = {0};
		GValue _tmp31_ = {0};
		g_value_init (&_tmp30_, G_TYPE_INT);
		G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
		oval = _tmp30_;
		_tmp31_ = oval;
	} else {
		GParamSpec* _tmp32_ = NULL;
		GType _tmp33_ = 0UL;
		GValue _tmp34_ = {0};
		GValue _tmp35_ = {0};
		_tmp32_ = prop;
		_tmp33_ = _tmp32_->value_type;
		g_value_init (&_tmp34_, _tmp33_);
		G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
		oval = _tmp34_;
		_tmp35_ = oval;
	}
	_tmp36_ = prop;
	_tmp37_ = _tmp36_->name;
	g_object_get_property ((GObject*) self, _tmp37_, &oval);
	_tmp38_ = g_strdup ("");
	val = _tmp38_;
	_tmp39_ = prop;
	_tmp40_ = _tmp39_->value_type;
	_tmp41_ = g_type_is_a (_tmp40_, G_TYPE_ENUM);
	if (_tmp41_) {
		{
			gchar* _tmp42_ = NULL;
			GParamSpec* _tmp43_ = NULL;
			GType _tmp44_ = 0UL;
			gint _tmp45_ = 0;
			gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			_tmp43_ = prop;
			_tmp44_ = _tmp43_->value_type;
			_tmp45_ = g_value_get_int (&oval);
			_tmp46_ = gxml_enumeration_get_nick_camelcase (_tmp44_, _tmp45_, &_inner_error_);
			_tmp42_ = _tmp46_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == GXML_ENUMERATION_ERROR) {
					goto __catch6_gxml_enumeration_error;
				}
				goto __finally6;
			}
			_tmp47_ = _tmp42_;
			_tmp42_ = NULL;
			_g_free0 (val);
			val = _tmp47_;
			_g_free0 (_tmp42_);
		}
		goto __finally6;
		__catch6_gxml_enumeration_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_free0 (val);
			val = NULL;
			_g_error_free0 (e);
		}
		__finally6:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
			return NULL;
		}
	} else {
		gboolean _tmp48_ = FALSE;
		GValue _tmp49_ = {0};
		gboolean _tmp50_ = FALSE;
		_tmp49_ = oval;
		_tmp50_ = gxml_serializable_object_model_transform_to_string (self, &_tmp49_, &val, &_inner_error_);
		_tmp48_ = _tmp50_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
			return NULL;
		}
		if (!_tmp48_) {
			GParamSpec* _tmp51_ = NULL;
			GType _tmp52_ = 0UL;
			gboolean _tmp53_ = FALSE;
			_tmp51_ = prop;
			_tmp52_ = _tmp51_->value_type;
			_tmp53_ = g_value_type_transformable (_tmp52_, G_TYPE_STRING);
			if (_tmp53_) {
				GValue rval = {0};
				GValue _tmp54_ = {0};
				gchar* _tmp55_ = NULL;
				g_value_init (&_tmp54_, G_TYPE_STRING);
				rval = _tmp54_;
				g_value_transform (&oval, &rval);
				_tmp55_ = g_value_dup_string (&rval);
				_g_free0 (val);
				val = _tmp55_;
				G_IS_VALUE (&rval) ? (g_value_unset (&rval), NULL) : NULL;
			} else {
				GXmlNode* node = NULL;
				GXmlElement* _tmp56_ = NULL;
				GParamSpec* _tmp57_ = NULL;
				GXmlNode* _tmp58_ = NULL;
				node = NULL;
				_tmp56_ = element;
				_tmp57_ = prop;
				g_signal_emit_by_name ((GXmlSerializable*) self, "serialize-unknown-property", (GXmlNode*) _tmp56_, _tmp57_, &_tmp58_);
				_g_object_unref0 (node);
				node = _tmp58_;
				result = node;
				_g_free0 (val);
				G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
				return result;
			}
		}
	}
	_tmp61_ = gxml_serializable_object_model_property_use_nick (self);
	if (_tmp61_) {
		GParamSpec* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		_tmp62_ = prop;
		_tmp63_ = g_param_spec_get_nick (_tmp62_);
		_tmp60_ = _tmp63_ != NULL;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		GParamSpec* _tmp64_ = NULL;
		const gchar* _tmp65_ = NULL;
		_tmp64_ = prop;
		_tmp65_ = g_param_spec_get_nick (_tmp64_);
		_tmp59_ = g_strcmp0 (_tmp65_, "") != 0;
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		GParamSpec* _tmp66_ = NULL;
		const gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
		_tmp66_ = prop;
		_tmp67_ = g_param_spec_get_nick (_tmp66_);
		_tmp68_ = g_strdup (_tmp67_);
		_g_free0 (attr_name);
		attr_name = _tmp68_;
	} else {
		GParamSpec* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		_tmp69_ = prop;
		_tmp70_ = g_param_spec_get_name (_tmp69_);
		_tmp71_ = g_strdup (_tmp70_);
		_g_free0 (attr_name);
		attr_name = _tmp71_;
	}
	_tmp72_ = element;
	_tmp73_ = attr_name;
	_tmp74_ = gxml_element_get_attr (_tmp72_, _tmp73_);
	attr = _tmp74_;
	_tmp75_ = attr;
	if (_tmp75_ == NULL) {
		const gchar* _tmp76_ = NULL;
		_tmp76_ = val;
		if (_tmp76_ != NULL) {
			GXmlElement* _tmp77_ = NULL;
			const gchar* _tmp78_ = NULL;
			const gchar* _tmp79_ = NULL;
			_tmp77_ = element;
			_tmp78_ = attr_name;
			_tmp79_ = val;
			gxml_element_set_attr (_tmp77_, _tmp78_, _tmp79_);
		}
	} else {
		GXmlNode* _tmp80_ = NULL;
		const gchar* _tmp81_ = NULL;
		_tmp80_ = attr;
		_tmp81_ = val;
		gxml_node_set_value (_tmp80_, _tmp81_);
	}
	result = attr;
	_g_free0 (attr_name);
	_g_free0 (val);
	G_IS_VALUE (&oval) ? (g_value_unset (&oval), NULL) : NULL;
	return result;
}


static GXmlNode* gxml_serializable_object_model_real_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	GXmlNode* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GXmlNode* _tmp2_ = NULL;
	GXmlNode* _tmp3_ = NULL;
	GXmlNode* _tmp4_ = NULL;
	GXmlNode* _tmp5_ = NULL;
	GXmlNode* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", NULL);
	_tmp3_ = node;
	_tmp4_ = gxml_serializable_object_model_default_deserialize (self, _tmp3_, &_inner_error_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp1_);
	_tmp2_ = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp6_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp6_;
	_g_object_unref0 (_tmp2_);
	return result;
}


GXmlNode* gxml_serializable_object_model_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gxml_serializable_object_model_node_name (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "node_name () != null", NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->deserialize (self, node, error);
}


GXmlNode* gxml_serializable_object_model_default_deserialize (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error) {
	GXmlNode* result = NULL;
	GXmlDocument* doc = NULL;
	GXmlNode* _tmp0_ = NULL;
	GXmlElement* element = NULL;
	GXmlNode* _tmp10_ = NULL;
	GXmlElement* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GXmlElement* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	GXmlElement* _tmp61_ = NULL;
	GeeBidirList* _tmp62_ = NULL;
	GeeBidirList* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_DOCUMENT)) {
		GXmlNode* _tmp1_ = NULL;
		GXmlDocument* _tmp2_ = NULL;
		GXmlDocument* _tmp3_ = NULL;
		GXmlNode* _tmp4_ = NULL;
		GXmlNode* _tmp5_ = NULL;
		_tmp1_ = node;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GXML_TYPE_DOCUMENT, GXmlDocument));
		_g_object_unref0 (doc);
		doc = _tmp2_;
		_tmp3_ = doc;
		_tmp4_ = gxml_document_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		g_return_val_if_fail (_tmp5_ != NULL, NULL);
	} else {
		GXmlNode* _tmp6_ = NULL;
		GXmlDocument* _tmp7_ = NULL;
		GXmlDocument* _tmp8_ = NULL;
		GXmlDocument* _tmp9_ = NULL;
		_tmp6_ = node;
		_tmp7_ = gxml_node_get_document (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (doc);
		doc = _tmp9_;
	}
	_tmp10_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GXML_TYPE_ELEMENT)) {
		GXmlNode* _tmp11_ = NULL;
		GXmlElement* _tmp12_ = NULL;
		_tmp11_ = node;
		_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GXML_TYPE_ELEMENT, GXmlElement));
		_g_object_unref0 (element);
		element = _tmp12_;
	} else {
		GXmlDocument* _tmp13_ = NULL;
		GXmlNode* _tmp14_ = NULL;
		GXmlNode* _tmp15_ = NULL;
		GXmlElement* _tmp16_ = NULL;
		_tmp13_ = doc;
		_tmp14_ = gxml_document_get_root (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GXML_TYPE_ELEMENT, GXmlElement));
		_g_object_unref0 (element);
		element = _tmp16_;
	}
	_tmp17_ = element;
	g_return_val_if_fail (_tmp17_ != NULL, NULL);
	_tmp18_ = gxml_serializable_object_model_node_name (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_ == NULL;
	_g_free0 (_tmp19_);
	if (_tmp20_) {
		const gchar* _tmp21_ = NULL;
		GType _tmp22_ = 0UL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp21_ = _ ("WARNING: Object type '%s' have no Node Name defined");
		_tmp22_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
		_tmp23_ = g_type_name (_tmp22_);
		_tmp24_ = g_strdup_printf (_tmp21_, _tmp23_);
		_tmp25_ = _tmp24_;
		g_warning ("SerializableObjectModel.vala:297: %s", _tmp25_);
		_g_free0 (_tmp25_);
		result = NULL;
		_g_object_unref0 (element);
		_g_object_unref0 (doc);
		return result;
	}
	_tmp26_ = element;
	_tmp27_ = gxml_node_get_name ((GXmlNode*) _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_utf8_strdown (_tmp28_, (gssize) (-1));
	_tmp30_ = _tmp29_;
	_tmp31_ = gxml_serializable_object_model_node_name (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_utf8_strdown (_tmp32_, (gssize) (-1));
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strcmp0 (_tmp30_, _tmp34_) != 0;
	_g_free0 (_tmp34_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	if (_tmp35_) {
		const gchar* _tmp36_ = NULL;
		GXmlElement* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		_tmp36_ = _ ("Actual node's name is '%s' expected '%s'");
		_tmp37_ = element;
		_tmp38_ = gxml_node_get_name ((GXmlNode*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_utf8_strdown (_tmp39_, (gssize) (-1));
		_tmp41_ = _tmp40_;
		_tmp42_ = gxml_serializable_object_model_node_name (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_utf8_strdown (_tmp43_, (gssize) (-1));
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strdup_printf (_tmp36_, _tmp41_, _tmp45_);
		_tmp47_ = _tmp46_;
		g_warning ("SerializableObjectModel.vala:301: %s", _tmp47_);
		_g_free0 (_tmp47_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
	}
	{
		GeeIterator* _attr_it = NULL;
		GXmlElement* _tmp48_ = NULL;
		GeeMap* _tmp49_ = NULL;
		GeeMap* _tmp50_ = NULL;
		GeeCollection* _tmp51_ = NULL;
		GeeCollection* _tmp52_ = NULL;
		GeeCollection* _tmp53_ = NULL;
		GeeIterator* _tmp54_ = NULL;
		GeeIterator* _tmp55_ = NULL;
		_tmp48_ = element;
		_tmp49_ = gxml_node_get_attrs ((GXmlNode*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = gee_map_get_values (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = _tmp52_;
		_tmp54_ = gee_iterable_iterator ((GeeIterable*) _tmp53_);
		_tmp55_ = _tmp54_;
		_g_object_unref0 (_tmp53_);
		_attr_it = _tmp55_;
		while (TRUE) {
			GeeIterator* _tmp56_ = NULL;
			gboolean _tmp57_ = FALSE;
			GXmlNode* attr = NULL;
			GeeIterator* _tmp58_ = NULL;
			gpointer _tmp59_ = NULL;
			GXmlNode* _tmp60_ = NULL;
			_tmp56_ = _attr_it;
			_tmp57_ = gee_iterator_next (_tmp56_);
			if (!_tmp57_) {
				break;
			}
			_tmp58_ = _attr_it;
			_tmp59_ = gee_iterator_get (_tmp58_);
			attr = (GXmlNode*) _tmp59_;
			_tmp60_ = attr;
			gxml_serializable_object_model_deserialize_property (self, _tmp60_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (attr);
				_g_object_unref0 (_attr_it);
				_g_object_unref0 (element);
				_g_object_unref0 (doc);
				return NULL;
			}
			_g_object_unref0 (attr);
		}
		_g_object_unref0 (_attr_it);
	}
	_tmp61_ = element;
	_tmp62_ = gxml_node_get_childs ((GXmlNode*) _tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = gee_collection_get_size ((GeeCollection*) _tmp63_);
	_tmp65_ = _tmp64_;
	if (_tmp65_ > 0) {
		GType _tmp66_ = 0UL;
		gboolean _tmp67_ = FALSE;
		GeeHashMap* cnodes = NULL;
		GeeHashMap* _tmp68_ = NULL;
		gint _tmp69_ = 0;
		GParamSpec** _tmp70_ = NULL;
		_tmp66_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
		_tmp67_ = g_type_is_a (_tmp66_, GXML_TYPE_SERIALIZABLE_CONTAINER);
		if (_tmp67_) {
			gxml_serializable_container_init_containers (G_TYPE_CHECK_INSTANCE_CAST (self, GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainer));
		}
		_tmp68_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_PARAM, (GBoxedCopyFunc) g_param_spec_ref, g_param_spec_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		cnodes = _tmp68_;
		_tmp70_ = gxml_serializable_object_model_list_serializable_properties (self, &_tmp69_);
		{
			GParamSpec** spec_collection = NULL;
			gint spec_collection_length1 = 0;
			gint _spec_collection_size_ = 0;
			gint spec_it = 0;
			spec_collection = _tmp70_;
			spec_collection_length1 = _tmp69_;
			for (spec_it = 0; spec_it < _tmp69_; spec_it = spec_it + 1) {
				GParamSpec* _tmp71_ = NULL;
				GParamSpec* spec = NULL;
				_tmp71_ = _g_param_spec_ref0 (spec_collection[spec_it]);
				spec = _tmp71_;
				{
					GParamSpec* _tmp72_ = NULL;
					GType _tmp73_ = 0UL;
					gboolean _tmp74_ = FALSE;
					_tmp72_ = spec;
					_tmp73_ = _tmp72_->value_type;
					_tmp74_ = g_type_is_a (_tmp73_, GXML_TYPE_SERIALIZABLE);
					if (_tmp74_) {
						GParamSpec* _tmp75_ = NULL;
						GType _tmp76_ = 0UL;
						gboolean _tmp77_ = FALSE;
						_tmp75_ = spec;
						_tmp76_ = _tmp75_->value_type;
						_tmp77_ = g_type_is_a (_tmp76_, GXML_TYPE_SERIALIZABLE_COLLECTION);
						if (_tmp77_) {
							GValue vo = {0};
							GParamSpec* _tmp78_ = NULL;
							GType _tmp79_ = 0UL;
							GValue _tmp80_ = {0};
							GParamSpec* _tmp81_ = NULL;
							const gchar* _tmp82_ = NULL;
							GObject* objv = NULL;
							GObject* _tmp83_ = NULL;
							GObject* _tmp84_ = NULL;
							GObject* _tmp85_ = NULL;
							_tmp78_ = spec;
							_tmp79_ = _tmp78_->value_type;
							g_value_init (&_tmp80_, _tmp79_);
							vo = _tmp80_;
							_tmp81_ = spec;
							_tmp82_ = _tmp81_->name;
							g_object_get_property ((GObject*) self, _tmp82_, &vo);
							_tmp83_ = g_value_get_object (&vo);
							_tmp84_ = _g_object_ref0 (_tmp83_);
							objv = _tmp84_;
							_tmp85_ = objv;
							if (_tmp85_ != NULL) {
								GObject* _tmp86_ = NULL;
								GXmlElement* _tmp87_ = NULL;
								GXmlNode* _tmp88_ = NULL;
								GXmlNode* _tmp89_ = NULL;
								GeeHashMap* _tmp90_ = NULL;
								GObject* _tmp91_ = NULL;
								gchar* _tmp92_ = NULL;
								gchar* _tmp93_ = NULL;
								GParamSpec* _tmp94_ = NULL;
								_tmp86_ = objv;
								_tmp87_ = element;
								_tmp88_ = gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) _tmp87_, &_inner_error_);
								_tmp89_ = _tmp88_;
								_g_object_unref0 (_tmp89_);
								if (G_UNLIKELY (_inner_error_ != NULL)) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (objv);
									G_IS_VALUE (&vo) ? (g_value_unset (&vo), NULL) : NULL;
									_g_param_spec_unref0 (spec);
									spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
									_g_object_unref0 (cnodes);
									_g_object_unref0 (element);
									_g_object_unref0 (doc);
									return NULL;
								}
								_tmp90_ = cnodes;
								_tmp91_ = objv;
								_tmp92_ = gxml_serializable_node_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, GXML_TYPE_SERIALIZABLE, GXmlSerializable));
								_tmp93_ = _tmp92_;
								_tmp94_ = spec;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp90_, _tmp93_, _tmp94_);
								_g_free0 (_tmp93_);
							}
							_g_object_unref0 (objv);
							G_IS_VALUE (&vo) ? (g_value_unset (&vo), NULL) : NULL;
						}
					}
					_g_param_spec_unref0 (spec);
				}
			}
			spec_collection = (_vala_array_free (spec_collection, spec_collection_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		}
		{
			GeeBidirList* _n_list = NULL;
			GXmlElement* _tmp95_ = NULL;
			GeeBidirList* _tmp96_ = NULL;
			GeeBidirList* _tmp97_ = NULL;
			GeeBidirList* _tmp98_ = NULL;
			gint _n_size = 0;
			GeeBidirList* _tmp99_ = NULL;
			gint _tmp100_ = 0;
			gint _tmp101_ = 0;
			gint _n_index = 0;
			_tmp95_ = element;
			_tmp96_ = gxml_node_get_childs ((GXmlNode*) _tmp95_);
			_tmp97_ = _tmp96_;
			_tmp98_ = _g_object_ref0 (_tmp97_);
			_n_list = _tmp98_;
			_tmp99_ = _n_list;
			_tmp100_ = gee_collection_get_size ((GeeCollection*) _tmp99_);
			_tmp101_ = _tmp100_;
			_n_size = _tmp101_;
			_n_index = -1;
			while (TRUE) {
				gint _tmp102_ = 0;
				gint _tmp103_ = 0;
				gint _tmp104_ = 0;
				GXmlNode* n = NULL;
				GeeBidirList* _tmp105_ = NULL;
				gint _tmp106_ = 0;
				gpointer _tmp107_ = NULL;
				GXmlNode* _tmp108_ = NULL;
				gboolean _tmp128_ = FALSE;
				GXmlNode* _tmp129_ = NULL;
				_tmp102_ = _n_index;
				_n_index = _tmp102_ + 1;
				_tmp103_ = _n_index;
				_tmp104_ = _n_size;
				if (!(_tmp103_ < _tmp104_)) {
					break;
				}
				_tmp105_ = _n_list;
				_tmp106_ = _n_index;
				_tmp107_ = gee_list_get ((GeeList*) _tmp105_, _tmp106_);
				n = (GXmlNode*) _tmp107_;
				_tmp108_ = n;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, GXML_TYPE_TEXT)) {
					gboolean _tmp109_ = FALSE;
					_tmp109_ = gxml_serializable_object_model_serialize_use_xml_node_value (self);
					if (_tmp109_) {
						GXmlNode* _tmp110_ = NULL;
						const gchar* _tmp111_ = NULL;
						const gchar* _tmp112_ = NULL;
						_tmp110_ = n;
						_tmp111_ = gxml_node_get_value (_tmp110_);
						_tmp112_ = _tmp111_;
						gxml_serializable_set_serialized_xml_node_value ((GXmlSerializable*) self, _tmp112_);
					} else {
						gboolean _tmp113_ = FALSE;
						_tmp113_ = gxml_serializable_object_model_get_enable_unknown_serializable_property (self);
						if (_tmp113_) {
							gboolean _tmp114_ = FALSE;
							GXmlNode* _tmp115_ = NULL;
							const gchar* _tmp116_ = NULL;
							const gchar* _tmp117_ = NULL;
							const gchar* _tmp118_ = NULL;
							GXmlNode* _tmp119_ = NULL;
							const gchar* _tmp120_ = NULL;
							const gchar* _tmp121_ = NULL;
							_tmp115_ = n;
							_tmp116_ = gxml_node_get_value (_tmp115_);
							_tmp117_ = _tmp116_;
							_tmp118_ = g_strchomp (_tmp117_);
							_tmp119_ = n;
							_tmp120_ = gxml_node_get_value (_tmp119_);
							_tmp121_ = _tmp120_;
							if (g_strcmp0 (_tmp118_, _tmp121_) == 0) {
								GXmlNode* _tmp122_ = NULL;
								const gchar* _tmp123_ = NULL;
								const gchar* _tmp124_ = NULL;
								_tmp122_ = n;
								_tmp123_ = gxml_node_get_value (_tmp122_);
								_tmp124_ = _tmp123_;
								_tmp114_ = g_strcmp0 (_tmp124_, "") != 0;
							} else {
								_tmp114_ = FALSE;
							}
							if (_tmp114_) {
								GeeCollection* _tmp125_ = NULL;
								GeeCollection* _tmp126_ = NULL;
								GXmlNode* _tmp127_ = NULL;
								_tmp125_ = gxml_serializable_get_unknown_serializable_nodes ((GXmlSerializable*) self);
								_tmp126_ = _tmp125_;
								_tmp127_ = n;
								gee_collection_add (_tmp126_, _tmp127_);
							}
						}
					}
				}
				_tmp129_ = n;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp129_, GXML_TYPE_ELEMENT)) {
					GeeHashMap* _tmp130_ = NULL;
					GXmlNode* _tmp131_ = NULL;
					const gchar* _tmp132_ = NULL;
					const gchar* _tmp133_ = NULL;
					gboolean _tmp134_ = FALSE;
					_tmp130_ = cnodes;
					_tmp131_ = n;
					_tmp132_ = gxml_node_get_name (_tmp131_);
					_tmp133_ = _tmp132_;
					_tmp134_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp130_, _tmp133_);
					_tmp128_ = !_tmp134_;
				} else {
					_tmp128_ = FALSE;
				}
				if (_tmp128_) {
					GXmlNode* _tmp135_ = NULL;
					_tmp135_ = n;
					gxml_serializable_object_model_deserialize_property (self, _tmp135_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (n);
						_g_object_unref0 (_n_list);
						_g_object_unref0 (cnodes);
						_g_object_unref0 (element);
						_g_object_unref0 (doc);
						return NULL;
					}
				}
				_g_object_unref0 (n);
			}
			_g_object_unref0 (_n_list);
		}
		_g_object_unref0 (cnodes);
	}
	result = NULL;
	_g_object_unref0 (element);
	_g_object_unref0 (doc);
	return result;
}


static gboolean gxml_serializable_object_model_real_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GXmlNode* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (property_node != NULL, FALSE);
	_tmp1_ = property_node;
	_tmp2_ = gxml_serializable_object_model_default_deserialize_property (self, _tmp1_, &_inner_error_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean gxml_serializable_object_model_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->deserialize_property (self, property_node, error);
}


gboolean gxml_serializable_object_model_default_deserialize_property (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GParamSpec* prop = NULL;
	GXmlNode* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GParamSpec* _tmp3_ = NULL;
	GParamSpec* _tmp4_ = NULL;
	gboolean _tmp31_ = FALSE;
	GParamSpec* _tmp32_ = NULL;
	GType _tmp33_ = 0UL;
	gboolean _tmp34_ = FALSE;
	GXmlNode* _tmp127_ = NULL;
	GParamSpec* _tmp128_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (property_node != NULL, FALSE);
	ret = FALSE;
	_tmp0_ = property_node;
	_tmp1_ = gxml_node_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gxml_serializable_object_model_find_property_spec (self, _tmp2_);
	prop = _tmp3_;
	_tmp4_ = prop;
	if (_tmp4_ == NULL) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = gxml_serializable_object_model_get_enable_unknown_serializable_property (self);
		if (_tmp5_) {
			GXmlTwDocument* _tmp6_ = NULL;
			GXmlNode* _tmp7_ = NULL;
			_tmp6_ = self->_doc;
			if (_tmp6_ == NULL) {
				gxml_serializable_object_model_init_unknown_doc (self);
			}
			_tmp7_ = property_node;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GXML_TYPE_ATTRIBUTE)) {
				GXmlTwDocument* _tmp8_ = NULL;
				GXmlNode* _tmp9_ = NULL;
				GXmlNode* _tmp10_ = NULL;
				GXmlNode* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				GXmlNode* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				_tmp8_ = self->_doc;
				_tmp9_ = gxml_document_get_root ((GXmlDocument*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = property_node;
				_tmp12_ = gxml_node_get_name (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = property_node;
				_tmp15_ = gxml_node_get_value (_tmp14_);
				_tmp16_ = _tmp15_;
				gxml_element_set_attr (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GXML_TYPE_ELEMENT, GXmlElement), _tmp13_, _tmp16_);
			} else {
				GXmlNode* e = NULL;
				GXmlTwDocument* _tmp17_ = NULL;
				GXmlNode* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				GXmlNode* _tmp21_ = NULL;
				GXmlTwDocument* _tmp22_ = NULL;
				GXmlNode* _tmp23_ = NULL;
				GXmlNode* _tmp24_ = NULL;
				GeeBidirList* _tmp25_ = NULL;
				GeeBidirList* _tmp26_ = NULL;
				GXmlNode* _tmp27_ = NULL;
				GXmlTwDocument* _tmp28_ = NULL;
				GXmlNode* _tmp29_ = NULL;
				GXmlNode* _tmp30_ = NULL;
				_tmp17_ = self->_doc;
				_tmp18_ = property_node;
				_tmp19_ = gxml_node_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gxml_document_create_element ((GXmlDocument*) _tmp17_, _tmp20_);
				e = _tmp21_;
				_tmp22_ = self->_doc;
				_tmp23_ = gxml_document_get_root ((GXmlDocument*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = gxml_node_get_childs (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = e;
				gee_collection_add ((GeeCollection*) _tmp26_, _tmp27_);
				_tmp28_ = self->_doc;
				_tmp29_ = e;
				_tmp30_ = property_node;
				gxml_node_copy ((GXmlDocument*) _tmp28_, _tmp29_, _tmp30_, TRUE);
				_g_object_unref0 (e);
			}
		}
		result = TRUE;
		_g_param_spec_unref0 (prop);
		return result;
	}
	_tmp32_ = prop;
	_tmp33_ = _tmp32_->value_type;
	_tmp34_ = g_type_is_a (_tmp33_, GXML_TYPE_SERIALIZABLE);
	if (_tmp34_) {
		_tmp31_ = TRUE;
	} else {
		GParamSpec* _tmp35_ = NULL;
		GType _tmp36_ = 0UL;
		gboolean _tmp37_ = FALSE;
		_tmp35_ = prop;
		_tmp36_ = _tmp35_->value_type;
		_tmp37_ = g_type_is_a (_tmp36_, GXML_TYPE_SERIALIZABLE_PROPERTY);
		_tmp31_ = _tmp37_;
	}
	if (_tmp31_) {
		GValue vobj = {0};
		GValue _tmp38_ = {0};
		GParamSpec* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		GObject* object = NULL;
		GObject* _tmp41_ = NULL;
		GObject* _tmp42_ = NULL;
		GObject* _tmp43_ = NULL;
		g_value_init (&_tmp38_, G_TYPE_OBJECT);
		vobj = _tmp38_;
		_tmp39_ = prop;
		_tmp40_ = _tmp39_->name;
		g_object_get_property ((GObject*) self, _tmp40_, &vobj);
		object = NULL;
		_tmp41_ = g_value_get_object (&vobj);
		_tmp42_ = _g_object_ref0 (_tmp41_);
		_g_object_unref0 (object);
		object = _tmp42_;
		_tmp43_ = object;
		if (_tmp43_ == NULL) {
			GParamSpec* _tmp44_ = NULL;
			GType _tmp45_ = 0UL;
			gboolean _tmp46_ = FALSE;
			_tmp44_ = prop;
			_tmp45_ = _tmp44_->value_type;
			_tmp46_ = g_type_is_a (_tmp45_, GXML_TYPE_SERIALIZABLE_PROPERTY);
			if (_tmp46_) {
				GObject* obj = NULL;
				GParamSpec* _tmp47_ = NULL;
				GType _tmp48_ = 0UL;
				GObject* _tmp49_ = NULL;
				GObject* _tmp50_ = NULL;
				GObject* _tmp51_ = NULL;
				GXmlNode* _tmp52_ = NULL;
				GParamSpec* _tmp53_ = NULL;
				gboolean _tmp54_ = FALSE;
				GParamSpec* _tmp55_ = NULL;
				const gchar* _tmp56_ = NULL;
				GObject* _tmp57_ = NULL;
				GValue _tmp58_ = {0};
				_tmp47_ = prop;
				_tmp48_ = _tmp47_->value_type;
				_tmp49_ = g_object_new (_tmp48_, NULL);
				_tmp50_ = G_IS_INITIALLY_UNOWNED (_tmp49_) ? g_object_ref_sink (_tmp49_) : _tmp49_;
				obj = _tmp50_;
				_tmp51_ = obj;
				_tmp52_ = property_node;
				_tmp53_ = prop;
				_tmp54_ = gxml_serializable_object_model_property_use_nick (self);
				gxml_serializable_property_deserialize_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty), _tmp52_, _tmp53_, _tmp54_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (obj);
					_g_object_unref0 (object);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return FALSE;
				}
				_tmp55_ = prop;
				_tmp56_ = _tmp55_->name;
				_tmp57_ = obj;
				g_value_init (&_tmp58_, G_TYPE_OBJECT);
				g_value_set_object (&_tmp58_, _tmp57_);
				g_object_set_property ((GObject*) self, _tmp56_, &_tmp58_);
				G_IS_VALUE (&_tmp58_) ? (g_value_unset (&_tmp58_), NULL) : NULL;
				_g_object_unref0 (obj);
			} else {
				GParamSpec* _tmp59_ = NULL;
				GType _tmp60_ = 0UL;
				gboolean _tmp61_ = FALSE;
				_tmp59_ = prop;
				_tmp60_ = _tmp59_->value_type;
				_tmp61_ = g_type_is_a (_tmp60_, GXML_TYPE_SERIALIZABLE);
				if (_tmp61_) {
					GObject* obj = NULL;
					GParamSpec* _tmp62_ = NULL;
					GType _tmp63_ = 0UL;
					GObject* _tmp64_ = NULL;
					GObject* _tmp65_ = NULL;
					GObject* _tmp66_ = NULL;
					GXmlNode* _tmp67_ = NULL;
					GXmlNode* _tmp68_ = NULL;
					GXmlNode* _tmp69_ = NULL;
					GParamSpec* _tmp70_ = NULL;
					const gchar* _tmp71_ = NULL;
					GObject* _tmp72_ = NULL;
					GValue _tmp73_ = {0};
					_tmp62_ = prop;
					_tmp63_ = _tmp62_->value_type;
					_tmp64_ = g_object_new (_tmp63_, NULL);
					_tmp65_ = G_IS_INITIALLY_UNOWNED (_tmp64_) ? g_object_ref_sink (_tmp64_) : _tmp64_;
					obj = _tmp65_;
					_tmp66_ = obj;
					_tmp67_ = property_node;
					_tmp68_ = gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), _tmp67_, &_inner_error_);
					_tmp69_ = _tmp68_;
					_g_object_unref0 (_tmp69_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (obj);
						_g_object_unref0 (object);
						G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
						_g_param_spec_unref0 (prop);
						return FALSE;
					}
					_tmp70_ = prop;
					_tmp71_ = _tmp70_->name;
					_tmp72_ = obj;
					g_value_init (&_tmp73_, G_TYPE_OBJECT);
					g_value_set_object (&_tmp73_, _tmp72_);
					g_object_set_property ((GObject*) self, _tmp71_, &_tmp73_);
					G_IS_VALUE (&_tmp73_) ? (g_value_unset (&_tmp73_), NULL) : NULL;
					_g_object_unref0 (obj);
				}
			}
		} else {
			GObject* _tmp74_ = NULL;
			_tmp74_ = object;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, GXML_TYPE_SERIALIZABLE_PROPERTY)) {
				GObject* _tmp75_ = NULL;
				GXmlNode* _tmp76_ = NULL;
				GParamSpec* _tmp77_ = NULL;
				gboolean _tmp78_ = FALSE;
				_tmp75_ = object;
				_tmp76_ = property_node;
				_tmp77_ = prop;
				_tmp78_ = gxml_serializable_object_model_property_use_nick (self);
				gxml_serializable_property_deserialize_property (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty), _tmp76_, _tmp77_, _tmp78_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (object);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return FALSE;
				}
			} else {
				GObject* _tmp79_ = NULL;
				GXmlNode* _tmp80_ = NULL;
				GXmlNode* _tmp81_ = NULL;
				GXmlNode* _tmp82_ = NULL;
				_tmp79_ = object;
				_tmp80_ = property_node;
				_tmp81_ = gxml_serializable_deserialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), _tmp80_, &_inner_error_);
				_tmp82_ = _tmp81_;
				_g_object_unref0 (_tmp82_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (object);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return FALSE;
				}
			}
		}
		result = TRUE;
		_g_object_unref0 (object);
		G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
		_g_param_spec_unref0 (prop);
		return result;
	} else {
		GValue val = {0};
		GParamSpec* _tmp83_ = NULL;
		GType _tmp84_ = 0UL;
		GXmlNode* _tmp91_ = NULL;
		_tmp83_ = prop;
		_tmp84_ = _tmp83_->value_type;
		if (_tmp84_ == G_TYPE_ENUM) {
			GValue _tmp85_ = {0};
			GValue _tmp86_ = {0};
			g_value_init (&_tmp85_, G_TYPE_INT);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			val = _tmp85_;
			_tmp86_ = val;
		} else {
			GParamSpec* _tmp87_ = NULL;
			GType _tmp88_ = 0UL;
			GValue _tmp89_ = {0};
			GValue _tmp90_ = {0};
			_tmp87_ = prop;
			_tmp88_ = _tmp87_->value_type;
			g_value_init (&_tmp89_, _tmp88_);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			val = _tmp89_;
			_tmp90_ = val;
		}
		_tmp91_ = property_node;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp91_, GXML_TYPE_ATTRIBUTE)) {
			GParamSpec* _tmp92_ = NULL;
			GType _tmp93_ = 0UL;
			gboolean _tmp94_ = FALSE;
			GParamSpec* _tmp124_ = NULL;
			const gchar* _tmp125_ = NULL;
			GValue _tmp126_ = {0};
			_tmp92_ = prop;
			_tmp93_ = _tmp92_->value_type;
			_tmp94_ = g_type_is_a (_tmp93_, G_TYPE_ENUM);
			if (_tmp94_) {
				GEnumValue env = {0};
				{
					GEnumValue* _tmp95_ = NULL;
					GParamSpec* _tmp96_ = NULL;
					GType _tmp97_ = 0UL;
					GXmlNode* _tmp98_ = NULL;
					const gchar* _tmp99_ = NULL;
					const gchar* _tmp100_ = NULL;
					GEnumValue* _tmp101_ = NULL;
					GEnumValue* _tmp102_ = NULL;
					GEnumValue* _tmp103_ = NULL;
					GEnumValue _tmp104_ = {0};
					gint _tmp105_ = 0;
					_tmp96_ = prop;
					_tmp97_ = _tmp96_->value_type;
					_tmp98_ = property_node;
					_tmp99_ = gxml_node_get_value (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = gxml_enumeration_parse (_tmp97_, _tmp100_, &_inner_error_);
					_tmp95_ = _tmp101_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == GXML_ENUMERATION_ERROR) {
							goto __catch7_gxml_enumeration_error;
						}
						goto __finally7;
					}
					_tmp102_ = _tmp95_;
					_tmp95_ = NULL;
					_tmp103_ = _tmp102_;
					env = *_tmp103_;
					_g_free0 (_tmp103_);
					_tmp104_ = env;
					_tmp105_ = _tmp104_.value;
					g_value_set_enum (&val, _tmp105_);
					_g_free0 (_tmp95_);
				}
				goto __finally7;
				__catch7_gxml_enumeration_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally7:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return FALSE;
				}
			} else {
				gboolean _tmp106_ = FALSE;
				GXmlNode* _tmp107_ = NULL;
				const gchar* _tmp108_ = NULL;
				const gchar* _tmp109_ = NULL;
				gboolean _tmp110_ = FALSE;
				_tmp107_ = property_node;
				_tmp108_ = gxml_node_get_value (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = gxml_serializable_object_model_transform_from_string (self, _tmp109_, &val, &_inner_error_);
				_tmp106_ = _tmp110_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_param_spec_unref0 (prop);
					return FALSE;
				}
				if (!_tmp106_) {
					GValue ptmp = {0};
					GValue _tmp111_ = {0};
					GXmlNode* _tmp112_ = NULL;
					const gchar* _tmp113_ = NULL;
					const gchar* _tmp114_ = NULL;
					GParamSpec* _tmp115_ = NULL;
					GType _tmp116_ = 0UL;
					gboolean _tmp117_ = FALSE;
					g_value_init (&_tmp111_, G_TYPE_STRING);
					ptmp = _tmp111_;
					_tmp112_ = property_node;
					_tmp113_ = gxml_node_get_value (_tmp112_);
					_tmp114_ = _tmp113_;
					g_value_set_string (&ptmp, _tmp114_);
					_tmp115_ = prop;
					_tmp116_ = _tmp115_->value_type;
					_tmp117_ = g_value_type_transformable (G_TYPE_STRING, _tmp116_);
					if (_tmp117_) {
						gboolean _tmp118_ = FALSE;
						_tmp118_ = g_value_transform (&ptmp, &val);
						ret = _tmp118_;
					} else {
						gboolean _tmp119_ = FALSE;
						GXmlNode* _tmp120_ = NULL;
						const gchar* _tmp121_ = NULL;
						const gchar* _tmp122_ = NULL;
						gboolean _tmp123_ = FALSE;
						_tmp120_ = property_node;
						_tmp121_ = gxml_node_get_value (_tmp120_);
						_tmp122_ = _tmp121_;
						_tmp123_ = gxml_serializable_string_to_gvalue (_tmp122_, &val, &_inner_error_);
						_tmp119_ = _tmp123_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							g_propagate_error (error, _inner_error_);
							G_IS_VALUE (&ptmp) ? (g_value_unset (&ptmp), NULL) : NULL;
							G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
							_g_param_spec_unref0 (prop);
							return FALSE;
						}
						ret = _tmp119_;
					}
					G_IS_VALUE (&ptmp) ? (g_value_unset (&ptmp), NULL) : NULL;
				}
			}
			_tmp124_ = prop;
			_tmp125_ = _tmp124_->name;
			_tmp126_ = val;
			g_object_set_property ((GObject*) self, _tmp125_, &_tmp126_);
			result = ret;
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			_g_param_spec_unref0 (prop);
			return result;
		}
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	}
	_tmp127_ = property_node;
	_tmp128_ = prop;
	g_signal_emit_by_name ((GXmlSerializable*) self, "deserialize-unknown-property", _tmp127_, _tmp128_);
	result = TRUE;
	_g_param_spec_unref0 (prop);
	return result;
}


static gchar* gxml_serializable_object_model_real_to_string (GXmlSerializableObjectModel* self) {
	g_critical ("Type `%s' does not implement abstract method `gxml_serializable_object_model_to_string'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* gxml_serializable_object_model_to_string (GXmlSerializableObjectModel* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS (self)->to_string (self);
}


static gboolean _g_value_equal (const GValue* s1, const GValue* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return FALSE;
}


gboolean gxml_serializable_object_model_equals (GXmlSerializableObjectModel* a, GXmlSerializableObjectModel* b) {
	gboolean result = FALSE;
	GXmlSerializableObjectModel* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	GXmlSerializableObjectModel* _tmp2_ = NULL;
	GType _tmp3_ = 0UL;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = b;
	_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp0_);
	_tmp2_ = a;
	_tmp3_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp2_);
	if (_tmp1_ == _tmp3_) {
		GParamSpec** alp = NULL;
		GXmlSerializableObjectModel* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GParamSpec** _tmp6_ = NULL;
		gint alp_length1 = 0;
		gint _alp_size_ = 0;
		gboolean ret = FALSE;
		GParamSpec** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		_tmp4_ = a;
		_tmp6_ = gxml_serializable_list_serializable_properties (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), &_tmp5_);
		alp = _tmp6_;
		alp_length1 = _tmp5_;
		_alp_size_ = alp_length1;
		ret = TRUE;
		_tmp7_ = alp;
		_tmp7__length1 = alp_length1;
		{
			GParamSpec** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
			p_collection = _tmp7_;
			p_collection_length1 = _tmp7__length1;
			for (p_it = 0; p_it < _tmp7__length1; p_it = p_it + 1) {
				GParamSpec* _tmp8_ = NULL;
				GParamSpec* p = NULL;
				_tmp8_ = _g_param_spec_ref0 (p_collection[p_it]);
				p = _tmp8_;
				{
					GParamSpec* bp = NULL;
					GXmlSerializableObjectModel* _tmp9_ = NULL;
					GParamSpec* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					GParamSpec* _tmp12_ = NULL;
					GParamSpec* _tmp13_ = NULL;
					_tmp9_ = b;
					_tmp10_ = p;
					_tmp11_ = _tmp10_->name;
					_tmp12_ = gxml_serializable_find_property_spec (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), _tmp11_);
					bp = _tmp12_;
					_tmp13_ = bp;
					if (_tmp13_ != NULL) {
						GValue apval = {0};
						GParamSpec* _tmp14_ = NULL;
						GType _tmp15_ = 0UL;
						GValue _tmp16_ = {0};
						GXmlSerializableObjectModel* _tmp17_ = NULL;
						GParamSpec* _tmp18_ = NULL;
						GValue bpval = {0};
						GParamSpec* _tmp19_ = NULL;
						GType _tmp20_ = 0UL;
						GValue _tmp21_ = {0};
						GXmlSerializableObjectModel* _tmp22_ = NULL;
						GParamSpec* _tmp23_ = NULL;
						GValue _tmp24_ = {0};
						GValue _tmp25_ = {0};
						_tmp14_ = p;
						_tmp15_ = _tmp14_->value_type;
						g_value_init (&_tmp16_, _tmp15_);
						apval = _tmp16_;
						_tmp17_ = a;
						_tmp18_ = p;
						gxml_serializable_get_property_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), _tmp18_, &apval);
						_tmp19_ = bp;
						_tmp20_ = _tmp19_->value_type;
						g_value_init (&_tmp21_, _tmp20_);
						bpval = _tmp21_;
						_tmp22_ = b;
						_tmp23_ = bp;
						gxml_serializable_get_property_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), _tmp23_, &bpval);
						_tmp24_ = apval;
						_tmp25_ = bpval;
						if (_g_value_equal (&_tmp24_, &_tmp25_) != TRUE) {
							ret = FALSE;
						}
						G_IS_VALUE (&bpval) ? (g_value_unset (&bpval), NULL) : NULL;
						G_IS_VALUE (&apval) ? (g_value_unset (&apval), NULL) : NULL;
					}
					_g_param_spec_unref0 (bp);
					_g_param_spec_unref0 (p);
				}
			}
		}
		result = ret;
		alp = (_vala_array_free (alp, alp_length1, (GDestroyNotify) g_param_spec_unref), NULL);
		return result;
	}
	result = FALSE;
	return result;
}


GXmlSerializableObjectModel* gxml_serializable_object_model_construct (GType object_type) {
	GXmlSerializableObjectModel * self = NULL;
	self = (GXmlSerializableObjectModel*) g_object_new (object_type, NULL);
	return self;
}


static GParamSpec** gxml_serializable_object_model_real_get_properties (GXmlSerializable* base, int* result_length1) {
	GParamSpec** result;
	GXmlSerializableObjectModel* self;
	GParamSpec** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GParamSpec** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = self->priv->_properties;
	_tmp0__length1 = self->priv->_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static GParamSpec** _vala_array_dup4 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_ = NULL;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void gxml_serializable_object_model_real_set_properties (GXmlSerializable* base, GParamSpec** value, int value_length1) {
	GXmlSerializableObjectModel* self;
	GParamSpec** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GParamSpec** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup4 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_properties = (_vala_array_free (self->priv->_properties, self->priv->_properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	self->priv->_properties = _tmp1_;
	self->priv->_properties_length1 = _tmp1__length1;
	self->priv->__properties_size_ = self->priv->_properties_length1;
}


static GHashTable* gxml_serializable_object_model_real_get_ignored_serializable_properties (GXmlSerializable* base) {
	GHashTable* result;
	GXmlSerializableObjectModel* self;
	GHashTable* _tmp0_ = NULL;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = self->priv->_ignored_serializable_properties;
	result = _tmp0_;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void gxml_serializable_object_model_real_set_ignored_serializable_properties (GXmlSerializable* base, GHashTable* value) {
	GXmlSerializableObjectModel* self;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = value;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	_g_hash_table_unref0 (self->priv->_ignored_serializable_properties);
	self->priv->_ignored_serializable_properties = _tmp1_;
	g_object_notify ((GObject *) self, "ignored-serializable-properties");
}


static const gchar* gxml_serializable_object_model_real_get_serialized_xml_node_value (GXmlSerializable* base) {
	const gchar* result;
	GXmlSerializableObjectModel* self;
	const gchar* _tmp0_ = NULL;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = self->priv->_serialized_xml_node_value;
	result = _tmp0_;
	return result;
}


static void gxml_serializable_object_model_real_set_serialized_xml_node_value (GXmlSerializable* base, const gchar* value) {
	GXmlSerializableObjectModel* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_serialized_xml_node_value);
	self->priv->_serialized_xml_node_value = _tmp1_;
	g_object_notify ((GObject *) self, "serialized-xml-node-value");
}


static GeeMap* gxml_serializable_object_model_real_get_unknown_serializable_properties (GXmlSerializable* base) {
	GeeMap* result;
	GXmlSerializableObjectModel* self;
	GXmlTwDocument* _tmp0_ = NULL;
	GXmlTwDocument* _tmp1_ = NULL;
	GXmlNode* _tmp2_ = NULL;
	GXmlNode* _tmp3_ = NULL;
	GeeMap* _tmp4_ = NULL;
	GeeMap* _tmp5_ = NULL;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = self->_doc;
	if (_tmp0_ == NULL) {
		gxml_serializable_object_model_init_unknown_doc (self);
	}
	_tmp1_ = self->_doc;
	_tmp2_ = gxml_document_get_root ((GXmlDocument*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gxml_node_get_attrs (_tmp3_);
	_tmp5_ = _tmp4_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_MAP, GeeMap);
	return result;
}


static GeeCollection* gxml_serializable_object_model_real_get_unknown_serializable_nodes (GXmlSerializable* base) {
	GeeCollection* result;
	GXmlSerializableObjectModel* self;
	GXmlTwDocument* _tmp0_ = NULL;
	GXmlTwDocument* _tmp1_ = NULL;
	GXmlNode* _tmp2_ = NULL;
	GXmlNode* _tmp3_ = NULL;
	GeeBidirList* _tmp4_ = NULL;
	GeeBidirList* _tmp5_ = NULL;
	self = (GXmlSerializableObjectModel*) base;
	_tmp0_ = self->_doc;
	if (_tmp0_ == NULL) {
		gxml_serializable_object_model_init_unknown_doc (self);
	}
	_tmp1_ = self->_doc;
	_tmp2_ = gxml_document_get_root ((GXmlDocument*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gxml_node_get_childs (_tmp3_);
	_tmp5_ = _tmp4_;
	result = (GeeCollection*) _tmp5_;
	return result;
}


static GObject * gxml_serializable_object_model_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GXmlSerializableObjectModel * self;
	parent_class = G_OBJECT_CLASS (gxml_serializable_object_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	gxml_init_init ();
	return obj;
}


static void gxml_serializable_object_model_class_init (GXmlSerializableObjectModelClass * klass) {
	gxml_serializable_object_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlSerializableObjectModelPrivate));
	((GXmlSerializableObjectModelClass *) klass)->get_enable_unknown_serializable_property = gxml_serializable_object_model_real_get_enable_unknown_serializable_property;
	((GXmlSerializableObjectModelClass *) klass)->serialize_use_xml_node_value = gxml_serializable_object_model_real_serialize_use_xml_node_value;
	((GXmlSerializableObjectModelClass *) klass)->property_use_nick = gxml_serializable_object_model_real_property_use_nick;
	((GXmlSerializableObjectModelClass *) klass)->set_namespace = gxml_serializable_object_model_real_set_namespace;
	((GXmlSerializableObjectModelClass *) klass)->node_name = gxml_serializable_object_model_real_node_name;
	((GXmlSerializableObjectModelClass *) klass)->find_property_spec = gxml_serializable_object_model_real_find_property_spec;
	((GXmlSerializableObjectModelClass *) klass)->init_properties = gxml_serializable_object_model_real_init_properties;
	((GXmlSerializableObjectModelClass *) klass)->list_serializable_properties = gxml_serializable_object_model_real_list_serializable_properties;
	((GXmlSerializableObjectModelClass *) klass)->get_property_value = gxml_serializable_object_model_real_get_property_value;
	((GXmlSerializableObjectModelClass *) klass)->set_property_value = gxml_serializable_object_model_real_set_property_value;
	((GXmlSerializableObjectModelClass *) klass)->transform_from_string = gxml_serializable_object_model_real_transform_from_string;
	((GXmlSerializableObjectModelClass *) klass)->transform_to_string = gxml_serializable_object_model_real_transform_to_string;
	((GXmlSerializableObjectModelClass *) klass)->serialize = gxml_serializable_object_model_real_serialize;
	((GXmlSerializableObjectModelClass *) klass)->serialize_property = gxml_serializable_object_model_real_serialize_property;
	((GXmlSerializableObjectModelClass *) klass)->deserialize = gxml_serializable_object_model_real_deserialize;
	((GXmlSerializableObjectModelClass *) klass)->deserialize_property = gxml_serializable_object_model_real_deserialize_property;
	((GXmlSerializableObjectModelClass *) klass)->to_string = gxml_serializable_object_model_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_serializable_object_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_serializable_object_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = gxml_serializable_object_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = gxml_serializable_object_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES, g_param_spec_boxed ("ignored-serializable-properties", "ignored-serializable-properties", "ignored-serializable-properties", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE, g_param_spec_string ("serialized-xml-node-value", "serialized-xml-node-value", "serialized-xml-node-value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * All unknown nodes, will be stored in a per-object {@link GXml.Document}
	   * in its {@link GXml.Element} root. Then, all unknown properties will be
	   * stored as properties in document's root and all unknown childs {@link GXml.Node}
	   * as root's childs.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_PROPERTIES, g_param_spec_object ("unknown-serializable-properties", "unknown-serializable-properties", "unknown-serializable-properties", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_NODES, g_param_spec_object ("unknown-serializable-nodes", "unknown-serializable-nodes", "unknown-serializable-nodes", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gxml_serializable_object_model_gxml_serializable_interface_init (GXmlSerializableIface * iface) {
	gxml_serializable_object_model_gxml_serializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_enable_unknown_serializable_property = (gboolean (*)(GXmlSerializable*)) gxml_serializable_object_model_get_enable_unknown_serializable_property;
	iface->serialize_use_xml_node_value = (gboolean (*)(GXmlSerializable*)) gxml_serializable_object_model_serialize_use_xml_node_value;
	iface->property_use_nick = (gboolean (*)(GXmlSerializable*)) gxml_serializable_object_model_property_use_nick;
	iface->set_namespace = (gboolean (*)(GXmlSerializable*, GXmlNode*)) gxml_serializable_object_model_set_namespace;
	iface->node_name = (gchar* (*)(GXmlSerializable*)) gxml_serializable_object_model_node_name;
	iface->find_property_spec = (GParamSpec* (*)(GXmlSerializable*, const gchar*)) gxml_serializable_object_model_find_property_spec;
	iface->init_properties = (void (*)(GXmlSerializable*)) gxml_serializable_object_model_init_properties;
	iface->list_serializable_properties = (GParamSpec** (*)(GXmlSerializable*, int*)) gxml_serializable_object_model_list_serializable_properties;
	iface->get_property_value = (void (*)(GXmlSerializable*, GParamSpec*, GValue*)) gxml_serializable_object_model_get_property_value;
	iface->set_property_value = (void (*)(GXmlSerializable*, GParamSpec*, GValue*)) gxml_serializable_object_model_set_property_value;
	iface->transform_from_string = (gboolean (*)(GXmlSerializable*, const gchar*, GValue*, GError**)) gxml_serializable_object_model_transform_from_string;
	iface->transform_to_string = (gboolean (*)(GXmlSerializable*, GValue*, gchar**, GError**)) gxml_serializable_object_model_transform_to_string;
	iface->serialize = (GXmlNode* (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_object_model_serialize;
	iface->serialize_property = (GXmlNode* (*)(GXmlSerializable*, GXmlNode*, GParamSpec*, GError**)) gxml_serializable_object_model_serialize_property;
	iface->deserialize = (GXmlNode* (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_object_model_deserialize;
	iface->deserialize_property = (gboolean (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_object_model_deserialize_property;
	iface->get_properties = gxml_serializable_object_model_real_get_properties;
	iface->set_properties = gxml_serializable_object_model_real_set_properties;
	iface->get_ignored_serializable_properties = gxml_serializable_object_model_real_get_ignored_serializable_properties;
	iface->set_ignored_serializable_properties = gxml_serializable_object_model_real_set_ignored_serializable_properties;
	iface->get_serialized_xml_node_value = gxml_serializable_object_model_real_get_serialized_xml_node_value;
	iface->set_serialized_xml_node_value = gxml_serializable_object_model_real_set_serialized_xml_node_value;
	iface->get_unknown_serializable_properties = gxml_serializable_object_model_real_get_unknown_serializable_properties;
	iface->get_unknown_serializable_nodes = gxml_serializable_object_model_real_get_unknown_serializable_nodes;
}


static void gxml_serializable_object_model_instance_init (GXmlSerializableObjectModel * self) {
	self->priv = GXML_SERIALIZABLE_OBJECT_MODEL_GET_PRIVATE (self);
	self->_doc = NULL;
	self->priv->_serialized_xml_node_value = NULL;
}


static void gxml_serializable_object_model_finalize (GObject* obj) {
	GXmlSerializableObjectModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	_g_object_unref0 (self->_doc);
	self->priv->_properties = (_vala_array_free (self->priv->_properties, self->priv->_properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_hash_table_unref0 (self->priv->_ignored_serializable_properties);
	_g_free0 (self->priv->_serialized_xml_node_value);
	G_OBJECT_CLASS (gxml_serializable_object_model_parent_class)->finalize (obj);
}


/**
 * Object Model is an {@link Serializable} implementation using {@link Element}
 * to represent {@link GLib.Object} class objects.
 * 
 * This implementation consider each object as a XML node, represented in GXml 
 * as a {@link GXml.Element} and its properties is represented by {@link GXml.Attribute}.
 * Each property, if it is a {@link Serializable} object, is represented as child
 * {@link Element}.
 * 
 * If a object's value property must be represented as a XML node content, 
 * then it requires to override {@link Serializable.serialize_use_xml_node_value}
 * and set value at {@link Serializable.serialized_xml_node_value}.
 */
GType gxml_serializable_object_model_get_type (void) {
	static volatile gsize gxml_serializable_object_model_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_object_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableObjectModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serializable_object_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlSerializableObjectModel), 0, (GInstanceInitFunc) gxml_serializable_object_model_instance_init, NULL };
		static const GInterfaceInfo gxml_serializable_info = { (GInterfaceInitFunc) gxml_serializable_object_model_gxml_serializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gxml_serializable_object_model_type_id;
		gxml_serializable_object_model_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlSerializableObjectModel", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (gxml_serializable_object_model_type_id, GXML_TYPE_SERIALIZABLE, &gxml_serializable_info);
		g_once_init_leave (&gxml_serializable_object_model_type_id__volatile, gxml_serializable_object_model_type_id);
	}
	return gxml_serializable_object_model_type_id__volatile;
}


static void _vala_gxml_serializable_object_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlSerializableObjectModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	switch (property_id) {
		case GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES:
		g_value_set_boxed (value, gxml_serializable_get_ignored_serializable_properties ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE:
		g_value_set_string (value, gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_PROPERTIES:
		g_value_set_object (value, gxml_serializable_get_unknown_serializable_properties ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_UNKNOWN_SERIALIZABLE_NODES:
		g_value_set_object (value, gxml_serializable_get_unknown_serializable_nodes ((GXmlSerializable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_serializable_object_model_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlSerializableObjectModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel);
	switch (property_id) {
		case GXML_SERIALIZABLE_OBJECT_MODEL_IGNORED_SERIALIZABLE_PROPERTIES:
		gxml_serializable_set_ignored_serializable_properties ((GXmlSerializable*) self, g_value_get_boxed (value));
		break;
		case GXML_SERIALIZABLE_OBJECT_MODEL_SERIALIZED_XML_NODE_VALUE:
		gxml_serializable_set_serialized_xml_node_value ((GXmlSerializable*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



