/* SerializableJson.c generated by valac 0.28.1, the Vala compiler
 * generated from SerializableJson.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/* Serialization.vala
 *
 * Copyright (C) 2012-2013  Richard Schwarting <aquarichy@gmail.com>
 * Copyright (C) 2013-2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Richard Schwarting <aquarichy@gmail.com>
 *       Daniel Espinosa <esodan@gmail.com>
 */
/*
  Version 3: json-glib version

  PLAN:
  * add support for GObject Introspection to allow us to serialise non-property members

  json-glib
  * has functions to convert XML structures into Objects and vice versa
  * can convert simple objects automatically
  * richer objects need to implement interface

  json_serializable_real_serialize -> json_serialize_pspec
  * how do these get used with GInterfaces?  are these default methods like with superclasses?
  * TODO: I don't think vala does multiple inheritance, so do we want GXml.Serializable to be an interface or a superclass?

  json_serializable_default_{de,}serialize_property -> json_serializable_real_{de,}serialize

  json_serializable_{de,}serialize_property -> iface->{de,}serialize_property
    these all get init'd to -> json_serializable_real_{de,}serialize_property
      these all call -> json_{de,}serialize_pspec

  json_serializable_{find,list,get,set}_propert{y,ies} -> iface->{find,list,get,set}_propert{y,ies}
    these all get init'd to -> json_serializable_real_{find,list,get,set}_propert{y,ies}
    these all call -> g_object_{class,}_{find,list,get,set}_propert{y,ies}
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_ATTRIBUTE (gxml_attribute_get_type ())
#define GXML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttribute))
#define GXML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTRIBUTE))
#define GXML_ATTRIBUTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttributeIface))

typedef struct _GXmlAttribute GXmlAttribute;
typedef struct _GXmlAttributeIface GXmlAttributeIface;

#define GXML_TYPE_SERIALIZABLE_JSON (gxml_serializable_json_get_type ())
#define GXML_SERIALIZABLE_JSON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJson))
#define GXML_SERIALIZABLE_JSON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJsonClass))
#define GXML_IS_SERIALIZABLE_JSON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_JSON))
#define GXML_IS_SERIALIZABLE_JSON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_JSON))
#define GXML_SERIALIZABLE_JSON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJsonClass))

typedef struct _GXmlSerializableJson GXmlSerializableJson;
typedef struct _GXmlSerializableJsonClass GXmlSerializableJsonClass;
typedef struct _GXmlSerializableJsonPrivate GXmlSerializableJsonPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GXML_TYPE_XNODE (gxml_xnode_get_type ())
#define GXML_XNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XNODE, GXmlxNode))
#define GXML_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XNODE, GXmlxNodeClass))
#define GXML_IS_XNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XNODE))
#define GXML_IS_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XNODE))
#define GXML_XNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XNODE, GXmlxNodeClass))

typedef struct _GXmlxNode GXmlxNode;
typedef struct _GXmlxNodeClass GXmlxNodeClass;

#define GXML_TYPE_XDOCUMENT (gxml_xdocument_get_type ())
#define GXML_XDOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XDOCUMENT, GXmlxDocument))
#define GXML_XDOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XDOCUMENT, GXmlxDocumentClass))
#define GXML_IS_XDOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XDOCUMENT))
#define GXML_IS_XDOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XDOCUMENT))
#define GXML_XDOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XDOCUMENT, GXmlxDocumentClass))

typedef struct _GXmlxDocument GXmlxDocument;
typedef struct _GXmlxDocumentClass GXmlxDocumentClass;

#define GXML_TYPE_BACKED_NODE (gxml_backed_node_get_type ())
#define GXML_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNode))
#define GXML_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))
#define GXML_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_BACKED_NODE))
#define GXML_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_BACKED_NODE))
#define GXML_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_BACKED_NODE, GXmlBackedNodeClass))

typedef struct _GXmlBackedNode GXmlBackedNode;
typedef struct _GXmlBackedNodeClass GXmlBackedNodeClass;

#define GXML_TYPE_XELEMENT (gxml_xelement_get_type ())
#define GXML_XELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XELEMENT, GXmlxElement))
#define GXML_XELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XELEMENT, GXmlxElementClass))
#define GXML_IS_XELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XELEMENT))
#define GXML_IS_XELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XELEMENT))
#define GXML_XELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XELEMENT, GXmlxElementClass))

typedef struct _GXmlxElement GXmlxElement;
typedef struct _GXmlxElementClass GXmlxElementClass;
#define _g_param_spec_unref0(var) ((var == NULL) ? NULL : (var = (g_param_spec_unref (var), NULL)))

#define GXML_TYPE_XCHARACTER_DATA (gxml_xcharacter_data_get_type ())
#define GXML_XCHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XCHARACTER_DATA, GXmlxCharacterData))
#define GXML_XCHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XCHARACTER_DATA, GXmlxCharacterDataClass))
#define GXML_IS_XCHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XCHARACTER_DATA))
#define GXML_IS_XCHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XCHARACTER_DATA))
#define GXML_XCHARACTER_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XCHARACTER_DATA, GXmlxCharacterDataClass))

typedef struct _GXmlxCharacterData GXmlxCharacterData;
typedef struct _GXmlxCharacterDataClass GXmlxCharacterDataClass;

#define GXML_TYPE_XTEXT (gxml_xtext_get_type ())
#define GXML_XTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_XTEXT, GXmlxText))
#define GXML_XTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_XTEXT, GXmlxTextClass))
#define GXML_IS_XTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_XTEXT))
#define GXML_IS_XTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_XTEXT))
#define GXML_XTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_XTEXT, GXmlxTextClass))

typedef struct _GXmlxText GXmlxText;
typedef struct _GXmlxTextClass GXmlxTextClass;

#define GXML_TYPE_NODE_LIST (gxml_node_list_get_type ())
#define GXML_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE_LIST, GXmlNodeList))
#define GXML_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE_LIST))
#define GXML_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE_LIST, GXmlNodeListIface))

typedef struct _GXmlNodeList GXmlNodeList;
typedef struct _GXmlNodeListIface GXmlNodeListIface;

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ELEMENT, GXmlElementIface))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementIface GXmlElementIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	const gchar* (*get_uri) (GXmlNamespace* self);
	const gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_X_UNKNOWN = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_childs) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	const gchar* (*get_name) (GXmlNode* self);
	const gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
};

struct _GXmlAttributeIface {
	GTypeInterface parent_iface;
};

struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializable* self);
	gboolean (*set_namespace) (GXmlSerializable* self, GXmlNode* node);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializable* self);
	gchar* (*node_name) (GXmlSerializable* self);
	gboolean (*property_use_nick) (GXmlSerializable* self);
	GXmlNode* (*serialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializable* self, GXmlNode* element, GParamSpec* prop, GError** error);
	GXmlNode* (*deserialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializable* self, GXmlNode* property_node, GError** error);
	GParamSpec* (*find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec* (*default_find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	void (*init_properties) (GXmlSerializable* self);
	void (*default_init_properties) (GXmlSerializable* self);
	GParamSpec** (*list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GParamSpec** (*default_list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	void (*get_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*default_get_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*set_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	void (*default_set_property_value) (GXmlSerializable* self, GParamSpec* spec, GValue* val);
	gboolean (*transform_from_string) (GXmlSerializable* self, const gchar* str, GValue* dest, GError** error);
	gboolean (*transform_to_string) (GXmlSerializable* self, GValue* val, gchar** str, GError** error);
	GParamSpec** (*get_properties) (GXmlSerializable* self, int* result_length1);
	void (*set_properties) (GXmlSerializable* self, GParamSpec** value, int value_length1);
	GHashTable* (*get_ignored_serializable_properties) (GXmlSerializable* self);
	void (*set_ignored_serializable_properties) (GXmlSerializable* self, GHashTable* value);
	GeeMap* (*get_unknown_serializable_properties) (GXmlSerializable* self);
	GeeCollection* (*get_unknown_serializable_nodes) (GXmlSerializable* self);
	const gchar* (*get_serialized_xml_node_value) (GXmlSerializable* self);
	void (*set_serialized_xml_node_value) (GXmlSerializable* self, const gchar* value);
};

struct _GXmlSerializableJson {
	GObject parent_instance;
	GXmlSerializableJsonPrivate * priv;
};

struct _GXmlSerializableJsonClass {
	GObjectClass parent_class;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializableJson* self);
	gboolean (*set_namespace) (GXmlSerializableJson* self, GXmlNode* node);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializableJson* self);
	gchar* (*node_name) (GXmlSerializableJson* self);
	gboolean (*property_use_nick) (GXmlSerializableJson* self);
	GParamSpec* (*find_property_spec) (GXmlSerializableJson* self, const gchar* property_name);
	void (*init_properties) (GXmlSerializableJson* self);
	GParamSpec** (*list_serializable_properties) (GXmlSerializableJson* self, int* result_length1);
	void (*get_property_value) (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
	void (*set_property_value) (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
	gboolean (*transform_from_string) (GXmlSerializableJson* self, const gchar* str, GValue* dest, GError** error);
	gboolean (*transform_to_string) (GXmlSerializableJson* self, GValue* val, gchar** str, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableJson* self, GXmlNode* node, GParamSpec* prop, GError** error);
	gboolean (*deserialize_property) (GXmlSerializableJson* self, GXmlNode* nproperty, GError** error);
};

struct _GXmlSerializableJsonPrivate {
	GeeHashMap* _unknown_serializable_property;
	GeeArrayList* _unknown_serializable_nodes;
	GParamSpec** _properties;
	gint _properties_length1;
	gint __properties_size_;
	GHashTable* _ignored_serializable_properties;
	gchar* _serialized_xml_node_value;
};

struct _GXmlNodeListIface {
	GTypeInterface parent_iface;
	GXmlxNode* (*item) (GXmlNodeList* self, gulong idx);
	GXmlxNode* (*insert_before) (GXmlNodeList* self, GXmlxNode* new_child, GXmlxNode* ref_child);
	GXmlxNode* (*replace_child) (GXmlNodeList* self, GXmlxNode* new_child, GXmlxNode* old_child);
	GXmlxNode* (*remove_child) (GXmlNodeList* self, GXmlxNode* old_child);
	GXmlxNode* (*append_child) (GXmlNodeList* self, GXmlxNode* new_child);
	gchar* (*to_string) (GXmlNodeList* self, gboolean in_line);
	GXmlxNode* (*first) (GXmlNodeList* self);
	GXmlxNode* (*last) (GXmlNodeList* self);
	GXmlxNode* (*get) (GXmlNodeList* self, gint n);
	gulong (*get_length) (GXmlNodeList* self);
	void (*set_length) (GXmlNodeList* self, gulong value);
};

struct _GXmlElementIface {
	GTypeInterface parent_iface;
	void (*normalize) (GXmlElement* self);
	void (*set_attr) (GXmlElement* self, const gchar* name, const gchar* value);
	GXmlNode* (*get_attr) (GXmlElement* self, const gchar* name);
	void (*finalize_attr) (GXmlElement* self);
	const gchar* (*get_tag_name) (GXmlElement* self);
	gchar* (*get_content) (GXmlElement* self);
	void (*set_content) (GXmlElement* self, const gchar* value);
};

typedef enum  {
	GXML_SERIALIZABLE_ERROR_UNSUPPORTED_TYPE_ERROR,
	GXML_SERIALIZABLE_ERROR_STR_TO_VALUE_ERROR
} GXmlSerializableError;
#define GXML_SERIALIZABLE_ERROR gxml_serializable_error_quark ()

static gpointer gxml_serializable_json_parent_class = NULL;
static GXmlSerializableIface* gxml_serializable_json_gxml_serializable_parent_iface = NULL;

GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_attribute_get_type (void) G_GNUC_CONST;
GType gxml_serializable_get_type (void) G_GNUC_CONST;
GType gxml_serializable_json_get_type (void) G_GNUC_CONST;
#define GXML_SERIALIZABLE_JSON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJsonPrivate))
enum  {
	GXML_SERIALIZABLE_JSON_DUMMY_PROPERTY,
	GXML_SERIALIZABLE_JSON_IGNORED_SERIALIZABLE_PROPERTIES,
	GXML_SERIALIZABLE_JSON_SERIALIZED_XML_NODE_VALUE,
	GXML_SERIALIZABLE_JSON_UNKNOWN_SERIALIZABLE_PROPERTIES,
	GXML_SERIALIZABLE_JSON_UNKNOWN_SERIALIZABLE_NODES
};
gboolean gxml_serializable_json_get_enable_unknown_serializable_property (GXmlSerializableJson* self);
static gboolean gxml_serializable_json_real_get_enable_unknown_serializable_property (GXmlSerializableJson* self);
gboolean gxml_serializable_json_set_namespace (GXmlSerializableJson* self, GXmlNode* node);
static gboolean gxml_serializable_json_real_set_namespace (GXmlSerializableJson* self, GXmlNode* node);
gboolean gxml_serializable_json_serialize_use_xml_node_value (GXmlSerializableJson* self);
static gboolean gxml_serializable_json_real_serialize_use_xml_node_value (GXmlSerializableJson* self);
gchar* gxml_serializable_json_node_name (GXmlSerializableJson* self);
static gchar* gxml_serializable_json_real_node_name (GXmlSerializableJson* self);
gboolean gxml_serializable_json_property_use_nick (GXmlSerializableJson* self);
static gboolean gxml_serializable_json_real_property_use_nick (GXmlSerializableJson* self);
GParamSpec* gxml_serializable_json_find_property_spec (GXmlSerializableJson* self, const gchar* property_name);
static GParamSpec* gxml_serializable_json_real_find_property_spec (GXmlSerializableJson* self, const gchar* property_name);
GParamSpec* gxml_serializable_default_find_property_spec (GXmlSerializable* self, const gchar* property_name);
void gxml_serializable_json_init_properties (GXmlSerializableJson* self);
static void gxml_serializable_json_real_init_properties (GXmlSerializableJson* self);
void gxml_serializable_default_init_properties (GXmlSerializable* self);
GParamSpec** gxml_serializable_json_list_serializable_properties (GXmlSerializableJson* self, int* result_length1);
static GParamSpec** gxml_serializable_json_real_list_serializable_properties (GXmlSerializableJson* self, int* result_length1);
GParamSpec** gxml_serializable_default_list_serializable_properties (GXmlSerializable* self, int* result_length1);
void gxml_serializable_json_get_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
static void gxml_serializable_json_real_get_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
void gxml_serializable_default_get_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
void gxml_serializable_json_set_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
static void gxml_serializable_json_real_set_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val);
void gxml_serializable_default_set_property_value (GXmlSerializable* self, GParamSpec* spec, GValue* val);
gboolean gxml_serializable_json_transform_from_string (GXmlSerializableJson* self, const gchar* str, GValue* dest, GError** error);
static gboolean gxml_serializable_json_real_transform_from_string (GXmlSerializableJson* self, const gchar* str, GValue* dest, GError** error);
gboolean gxml_serializable_json_transform_to_string (GXmlSerializableJson* self, GValue* val, gchar** str, GError** error);
static gboolean gxml_serializable_json_real_transform_to_string (GXmlSerializableJson* self, GValue* val, gchar** str, GError** error);
static GXmlNode* gxml_serializable_json_real_serialize (GXmlSerializable* base, GXmlNode* node, GError** error);
GType gxml_xnode_get_type (void) G_GNUC_CONST;
GType gxml_xdocument_get_type (void) G_GNUC_CONST;
GType gxml_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_xelement_get_type (void) G_GNUC_CONST;
GXmlDocument* gxml_node_get_document (GXmlNode* self);
GXmlNode* gxml_document_create_element (GXmlDocument* self, const gchar* name);
GXmlxNode* gxml_xnode_append_child (GXmlxNode* self, GXmlxNode* new_child);
void gxml_xelement_set_attribute (GXmlxElement* self, const gchar* name, const gchar* value);
GXmlNode* gxml_serializable_json_serialize_property (GXmlSerializableJson* self, GXmlNode* node, GParamSpec* prop, GError** error);
static GXmlNode* gxml_serializable_json_real_serialize_property (GXmlSerializableJson* self, GXmlNode* node, GParamSpec* prop, GError** error);
GXmlNode* gxml_serializable_serialize (GXmlSerializable* self, GXmlNode* node, GError** error);
GXmlxDocument* gxml_xnode_get_owner_document (GXmlxNode* self);
GType gxml_xcharacter_data_get_type (void) G_GNUC_CONST;
GType gxml_xtext_get_type (void) G_GNUC_CONST;
GXmlxText* gxml_xdocument_create_text_node (GXmlxDocument* self, const gchar* text_data);
GeeBidirList* gxml_xnode_get_childs (GXmlxNode* self);
GXmlxDocument* gxml_serialization_serialize_object (GObject* object, GError** error);
GXmlxElement* gxml_xdocument_get_document_element (GXmlxDocument* self);
const gchar* gxml_xnode_get_name (GXmlxNode* self);
gboolean gxml_node_copy (GXmlDocument* doc, GXmlNode* node, GXmlNode* source, gboolean deep);
static GXmlNode* gxml_serializable_json_real_deserialize (GXmlSerializable* base, GXmlNode* n, GError** error);
GType gxml_node_list_get_type (void) G_GNUC_CONST;
GXmlNodeList* gxml_xnode_get_child_nodes (GXmlxNode* self);
GXmlxNode* gxml_node_list_get (GXmlNodeList* self, gint n);
gboolean gxml_serializable_json_deserialize_property (GXmlSerializableJson* self, GXmlNode* nproperty, GError** error);
static gboolean gxml_serializable_json_real_deserialize_property (GXmlSerializableJson* self, GXmlNode* nproperty, GError** error);
const gchar* gxml_xnode_get_node_name (GXmlxNode* self);
gchar* gxml_xelement_get_attribute (GXmlxElement* self, const gchar* name);
gchar* gxml_xnode_stringify (GXmlxNode* self, gboolean format, gint level);
GeeMap* gxml_serializable_get_unknown_serializable_properties (GXmlSerializable* self);
GXmlNode* gxml_serializable_deserialize (GXmlSerializable* self, GXmlNode* node, GError** error);
GType gxml_element_get_type (void) G_GNUC_CONST;
gchar* gxml_element_get_content (GXmlElement* self);
GQuark gxml_serializable_error_quark (void);
gboolean gxml_serializable_string_to_gvalue (const gchar* str, GValue* dest, GError** error);
GXmlxNode* gxml_xnode_get_first_child (GXmlxNode* self);
GObject* gxml_serialization_deserialize_object_from_node (GXmlxNode* obj_node, GError** error);
GXmlSerializableJson* gxml_serializable_json_new (void);
GXmlSerializableJson* gxml_serializable_json_construct (GType object_type);
static GParamSpec** _vala_array_dup5 (GParamSpec** self, int length);
static GObject * gxml_serializable_json_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void gxml_init_init (void);
static void gxml_serializable_json_finalize (GObject* obj);
GHashTable* gxml_serializable_get_ignored_serializable_properties (GXmlSerializable* self);
const gchar* gxml_serializable_get_serialized_xml_node_value (GXmlSerializable* self);
GeeCollection* gxml_serializable_get_unknown_serializable_nodes (GXmlSerializable* self);
static void _vala_gxml_serializable_json_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gxml_serializable_set_ignored_serializable_properties (GXmlSerializable* self, GHashTable* value);
void gxml_serializable_set_serialized_xml_node_value (GXmlSerializable* self, const gchar* value);
static void _vala_gxml_serializable_json_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gboolean gxml_serializable_json_real_get_enable_unknown_serializable_property (GXmlSerializableJson* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_get_enable_unknown_serializable_property (GXmlSerializableJson* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->get_enable_unknown_serializable_property (self);
}


static gboolean gxml_serializable_json_real_set_namespace (GXmlSerializableJson* self, GXmlNode* node) {
	gboolean result = FALSE;
	g_return_val_if_fail (node != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean gxml_serializable_json_set_namespace (GXmlSerializableJson* self, GXmlNode* node) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->set_namespace (self, node);
}


static gboolean gxml_serializable_json_real_serialize_use_xml_node_value (GXmlSerializableJson* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_serialize_use_xml_node_value (GXmlSerializableJson* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->serialize_use_xml_node_value (self);
}


static gchar* gxml_serializable_json_real_node_name (GXmlSerializableJson* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	_tmp0_ = g_strdup ("Object");
	result = _tmp0_;
	return result;
}


gchar* gxml_serializable_json_node_name (GXmlSerializableJson* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->node_name (self);
}


static gboolean gxml_serializable_json_real_property_use_nick (GXmlSerializableJson* self) {
	gboolean result = FALSE;
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_property_use_nick (GXmlSerializableJson* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->property_use_nick (self);
}


static GParamSpec* gxml_serializable_json_real_find_property_spec (GXmlSerializableJson* self, const gchar* property_name) {
	GParamSpec* result = NULL;
	const gchar* _tmp0_ = NULL;
	GParamSpec* _tmp1_ = NULL;
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp0_ = property_name;
	_tmp1_ = gxml_serializable_default_find_property_spec ((GXmlSerializable*) self, _tmp0_);
	result = _tmp1_;
	return result;
}


GParamSpec* gxml_serializable_json_find_property_spec (GXmlSerializableJson* self, const gchar* property_name) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->find_property_spec (self, property_name);
}


static void gxml_serializable_json_real_init_properties (GXmlSerializableJson* self) {
	gxml_serializable_default_init_properties ((GXmlSerializable*) self);
}


void gxml_serializable_json_init_properties (GXmlSerializableJson* self) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_JSON_GET_CLASS (self)->init_properties (self);
}


static GParamSpec** gxml_serializable_json_real_list_serializable_properties (GXmlSerializableJson* self, int* result_length1) {
	GParamSpec** result = NULL;
	gint _tmp0_ = 0;
	GParamSpec** _tmp1_ = NULL;
	GParamSpec** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	_tmp1_ = gxml_serializable_default_list_serializable_properties ((GXmlSerializable*) self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


GParamSpec** gxml_serializable_json_list_serializable_properties (GXmlSerializableJson* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->list_serializable_properties (self, result_length1);
}


static void gxml_serializable_json_real_get_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val) {
	GParamSpec* _tmp0_ = NULL;
	g_return_if_fail (spec != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = spec;
	gxml_serializable_default_get_property_value ((GXmlSerializable*) self, _tmp0_, val);
}


void gxml_serializable_json_get_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_JSON_GET_CLASS (self)->get_property_value (self, spec, val);
}


static void gxml_serializable_json_real_set_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val) {
	GParamSpec* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	g_return_if_fail (spec != NULL);
	g_return_if_fail (val != NULL);
	_tmp0_ = spec;
	_tmp1_ = *val;
	gxml_serializable_default_set_property_value ((GXmlSerializable*) self, _tmp0_, &_tmp1_);
}


void gxml_serializable_json_set_property_value (GXmlSerializableJson* self, GParamSpec* spec, GValue* val) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_JSON_GET_CLASS (self)->set_property_value (self, spec, val);
}


static gboolean gxml_serializable_json_real_transform_from_string (GXmlSerializableJson* self, const gchar* str, GValue* dest, GError** error) {
	gboolean result = FALSE;
	g_return_val_if_fail (str != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_transform_from_string (GXmlSerializableJson* self, const gchar* str, GValue* dest, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->transform_from_string (self, str, dest, error);
}


static gboolean gxml_serializable_json_real_transform_to_string (GXmlSerializableJson* self, GValue* val, gchar** str, GError** error) {
	gboolean result = FALSE;
	g_return_val_if_fail (val != NULL, FALSE);
	g_return_val_if_fail (*str != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean gxml_serializable_json_transform_to_string (GXmlSerializableJson* self, GValue* val, gchar** str, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->transform_to_string (self, val, str, error);
}


/**
   * If @node is a xDocument serialize just add an <Object> element.
   *
   * If @node is an xElement serialize add to it an <Object> element.
   *
   * Is up to you to add convenient xElement node to a xDocument, in order to be
   * used by serialize and add new <Object> tags per object to serialize.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_param_spec_ref0 (gpointer self) {
	return self ? g_param_spec_ref (self) : NULL;
}


static GXmlNode* gxml_serializable_json_real_serialize (GXmlSerializable* base, GXmlNode* node, GError** error) {
	GXmlSerializableJson * self;
	GXmlNode* result = NULL;
	GXmlxDocument* doc = NULL;
	GXmlxElement* root = NULL;
	GParamSpec** props = NULL;
	gint props_length1 = 0;
	gint _props_size_ = 0;
	gchar* oid = NULL;
	gchar* _tmp0_ = NULL;
	GXmlNode* _tmp1_ = NULL;
	GXmlxDocument* _tmp8_ = NULL;
	GXmlNode* _tmp9_ = NULL;
	GXmlxDocument* _tmp10_ = NULL;
	GXmlxElement* _tmp11_ = NULL;
	GXmlxElement* _tmp12_ = NULL;
	GType _tmp13_ = 0UL;
	const gchar* _tmp14_ = NULL;
	GXmlxElement* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	GParamSpec** _tmp18_ = NULL;
	GParamSpec** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (GXmlSerializableJson*) base;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%p", self);
	oid = _tmp0_;
	_tmp1_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, GXML_TYPE_XDOCUMENT)) {
		GXmlNode* _tmp2_ = NULL;
		GXmlxDocument* _tmp3_ = NULL;
		_tmp2_ = node;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GXML_TYPE_XDOCUMENT, GXmlxDocument));
		_g_object_unref0 (doc);
		doc = _tmp3_;
	} else {
		GXmlNode* _tmp4_ = NULL;
		GXmlDocument* _tmp5_ = NULL;
		GXmlDocument* _tmp6_ = NULL;
		GXmlxDocument* _tmp7_ = NULL;
		_tmp4_ = node;
		_tmp5_ = gxml_node_get_document (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GXML_TYPE_XDOCUMENT, GXmlxDocument));
		_g_object_unref0 (doc);
		doc = _tmp7_;
	}
	_tmp8_ = doc;
	_tmp9_ = gxml_document_create_element ((GXmlDocument*) _tmp8_, "Object");
	_g_object_unref0 (root);
	root = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GXML_TYPE_XELEMENT, GXmlxElement);
	_tmp10_ = doc;
	_tmp11_ = root;
	gxml_xnode_append_child ((GXmlxNode*) _tmp10_, (GXmlxNode*) _tmp11_);
	_tmp12_ = root;
	_tmp13_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp14_ = g_type_name (_tmp13_);
	gxml_xelement_set_attribute (_tmp12_, "otype", _tmp14_);
	_tmp15_ = root;
	_tmp16_ = oid;
	gxml_xelement_set_attribute (_tmp15_, "oid", _tmp16_);
	_tmp18_ = gxml_serializable_json_list_serializable_properties (self, &_tmp17_);
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	props = _tmp18_;
	props_length1 = _tmp17_;
	_props_size_ = props_length1;
	_tmp19_ = props;
	_tmp19__length1 = props_length1;
	{
		GParamSpec** prop_spec_collection = NULL;
		gint prop_spec_collection_length1 = 0;
		gint _prop_spec_collection_size_ = 0;
		gint prop_spec_it = 0;
		prop_spec_collection = _tmp19_;
		prop_spec_collection_length1 = _tmp19__length1;
		for (prop_spec_it = 0; prop_spec_it < _tmp19__length1; prop_spec_it = prop_spec_it + 1) {
			GParamSpec* _tmp20_ = NULL;
			GParamSpec* prop_spec = NULL;
			_tmp20_ = _g_param_spec_ref0 (prop_spec_collection[prop_spec_it]);
			prop_spec = _tmp20_;
			{
				GXmlxElement* _tmp21_ = NULL;
				GParamSpec* _tmp22_ = NULL;
				GXmlNode* _tmp23_ = NULL;
				GXmlNode* _tmp24_ = NULL;
				_tmp21_ = root;
				_tmp22_ = prop_spec;
				_tmp23_ = gxml_serializable_json_serialize_property (self, (GXmlNode*) _tmp21_, _tmp22_, &_inner_error_);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp24_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_param_spec_unref0 (prop_spec);
					_g_free0 (oid);
					props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
					_g_object_unref0 (root);
					_g_object_unref0 (doc);
					return NULL;
				}
				_g_param_spec_unref0 (prop_spec);
			}
		}
	}
	result = (GXmlNode*) root;
	_g_free0 (oid);
	props = (_vala_array_free (props, props_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_object_unref0 (doc);
	return result;
}


static GXmlNode* gxml_serializable_json_real_serialize_property (GXmlSerializableJson* self, GXmlNode* node, GParamSpec* prop, GError** error) {
	GXmlNode* result = NULL;
	GXmlNode* _tmp0_ = NULL;
	GXmlxElement* element = NULL;
	GXmlNode* _tmp1_ = NULL;
	GXmlxElement* _tmp2_ = NULL;
	GType type = 0UL;
	GValue val = {0};
	GXmlNode* value_node = NULL;
	GXmlxElement* prop_node = NULL;
	GParamSpec* _tmp3_ = NULL;
	GType _tmp4_ = 0UL;
	GType _tmp5_ = 0UL;
	gboolean _tmp6_ = FALSE;
	GXmlxDocument* doc = NULL;
	GXmlxElement* _tmp16_ = NULL;
	GXmlxDocument* _tmp17_ = NULL;
	GXmlxDocument* _tmp18_ = NULL;
	GXmlxDocument* _tmp19_ = NULL;
	GXmlxDocument* _tmp20_ = NULL;
	GXmlNode* _tmp21_ = NULL;
	GXmlxElement* _tmp22_ = NULL;
	GParamSpec* _tmp23_ = NULL;
	GType _tmp24_ = 0UL;
	const gchar* _tmp25_ = NULL;
	GXmlxElement* _tmp26_ = NULL;
	GParamSpec* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GXmlxElement* _tmp29_ = NULL;
	GXmlxElement* _tmp30_ = NULL;
	GType _tmp31_ = 0UL;
	gboolean _tmp32_ = FALSE;
	GXmlxElement* _tmp103_ = NULL;
	GParamSpec* _tmp104_ = NULL;
	GXmlNode* _tmp105_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = node;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_XELEMENT), "node is xElement", NULL);
	_tmp1_ = node;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GXML_TYPE_XELEMENT, GXmlxElement));
	element = _tmp2_;
	value_node = NULL;
	_tmp3_ = prop;
	_tmp4_ = _tmp3_->value_type;
	type = _tmp4_;
	_tmp5_ = type;
	_tmp6_ = g_type_is_a (_tmp5_, GXML_TYPE_SERIALIZABLE);
	if (_tmp6_) {
		GType _tmp7_ = 0UL;
		GValue _tmp8_ = {0};
		GValue _tmp9_ = {0};
		GParamSpec* _tmp10_ = NULL;
		GXmlNode* _tmp11_ = NULL;
		GObject* _tmp12_ = NULL;
		GXmlxElement* _tmp13_ = NULL;
		GXmlNode* _tmp14_ = NULL;
		GXmlNode* _tmp15_ = NULL;
		_tmp7_ = type;
		g_value_init (&_tmp8_, _tmp7_);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		val = _tmp8_;
		_tmp9_ = val;
		_tmp10_ = prop;
		gxml_serializable_json_get_property_value (self, _tmp10_, &val);
		_tmp12_ = g_value_get_object (&val);
		_tmp13_ = element;
		_tmp14_ = gxml_serializable_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GXML_TYPE_SERIALIZABLE, GXmlSerializable), (GXmlNode*) _tmp13_, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (prop_node);
			_g_object_unref0 (value_node);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			_g_object_unref0 (element);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = (GXmlNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GXML_TYPE_XNODE, GXmlxNode);
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (prop_node);
		_g_object_unref0 (value_node);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		_g_object_unref0 (element);
		return result;
	}
	_tmp16_ = element;
	_tmp17_ = gxml_xnode_get_owner_document ((GXmlxNode*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	doc = _tmp19_;
	_tmp20_ = doc;
	_tmp21_ = gxml_document_create_element ((GXmlDocument*) _tmp20_, "Property");
	_g_object_unref0 (prop_node);
	prop_node = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GXML_TYPE_XELEMENT, GXmlxElement);
	_tmp22_ = prop_node;
	_tmp23_ = prop;
	_tmp24_ = _tmp23_->value_type;
	_tmp25_ = g_type_name (_tmp24_);
	gxml_xelement_set_attribute (_tmp22_, "ptype", _tmp25_);
	_tmp26_ = prop_node;
	_tmp27_ = prop;
	_tmp28_ = _tmp27_->name;
	gxml_xelement_set_attribute (_tmp26_, "pname", _tmp28_);
	_tmp29_ = element;
	_tmp30_ = prop_node;
	gxml_xnode_append_child ((GXmlxNode*) _tmp29_, (GXmlxNode*) _tmp30_);
	_tmp31_ = type;
	_tmp32_ = G_TYPE_IS_ENUM (_tmp31_);
	if (_tmp32_) {
		GValue _tmp33_ = {0};
		GValue _tmp34_ = {0};
		GParamSpec* _tmp35_ = NULL;
		GXmlxDocument* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		GXmlxText* _tmp40_ = NULL;
		GXmlNode* _tmp41_ = NULL;
		GXmlxElement* _tmp42_ = NULL;
		GeeBidirList* _tmp43_ = NULL;
		GeeBidirList* _tmp44_ = NULL;
		GXmlNode* _tmp45_ = NULL;
		g_value_init (&_tmp33_, G_TYPE_INT);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		val = _tmp33_;
		_tmp34_ = val;
		_tmp35_ = prop;
		gxml_serializable_json_get_property_value (self, _tmp35_, &val);
		_tmp36_ = doc;
		_tmp37_ = g_value_get_int (&val);
		_tmp38_ = g_strdup_printf ("%d", _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = gxml_xdocument_create_text_node (_tmp36_, _tmp39_);
		_tmp41_ = _g_object_ref0 ((GXmlNode*) _tmp40_);
		_g_object_unref0 (value_node);
		value_node = _tmp41_;
		_g_free0 (_tmp39_);
		_tmp42_ = prop_node;
		_tmp43_ = gxml_xnode_get_childs ((GXmlxNode*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = value_node;
		gee_collection_add ((GeeCollection*) _tmp44_, _tmp45_);
		result = (GXmlNode*) prop_node;
		_g_object_unref0 (doc);
		_g_object_unref0 (value_node);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		_g_object_unref0 (element);
		return result;
	} else {
		GType _tmp46_ = 0UL;
		gboolean _tmp47_ = FALSE;
		_tmp46_ = type;
		_tmp47_ = g_value_type_transformable (_tmp46_, G_TYPE_STRING);
		if (_tmp47_) {
			GType _tmp48_ = 0UL;
			GValue _tmp49_ = {0};
			GValue _tmp50_ = {0};
			GValue t = {0};
			GValue _tmp51_ = {0};
			GParamSpec* _tmp52_ = NULL;
			gchar* str = NULL;
			const gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			const gchar* _tmp55_ = NULL;
			GXmlxDocument* _tmp57_ = NULL;
			const gchar* _tmp58_ = NULL;
			GXmlxText* _tmp59_ = NULL;
			GXmlNode* _tmp60_ = NULL;
			GXmlxElement* _tmp61_ = NULL;
			GeeBidirList* _tmp62_ = NULL;
			GeeBidirList* _tmp63_ = NULL;
			GXmlNode* _tmp64_ = NULL;
			_tmp48_ = type;
			g_value_init (&_tmp49_, _tmp48_);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			val = _tmp49_;
			_tmp50_ = val;
			g_value_init (&_tmp51_, G_TYPE_STRING);
			t = _tmp51_;
			_tmp52_ = prop;
			gxml_serializable_json_get_property_value (self, _tmp52_, &val);
			g_value_transform (&val, &t);
			_tmp53_ = g_value_get_string (&t);
			_tmp54_ = g_strdup (_tmp53_);
			str = _tmp54_;
			_tmp55_ = str;
			if (_tmp55_ == NULL) {
				gchar* _tmp56_ = NULL;
				_tmp56_ = g_strdup ("");
				_g_free0 (str);
				str = _tmp56_;
			}
			_tmp57_ = doc;
			_tmp58_ = str;
			_tmp59_ = gxml_xdocument_create_text_node (_tmp57_, _tmp58_);
			_tmp60_ = _g_object_ref0 ((GXmlNode*) _tmp59_);
			_g_object_unref0 (value_node);
			value_node = _tmp60_;
			_tmp61_ = prop_node;
			_tmp62_ = gxml_xnode_get_childs ((GXmlxNode*) _tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = value_node;
			gee_collection_add ((GeeCollection*) _tmp63_, _tmp64_);
			result = (GXmlNode*) prop_node;
			_g_free0 (str);
			G_IS_VALUE (&t) ? (g_value_unset (&t), NULL) : NULL;
			_g_object_unref0 (doc);
			_g_object_unref0 (value_node);
			G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
			_g_object_unref0 (element);
			return result;
		} else {
			GType _tmp65_ = 0UL;
			_tmp65_ = type;
			if (_tmp65_ == G_TYPE_GTYPE) {
				GXmlxDocument* _tmp66_ = NULL;
				GType _tmp67_ = 0UL;
				const gchar* _tmp68_ = NULL;
				GXmlxText* _tmp69_ = NULL;
				GXmlNode* _tmp70_ = NULL;
				GXmlxElement* _tmp71_ = NULL;
				GeeBidirList* _tmp72_ = NULL;
				GeeBidirList* _tmp73_ = NULL;
				GXmlNode* _tmp74_ = NULL;
				_tmp66_ = doc;
				_tmp67_ = type;
				_tmp68_ = g_type_name (_tmp67_);
				_tmp69_ = gxml_xdocument_create_text_node (_tmp66_, _tmp68_);
				_tmp70_ = _g_object_ref0 ((GXmlNode*) _tmp69_);
				_g_object_unref0 (value_node);
				value_node = _tmp70_;
				_tmp71_ = prop_node;
				_tmp72_ = gxml_xnode_get_childs ((GXmlxNode*) _tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = value_node;
				gee_collection_add ((GeeCollection*) _tmp73_, _tmp74_);
				result = (GXmlNode*) prop_node;
				_g_object_unref0 (doc);
				_g_object_unref0 (value_node);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				_g_object_unref0 (element);
				return result;
			} else {
				gboolean _tmp75_ = FALSE;
				GType _tmp76_ = 0UL;
				gboolean _tmp77_ = FALSE;
				_tmp76_ = type;
				_tmp77_ = g_type_is_a (_tmp76_, G_TYPE_OBJECT);
				if (_tmp77_) {
					GType _tmp78_ = 0UL;
					gboolean _tmp79_ = FALSE;
					_tmp78_ = type;
					_tmp79_ = g_type_is_a (_tmp78_, GEE_TYPE_COLLECTION);
					_tmp75_ = !_tmp79_;
				} else {
					_tmp75_ = FALSE;
				}
				if (_tmp75_) {
					GObject* child_object = NULL;
					GValue _tmp80_ = {0};
					GValue _tmp81_ = {0};
					GParamSpec* _tmp82_ = NULL;
					GObject* _tmp83_ = NULL;
					GObject* _tmp84_ = NULL;
					GXmlxDocument* value_doc = NULL;
					GObject* _tmp85_ = NULL;
					GXmlxDocument* _tmp86_ = NULL;
					GXmlxDocument* _tmp87_ = NULL;
					GXmlxDocument* _tmp88_ = NULL;
					GXmlxElement* _tmp89_ = NULL;
					GXmlxElement* _tmp90_ = NULL;
					const gchar* _tmp91_ = NULL;
					const gchar* _tmp92_ = NULL;
					GXmlNode* _tmp93_ = NULL;
					GXmlxDocument* _tmp94_ = NULL;
					GXmlNode* _tmp95_ = NULL;
					GXmlxDocument* _tmp96_ = NULL;
					GXmlxElement* _tmp97_ = NULL;
					GXmlxElement* _tmp98_ = NULL;
					GXmlxElement* _tmp99_ = NULL;
					GeeBidirList* _tmp100_ = NULL;
					GeeBidirList* _tmp101_ = NULL;
					GXmlNode* _tmp102_ = NULL;
					g_value_init (&_tmp80_, G_TYPE_OBJECT);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					val = _tmp80_;
					_tmp81_ = val;
					_tmp82_ = prop;
					gxml_serializable_json_get_property_value (self, _tmp82_, &val);
					_tmp83_ = g_value_get_object (&val);
					_tmp84_ = _g_object_ref0 (_tmp83_);
					_g_object_unref0 (child_object);
					child_object = _tmp84_;
					_tmp85_ = child_object;
					_tmp86_ = gxml_serialization_serialize_object (_tmp85_, &_inner_error_);
					value_doc = _tmp86_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (child_object);
						_g_object_unref0 (doc);
						_g_object_unref0 (prop_node);
						_g_object_unref0 (value_node);
						G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
						_g_object_unref0 (element);
						return NULL;
					}
					_tmp87_ = doc;
					_tmp88_ = doc;
					_tmp89_ = gxml_xdocument_get_document_element (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = gxml_xnode_get_name ((GXmlxNode*) _tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = gxml_document_create_element ((GXmlDocument*) _tmp87_, _tmp92_);
					_g_object_unref0 (value_node);
					value_node = (GXmlNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, GXML_TYPE_XNODE, GXmlxNode);
					_tmp94_ = value_doc;
					_tmp95_ = value_node;
					_tmp96_ = value_doc;
					_tmp97_ = gxml_xdocument_get_document_element (_tmp96_);
					_tmp98_ = _tmp97_;
					gxml_node_copy ((GXmlDocument*) _tmp94_, _tmp95_, (GXmlNode*) _tmp98_, TRUE);
					_tmp99_ = prop_node;
					_tmp100_ = gxml_xnode_get_childs ((GXmlxNode*) _tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = value_node;
					gee_collection_add ((GeeCollection*) _tmp101_, _tmp102_);
					result = (GXmlNode*) prop_node;
					_g_object_unref0 (value_doc);
					_g_object_unref0 (child_object);
					_g_object_unref0 (doc);
					_g_object_unref0 (value_node);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_object_unref0 (element);
					return result;
				}
			}
		}
	}
	_tmp103_ = prop_node;
	_tmp104_ = prop;
	g_signal_emit_by_name ((GXmlSerializable*) self, "serialize-unknown-property-type", (GXmlNode*) _tmp103_, _tmp104_, &_tmp105_);
	_g_object_unref0 (value_node);
	value_node = _tmp105_;
	result = (GXmlNode*) prop_node;
	_g_object_unref0 (doc);
	_g_object_unref0 (value_node);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	_g_object_unref0 (element);
	return result;
}


GXmlNode* gxml_serializable_json_serialize_property (GXmlSerializableJson* self, GXmlNode* node, GParamSpec* prop, GError** error) {
	GXmlNode* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = node;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_XELEMENT), "node is xElement", NULL);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->serialize_property (self, node, prop, error);
}


static GXmlNode* gxml_serializable_json_real_deserialize (GXmlSerializable* base, GXmlNode* n, GError** error) {
	GXmlSerializableJson * self;
	GXmlNode* result = NULL;
	GXmlxNode* node = NULL;
	GXmlNode* _tmp0_ = NULL;
	GXmlxNode* _tmp1_ = NULL;
	GXmlxElement* obj_elem = NULL;
	GParamSpec** specs = NULL;
	gint specs_length1 = 0;
	gint _specs_size_ = 0;
	GXmlxNode* _tmp2_ = NULL;
	gint _tmp11_ = 0;
	GParamSpec** _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
	self = (GXmlSerializableJson*) base;
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = n;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GXML_TYPE_XNODE, GXmlxNode));
	node = _tmp1_;
	_tmp2_ = node;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GXML_TYPE_XDOCUMENT)) {
		GXmlxNode* _tmp3_ = NULL;
		GXmlxDocument* _tmp4_ = NULL;
		GXmlxDocument* _tmp5_ = NULL;
		GXmlxElement* _tmp6_ = NULL;
		GXmlxElement* _tmp7_ = NULL;
		GXmlxElement* _tmp8_ = NULL;
		_tmp3_ = node;
		_tmp4_ = gxml_xnode_get_owner_document (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gxml_xdocument_get_document_element (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (obj_elem);
		obj_elem = _tmp8_;
	} else {
		GXmlxNode* _tmp9_ = NULL;
		GXmlxElement* _tmp10_ = NULL;
		_tmp9_ = node;
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GXML_TYPE_XELEMENT, GXmlxElement));
		_g_object_unref0 (obj_elem);
		obj_elem = _tmp10_;
	}
	_tmp12_ = gxml_serializable_json_list_serializable_properties (self, &_tmp11_);
	specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	specs = _tmp12_;
	specs_length1 = _tmp11_;
	_specs_size_ = specs_length1;
	{
		GXmlNodeList* _child_node_list = NULL;
		GXmlxElement* _tmp13_ = NULL;
		GXmlNodeList* _tmp14_ = NULL;
		GXmlNodeList* _tmp15_ = NULL;
		GXmlNodeList* _tmp16_ = NULL;
		gint _child_node_size = 0;
		GXmlNodeList* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _child_node_index = 0;
		_tmp13_ = obj_elem;
		_tmp14_ = gxml_xnode_get_child_nodes ((GXmlxNode*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_child_node_list = _tmp16_;
		_tmp17_ = _child_node_list;
		_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_child_node_size = _tmp19_;
		_child_node_index = -1;
		while (TRUE) {
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			GXmlxNode* child_node = NULL;
			GXmlNodeList* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			GXmlxNode* _tmp25_ = NULL;
			GXmlxNode* _tmp26_ = NULL;
			_tmp20_ = _child_node_index;
			_child_node_index = _tmp20_ + 1;
			_tmp21_ = _child_node_index;
			_tmp22_ = _child_node_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _child_node_list;
			_tmp24_ = _child_node_index;
			_tmp25_ = gxml_node_list_get (_tmp23_, _tmp24_);
			child_node = _tmp25_;
			_tmp26_ = child_node;
			gxml_serializable_json_deserialize_property (self, (GXmlNode*) _tmp26_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (child_node);
				_g_object_unref0 (_child_node_list);
				specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
				_g_object_unref0 (obj_elem);
				_g_object_unref0 (node);
				return NULL;
			}
			_g_object_unref0 (child_node);
		}
		_g_object_unref0 (_child_node_list);
	}
	result = (GXmlNode*) obj_elem;
	specs = (_vala_array_free (specs, specs_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_object_unref0 (node);
	return result;
}


static gboolean gxml_serializable_json_real_deserialize_property (GXmlSerializableJson* self, GXmlNode* nproperty, GError** error) {
	gboolean result = FALSE;
	GXmlNode* _tmp0_ = NULL;
	GXmlxNode* property_node = NULL;
	GXmlNode* _tmp1_ = NULL;
	GXmlxNode* _tmp2_ = NULL;
	GXmlxNode* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (nproperty != NULL, FALSE);
	_tmp0_ = nproperty;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_XNODE), "nproperty is xNode", FALSE);
	_tmp1_ = nproperty;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GXML_TYPE_XNODE, GXmlxNode));
	property_node = _tmp2_;
	_tmp3_ = property_node;
	_tmp4_ = gxml_xnode_get_node_name (_tmp3_);
	_tmp5_ = _tmp4_;
	if (g_strcmp0 (_tmp5_, "Property") == 0) {
		GXmlxElement* prop_elem = NULL;
		gchar* pname = NULL;
		gchar* ptype = NULL;
		GType type = 0UL;
		GValue val = {0};
		GParamSpec* spec = NULL;
		GXmlxNode* _tmp6_ = NULL;
		GXmlxElement* _tmp7_ = NULL;
		GXmlxElement* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		GXmlxElement* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GType _tmp13_ = 0UL;
		const gchar* _tmp14_ = NULL;
		GParamSpec* _tmp15_ = NULL;
		GParamSpec* _tmp16_ = NULL;
		_tmp6_ = property_node;
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GXML_TYPE_XELEMENT, GXmlxElement));
		_g_object_unref0 (prop_elem);
		prop_elem = _tmp7_;
		_tmp8_ = prop_elem;
		_tmp9_ = gxml_xelement_get_attribute (_tmp8_, "pname");
		_g_free0 (pname);
		pname = _tmp9_;
		_tmp10_ = prop_elem;
		_tmp11_ = gxml_xelement_get_attribute (_tmp10_, "ptype");
		_g_free0 (ptype);
		ptype = _tmp11_;
		_tmp12_ = ptype;
		_tmp13_ = g_type_from_name (_tmp12_);
		type = _tmp13_;
		_tmp14_ = pname;
		_tmp15_ = gxml_serializable_json_find_property_spec (self, _tmp14_);
		_g_param_spec_unref0 (spec);
		spec = _tmp15_;
		_tmp16_ = spec;
		if (_tmp16_ == NULL) {
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			GXmlxNode* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			GeeMap* _tmp22_ = NULL;
			GeeMap* _tmp23_ = NULL;
			GXmlxNode* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			GXmlxNode* _tmp27_ = NULL;
			_tmp17_ = ptype;
			_tmp18_ = pname;
			_tmp19_ = property_node;
			_tmp20_ = gxml_xnode_stringify (_tmp19_, FALSE, 0);
			_tmp21_ = _tmp20_;
			g_message ("SerializableJson.vala:275: Deserializing object of type '%s' claimed u" \
"nknown property named '%s'\n" \
"XML [%s]", _tmp17_, _tmp18_, _tmp21_);
			_g_free0 (_tmp21_);
			_tmp22_ = gxml_serializable_get_unknown_serializable_properties ((GXmlSerializable*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = property_node;
			_tmp25_ = gxml_xnode_get_node_name (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = property_node;
			gee_map_set (_tmp23_, _tmp26_, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GXML_TYPE_ATTRIBUTE, GXmlAttribute));
		} else {
			GParamSpec* _tmp28_ = NULL;
			GType _tmp29_ = 0UL;
			gboolean _tmp30_ = FALSE;
			_tmp28_ = spec;
			_tmp29_ = _tmp28_->value_type;
			_tmp30_ = g_type_is_a (_tmp29_, GXML_TYPE_SERIALIZABLE);
			if (_tmp30_) {
				GValue vobj = {0};
				GParamSpec* _tmp31_ = NULL;
				GType _tmp32_ = 0UL;
				GValue _tmp33_ = {0};
				const gchar* _tmp34_ = NULL;
				GValue _tmp35_ = {0};
				GXmlxNode* _tmp36_ = NULL;
				GXmlNode* _tmp37_ = NULL;
				GXmlNode* _tmp38_ = NULL;
				_tmp31_ = spec;
				_tmp32_ = _tmp31_->value_type;
				g_value_init (&_tmp33_, _tmp32_);
				vobj = _tmp33_;
				_tmp34_ = pname;
				g_object_get_property ((GObject*) self, _tmp34_, &vobj);
				_tmp35_ = vobj;
				_tmp36_ = property_node;
				_tmp37_ = gxml_serializable_deserialize (g_value_get_object (&_tmp35_), (GXmlNode*) _tmp36_, &_inner_error_);
				_tmp38_ = _tmp37_;
				_g_object_unref0 (_tmp38_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (ptype);
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					_g_object_unref0 (property_node);
					return FALSE;
				}
				G_IS_VALUE (&vobj) ? (g_value_unset (&vobj), NULL) : NULL;
			} else {
				GType _tmp39_ = 0UL;
				GValue _tmp40_ = {0};
				GValue _tmp41_ = {0};
				gboolean _tmp42_ = FALSE;
				GXmlxElement* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_ = FALSE;
				_tmp39_ = type;
				g_value_init (&_tmp40_, _tmp39_);
				G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
				val = _tmp40_;
				_tmp41_ = val;
				_tmp43_ = prop_elem;
				_tmp44_ = gxml_element_get_content ((GXmlElement*) _tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = _tmp45_;
				_tmp47_ = gxml_serializable_json_transform_from_string (self, _tmp46_, &val, &_inner_error_);
				_tmp48_ = _tmp47_;
				_g_free0 (_tmp46_);
				_tmp42_ = _tmp48_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (ptype);
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					_g_object_unref0 (property_node);
					return FALSE;
				}
				if (_tmp42_) {
					GParamSpec* _tmp49_ = NULL;
					GValue _tmp50_ = {0};
					_tmp49_ = spec;
					_tmp50_ = val;
					gxml_serializable_json_set_property_value (self, _tmp49_, &_tmp50_);
					result = TRUE;
					_g_param_spec_unref0 (spec);
					G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
					_g_free0 (ptype);
					_g_free0 (pname);
					_g_object_unref0 (prop_elem);
					_g_object_unref0 (property_node);
					return result;
				} else {
					GType _tmp51_ = 0UL;
					gboolean _tmp52_ = FALSE;
					_tmp51_ = type;
					_tmp52_ = g_value_type_transformable (_tmp51_, G_TYPE_STRING);
					if (_tmp52_) {
						GXmlxElement* _tmp53_ = NULL;
						gchar* _tmp54_ = NULL;
						gchar* _tmp55_ = NULL;
						gchar* _tmp56_ = NULL;
						GParamSpec* _tmp57_ = NULL;
						GValue _tmp58_ = {0};
						_tmp53_ = prop_elem;
						_tmp54_ = gxml_element_get_content ((GXmlElement*) _tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = _tmp55_;
						gxml_serializable_string_to_gvalue (_tmp56_, &val, &_inner_error_);
						_g_free0 (_tmp56_);
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							g_propagate_error (error, _inner_error_);
							_g_param_spec_unref0 (spec);
							G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
							_g_free0 (ptype);
							_g_free0 (pname);
							_g_object_unref0 (prop_elem);
							_g_object_unref0 (property_node);
							return FALSE;
						}
						_tmp57_ = spec;
						_tmp58_ = val;
						gxml_serializable_json_set_property_value (self, _tmp57_, &_tmp58_);
					} else {
						GType _tmp59_ = 0UL;
						gboolean _tmp60_ = FALSE;
						_tmp59_ = type;
						_tmp60_ = g_type_is_a (_tmp59_, G_TYPE_OBJECT);
						if (_tmp60_) {
							GXmlxNode* prop_elem_child = NULL;
							GObject* property_object = NULL;
							GXmlxElement* _tmp61_ = NULL;
							GXmlxNode* _tmp62_ = NULL;
							GXmlxNode* _tmp63_ = NULL;
							GXmlxNode* _tmp64_ = NULL;
							GObject* _tmp65_ = NULL;
							GXmlxNode* _tmp66_ = NULL;
							GObject* _tmp67_ = NULL;
							GObject* _tmp68_ = NULL;
							GObject* _tmp69_ = NULL;
							_tmp61_ = prop_elem;
							_tmp62_ = gxml_xnode_get_first_child ((GXmlxNode*) _tmp61_);
							_tmp63_ = _tmp62_;
							_tmp64_ = _g_object_ref0 (_tmp63_);
							_g_object_unref0 (prop_elem_child);
							prop_elem_child = _tmp64_;
							_tmp66_ = prop_elem_child;
							_tmp67_ = gxml_serialization_deserialize_object_from_node (_tmp66_, &_inner_error_);
							_tmp65_ = _tmp67_;
							if (G_UNLIKELY (_inner_error_ != NULL)) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (property_object);
								_g_object_unref0 (prop_elem_child);
								_g_param_spec_unref0 (spec);
								G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
								_g_free0 (ptype);
								_g_free0 (pname);
								_g_object_unref0 (prop_elem);
								_g_object_unref0 (property_node);
								return FALSE;
							}
							_tmp68_ = _tmp65_;
							_tmp65_ = NULL;
							_g_object_unref0 (property_object);
							property_object = _tmp68_;
							_tmp69_ = property_object;
							g_value_set_object (&val, _tmp69_);
							result = TRUE;
							_g_object_unref0 (_tmp65_);
							_g_object_unref0 (property_object);
							_g_object_unref0 (prop_elem_child);
							_g_param_spec_unref0 (spec);
							G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
							_g_free0 (ptype);
							_g_free0 (pname);
							_g_object_unref0 (prop_elem);
							_g_object_unref0 (property_node);
							return result;
						} else {
							GXmlxElement* _tmp70_ = NULL;
							GParamSpec* _tmp71_ = NULL;
							_tmp70_ = prop_elem;
							_tmp71_ = spec;
							g_signal_emit_by_name ((GXmlSerializable*) self, "deserialize-unknown-property-type", (GXmlNode*) _tmp70_, _tmp71_);
							result = FALSE;
							_g_param_spec_unref0 (spec);
							G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
							_g_free0 (ptype);
							_g_free0 (pname);
							_g_object_unref0 (prop_elem);
							_g_object_unref0 (property_node);
							return result;
						}
					}
				}
			}
		}
		result = TRUE;
		_g_param_spec_unref0 (spec);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		_g_free0 (ptype);
		_g_free0 (pname);
		_g_object_unref0 (prop_elem);
		_g_object_unref0 (property_node);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (property_node);
	return result;
}


gboolean gxml_serializable_json_deserialize_property (GXmlSerializableJson* self, GXmlNode* nproperty, GError** error) {
	GXmlNode* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = nproperty;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GXML_TYPE_XNODE), "nproperty is xNode", FALSE);
	return GXML_SERIALIZABLE_JSON_GET_CLASS (self)->deserialize_property (self, nproperty, error);
}


GXmlSerializableJson* gxml_serializable_json_construct (GType object_type) {
	GXmlSerializableJson * self = NULL;
	self = (GXmlSerializableJson*) g_object_new (object_type, NULL);
	return self;
}


GXmlSerializableJson* gxml_serializable_json_new (void) {
	return gxml_serializable_json_construct (GXML_TYPE_SERIALIZABLE_JSON);
}


static GParamSpec** gxml_serializable_json_real_get_properties (GXmlSerializable* base, int* result_length1) {
	GParamSpec** result;
	GXmlSerializableJson* self;
	GParamSpec** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GParamSpec** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = self->priv->_properties;
	_tmp0__length1 = self->priv->_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static GParamSpec** _vala_array_dup5 (GParamSpec** self, int length) {
	GParamSpec** result;
	int i;
	result = g_new0 (GParamSpec*, length + 1);
	for (i = 0; i < length; i++) {
		GParamSpec* _tmp0_ = NULL;
		_tmp0_ = _g_param_spec_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void gxml_serializable_json_real_set_properties (GXmlSerializable* base, GParamSpec** value, int value_length1) {
	GXmlSerializableJson* self;
	GParamSpec** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GParamSpec** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup5 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_properties = (_vala_array_free (self->priv->_properties, self->priv->_properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	self->priv->_properties = _tmp1_;
	self->priv->_properties_length1 = _tmp1__length1;
	self->priv->__properties_size_ = self->priv->_properties_length1;
}


static GHashTable* gxml_serializable_json_real_get_ignored_serializable_properties (GXmlSerializable* base) {
	GHashTable* result;
	GXmlSerializableJson* self;
	GHashTable* _tmp0_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = self->priv->_ignored_serializable_properties;
	result = _tmp0_;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void gxml_serializable_json_real_set_ignored_serializable_properties (GXmlSerializable* base, GHashTable* value) {
	GXmlSerializableJson* self;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = value;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	_g_hash_table_unref0 (self->priv->_ignored_serializable_properties);
	self->priv->_ignored_serializable_properties = _tmp1_;
	g_object_notify ((GObject *) self, "ignored-serializable-properties");
}


static const gchar* gxml_serializable_json_real_get_serialized_xml_node_value (GXmlSerializable* base) {
	const gchar* result;
	GXmlSerializableJson* self;
	const gchar* _tmp0_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = self->priv->_serialized_xml_node_value;
	result = _tmp0_;
	return result;
}


static void gxml_serializable_json_real_set_serialized_xml_node_value (GXmlSerializable* base, const gchar* value) {
	GXmlSerializableJson* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_serialized_xml_node_value);
	self->priv->_serialized_xml_node_value = _tmp1_;
	g_object_notify ((GObject *) self, "serialized-xml-node-value");
}


static GeeMap* gxml_serializable_json_real_get_unknown_serializable_properties (GXmlSerializable* base) {
	GeeMap* result;
	GXmlSerializableJson* self;
	GeeHashMap* _tmp0_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = self->priv->_unknown_serializable_property;
	result = (GeeMap*) _tmp0_;
	return result;
}


static GeeCollection* gxml_serializable_json_real_get_unknown_serializable_nodes (GXmlSerializable* base) {
	GeeCollection* result;
	GXmlSerializableJson* self;
	GeeArrayList* _tmp0_ = NULL;
	self = (GXmlSerializableJson*) base;
	_tmp0_ = self->priv->_unknown_serializable_nodes;
	result = (GeeCollection*) _tmp0_;
	return result;
}


static GObject * gxml_serializable_json_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GXmlSerializableJson * self;
	parent_class = G_OBJECT_CLASS (gxml_serializable_json_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJson);
	gxml_init_init ();
	return obj;
}


static void gxml_serializable_json_class_init (GXmlSerializableJsonClass * klass) {
	gxml_serializable_json_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlSerializableJsonPrivate));
	((GXmlSerializableJsonClass *) klass)->get_enable_unknown_serializable_property = gxml_serializable_json_real_get_enable_unknown_serializable_property;
	((GXmlSerializableJsonClass *) klass)->set_namespace = gxml_serializable_json_real_set_namespace;
	((GXmlSerializableJsonClass *) klass)->serialize_use_xml_node_value = gxml_serializable_json_real_serialize_use_xml_node_value;
	((GXmlSerializableJsonClass *) klass)->node_name = gxml_serializable_json_real_node_name;
	((GXmlSerializableJsonClass *) klass)->property_use_nick = gxml_serializable_json_real_property_use_nick;
	((GXmlSerializableJsonClass *) klass)->find_property_spec = gxml_serializable_json_real_find_property_spec;
	((GXmlSerializableJsonClass *) klass)->init_properties = gxml_serializable_json_real_init_properties;
	((GXmlSerializableJsonClass *) klass)->list_serializable_properties = gxml_serializable_json_real_list_serializable_properties;
	((GXmlSerializableJsonClass *) klass)->get_property_value = gxml_serializable_json_real_get_property_value;
	((GXmlSerializableJsonClass *) klass)->set_property_value = gxml_serializable_json_real_set_property_value;
	((GXmlSerializableJsonClass *) klass)->transform_from_string = gxml_serializable_json_real_transform_from_string;
	((GXmlSerializableJsonClass *) klass)->transform_to_string = gxml_serializable_json_real_transform_to_string;
	((GXmlSerializableJsonClass *) klass)->serialize_property = gxml_serializable_json_real_serialize_property;
	((GXmlSerializableJsonClass *) klass)->deserialize_property = gxml_serializable_json_real_deserialize_property;
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_serializable_json_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_serializable_json_set_property;
	G_OBJECT_CLASS (klass)->constructor = gxml_serializable_json_constructor;
	G_OBJECT_CLASS (klass)->finalize = gxml_serializable_json_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_JSON_IGNORED_SERIALIZABLE_PROPERTIES, g_param_spec_boxed ("ignored-serializable-properties", "ignored-serializable-properties", "ignored-serializable-properties", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_JSON_SERIALIZED_XML_NODE_VALUE, g_param_spec_string ("serialized-xml-node-value", "serialized-xml-node-value", "serialized-xml-node-value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_JSON_UNKNOWN_SERIALIZABLE_PROPERTIES, g_param_spec_object ("unknown-serializable-properties", "unknown-serializable-properties", "unknown-serializable-properties", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_SERIALIZABLE_JSON_UNKNOWN_SERIALIZABLE_NODES, g_param_spec_object ("unknown-serializable-nodes", "unknown-serializable-nodes", "unknown-serializable-nodes", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gxml_serializable_json_gxml_serializable_interface_init (GXmlSerializableIface * iface) {
	gxml_serializable_json_gxml_serializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_enable_unknown_serializable_property = (gboolean (*)(GXmlSerializable*)) gxml_serializable_json_get_enable_unknown_serializable_property;
	iface->set_namespace = (gboolean (*)(GXmlSerializable*, GXmlNode*)) gxml_serializable_json_set_namespace;
	iface->serialize_use_xml_node_value = (gboolean (*)(GXmlSerializable*)) gxml_serializable_json_serialize_use_xml_node_value;
	iface->node_name = (gchar* (*)(GXmlSerializable*)) gxml_serializable_json_node_name;
	iface->property_use_nick = (gboolean (*)(GXmlSerializable*)) gxml_serializable_json_property_use_nick;
	iface->find_property_spec = (GParamSpec* (*)(GXmlSerializable*, const gchar*)) gxml_serializable_json_find_property_spec;
	iface->init_properties = (void (*)(GXmlSerializable*)) gxml_serializable_json_init_properties;
	iface->list_serializable_properties = (GParamSpec** (*)(GXmlSerializable*, int*)) gxml_serializable_json_list_serializable_properties;
	iface->get_property_value = (void (*)(GXmlSerializable*, GParamSpec*, GValue*)) gxml_serializable_json_get_property_value;
	iface->set_property_value = (void (*)(GXmlSerializable*, GParamSpec*, GValue*)) gxml_serializable_json_set_property_value;
	iface->transform_from_string = (gboolean (*)(GXmlSerializable*, const gchar*, GValue*, GError**)) gxml_serializable_json_transform_from_string;
	iface->transform_to_string = (gboolean (*)(GXmlSerializable*, GValue*, gchar**, GError**)) gxml_serializable_json_transform_to_string;
	iface->serialize = (GXmlNode* (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_json_real_serialize;
	iface->serialize_property = (GXmlNode* (*)(GXmlSerializable*, GXmlNode*, GParamSpec*, GError**)) gxml_serializable_json_serialize_property;
	iface->deserialize = (GXmlNode* (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_json_real_deserialize;
	iface->deserialize_property = (gboolean (*)(GXmlSerializable*, GXmlNode*, GError**)) gxml_serializable_json_deserialize_property;
	iface->get_properties = gxml_serializable_json_real_get_properties;
	iface->set_properties = gxml_serializable_json_real_set_properties;
	iface->get_ignored_serializable_properties = gxml_serializable_json_real_get_ignored_serializable_properties;
	iface->set_ignored_serializable_properties = gxml_serializable_json_real_set_ignored_serializable_properties;
	iface->get_serialized_xml_node_value = gxml_serializable_json_real_get_serialized_xml_node_value;
	iface->set_serialized_xml_node_value = gxml_serializable_json_real_set_serialized_xml_node_value;
	iface->get_unknown_serializable_properties = gxml_serializable_json_real_get_unknown_serializable_properties;
	iface->get_unknown_serializable_nodes = gxml_serializable_json_real_get_unknown_serializable_nodes;
}


static void gxml_serializable_json_instance_init (GXmlSerializableJson * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	self->priv = GXML_SERIALIZABLE_JSON_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GXML_TYPE_ATTRIBUTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_unknown_serializable_property = _tmp0_;
	_tmp1_ = gee_array_list_new (GXML_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->_unknown_serializable_nodes = _tmp1_;
	self->priv->_serialized_xml_node_value = NULL;
}


static void gxml_serializable_json_finalize (GObject* obj) {
	GXmlSerializableJson * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJson);
	_g_object_unref0 (self->priv->_unknown_serializable_property);
	_g_object_unref0 (self->priv->_unknown_serializable_nodes);
	self->priv->_properties = (_vala_array_free (self->priv->_properties, self->priv->_properties_length1, (GDestroyNotify) g_param_spec_unref), NULL);
	_g_hash_table_unref0 (self->priv->_ignored_serializable_properties);
	_g_free0 (self->priv->_serialized_xml_node_value);
	G_OBJECT_CLASS (gxml_serializable_json_parent_class)->finalize (obj);
}


/**
 * An implementation of {@link Serializable} using an {@link xElement} called "Object".
 * 
 * {@link xElement} have two properties with object type and object id.
 * 
 * It uses a set children {@link xElement} for each Object property with two {@link GXml.Attribute},
 * one for its type and one for its name; property's value is set as the property
 * {@link xElement}'s content text.
 */
GType gxml_serializable_json_get_type (void) {
	static volatile gsize gxml_serializable_json_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_json_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableJsonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serializable_json_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlSerializableJson), 0, (GInstanceInitFunc) gxml_serializable_json_instance_init, NULL };
		static const GInterfaceInfo gxml_serializable_info = { (GInterfaceInitFunc) gxml_serializable_json_gxml_serializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gxml_serializable_json_type_id;
		gxml_serializable_json_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlSerializableJson", &g_define_type_info, 0);
		g_type_add_interface_static (gxml_serializable_json_type_id, GXML_TYPE_SERIALIZABLE, &gxml_serializable_info);
		g_once_init_leave (&gxml_serializable_json_type_id__volatile, gxml_serializable_json_type_id);
	}
	return gxml_serializable_json_type_id__volatile;
}


static void _vala_gxml_serializable_json_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlSerializableJson * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJson);
	switch (property_id) {
		case GXML_SERIALIZABLE_JSON_IGNORED_SERIALIZABLE_PROPERTIES:
		g_value_set_boxed (value, gxml_serializable_get_ignored_serializable_properties ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_JSON_SERIALIZED_XML_NODE_VALUE:
		g_value_set_string (value, gxml_serializable_get_serialized_xml_node_value ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_JSON_UNKNOWN_SERIALIZABLE_PROPERTIES:
		g_value_set_object (value, gxml_serializable_get_unknown_serializable_properties ((GXmlSerializable*) self));
		break;
		case GXML_SERIALIZABLE_JSON_UNKNOWN_SERIALIZABLE_NODES:
		g_value_set_object (value, gxml_serializable_get_unknown_serializable_nodes ((GXmlSerializable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_serializable_json_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlSerializableJson * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GXML_TYPE_SERIALIZABLE_JSON, GXmlSerializableJson);
	switch (property_id) {
		case GXML_SERIALIZABLE_JSON_IGNORED_SERIALIZABLE_PROPERTIES:
		gxml_serializable_set_ignored_serializable_properties ((GXmlSerializable*) self, g_value_get_boxed (value));
		break;
		case GXML_SERIALIZABLE_JSON_SERIALIZED_XML_NODE_VALUE:
		gxml_serializable_set_serialized_xml_node_value ((GXmlSerializable*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



