/* SerializableContainer.c generated by valac 0.34.13, the Vala compiler
 * generated from SerializableContainer.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 0; tab-width: 2 -*- */
/* ObjectModel.vala
 *
 * Copyright (C) 2014  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>


#define GXML_TYPE_SERIALIZABLE (gxml_serializable_get_type ())
#define GXML_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializable))
#define GXML_IS_SERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE))
#define GXML_SERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE, GXmlSerializableIface))

typedef struct _GXmlSerializable GXmlSerializable;
typedef struct _GXmlSerializableIface GXmlSerializableIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_ATTRIBUTE (gxml_attribute_get_type ())
#define GXML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttribute))
#define GXML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTRIBUTE))
#define GXML_ATTRIBUTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttributeIface))

typedef struct _GXmlAttribute GXmlAttribute;
typedef struct _GXmlAttributeIface GXmlAttributeIface;

#define GXML_TYPE_SERIALIZABLE_OBJECT_MODEL (gxml_serializable_object_model_get_type ())
#define GXML_SERIALIZABLE_OBJECT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModel))
#define GXML_SERIALIZABLE_OBJECT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelClass))
#define GXML_IS_SERIALIZABLE_OBJECT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL))
#define GXML_IS_SERIALIZABLE_OBJECT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL))
#define GXML_SERIALIZABLE_OBJECT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, GXmlSerializableObjectModelClass))

typedef struct _GXmlSerializableObjectModel GXmlSerializableObjectModel;
typedef struct _GXmlSerializableObjectModelClass GXmlSerializableObjectModelClass;
typedef struct _GXmlSerializableObjectModelPrivate GXmlSerializableObjectModelPrivate;

#define GXML_TYPE_SERIALIZABLE_CONTAINER (gxml_serializable_container_get_type ())
#define GXML_SERIALIZABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainer))
#define GXML_SERIALIZABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainerClass))
#define GXML_IS_SERIALIZABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER))
#define GXML_IS_SERIALIZABLE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_CONTAINER))
#define GXML_SERIALIZABLE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainerClass))

typedef struct _GXmlSerializableContainer GXmlSerializableContainer;
typedef struct _GXmlSerializableContainerClass GXmlSerializableContainerClass;
typedef struct _GXmlSerializableContainerPrivate GXmlSerializableContainerPrivate;

#define GXML_TYPE_SERIALIZABLE_COLLECTION (gxml_serializable_collection_get_type ())
#define GXML_SERIALIZABLE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION, GXmlSerializableCollection))
#define GXML_IS_SERIALIZABLE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION))
#define GXML_SERIALIZABLE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_COLLECTION, GXmlSerializableCollectionIface))

typedef struct _GXmlSerializableCollection GXmlSerializableCollection;
typedef struct _GXmlSerializableCollectionIface GXmlSerializableCollectionIface;

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_INVALID = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlAttributeIface {
	GTypeInterface parent_iface;
	GXmlNamespace* (*get_namespace) (GXmlAttribute* self);
	void (*set_namespace) (GXmlAttribute* self, GXmlNamespace* value);
	gchar* (*get_prefix) (GXmlAttribute* self);
};

struct _GXmlSerializableIface {
	GTypeInterface parent_iface;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializable* self);
	gboolean (*set_default_namespace) (GXmlSerializable* self, GXmlNode* node);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializable* self);
	gchar* (*node_name) (GXmlSerializable* self);
	gboolean (*property_use_nick) (GXmlSerializable* self);
	GXmlNode* (*serialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializable* self, GXmlNode* element, GParamSpec* prop, GError** error);
	gboolean (*deserialize) (GXmlSerializable* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializable* self, GXmlNode* property_node, GError** error);
	GParamSpec* (*find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec* (*default_find_property_spec) (GXmlSerializable* self, const gchar* property_name);
	GParamSpec** (*list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GParamSpec** (*default_list_serializable_properties) (GXmlSerializable* self, int* result_length1);
	GeeMap* (*get_unknown_serializable_properties) (GXmlSerializable* self);
	GeeCollection* (*get_unknown_serializable_nodes) (GXmlSerializable* self);
	gchar* (*get_serialized_xml_node_value) (GXmlSerializable* self);
	void (*set_serialized_xml_node_value) (GXmlSerializable* self, const gchar* value);
};

struct _GXmlSerializableObjectModel {
	GObject parent_instance;
	GXmlSerializableObjectModelPrivate * priv;
	GXmlNode* _node;
};

struct _GXmlSerializableObjectModelClass {
	GObjectClass parent_class;
	gboolean (*get_enable_unknown_serializable_property) (GXmlSerializableObjectModel* self);
	gboolean (*serialize_use_xml_node_value) (GXmlSerializableObjectModel* self);
	gboolean (*property_use_nick) (GXmlSerializableObjectModel* self);
	gboolean (*set_default_namespace) (GXmlSerializableObjectModel* self, GXmlNode* node);
	gchar* (*node_name) (GXmlSerializableObjectModel* self);
	GParamSpec* (*find_property_spec) (GXmlSerializableObjectModel* self, const gchar* property_name);
	GParamSpec** (*list_serializable_properties) (GXmlSerializableObjectModel* self, int* result_length1);
	GXmlNode* (*serialize) (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableObjectModel* self, GXmlNode* element, GParamSpec* prop, GError** error);
	gboolean (*deserialize) (GXmlSerializableObjectModel* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_property) (GXmlSerializableObjectModel* self, GXmlNode* property_node, GError** error);
	gchar* (*to_string) (GXmlSerializableObjectModel* self);
};

struct _GXmlSerializableContainer {
	GXmlSerializableObjectModel parent_instance;
	GXmlSerializableContainerPrivate * priv;
};

struct _GXmlSerializableContainerClass {
	GXmlSerializableObjectModelClass parent_class;
	void (*init_containers) (GXmlSerializableContainer* self);
};

struct _GXmlSerializableCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*deserialize_proceed) (GXmlSerializableCollection* self);
	gboolean (*deserialized) (GXmlSerializableCollection* self);
	gboolean (*deserialize_node) (GXmlSerializableCollection* self, GXmlNode* node, GError** error);
	gboolean (*deserialize_children) (GXmlSerializableCollection* self, GError** error);
	gboolean (*is_collection) (GXmlSerializableCollection* self);
};


static gpointer gxml_serializable_container_parent_class = NULL;

GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_attribute_get_type (void) G_GNUC_CONST;
GType gxml_serializable_get_type (void) G_GNUC_CONST;
GType gxml_serializable_object_model_get_type (void) G_GNUC_CONST;
GType gxml_serializable_container_get_type (void) G_GNUC_CONST;
enum  {
	GXML_SERIALIZABLE_CONTAINER_0_PROPERTY
};
void gxml_serializable_container_init_containers (GXmlSerializableContainer* self);
static void gxml_serializable_container_real_init_containers (GXmlSerializableContainer* self);
GXmlSerializableContainer* gxml_serializable_container_construct (GType object_type);
GXmlSerializableObjectModel* gxml_serializable_object_model_construct (GType object_type);
static GObject * gxml_serializable_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void gxml_init_init (void);
GType gxml_serializable_collection_get_type (void) G_GNUC_CONST;
gboolean gxml_serializable_collection_deserialize_proceed (GXmlSerializableCollection* self);
gboolean gxml_serializable_collection_deserialized (GXmlSerializableCollection* self);
gboolean gxml_serializable_collection_deserialize_node (GXmlSerializableCollection* self, GXmlNode* node, GError** error);
gboolean gxml_serializable_collection_deserialize_children (GXmlSerializableCollection* self, GError** error);
gboolean gxml_serializable_collection_is_collection (GXmlSerializableCollection* self);
static gboolean gxml_serializable_collection_real_is_collection (GXmlSerializableCollection* self);


/**
   * Implementors must implement this function and initialize any Serializable container.
   */
static void gxml_serializable_container_real_init_containers (GXmlSerializableContainer* self) {
	g_critical ("Type `%s' does not implement abstract method `gxml_serializable_container_init_containers'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void gxml_serializable_container_init_containers (GXmlSerializableContainer* self) {
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_CONTAINER_GET_CLASS (self)->init_containers (self);
}


GXmlSerializableContainer* gxml_serializable_container_construct (GType object_type) {
	GXmlSerializableContainer * self = NULL;
	self = (GXmlSerializableContainer*) gxml_serializable_object_model_construct (object_type);
	return self;
}


static GObject * gxml_serializable_container_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GXmlSerializableContainer * self;
	parent_class = G_OBJECT_CLASS (gxml_serializable_container_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_CONTAINER, GXmlSerializableContainer);
	gxml_init_init ();
	return obj;
}


static void gxml_serializable_container_class_init (GXmlSerializableContainerClass * klass) {
	gxml_serializable_container_parent_class = g_type_class_peek_parent (klass);
	((GXmlSerializableContainerClass *) klass)->init_containers = (void (*)(GXmlSerializableContainer*)) gxml_serializable_container_real_init_containers;
	G_OBJECT_CLASS (klass)->constructor = gxml_serializable_container_constructor;
}


static void gxml_serializable_container_instance_init (GXmlSerializableContainer * self) {
}


/**
 * Any {@link GXml.Serializable} class having a collection managed list of
 * {@link GXml.Node} must implement this abstract class.
 * 
 * Gee Serializable clases requires to be initialized with required typed objects to contain 
 * its collections and Serializable interface don't know required type. Then you must use this
 * function to initialize any Serializable collection objects in order to serialize/deserialize
 * all {@link GXml.Node} to given clases.
 */
GType gxml_serializable_container_get_type (void) {
	static volatile gsize gxml_serializable_container_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serializable_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlSerializableContainer), 0, (GInstanceInitFunc) gxml_serializable_container_instance_init, NULL };
		GType gxml_serializable_container_type_id;
		gxml_serializable_container_type_id = g_type_register_static (GXML_TYPE_SERIALIZABLE_OBJECT_MODEL, "GXmlSerializableContainer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gxml_serializable_container_type_id__volatile, gxml_serializable_container_type_id);
	}
	return gxml_serializable_container_type_id__volatile;
}


/**
   * Returns true if the collection should be deserialized from a {@link GXml.Node}'s children
   * when {@link GXml.Serializable.deserialize} is called. For large collection of nodes
   * this could impact in performance; return false and use {@link GXml.SerializableCollection.deserialize_children}
   * when you need to deserialize all nodes to access them.
   */
gboolean gxml_serializable_collection_deserialize_proceed (GXmlSerializableCollection* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_COLLECTION_GET_INTERFACE (self)->deserialize_proceed (self);
}


/**
   * Returns true if the collection was deserialized from a {@link GXml.Node}'s children.
   */
gboolean gxml_serializable_collection_deserialized (GXmlSerializableCollection* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_COLLECTION_GET_INTERFACE (self)->deserialized (self);
}


/**
   * Executes a deserialization from a {@link GXml.Node}. After this operation
   * {@link GXml.SerializableCollection.deserialized} should return true.
   *
   * This could unref existing objects in collection.
   */
gboolean gxml_serializable_collection_deserialize_node (GXmlSerializableCollection* self, GXmlNode* node, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_COLLECTION_GET_INTERFACE (self)->deserialize_node (self, node, error);
}


/**
   * Executes a deserialization from all children nodes in a {@link GXml.Node}. After this operation
   * {@link GXml.SerializableCollection.deserialized} should return true.
   *
   * This could unref existing objects in collection.
   */
gboolean gxml_serializable_collection_deserialize_children (GXmlSerializableCollection* self, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_COLLECTION_GET_INTERFACE (self)->deserialize_children (self, error);
}


/**
   * Convenient function to detect Serializable Collections.
   */
static gboolean gxml_serializable_collection_real_is_collection (GXmlSerializableCollection* self) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


gboolean gxml_serializable_collection_is_collection (GXmlSerializableCollection* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_COLLECTION_GET_INTERFACE (self)->is_collection (self);
}


static void gxml_serializable_collection_base_init (GXmlSerializableCollectionIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		iface->is_collection = gxml_serializable_collection_real_is_collection;
	}
}


/**
 * Serializable Framework. interface to be implemented by any collection of {@link Serializable} objects.
 */
GType gxml_serializable_collection_get_type (void) {
	static volatile gsize gxml_serializable_collection_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableCollectionIface), (GBaseInitFunc) gxml_serializable_collection_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_serializable_collection_type_id;
		gxml_serializable_collection_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlSerializableCollection", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_serializable_collection_type_id, G_TYPE_OBJECT);
		g_type_interface_add_prerequisite (gxml_serializable_collection_type_id, GEE_TYPE_TRAVERSABLE);
		g_type_interface_add_prerequisite (gxml_serializable_collection_type_id, GXML_TYPE_SERIALIZABLE);
		g_once_init_leave (&gxml_serializable_collection_type_id__volatile, gxml_serializable_collection_type_id);
	}
	return gxml_serializable_collection_type_id__volatile;
}



