using GLib;
using GSSDP;

public class TestPublisher : ResourceGroup {
    public string resource_type { get; set construct; }
    public string usn { get; set construct; }
    public string location { get; set construct; }

    construct {
        this.add_resource_simple (this.resource_type,
                                  this.usn,
                                  this.location);
    }

    public TestPublisher() {
        Object (client: new Client (null, null),
                resource_type: "upnp:rootdevice",
                usn: "uuid:1234abcd-12ab-12ab-12ab-1234567abc12" +
                      "::upnp:rootdevice",
                location: "http://192.168.1.100/");
    }

    public static int main (string[] args) {
        TestPublisher publisher = new TestPublisher ();

        publisher.available = true;

        MainLoop loop = new MainLoop (null, false);
        loop.run();

        return 0;
    }
}
