using GLib;
using GSSDP;

public class TestBrowser : ResourceBrowser {

    private void on_resource_available (ResourceBrowser   browser,
                                        string            usn,
                                        GLib.List<string> locations) {
        GLib.print ("Resource available:\n  USN: %s\n", usn);
        for (weak List<string> l = locations; l != null; l = l.next) {
            GLib.print ("  Location: %s\n", l.data);
        }
    }

    private void on_resource_unavailable (ResourceBrowser browser,
                                          string      usn) {
        GLib.print ("Resource unavailable:\n  USN: %s\n", usn);
    }

    construct {
        this.resource_available.connect (this.on_resource_available);
        this.resource_unavailable.connect (this.on_resource_unavailable);
    }

    public TestBrowser() {
        Object (target: GSSDP.ALL_RESOURCES,
                client: new Client (null, null));
    }

    public static int main (string[] args) {
        TestBrowser browser = new TestBrowser ();

        browser.active = true;

        GLib.MainLoop loop = new MainLoop (null, false);
        loop.run();

        return 0;
    }

}

