// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEGUTTER_H
#define _GTKSOURCEVIEWMM_SOURCEGUTTER_H


#include <glibmm.h>

/* sourcegutter.h
 *
 * Copyright (C) 2009, 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief SourceGutter class

#include <gdkmm/window.h>
#include <glibmm/object.h>
#include <glibmm/refptr.h>
#include <gtkmm/cellrenderer.h>
#include <gtkmm/tooltip.h>
#include <gtksourceviewmm/sourceview.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceGutter GtkSourceGutter;
typedef struct _GtkSourceGutterClass GtkSourceGutterClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceGutter_Class; } // namespace gtksourceview
namespace gtksourceview
{

class SourceView;

/** Gutter object for SourceView
 *
 * The SourceGutter object represents the left and right gutters of the text
 * view. It is used by SourceView to draw the line numbers and category marks
 * that might be present on a line. By packing additional CellRenderer objects
 * in the gutter, you can extend the gutter with your own custom drawings.
 *
 * The gutter works very much the same way as cells rendered in a Gtk::TreeView.
 * The concept is similar, with the exception that the gutter does not have an
 * underlying Gtk::TreeModel. Instead, you should use set_cell_data_func() to
 * set a callback to fill in any of the cell renderers properties, given the
 * line for which the cell is to be rendered. Renderers are inserted into the
 * gutter at a certain position. The builtin line number renderer is at position
 * SourceView::gutter_position_lines (-30) and the marks renderer is at
 * SourceView::gutter_position_marks (-20). You can use these values to
 * position custom renderers accordingly. The width of a cell renderer can be
 * specified as either fixed (using Gtk::CellRenderer::set_fixed_size()) or
 * dynamic, in which case you @e must set set_cell_size_func(). This callback is
 * used to set the properties of the renderer such that
 * Gtk::CellRenderer::get_size() yields the maximum width of the cell.
 *
 * @newin{2,10}
 */

class SourceGutter : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SourceGutter CppObjectType;
  typedef SourceGutter_Class CppClassType;
  typedef GtkSourceGutter BaseObjectType;
  typedef GtkSourceGutterClass BaseClassType;

private:  friend class SourceGutter_Class;
  static CppClassType sourcegutter_class_;

private:
  // noncopyable
  SourceGutter(const SourceGutter&);
  SourceGutter& operator=(const SourceGutter&);

protected:
  explicit SourceGutter(const Glib::ConstructParams& construct_params);
  explicit SourceGutter(GtkSourceGutter* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SourceGutter();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceGutter*       gobj()       { return reinterpret_cast<GtkSourceGutter*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceGutter* gobj() const { return reinterpret_cast<GtkSourceGutter*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceGutter* gobj_copy();

private:


public:
  
  /** Get the Gdk::Window of the gutter.
   *
   * The window will only be available when the gutter has at least one,
   * non-zero width, cell renderer packed.
   *
   * @return The Gdk::Window of the gutter, or empty Glib::RefPtr if the gutter
   * has no window.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<Gdk::Window> get_window();

  
  /** Get the Gdk::Window of the gutter.
   *
   * The window will only be available when the gutter has at least one,
   * non-zero width, cell renderer packed.
   *
   * @return The Gdk::Window of the gutter, or empty Glib::RefPtr if the gutter
   * has no window.
   *
   * @newin{2,10}
   */
  Glib::RefPtr<const Gdk::Window> get_window() const;

  
  /** Inserts @a renderer into a gutter at @a position.
   *
   * @param renderer A Gtk::CellRenderer.
   * @param position The renderers position.
   *
   * @newin{2,10}
   */
  void insert(Gtk::CellRenderer* renderer, int position);

  
  /** Reorders @a renderer in a gutter to new @a position.
   *
   * @param renderer A Gtk::CellRenderer.
   * @param position The new renderer position.
   *
   * @newin{2,10}
   */
  void reorder(Gtk::CellRenderer* renderer, int position);

  
  /** Removes @a renderer from a gutter.
   *
   * @param renderer A Gtk::CellRenderer.
   *
   * @newin{2,10}
   */
  void remove(Gtk::CellRenderer* renderer);

  
  /** Invalidates the drawable area of the gutter.
   *
   * You can use this to force a redraw of the gutter if something has changed
   * and needs to be redrawn.
   *
   * @newin{2,10}
   */
  void queue_draw();

  /** Slot holding a function.
   *
   * @par Prototype:
   * <tt>void on_cell_data(Gtk::CellRenderer& cell, int line_number, bool current_line);</tt>
   *
   * @newin{2,10}
   */
  typedef sigc::slot<void, Gtk::CellRenderer* /* cell */, int /* line_number */, bool /* current_line */> SlotData;

  /** Slot holding a function.
   *
   * @par Prototype:
   * <tt>void on_cell_size(Gtk::CellRenderer& cell);</tt>
   *
   * @newin{2,10}
   */
  typedef sigc::slot<void, Gtk::CellRenderer* /* cell */> SlotSize;
  

  /** Sets the SlotData to use for @a renderer.
   *
   * This function is used to setup the cell renderer properties for rendering
   * the current cell.
   *
   * @param renderer A Gtk::CellRenderer.
   * @param slot A slot containing function to use.
   *
   * @newin{2,10}
   */
  void set_cell_data_func(Gtk::CellRenderer* renderer, const SlotData& slot);

  /** Sets the SlotSize to use for @a renderer.
   *
   * This function is used to setup the cell renderer properties for measuring
   * the maximum size of the cell.
   *
   * @param renderer A Gtk::CellRenderer.
   * @param slot A slot containing function to use.
   *
   * @newin{2,10}
   */
  void set_cell_size_func(Gtk::CellRenderer* renderer, const SlotSize& slot);

  /** Resets a SlotData to use for @a renderer.
   *
   * @param renderer A Gtk::CellRenderer.
   *
   * @newin{2,10}
   */
  void reset_cell_data_func(Gtk::CellRenderer* renderer);

  /** Resets a SlotSize to use for @a renderer.
   *
   * @param renderer A Gtk::CellRenderer.
   *
   * @newin{2,10}
   */
  void reset_cell_size_func(Gtk::CellRenderer* renderer);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The gutters' GtkSourceView.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SourceView*> property_view() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The gutters text window type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::TextWindowType> property_window_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /** Emitted when a cell has been activated (for instance when there was
   *  a button press on the cell).
   *
   * The signal is only emitted for cells that have the @c activatable property
   * set to @c true.
   *
   * @par Handler parameters:
   * renderer A Gtk::CellRenderer which was activated.
   * iter The Gtk::TextIter at which the cell was activated.
   * event An event with which the cell was activated.
   *
   * @newin{2,10}
   *
   * @par Prototype:
   * <tt>void on_my_%cell_activated(Gtk::CellRenderer* renderer, const Gtk::TextIter& iter, GdkEvent* event)</tt>
   */

  Glib::SignalProxy3< void,Gtk::CellRenderer*,const Gtk::TextIter&,GdkEvent* > signal_cell_activated();


  /** Emitted when a tooltip is requested for a specific cell.
   *
   * Signal handlers can return @c true to notify the tooltip has been handled.
   *
   * @par Handler parameters:
   * renderer A Gtk::CellRenderer which was activated.
   * iter The Gtk::TextIter at which the cell was activated.
   * tooltip A Gtk::Tooltip.
   *
   * @return @c true if tooltip has been handled, otherwise @c false.
   *
   * @newin{2,10}
   *
   * @par Prototype:
   * <tt>bool on_my_%query_tooltip(Gtk::CellRenderer* renderer, const Gtk::TextIter& iter, const Glib::RefPtr<Gtk::Tooltip>& tooltip)</tt>
   */

  Glib::SignalProxy3< bool,Gtk::CellRenderer*,const Gtk::TextIter&,const Glib::RefPtr<Gtk::Tooltip>& > signal_query_tooltip();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_cell_activated(Gtk::CellRenderer* renderer, const Gtk::TextIter& iter, GdkEvent* event);
  virtual bool on_query_tooltip(Gtk::CellRenderer* renderer, const Gtk::TextIter& iter, const Glib::RefPtr<Gtk::Tooltip>& tooltip);


};

} // namespace gtksourceview


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates gtksourceview::SourceGutter
   */
  Glib::RefPtr<gtksourceview::SourceGutter> wrap(GtkSourceGutter* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_SOURCEGUTTER_H */

