// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEPRINTCOMPOSITOR_H
#define _GTKSOURCEVIEWMM_SOURCEPRINTCOMPOSITOR_H


#include <glibmm.h>

/* sourceprintcompositor.h
 *
 * Copyright (C) 2009, 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/printcontext.h>

#include <gtksourceviewmm/sourceview.h>
#include <gtksourceviewmm/sourcebuffer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourcePrintCompositor GtkSourcePrintCompositor;
typedef struct _GtkSourcePrintCompositorClass GtkSourcePrintCompositorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourcePrintCompositor_Class; } // namespace gtksourceview
namespace gtksourceview
{


class SourcePrintCompositor : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SourcePrintCompositor CppObjectType;
  typedef SourcePrintCompositor_Class CppClassType;
  typedef GtkSourcePrintCompositor BaseObjectType;
  typedef GtkSourcePrintCompositorClass BaseClassType;

private:  friend class SourcePrintCompositor_Class;
  static CppClassType sourceprintcompositor_class_;

private:
  // noncopyable
  SourcePrintCompositor(const SourcePrintCompositor&);
  SourcePrintCompositor& operator=(const SourcePrintCompositor&);

protected:
  explicit SourcePrintCompositor(const Glib::ConstructParams& construct_params);
  explicit SourcePrintCompositor(GtkSourcePrintCompositor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SourcePrintCompositor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourcePrintCompositor*       gobj()       { return reinterpret_cast<GtkSourcePrintCompositor*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourcePrintCompositor* gobj() const { return reinterpret_cast<GtkSourcePrintCompositor*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourcePrintCompositor* gobj_copy();

private:


protected:
  explicit SourcePrintCompositor(const Glib::RefPtr<SourceBuffer>& buffer);
  explicit SourcePrintCompositor(const SourceView& view);
public:
  
  static Glib::RefPtr<SourcePrintCompositor> create(const Glib::RefPtr<SourceBuffer>& buffer);

  
  static Glib::RefPtr<SourcePrintCompositor> create(const SourceView& view);


  /** Gets the Gtk::SourceBuffer associated with the compositor. The returned
   * object reference is owned by the compositor object and
   * should not be unreferenced.
   * @return The Gtk::SourceBuffer associated with the compositor.
   * 
   * @newin{2,2}.
   */
  Glib::RefPtr<SourceBuffer> get_buffer();
  
  /** Gets the Gtk::SourceBuffer associated with the compositor. The returned
   * object reference is owned by the compositor object and
   * should not be unreferenced.
   * @return The Gtk::SourceBuffer associated with the compositor.
   * 
   * @newin{2,2}.
   */
  Glib::RefPtr<const SourceBuffer> get_buffer() const;

  
  /** Sets the width of tabulation in characters for printed text. 
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.
   * 
   * @newin{2,2}
   * @param width Width of tab in characters.
   */
  void set_tab_width(guint width);
  
  /** Return value: width of tab.
   * @return Width of tab.
   * 
   * @newin{2,2}.
   */
  guint get_tab_width() const;

  
  /** Sets the line wrapping mode for the printed text.
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.  
   * 
   * @newin{2,2}
   * @param wrap_mode A Gtk::WrapMode.
   */
  void set_wrap_mode(Gtk::WrapMode wrap_mode);
  
  /** Gets the line wrapping mode for the printed text.
   * @return The line wrap mode.
   * 
   * @newin{2,2}.
   */
  Gtk::WrapMode get_wrap_mode() const;

  
  /** Sets whether the printed text will be highlighted according to the
   * buffer rules.  Both color and font style are applied.
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.   
   * 
   * @newin{2,2}
   * @param highlight Whether syntax should be highlighted.
   */
  void set_highlight_syntax(bool highlight);
  
  /** Determines whether the printed text will be highlighted according to the
   * buffer rules.  Note that highlighting will happen
   * only if the buffer to print has highlighting activated.
   * @return <tt>true</tt> if the printed output will be highlighted.
   * 
   * @newin{2,2}.
   */
  bool get_highlight_syntax() const;

  
  /** Sets the interval for printed line numbers.  If @a interval is 0 no
   * numbers will be printed.  If greater than 0, a number will be
   * printed every @a interval lines (i.e. 1 will print all line numbers).
   * 
   * Maximum accepted value for @a interval is 100.
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.   
   * 
   * @newin{2,2}
   * @param interval Interval for printed line numbers.
   */
  void set_print_line_numbers(guint interval);
  
  /** Return value: the interval of printed line numbers.
   * @return The interval of printed line numbers.
   * 
   * @newin{2,2}.
   */
  guint get_print_line_numbers() const;

  
  /** Sets the default font for the printed text. 
   * 
   *  @a font_name should be a
   * string representation of a font description Pango can understand.
   * (e.g. "Monospace 10"). See pango_font_description_from_string()
   * for a description of the format of the string representation. 
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.   
   * 
   * @newin{2,2}
   * @param font_name The name of the default font for the body text.
   */
  void set_body_font_name(const Glib::ustring& font_name);
  
  /** Return value: a new string containing the name of the font used to print the
   * @return A new string containing the name of the font used to print the 
   * text body.
   * 
   * @newin{2,2}.
   */
  Glib::ustring get_body_font_name() const;

  
  /** Sets the font for printing line numbers on the left margin.  If
   * <tt>0</tt> is supplied, the default font (i.e. the one being used for the
   * text) will be used instead.  
   * 
   *  @a font_name should be a
   * string representation of a font description Pango can understand.
   * (e.g. "Monospace 10"). See pango_font_description_from_string()
   * for a description of the format of the string representation. 
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.    
   * 
   * @newin{2,2}
   * @param font_name The name of the font for line numbers, or <tt>0</tt>.
   */
  void set_line_numbers_font_name(const Glib::ustring& font_name);
  
  /** Return value: a new string containing the name of the font used to print
   * @return A new string containing the name of the font used to print 
   * line numbers on the left margin.
   * 
   * @newin{2,2}.
   */
  Glib::ustring get_line_numbers_font_name() const;

  
  /** Sets the font for printing the page header. If
   * <tt>0</tt> is supplied, the default font (i.e. the one being used for the
   * text) will be used instead.  
   * 
   *  @a font_name should be a
   * string representation of a font description Pango can understand.
   * (e.g. "Monospace 10"). See pango_font_description_from_string()
   * for a description of the format of the string representation. 
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.    
   * 
   * @newin{2,2}
   * @param font_name The name of the font for header text, or <tt>0</tt>.
   */
  void set_header_font_name(const Glib::ustring& font_name);
  
  /** Return value: a new string containing the name of the font used to print
   * @return A new string containing the name of the font used to print 
   * the page header.
   * 
   * @newin{2,2}.
   */
  Glib::ustring get_header_font_name() const;

  
  /** Sets the font for printing the page footer. If
   * <tt>0</tt> is supplied, the default font (i.e. the one being used for the
   * text) will be used instead.  
   * 
   *  @a font_name should be a
   * string representation of a font description Pango can understand.
   * (e.g. "Monospace 10"). See pango_font_description_from_string()
   * for a description of the format of the string representation. 
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.    
   * 
   * @newin{2,2}
   * @param font_name The name of the font for the footer text, or <tt>0</tt>.
   */
  void set_footer_font_name(const Glib::ustring& font_name);
  
  /** Return value: a new string containing the name of the font used to print
   * @return A new string containing the name of the font used to print 
   * the page footer.
   * 
   * @newin{2,2}.
   */
  Glib::ustring get_footer_font_name() const;

 
  /** Sets the top margin used by @a compositor.
   * 
   * @newin{2,2}
   * @param margin The new top margin in units of @a unit.
   * @param unit The units for @a margin.
   */
  void set_top_margin(double margin, Gtk::Unit unit);
  
  /** Gets the top margin in units of @a unit.
   * @param unit The unit for the return value.
   * @return The top margin.
   * 
   * @newin{2,2}.
   */
  double get_top_margin(Gtk::Unit unit) const;

  
  /** Sets the bottom margin used by @a compositor.
   * 
   * @newin{2,2}
   * @param margin The new bottom margin in units of @a unit.
   * @param unit The units for @a margin.
   */
  void set_bottom_margin(double margin, Gtk::Unit unit);
  
  /** Gets the bottom margin in units of @a unit.
   * @param unit The unit for the return value.
   * @return The bottom margin.
   * 
   * @newin{2,2}.
   */
  double get_bottom_margin(Gtk::Unit unit) const;

  
  /** Sets the left margin used by @a compositor.
   * 
   * @newin{2,2}
   * @param margin The new left margin in units of @a unit.
   * @param unit The units for @a margin.
   */
  void set_left_margin(double margin, Gtk::Unit unit);
  
  /** Gets the left margin in units of @a unit.
   * @param unit The unit for the return value.
   * @return The left margin
   * 
   * @newin{2,2}.
   */
  double get_left_margin(Gtk::Unit unit) const;

  
  /** Sets the right margin used by @a compositor.
   * 
   * @newin{2,2}
   * @param margin The new right margin in units of @a unit.
   * @param unit The units for @a margin.
   */
  void set_right_margin(double margin, Gtk::Unit unit);
  
  /** Gets the right margin in units of @a unit.
   * @param unit The unit for the return value.
   * @return The right margin
   * 
   * @newin{2,2}.
   */
  double get_right_margin(Gtk::Unit unit) const;

  
  /** Sets whether you want to print a header in each page.  The 
   * header consists of three pieces of text and an optional line
   * separator, configurable with
   * set_header_format().
   * 
   * Note that by default the header format is unspecified, and if it's
   * empty it will not be printed, regardless of this setting.
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.    
   * 
   * @newin{2,2}
   * @param print <tt>true</tt> if you want the header to be printed.
   */
  void set_print_header(bool print);
  
  /** Determines if a header is set to be printed for each page.  A
   * header will be printed if this function returns <tt>true</tt>
   * <emphasis>and</emphasis> some format strings have been specified
   * with set_header_format().
   * @return <tt>true</tt> if the header is set to be printed.
   * 
   * @newin{2,2}.
   */
  bool get_print_header() const;

  
  /** Sets whether you want to print a footer in each page.  The 
   * footer consists of three pieces of text and an optional line
   * separator, configurable with
   * set_footer_format().
   * 
   * Note that by default the footer format is unspecified, and if it's
   * empty it will not be printed, regardless of this setting.
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.    
   * 
   * @newin{2,2}
   * @param print <tt>true</tt> if you want the footer to be printed.
   */
  void set_print_footer(bool print);
  
  /** Determines if a footer is set to be printed for each page.  A
   * footer will be printed if this function returns <tt>true</tt>
   * <emphasis>and</emphasis> some format strings have been specified
   * with set_footer_format().
   * @return <tt>true</tt> if the footer is set to be printed.
   * 
   * @newin{2,2}.
   */
  bool get_print_footer() const;

  
  /** Sets strftime like header format strings, to be printed on the
   * left, center and right of the top of each page.  The strings may
   * include strftime(3) codes which will be expanded at print time.
   * All strftime() codes are accepted, with the addition of %N for the
   * page number and %Q for the page count.
   * 
   *  @a separator specifies if a solid line should be drawn to separate
   * the header from the document text.
   * 
   * If <tt>0</tt> is given for any of the three arguments, that particular
   * string will not be printed.
   * 
   * For the header to be printed, in
   * addition to specifying format strings, you need to enable header
   * printing with set_print_header().
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.    
   * 
   * @newin{2,2}
   * @param separator <tt>true</tt> if you want a separator line to be printed.
   * @param left A format string to print on the left of the header.
   * @param center A format string to print on the center of the header.
   * @param right A format string to print on the right of the header.
   */

  void set_header_format(bool separator, const Glib::ustring& left, const Glib::ustring& center, const Glib::ustring& right);
  
  /** Sets strftime like header format strings, to be printed on the
   * left, center and right of the bottom of each page. The strings may
   * include strftime(3) codes which will be expanded at print time.
   * All strftime() codes are accepted, with the addition of %N for the
   * page number and %Q for the page count.
   * 
   *  @a separator specifies if a solid line should be drawn to separate
   * the footer from the document text.
   * 
   * If <tt>0</tt> is given for any of the three arguments, that particular
   * string will not be printed.
   * 
   * For the footer to be printed, in
   * addition to specifying format strings, you need to enable footer
   * printing with set_print_footer().
   * 
   * This function cannot be called anymore after the first call to the 
   * paginate() function.    
   * 
   * @newin{2,2}
   * @param separator <tt>true</tt> if you want a separator line to be printed.
   * @param left A format string to print on the left of the footer.
   * @param center A format string to print on the center of the footer.
   * @param right A format string to print on the right of the footer.
   */

  void set_footer_format(bool separator, const Glib::ustring& left, const Glib::ustring& center, const Glib::ustring& right);

  
  /** Return value: the number of pages in the document or <code>-1</code> if the
   * @return The number of pages in the document or <code>-1</code> if the 
   * document has not been completely paginated.
   * 
   * @newin{2,2}.
   */
  int get_n_pages() const;
  
  /** Paginate the document associated with the @a compositor.
   * 
   * In order to support non-blocking pagination, document is paginated in small chunks.
   * Each time paginate() is invoked, a chunk of the document 
   * is paginated. To paginate the entire document, paginate() 
   * must be invoked multiple times.
   * It returns <tt>true</tt> if the document has been completely paginated, otherwise it returns <tt>false</tt>.
   * 
   * This method has been designed to be invoked in the handler of the Gtk::PrintOperation::paginate signal,
   * as shown in the following example:
   * 
   * <informalexample><programlisting>
   * // Signal handler for the GtkPrintOperation::paginate signal
   * 
   * static <tt>bool</tt>
   * paginate (GtkPrintOperation *operation,
   * GtkPrintContext   *context,
   * gpointer           user_data)
   * {
   * GtkSourcePrintCompositor *compositor;
   * 
   * compositor = GTK_SOURCE_PRINT_COMPOSITOR (user_data);
   * 
   * if (gtk_source_print_compositor_paginate (compositor, context))
   * {
   * <tt>int</tt> n_pages;
   * 
   * n_pages = gtk_source_print_compositor_get_n_pages (compositor);
   * gtk_print_operation_set_n_pages (operation, n_pages);
   * 
   * return <tt>true</tt>;
   * }
   * 
   * return <tt>false</tt>;
   * }
   * </programlisting></informalexample>
   * 
   * If you don't need to do pagination in chunks, you can simply do it all in the 
   * Gtk::PrintOperation::begin-print handler, and set the number of pages from there, like
   * in the following example:
   * 
   * <informalexample><programlisting>
   * // Signal handler for the GtkPrintOperation::begin-print signal
   * 
   * static void
   * begin_print (GtkPrintOperation *operation,
   * GtkPrintContext   *context,
   * gpointer           user_data)
   * {
   * GtkSourcePrintCompositor *compositor;
   * <tt>int</tt> n_pages;
   * 
   * compositor = GTK_SOURCE_PRINT_COMPOSITOR (user_data);
   * 
   * while (!gtk_source_print_compositor_paginate (compositor, context));
   * 
   * n_pages = gtk_source_print_compositor_get_n_pages (compositor);
   * gtk_print_operation_set_n_pages (operation, n_pages);
   * }
   * </programlisting></informalexample>
   * @param context The Gtk::PrintContext whose parameters (e.g. paper size, print margins, etc.) 
   * are used by the the @a compositor to paginate the document.
   * @return <tt>true</tt> if the document has been completely paginated, <tt>false</tt> otherwise.
   * 
   * @newin{2,2}.
   */
  bool paginate(const Glib::RefPtr<Gtk::PrintContext>& context);
  
  /** Return value: a fraction from 0.0 to 1.0 inclusive
   * @return A fraction from 0.0 to 1.0 inclusive
   * 
   * @newin{2,2}.
   */
  double get_pagination_process();
  
  /** Draw page @a page_nr for printing on the the Cairo context encapsuled in @a context.
   * 
   * This method has been designed to be called in the handler of the Gtk::PrintOperation::draw_page signal
   * as shown in the following example:
   * 
   * <informalexample><programlisting>
   * // Signal handler for the GtkPrintOperation::draw_page signal
   * 
   * static void
   * draw_page (GtkPrintOperation *operation,
   * GtkPrintContext   *context,
   * <tt>int</tt>               page_nr,
   * gpointer           user_data)
   * {
   * GtkSourcePrintCompositor *compositor;
   * 
   * compositor = GTK_SOURCE_PRINT_COMPOSITOR (user_data);
   * 
   * gtk_source_print_compositor_draw_page (compositor, 
   * context,
   * page_nr);
   * }
   * </programlisting></informalexample>
   * @param context The Gtk::PrintContext encapsulating the context information that is required when 
   * drawing the page for printing.
   * @param page_nr The number of the page to print.
   */
  void draw_page(const Glib::RefPtr<Gtk::PrintContext>& context, int page_nr);


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the font to use for the text body (e.g. 'Monospace 10').
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_body_font_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the font to use for the text body (e.g. 'Monospace 10').
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_body_font_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkSourceBuffer object to print.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<SourceBuffer> > property_buffer() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the font to use for the page footer (e.g. 'Monospace 10').
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_footer_font_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the font to use for the page footer (e.g. 'Monospace 10').
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_footer_font_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the font to use for the page header (e.g. 'Monospace 10').
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_header_font_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the font to use for the page header (e.g. 'Monospace 10').
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_header_font_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to print the document with highlighted syntax.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_highlight_syntax() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to print the document with highlighted syntax.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_highlight_syntax() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the font to use for the line numbers (e.g. 'Monospace 10').
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_line_numbers_font_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Name of the font to use for the line numbers (e.g. 'Monospace 10').
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_line_numbers_font_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The number of pages in the document (-1 means the document has not been completely paginated).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_n_pages() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to print a footer in each page.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_print_footer() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to print a footer in each page.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_print_footer() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to print a header in each page.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_print_header() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to print a header in each page.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_print_header() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Interval of printed line numbers (0 means no numbers).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_print_line_numbers() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Interval of printed line numbers (0 means no numbers).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_print_line_numbers() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of a tab character expressed in spaces.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_tab_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Width of a tab character expressed in spaces.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_tab_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to wrap lines never
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::WrapMode> property_wrap_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to wrap lines never
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::WrapMode> property_wrap_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} /* namespace gtksourceview */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates gtksourceview::SourcePrintCompositor
   */
  Glib::RefPtr<gtksourceview::SourcePrintCompositor> wrap(GtkSourcePrintCompositor* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_SOURCEPRINTCOMPOSITOR_H */

