// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCEGUTTER_H
#define _GTKSOURCEVIEWMM_SOURCEGUTTER_H


#include <glibmm.h>

/* sourcegutter.h
 *
 * Copyright (C) 2009, 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/// \file
/// \brief SourceGutter class

#include <gdkmm/window.h>
#include <glibmm/object.h>
#include <glibmm/refptr.h>
#include <gtkmm/cellrenderer.h>
#include <gtkmm/tooltip.h>
#include <gtksourceviewmm/sourceview.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceGutter GtkSourceGutter;
typedef struct _GtkSourceGutterClass GtkSourceGutterClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceGutter_Class; } // namespace gtksourceview
namespace gtksourceview
{

class SourceView;


class SourceGutter : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SourceGutter CppObjectType;
  typedef SourceGutter_Class CppClassType;
  typedef GtkSourceGutter BaseObjectType;
  typedef GtkSourceGutterClass BaseClassType;

private:  friend class SourceGutter_Class;
  static CppClassType sourcegutter_class_;

private:
  // noncopyable
  SourceGutter(const SourceGutter&);
  SourceGutter& operator=(const SourceGutter&);

protected:
  explicit SourceGutter(const Glib::ConstructParams& construct_params);
  explicit SourceGutter(GtkSourceGutter* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SourceGutter();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceGutter*       gobj()       { return reinterpret_cast<GtkSourceGutter*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSourceGutter* gobj() const { return reinterpret_cast<GtkSourceGutter*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSourceGutter* gobj_copy();

private:


protected:
  // TODO: C API does not provide any constructor for GtkSourceGutter, should we delete it on API/ABI break? krnowak
  SourceGutter();

public:
  // TODO: C API does not provide any constructor for GtkSourceGutter, should we delete it on API/ABI break? krnowak
  
  static Glib::RefPtr<SourceGutter> create();


  /** Get the Gdk::Window of the gutter. The window will only be available when the
   * gutter has at least one, non-zero width, cell renderer packed.
   * @return The Gdk::Window of the gutter, or <tt>0</tt> if the gutter has no window.
   * 
   * @newin{2,8}.
   */
  Glib::RefPtr<Gdk::Window> get_window();
  
  /** Get the Gdk::Window of the gutter. The window will only be available when the
   * gutter has at least one, non-zero width, cell renderer packed.
   * @return The Gdk::Window of the gutter, or <tt>0</tt> if the gutter has no window.
   * 
   * @newin{2,8}.
   */
  Glib::RefPtr<const Gdk::Window> get_window() const;

  
  /** Inserts @a renderer into @a gutter at @a position.
   * 
   * @newin{2,8}
   * @param renderer A Gtk::CellRenderer.
   * @param position The renderers position.
   */
  void insert(Gtk::CellRenderer* renderer, int position);
  
  /** Reorders @a renderer in @a gutter to new @a position.
   * 
   * @newin{2,8}
   * @param renderer A Gtk::CellRenderer.
   * @param position The new renderer position.
   */
  void reorder(Gtk::CellRenderer* renderer, int position);
  
  /** Removes @a renderer from @a gutter.
   * 
   * @newin{2,8}
   * @param renderer A Gtk::CellRenderer.
   */
  void remove(Gtk::CellRenderer* renderer);

  
  /** Invalidates the drawable area of the gutter. You can use this to force a
   * redraw of the gutter if something has changed and needs to be redrawn.
   * 
   * @newin{2,8}
   */
  void queue_draw();

  /// For instance,
  /// void on_cell_data(Gtk::CellRenderer& cell, int line_number, bool current_line);
  typedef sigc::slot<void, Gtk::CellRenderer* /* cell */, int /* line_number */, bool /* current_line */> SlotData;
  /// For instance,
  /// void on_cell_size(Gtk::CellRenderer& cell);
  typedef sigc::slot<void, Gtk::CellRenderer* /* cell */> SlotSize;
  
  void set_cell_data_func(Gtk::CellRenderer* renderer, const SlotData& slot);
  void set_cell_size_func(Gtk::CellRenderer* renderer, const SlotSize& slot);
  void reset_cell_data_func(Gtk::CellRenderer* renderer);
  void reset_cell_size_func(Gtk::CellRenderer* renderer);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The gutters' GtkSourceView.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<SourceView*> property_view() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The gutters text window type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::TextWindowType> property_window_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%cell_activated(Gtk::CellRenderer* renderer, const Gtk::TextIter& iter, GdkEvent* event)</tt>
   */

  Glib::SignalProxy3< void,Gtk::CellRenderer*,const Gtk::TextIter&,GdkEvent* > signal_cell_activated();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%query_tooltip(Gtk::CellRenderer* renderer, const Gtk::TextIter& iter, const Glib::RefPtr<Gtk::Tooltip>& tooltip)</tt>
   */

  Glib::SignalProxy3< bool,Gtk::CellRenderer*,const Gtk::TextIter&,const Glib::RefPtr<Gtk::Tooltip>& > signal_query_tooltip();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_cell_activated(Gtk::CellRenderer* renderer, const Gtk::TextIter& iter, GdkEvent* event);
  virtual bool on_query_tooltip(Gtk::CellRenderer* renderer, const Gtk::TextIter& iter, const Glib::RefPtr<Gtk::Tooltip>& tooltip);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace gtksourceview


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates gtksourceview::SourceGutter
   */
  Glib::RefPtr<gtksourceview::SourceGutter> wrap(GtkSourceGutter* object, bool take_copy = false);
}


#endif /* _GTKSOURCEVIEWMM_SOURCEGUTTER_H */

