// -*- c++ -*-
// Generated by gmmproc 2.43.1 -- DO NOT MODIFY!
#ifndef _GTKMM_NOTEBOOK_H
#define _GTKMM_NOTEBOOK_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <gtkmm/container.h>
#include <gtkmm/label.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkNotebook GtkNotebook;
typedef struct _GtkNotebookClass GtkNotebookClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Notebook_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 * 
 * @ingroup gtkmmEnums
 */
enum NotebookTab
{
  NOTEBOOK_TAB_FIRST,
  NOTEBOOK_TAB_LAST
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::NotebookTab> : public Glib::Value_Enum<Gtk::NotebookTab>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** Container which shows one of its children at a time, in tabbed windows.
 *
 * The Gtk::Notebook widget is a Gtk::Container whose children are pages that
 * can be switched between using tab labels along one edge.
 *
 * A Notebook widget looks like this:
 * @image html notebook1.png
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class Notebook : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Notebook CppObjectType;
  typedef Notebook_Class CppClassType;
  typedef GtkNotebook BaseObjectType;
  typedef GtkNotebookClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Notebook();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Notebook_Class;
  static CppClassType notebook_class_;

  // noncopyable
  Notebook(const Notebook&);
  Notebook& operator=(const Notebook&);

protected:
  explicit Notebook(const Glib::ConstructParams& construct_params);
  explicit Notebook(GtkNotebook* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkNotebook*       gobj()       { return reinterpret_cast<GtkNotebook*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkNotebook* gobj() const { return reinterpret_cast<GtkNotebook*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_switch_page().
  virtual void on_switch_page(Widget* page, guint page_num);


private:

  //gtkmmproc error: gtk_notebook_set_homogeneous_tabs : ignored method defs lookup failed//gtkmmproc error: gtk_notebook_set_tab_border : ignored method defs lookup failed//gtkmmproc error: gtk_notebook_set_tab_hborder : ignored method defs lookup failed//gtkmmproc error: gtk_notebook_set_tab_vborder : ignored method defs lookup failed

public:

  Notebook();

  
  /** Prepends a page to @a notebook.
   * 
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page.
   */
  int prepend_page(Widget& child, Widget& tab_label);
  int prepend_page(Widget& child);

  int prepend_page(Widget& child, const Glib::ustring& tab_label, bool use_mnemonic = false);
  
  /** Prepends a page to @a notebook, specifying the widget to use as the
   * label in the popup menu.
   * 
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page.
   * @param menu_label The widget to use as a label for the page-switch
   * menu.
   */
  int prepend_page(Widget& child, Widget& tab_label, Widget& menu_label);
  //Ignore the possible-0 menu_label version of this method. It would have the same signature as another method.

  int prepend_page(Widget& child, const Glib::ustring& tab_label, const Glib::ustring& menu_label, bool use_mnemonic);

  
  /** Appends a page to @a notebook.
   * 
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page.
   */
  int append_page(Widget& child, Widget& tab_label);
  int append_page(Widget& child);
  int append_page(Widget& child, const Glib::ustring& tab_label, bool use_mnemonic = false);

  
  /** Appends a page to @a notebook, specifying the widget to use as the
   * label in the popup menu.
   * 
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page.
   * @param menu_label The widget to use as a label for the page-switch
   * menu.
   */
  int append_page(Widget& child, Widget& tab_label, Widget& menu_label);
  //Ignore the possible-0 menu_label version of this method. It would have the same signature as another method.

  int append_page(Widget& child, const Glib::ustring& tab_label, const Glib::ustring& menu_label, bool use_mnemonic = false);

  
  /** Insert a page into @a notebook at the given position.
   * 
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page.
   * @param position The index (starting at 0) at which to insert the page,
   * or -1 to append the page after all other pages.
   */
  int insert_page(Widget& child, Widget& tab_label, int position);
  int insert_page(Widget& child, int position);

  int insert_page(Widget& child, const Glib::ustring& tab_label, int position, bool use_mnemonic = false);
  
  /** Insert a page into @a notebook at the given position, specifying
   * the widget to use as the label in the popup menu.
   * 
   * @param child The Gtk::Widget to use as the contents of the page.
   * @param tab_label The Gtk::Widget to be used as the label for the page..
   * @param menu_label The widget to use as a label for the page-switch
   * menu.
   * @param position The index (starting at 0) at which to insert the page,
   * or -1 to append the page after all other pages.
   */
  int insert_page(Widget& child, Widget& tab_label, Widget& menu_label, int position);
  //Ignore the possible-0 menu_label version of this method. It would have the same signature as another method.

  int insert_page(Widget& child, const Glib::ustring& tab_label, const Glib::ustring& menu_label, int position, bool use_mnemonic = false);

  
  /** Removes a page from the notebook given its index
   * in the notebook.
   * 
   * @param page_num The index of a notebook page, starting
   * from 0. If -1, the last page will be removed.
   */
  void remove_page(int page_num =  0);
  void remove_page(Widget& child);

  //gtkmmproc error: gtk_notebook_set_group_id : ignored method defs lookup failed//gtkmmproc error: gtk_notebook_get_group_id : ignored method defs lookup failed //deprecated

  
  /** Sets a group name for @a notebook.
   * 
   * Notebooks with the same name will be able to exchange tabs
   * via drag and drop. A notebook with a <tt>0</tt> group name will
   * not be able to exchange tabs with any other notebook.
   * 
   * @newin{2,24}
   * 
   * @param group_name The name of the notebook group,
   * or <tt>0</tt> to unset it.
   */
  void set_group_name(const Glib::ustring& group_name);
  
  /** Gets the current group name for @a notebook.
   * 
   * @newin{2,24}
   * 
   * @return The group name,
   * or <tt>0</tt> if none is set.
   */
  Glib::ustring get_group_name() const;

  
  /** Returns the page number of the current page.
   * 
   * @return The index (starting from 0) of the current
   * page in the notebook. If the notebook has no pages,
   * then -1 will be returned.
   */
  int get_current_page() const;
  
  /** Returns the child widget contained in page number @a page_num.
   * 
   * @param page_num The index of a page in the notebook, or -1
   * to get the last page.
   * @return The child widget, or <tt>0</tt>
   * if @a page_num is out of bounds.
   */
  Widget* get_nth_page(int page_num);
  
  /** Returns the child widget contained in page number @a page_num.
   * 
   * @param page_num The index of a page in the notebook, or -1
   * to get the last page.
   * @return The child widget, or <tt>0</tt>
   * if @a page_num is out of bounds.
   */
  const Widget* get_nth_page(int page_num) const;
  
  /** Gets the number of pages in a notebook.
   * 
   * @newin{2,2}
   * 
   * @return The number of pages in the notebook.
   */
  int get_n_pages() const;
  /*Widget* get_current_page();*/ /*inconsistency with set_current_page*/
  
  /** Finds the index of the page which contains the given child
   * widget.
   * 
   * @param child A Gtk::Widget.
   * @return The index of the page containing @a child, or
   * -1 if @a child is not in the notebook.
   */
  int page_num(const Widget& child) const;

  
  /** Switches to the page number @a page_num.
   * 
   * Note that due to historical reasons, GtkNotebook refuses
   * to switch to a page unless the child widget is visible.
   * Therefore, it is recommended to show child widgets before
   * adding them to a notebook.
   * 
   * @param page_num Index of the page to switch to, starting from 0.
   * If negative, the last page will be used. If greater
   * than the number of pages in the notebook, nothing
   * will be done.
   */
  void set_current_page(int page_num);
  
  /** Switches to the next page. Nothing happens if the current page is
   * the last page.
   * 
   */
  void next_page();
  
  /** Switches to the previous page. Nothing happens if the current page
   * is the first page.
   * 
   */
  void prev_page();

  
  /** Sets whether a bevel will be drawn around the notebook pages.
   * This only has a visual effect when the tabs are not shown.
   * See set_show_tabs().
   * 
   * @param show_border <tt>true</tt> if a bevel should be drawn around the notebook.
   */
  void set_show_border(bool show_border =  true);

  
  /** Returns whether a bevel will be drawn around the notebook pages.
   * See set_show_border().
   * 
   * @return <tt>true</tt> if the bevel is drawn.
   */
  bool get_show_border() const;
  
  /** Sets whether to show the tabs for the notebook or not.
   * 
   * @param show_tabs <tt>true</tt> if the tabs should be shown.
   */
  void set_show_tabs(bool show_tabs =  true);
  
  /** Returns whether the tabs of the notebook are shown.
   * See set_show_tabs().
   * 
   * @return <tt>true</tt> if the tabs are shown.
   */
  bool get_show_tabs() const;


  /** Sets the edge at which the tabs for switching pages in the
   * notebook are drawn.
   * 
   * @param pos The edge to draw the tabs at.
   */
  void set_tab_pos(PositionType pos);
  
  /** Gets the edge at which the tabs for switching pages in the
   * notebook are drawn.
   * 
   * @return The edge at which the tabs are drawn.
   */
  PositionType get_tab_pos() const;

  
  /** Sets whether the tab label area will have arrows for
   * scrolling if there are too many tabs to fit in the area.
   * 
   * @param scrollable <tt>true</tt> if scroll arrows should be added.
   */
  void set_scrollable(bool scrollable =  true);
  
  /** Returns whether the tab label area has arrows for scrolling.
   * See set_scrollable().
   * 
   * @return <tt>true</tt> if arrows for scrolling are present.
   */
  bool get_scrollable() const;

  
#ifndef GTKMM_DISABLE_DEPRECATED

  /** Returns the horizontal width of a tab border.
   * 
   * @newin{2,22}
   * 
   * Deprecated: 3.4: this function returns zero
   * 
   * @deprecated This method now returns zero.
   * 
   * @return Horizontal width of a tab border.
   */
  guint16 get_tab_hborder() const;
#endif // GTKMM_DISABLE_DEPRECATED


#ifndef GTKMM_DISABLE_DEPRECATED

  /** Returns the vertical width of a tab border.
   * 
   * @newin{2,22}
   * 
   * Deprecated: 3.4: this function returns zero
   * 
   * @deprecated This method now returns zero.
   * 
   * @return Vertical width of a tab border.
   */
  guint16 get_tab_vborder() const;
#endif // GTKMM_DISABLE_DEPRECATED


  /** Enables the popup menu: if the user clicks with the right
   * mouse button on the tab labels, a menu with all the pages
   * will be popped up.
   * 
   */
  void popup_enable();

  
  /** Disables the popup menu.
   * 
   */
  void popup_disable();

  
  /** Returns the tab label widget for the page @a child.
   * <tt>0</tt> is returned if @a child is not in @a notebook or
   * if no tab label has specifically been set for @a child.
   * 
   * @param child The page.
   * @return The tab label.
   */
  Widget* get_tab_label(Widget& child);
  
  /** Returns the tab label widget for the page @a child.
   * <tt>0</tt> is returned if @a child is not in @a notebook or
   * if no tab label has specifically been set for @a child.
   * 
   * @param child The page.
   * @return The tab label.
   */
  const Widget* get_tab_label(Widget& child) const;
  
  /** Changes the tab label for @a child.
   * If <tt>0</tt> is specified for @a tab_label, then the page will
   * have the label “page N”.
   * 
   * @param child The page.
   * @param tab_label The tab label widget to use, or <tt>0</tt>
   * for default tab label.
   */
  void set_tab_label(Widget& child, Widget& tab_label);
  
  /** Creates a new label and sets it as the tab label for the page
   * containing @a child.
   * 
   * @param child The page.
   * @param tab_text The label text.
   */
  void set_tab_label_text(Widget& child, const Glib::ustring& tab_text);
  
  /** Retrieves the text of the tab label for the page containing
   *  @a child.
   * 
   * @param child A widget contained in a page of @a notebook.
   * @return The text of the tab label.
   */
  Glib::ustring get_tab_label_text(Widget& child) const;
  
  /** Retrieves the menu label widget of the page containing @a child.
   * 
   * @param child A widget contained in a page of @a notebook.
   * @return The menu label, or <tt>0</tt> if the
   * notebook page does not have a menu label other than the
   * default (the tab label).
   */
  Widget* get_menu_label(Widget& child);
  
  /** Retrieves the menu label widget of the page containing @a child.
   * 
   * @param child A widget contained in a page of @a notebook.
   * @return The menu label, or <tt>0</tt> if the
   * notebook page does not have a menu label other than the
   * default (the tab label).
   */
  const Widget* get_menu_label(Widget& child) const;
  
  /** Changes the menu label for the page containing @a child.
   * 
   * @param child The child widget.
   * @param menu_label The menu label, or <tt>0</tt> for default.
   */
  void set_menu_label(Widget& child, Widget& menu_label);
  
  /** Creates a new label and sets it as the menu label of @a child.
   * 
   * @param child The child widget.
   * @param menu_text The label text.
   */
  void set_menu_label_text(Widget& child, const Glib::ustring& menu_text);
  
  /** Retrieves the text of the menu label for the page containing
   *  @a child.
   * 
   * @param child The child widget of a page of the notebook.
   * @return The text of the tab label.
   */
  Glib::ustring get_menu_label_text(Widget& child) const;

  //gtkmmproc error: gtk_notebook_query_tab_label_packing : ignored method defs lookup failed//gtkmmproc error: gtk_notebook_set_tab_label_packing : ignored method defs lookup failed //deprecated

  
  /** Reorders the page containing @a child, so that it appears in position
   *  @a position. If @a position is greater than or equal to the number of
   * children in the list or negative, @a child will be moved to the end
   * of the list.
   * 
   * @param child The child to move.
   * @param position The new position, or -1 to move to the end.
   */
  void reorder_child(Widget& child, int position);

  
  /** Gets whether the tab can be reordered via drag and drop or not.
   * 
   * @newin{2,10}
   * 
   * @param child A child Gtk::Widget.
   * @return <tt>true</tt> if the tab is reorderable.
   */
  bool get_tab_reorderable(Widget& child) const;
  
  /** Sets whether the notebook tab can be reordered
   * via drag and drop or not.
   * 
   * @newin{2,10}
   * 
   * @param child A child Gtk::Widget.
   * @param reorderable Whether the tab is reorderable or not.
   */
  void set_tab_reorderable(Widget& child, bool reorderable =  true);
  
  /** Returns whether the tab contents can be detached from @a notebook.
   * 
   * @newin{2,10}
   * 
   * @param child A child Gtk::Widget.
   * @return <tt>true</tt> if the tab is detachable.
   */
  bool get_tab_detachable(Widget& child) const;
  
  /** Sets whether the tab can be detached from @a notebook to another
   * notebook or widget.
   * 
   * Note that 2 notebooks must share a common group identificator
   * (see set_group_name()) to allow automatic tabs
   * interchange between them.
   * 
   * If you want a widget to interact with a notebook through DnD
   * (i.e.: accept dragged tabs from it) it must be set as a drop
   * destination and accept the target “GTK_NOTEBOOK_TAB”. The notebook
   * will fill the selection with a GtkWidget** pointing to the child
   * widget that corresponds to the dropped tab.
   * 
   * [C example ellipted]
   * 
   * If you want a notebook to accept drags from other widgets,
   * you will have to set your own DnD code to do it.
   * 
   * @newin{2,10}
   * 
   * @param child A child Gtk::Widget.
   * @param detachable Whether the tab is detachable or not.
   */
  void set_tab_detachable(Widget& child, bool detachable =  true);

  
  /** Gets one of the action widgets. See set_action_widget().
   * 
   * @newin{2,20}
   * 
   * @param pack_type Pack type of the action widget to receive.
   * @return The action widget with the given @a pack_type
   * or <tt>0</tt> when this action widget has not been set.
   */
  Widget* get_action_widget(PackType pack_type =  PACK_START);
  
  /** Sets @a widget as one of the action widgets. Depending on the pack type
   * the widget will be placed before or after the tabs. You can use
   * a Gtk::Box if you need to pack more than one widget on the same side.
   * 
   * Note that action widgets are “internal” children of the notebook and thus
   * not included in the list returned from Gtk::Container::foreach().
   * 
   * @newin{2,20}
   * 
   * @param widget A Gtk::Widget.
   * @param pack_type Pack type of the action widget.
   */
  void set_action_widget(Widget* widget, PackType pack_type =  PACK_START);

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%switch_page(Widget* page, guint page_num)</tt>
   *
   * Emitted when the user or a function changes the current page.
   * 
   * @param page The new current page.
   * @param page_num The index of the page.
   */

  Glib::SignalProxy2< void,Widget*,guint > signal_switch_page();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%page_reordered(Widget* page, guint page_num)</tt>
   *
   * the signal_page_reordered() signal is emitted in the notebook
   * right after a page has been reordered.
   * 
   * @newin{2,10}
   * 
   * @param child The child Gtk::Widget affected.
   * @param page_num The new page number for @a child.
   */

  Glib::SignalProxy2< void,Widget*,guint > signal_page_reordered();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%page_removed(Widget* page, guint page_num)</tt>
   *
   * the signal_page_removed() signal is emitted in the notebook
   * right after a page is removed from the notebook.
   * 
   * @newin{2,10}
   * 
   * @param child The child Gtk::Widget affected.
   * @param page_num The @a child page number.
   */

  Glib::SignalProxy2< void,Widget*,guint > signal_page_removed();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%page_added(Widget* page, guint page_num)</tt>
   *
   * the signal_page_added() signal is emitted in the notebook
   * right after a page is added to the notebook.
   * 
   * @newin{2,10}
   * 
   * @param child The child Gtk::Widget affected.
   * @param page_num The new page number for @a child.
   */

  Glib::SignalProxy2< void,Widget*,guint > signal_page_added();


  //Key-binding signals:
  
  
  //This doesn't seem generally useful:
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Which side of the notebook holds the tabs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< PositionType > property_tab_pos() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Which side of the notebook holds the tabs.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PositionType > property_tab_pos() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether tabs should be shown.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_tabs() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether tabs should be shown.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_tabs() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the border should be shown.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_border() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the border should be shown.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_border() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE, scroll arrows are added if there are too many tabs to fit.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_scrollable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE, scroll arrows are added if there are too many tabs to fit.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_scrollable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The index of the current page.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_page() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The index of the current page.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_page() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Group name for tab drag and drop.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_group_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Group name for tab drag and drop.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_group_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE, pressing the right mouse button on the notebook pops up a menu that you can use to go to a page.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_enable_popup() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If TRUE, pressing the right mouse button on the notebook pops up a menu that you can use to go to a page.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_enable_popup() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /** The string displayed on the child's tab label.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< Glib::ustring > child_property_tab_label(Gtk::Widget& child) ;

/** The string displayed on the child's tab label.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< Glib::ustring > child_property_tab_label(const Gtk::Widget& child) const;

  /** The string displayed in the child's menu entry.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< Glib::ustring > child_property_menu_label(Gtk::Widget& child) ;

/** The string displayed in the child's menu entry.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< Glib::ustring > child_property_menu_label(const Gtk::Widget& child) const;

  /** The index of the child in the parent.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< int > child_property_position(Gtk::Widget& child) ;

/** The index of the child in the parent.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< int > child_property_position(const Gtk::Widget& child) const;

  /** Whether to expand the child's tab.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< bool > child_property_tab_expand(Gtk::Widget& child) ;

/** Whether to expand the child's tab.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< bool > child_property_tab_expand(const Gtk::Widget& child) const;

  /** Whether the child's tab should fill the allocated area.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< bool > child_property_tab_fill(Gtk::Widget& child) ;

/** Whether the child's tab should fill the allocated area.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< bool > child_property_tab_fill(const Gtk::Widget& child) const;

  /** Whether the tab is reorderable by user action.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< bool > child_property_reorderable(Gtk::Widget& child) ;

/** Whether the tab is reorderable by user action.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< bool > child_property_reorderable(const Gtk::Widget& child) const;

  /** Whether the tab is detachable.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< bool > child_property_detachable(Gtk::Widget& child) ;

/** Whether the tab is detachable.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< bool > child_property_detachable(const Gtk::Widget& child) const;


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS


#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Notebook
   */
  Gtk::Notebook* wrap(GtkNotebook* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_NOTEBOOK_H */

