// -*- c++ -*-
// Generated by gmmproc 2.43.1 -- DO NOT MODIFY!
#ifndef _GTKMM_HEADERBAR_H
#define _GTKMM_HEADERBAR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2013 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/container.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkHeaderBar GtkHeaderBar;
typedef struct _GtkHeaderBarClass GtkHeaderBarClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class HeaderBar_Class; } // namespace Gtk
namespace Gtk
{

/** A box with a centered child.
 *
 * Gtk::HeaderBar is similar to a horizontal Gtk::Box, it allows
 * to place children at the start or the end. In addition,
 * it allows a title to be displayed. The title will be
 * centered with respect to the width of the box, even if the children
 * at either side take up different amounts of space.
 *
 * @ingroup Containers
 * @newin{3,10}
 */

class HeaderBar
  : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef HeaderBar CppObjectType;
  typedef HeaderBar_Class CppClassType;
  typedef GtkHeaderBar BaseObjectType;
  typedef GtkHeaderBarClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~HeaderBar();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class HeaderBar_Class;
  static CppClassType headerbar_class_;

  // noncopyable
  HeaderBar(const HeaderBar&);
  HeaderBar& operator=(const HeaderBar&);

protected:
  explicit HeaderBar(const Glib::ConstructParams& construct_params);
  explicit HeaderBar(GtkHeaderBar* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkHeaderBar*       gobj()       { return reinterpret_cast<GtkHeaderBar*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkHeaderBar* gobj() const { return reinterpret_cast<GtkHeaderBar*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:

  /** Create a new HeaderBar widget.
   */
  HeaderBar();


  /** Sets the title of the Gtk::HeaderBar. The title should help a user
   * identify the current view. A good title should not include the
   * application name.
   * 
   * @newin{3,10}
   * 
   * @param title A title, or <tt>0</tt>.
   */
  void set_title(const Glib::ustring& title);
  
  /** Retrieves the title of the header. See set_title().
   * 
   * @newin{3,10}
   * 
   * @return The title of the header, or <tt>0</tt> if none has
   * been set explicitly. The returned string is owned by the widget
   * and must not be modified or freed.
   */
  Glib::ustring get_title() const;

  
  /** Sets the subtitle of the Gtk::HeaderBar. The title should give a user
   * an additional detail to help him identify the current view.
   * 
   * Note that GtkHeaderBar by default reserves room for the subtitle,
   * even if none is currently set. If this is not desired, set the
   * Gtk::HeaderBar::property_has_subtitle() property to <tt>false</tt>.
   * 
   * @newin{3,10}
   * 
   * @param subtitle A subtitle, or <tt>0</tt>.
   */
  void set_subtitle(const Glib::ustring& subtitle);
  
  /** Retrieves the subtitle of the header. See set_subtitle().
   * 
   * @newin{3,10}
   * 
   * @return The subtitle of the header, or <tt>0</tt> if none has
   * been set explicitly. The returned string is owned by the widget
   * and must not be modified or freed.
   */
  Glib::ustring get_subtitle() const;

  
  /** Sets whether the header bar should reserve space
   * for a subtitle, even if none is currently set.
   * 
   * @newin{3,12}
   * 
   * @param setting <tt>true</tt> to reserve space for a subtitle.
   */
  void set_has_subtitle(bool setting =  true);
  
  /** Retrieves whether the header bar reserves space for
   * a subtitle, regardless if one is currently set or not.
   * 
   * @newin{3,12}
   * 
   * @return <tt>true</tt> if the header bar reserves space
   * for a subtitle.
   */
  bool get_has_subtitle() const;

  
  /** Sets a custom title for the Gtk::HeaderBar.
   * 
   * The title should help a user identify the current view. This
   * supersedes any title set by set_title() or
   * set_subtitle(). To achieve the same style as
   * the builtin title and subtitle, use the “title” and “subtitle”
   * style classes.
   * 
   * You should set the custom title to <tt>0</tt>, for the header title
   * label to be visible again.
   * 
   * @newin{3,10}
   * 
   * @param title_widget A custom widget to use for a title.
   */
  void set_custom_title(Gtk::Widget& title_widget);
  
  /** Retrieves the custom title widget of the header. See
   * set_custom_title().
   * 
   * @newin{3,10}
   * 
   * @return The custom title widget
   * of the header, or <tt>0</tt> if none has been set explicitly.
   */
  Widget* get_custom_title();
  
  /** Retrieves the custom title widget of the header. See
   * set_custom_title().
   * 
   * @newin{3,10}
   * 
   * @return The custom title widget
   * of the header, or <tt>0</tt> if none has been set explicitly.
   */
  const Widget* get_custom_title() const;

  
  /** Adds @a child to @a bar, packed with reference to the
   * start of the @a bar.
   * 
   * @newin{3,10}
   * 
   * @param child The Gtk::Widget to be added to @a bar.
   */
  void pack_start(Gtk::Widget& child);
  
  /** Adds @a child to @a bar, packed with reference to the
   * end of the @a bar.
   * 
   * @newin{3,10}
   * 
   * @param child The Gtk::Widget to be added to @a bar.
   */
  void pack_end(Gtk::Widget& child);

  
  /** Sets whether this header bar shows the standard window decorations,
   * including close, maximize, and minimize.
   * 
   * @newin{3,10}
   * 
   * @param setting <tt>true</tt> to show standard widow decorations.
   */
  void set_show_close_button(bool setting =  true);
  
  /** Returns whether this header bar shows the standard window
   * decorations.
   * 
   * @newin{3,10}
   * 
   * @return <tt>true</tt> if the decorations are shown.
   */
  bool get_show_close_button() const;

  
  /** Sets the decoration layout for this header bar, overriding
   * the Gtk::Settings::property_gtk_decoration_layout() setting. 
   * 
   * There can be valid reasons for overriding the setting, such
   * as a header bar design that does not allow for buttons to take
   * room on the right, or only offers room for a single close button.
   * Split header bars are another example for overriding the
   * setting.
   * 
   * The format of the string is button names, separated by commas.
   * A colon separates the buttons that should appear on the left
   * from those on the right. Recognized button names are minimize,
   * maximize, close, icon (the window icon) and menu (a menu button
   * for the fallback app menu).
   * 
   * For example, “menu:minimize,maximize,close” specifies a menu
   * on the left, and minimize, maximize and close buttons on the right.
   * 
   * @newin{3,12}
   * 
   * @param layout A decoration layout, or <tt>0</tt> to
   * unset the layout.
   */
  void set_decoration_layout(const Glib::ustring& layout);
  
  /** Unset the decoration layout.
   * See set_decoration_layout().
   */
  void unset_decoration_layout();

  
  /** Gets the decoration layout set with
   * set_decoration_layout().
   * 
   * @newin{3,12}
   * 
   * @return The decoration layout.
   */
  Glib::ustring get_decoration_layout() const;


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Custom title widget to display.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gtk::Widget* > property_custom_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Custom title widget to display.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gtk::Widget* > property_custom_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to show window decorations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_show_close_button() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to show window decorations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_show_close_button() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The amount of space between children.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< int > property_spacing() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The amount of space between children.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_spacing() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The subtitle to display.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_subtitle() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The subtitle to display.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_subtitle() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The title to display.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The title to display.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The layout for window decorations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_decoration_layout() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The layout for window decorations.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_decoration_layout() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the decoration-layout property has been set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_decoration_layout_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the decoration-layout property has been set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_decoration_layout_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to reserve space for a subtitle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_subtitle() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to reserve space for a subtitle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_subtitle() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /** A GtkPackType indicating whether the child is packed with reference to the start or end of the parent.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< PackType > child_property_pack_type(Gtk::Widget& child) ;

/** A GtkPackType indicating whether the child is packed with reference to the start or end of the parent.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< PackType > child_property_pack_type(const Gtk::Widget& child) const;

  /** The index of the child in the parent.
   *
   * @return A ChildPropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy< int > child_property_position(Gtk::Widget& child) ;

/** The index of the child in the parent.
   *
   * @return A ChildPropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Gtk::ChildPropertyProxy_ReadOnly< int > child_property_position(const Gtk::Widget& child) const;


  // Gtk::HeaderBar has no signals nor vfuncs as of 3.12.


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::HeaderBar
   */
  Gtk::HeaderBar* wrap(GtkHeaderBar* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_HEADERBAR_H */

