// -*- c++ -*-
// Generated by gmmproc 2.41.0 -- DO NOT MODIFY!
#ifndef _GTKMM_ABOUTDIALOG_H
#define _GTKMM_ABOUTDIALOG_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2004 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <vector>

#include <gtkmm/dialog.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkAboutDialog GtkAboutDialog;
typedef struct _GtkAboutDialogClass GtkAboutDialogClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class AboutDialog_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 *  @var License LICENSE_UNKNOWN
 *  No license specified.
 * 
 *  @var License LICENSE_CUSTOM
 *  A license text is going to be specified by the developer.
 * 
 *  @var License LICENSE_GPL_2_0
 *  The GNU General Public License, version 2.0 or later.
 * 
 *  @var License LICENSE_GPL_3_0
 *  The GNU General Public License, version 3.0 or later.
 * 
 *  @var License LICENSE_LGPL_2_1
 *  The GNU Lesser General Public License, version 2.1 or later.
 * 
 *  @var License LICENSE_LGPL_3_0
 *  The GNU Lesser General Public License, version 3.0 or later.
 * 
 *  @var License LICENSE_BSD
 *  The BSD standard license.
 * 
 *  @var License LICENSE_MIT_X11
 *  The MIT/X11 standard license.
 * 
 *  @var License LICENSE_ARTISTIC
 *  The Artistic License, version 2.0.
 * 
 *  @var License LICENSE_GPL_2_0_ONLY
 *  The GNU General Public License, version 2.0 only. Since 3.12.
 * 
 *  @var License LICENSE_GPL_3_0_ONLY
 *  The GNU General Public License, version 3.0 only. Since 3.12.
 * 
 *  @var License LICENSE_LGPL_2_1_ONLY
 *  The GNU Lesser General Public License, version 2.1 only. Since 3.12.
 * 
 *  @var License LICENSE_LGPL_3_0_ONLY
 *  The GNU Lesser General Public License, version 3.0 only. Since 3.12.
 * 
 *  @enum License
 * 
 * The type of license for an application.
 * 
 * This enumeration can be expanded at later date.
 * 
 * @newin{3,0}
 * @ingroup gtkmmEnums
 */
enum License
{
  LICENSE_UNKNOWN,
  LICENSE_CUSTOM,
  LICENSE_GPL_2_0,
  LICENSE_GPL_3_0,
  LICENSE_LGPL_2_1,
  LICENSE_LGPL_3_0,
  LICENSE_BSD,
  LICENSE_MIT_X11,
  LICENSE_ARTISTIC,
  LICENSE_GPL_2_0_ONLY,
  LICENSE_GPL_3_0_ONLY,
  LICENSE_LGPL_2_1_ONLY,
  LICENSE_LGPL_3_0_ONLY
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::License> : public Glib::Value_Enum<Gtk::License>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** The AboutDialog offers a simple way to display information about a program like its logo, name, copyright,
 * website and license. It is also possible to give credits to the authors, documenters, translators and artists
 * who have worked on the program. An about dialog is typically opened when the user selects the About option
 * from the Help menu. All parts of the dialog are optional.
 *
 * About dialogs often contain links and email addresses. Gtk::AboutDialog displays these as clickable links.
 * By default, it calls gtk_show_uri() when a user clicks one. The behaviour can be overridden with the activate_link signal.
 * Email addresses in the authors, documenters and artists properties are recognized by looking
 * for \<user\@host\>, URLs are recognized by looking for http://url, with the URL extending to the next space,
 * tab or line break.
 *
 * An AboutDialog looks like this:
 * @image html aboutdialog1.png
 *
 * @ingroup Dialogs
 */

class AboutDialog : public Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AboutDialog CppObjectType;
  typedef AboutDialog_Class CppClassType;
  typedef GtkAboutDialog BaseObjectType;
  typedef GtkAboutDialogClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~AboutDialog();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class AboutDialog_Class;
  static CppClassType aboutdialog_class_;

  // noncopyable
  AboutDialog(const AboutDialog&);
  AboutDialog& operator=(const AboutDialog&);

protected:
  explicit AboutDialog(const Glib::ConstructParams& construct_params);
  explicit AboutDialog(GtkAboutDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkAboutDialog*       gobj()       { return reinterpret_cast<GtkAboutDialog*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkAboutDialog* gobj() const { return reinterpret_cast<GtkAboutDialog*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_activate_link().
  virtual bool on_activate_link(const std::string& uri);


private:

  
public:
  AboutDialog();

   //deprecated
  
  /** Returns the program name displayed in the about dialog.
   * 
   * @newin{2,12}
   * 
   * @return The program name.
   */
  Glib::ustring get_program_name() const;
  
  /** Sets the name to display in the about dialog.
   * If this is not set, it defaults to Glib::get_application_name().
   * 
   * @newin{2,12}
   * 
   * @param name The program name.
   */
  void set_program_name(const Glib::ustring& name);

  
  /** Returns the version string.
   * 
   * @newin{2,6}
   * 
   * @return The version string. The string is owned by the about
   * dialog and must not be modified.
   */
  Glib::ustring get_version() const;
  
  /** Sets the version string to display in the about dialog.
   * 
   * @newin{2,6}
   * 
   * @param version The version string.
   */
  void set_version(const Glib::ustring& version);
  
  /** Returns the copyright string.
   * 
   * @newin{2,6}
   * 
   * @return The copyright string. The string is owned by the about
   * dialog and must not be modified.
   */
  Glib::ustring get_copyright() const;
  
  /** Sets the copyright string to display in the about dialog.
   * This should be a short string of one or two lines.
   * 
   * @newin{2,6}
   * 
   * @param copyright The copyright string.
   */
  void set_copyright(const Glib::ustring& copyright);
  
  /** Returns the comments string.
   * 
   * @newin{2,6}
   * 
   * @return The comments. The string is owned by the about
   * dialog and must not be modified.
   */
  Glib::ustring get_comments() const;
  
  /** Sets the comments string to display in the about dialog.
   * This should be a short string of one or two lines.
   * 
   * @newin{2,6}
   * 
   * @param comments A comments string.
   */
  void set_comments(const Glib::ustring& comments);
  
  /** Returns the license information.
   * 
   * @newin{2,6}
   * 
   * @return The license information. The string is owned by the about
   * dialog and must not be modified.
   */
  Glib::ustring get_license() const;
  
  /** Sets the license information to be displayed in the secondary
   * license dialog. If @a license is <tt>0</tt>, the license button is
   * hidden.
   * 
   * @newin{2,6}
   * 
   * @param license The license information or <tt>0</tt>.
   */
  void set_license(const Glib::ustring& license);

  /** Hides the license button.
   *
   * @newin{3,4}
   */
  void unset_license();
  
  /** Retrieves the license set using set_license_type()
   * 
   * @newin{3,0}
   * 
   * @return A Gtk::License value.
   */
  License get_license_type() const;
  
  /** Sets the license of the application showing the @a about dialog from a
   * list of known licenses.
   * 
   * This function overrides the license set using
   * set_license().
   * 
   * @newin{3,0}
   * 
   * @param license_type The type of license.
   */
  void set_license_type(License license_type);
  
  /** Returns the website URL.
   * 
   * @newin{2,6}
   * 
   * @return The website URL. The string is owned by the about
   * dialog and must not be modified.
   */
  Glib::ustring get_website() const;
  
  /** Sets the URL to use for the website link.
   * 
   * @newin{2,6}
   * 
   * @param website A URL string starting with "http://".
   */
  void set_website(const Glib::ustring& website);
  
  /** Returns the label used for the website link.
   * 
   * @newin{2,6}
   * 
   * @return The label used for the website link.
   */
  Glib::ustring get_website_label() const;
  
  /** Sets the label to be used for the website link.
   * 
   * @newin{2,6}
   * 
   * @param website_label The label used for the website link.
   */
  void set_website_label(const Glib::ustring& website_label);

 
  /** Returns the string which are displayed in the authors tab
   * of the secondary credits dialog.
   * 
   * @newin{2,6}
   * 
   * @return A
   * <tt>0</tt>-terminated string array containing the authors. The array is
   * owned by the about dialog and must not be modified.
   */
  std::vector<Glib::ustring> get_authors() const;

 
  /** Sets the strings which are displayed in the authors tab
   * of the secondary credits dialog.
   * 
   * @newin{2,6}
   * 
   * @param authors A <tt>0</tt>-terminated array of strings.
   */
  void set_authors(const std::vector<Glib::ustring>& authors) const;

  
  /** Returns the string which are displayed in the documenters
   * tab of the secondary credits dialog.
   * 
   * @newin{2,6}
   * 
   * @return A
   * <tt>0</tt>-terminated string array containing the documenters. The
   * array is owned by the about dialog and must not be modified.
   */
  std::vector<Glib::ustring> get_documenters() const;

  
  /** Sets the strings which are displayed in the documenters tab
   * of the secondary credits dialog.
   * 
   * @newin{2,6}
   * 
   * @param documenters A <tt>0</tt>-terminated array of strings.
   */
  void set_documenters(const std::vector<Glib::ustring>& documenters);
  
  /** Returns the string which are displayed in the artists tab
   * of the secondary credits dialog.
   * 
   * @newin{2,6}
   * 
   * @return A
   * <tt>0</tt>-terminated string array containing the artists. The array is
   * owned by the about dialog and must not be modified.
   */
  std::vector<Glib::ustring> get_artists() const;
  
  /** Sets the strings which are displayed in the artists tab
   * of the secondary credits dialog.
   * 
   * @newin{2,6}
   * 
   * @param artists A <tt>0</tt>-terminated array of strings.
   */
  void set_artists(const std::vector<Glib::ustring>& artists);
  
  /** Returns the translator credits string which is displayed
   * in the translators tab of the secondary credits dialog.
   * 
   * @newin{2,6}
   * 
   * @return The translator credits string. The string is
   * owned by the about dialog and must not be modified.
   */
  Glib::ustring get_translator_credits() const;
  
  /** Sets the translator credits string which is displayed in
   * the translators tab of the secondary credits dialog.
   * 
   * The intended use for this string is to display the translator
   * of the language which is currently used in the user interface.
   * Using gettext(), a simple way to achieve that is to mark the
   * string for translation:
   * 
   * [C example ellipted]
   * It is a good idea to use the customary msgid “translator-credits” for this
   * purpose, since translators will already know the purpose of that msgid, and
   * since Gtk::AboutDialog will detect if “translator-credits” is untranslated
   * and hide the tab.
   * 
   * @newin{2,6}
   * 
   * @param translator_credits The translator credits.
   */
  void set_translator_credits(const Glib::ustring& translator_credits);

  
  /** Returns the pixbuf displayed as logo in the about dialog.
   * 
   * @newin{2,6}
   * 
   * @return The pixbuf displayed as logo. The
   * pixbuf is owned by the about dialog. If you want to keep a
   * reference to it, you have to call Glib::object_ref() on it.
   */
  Glib::RefPtr<Gdk::Pixbuf> get_logo();
  
  /** Returns the pixbuf displayed as logo in the about dialog.
   * 
   * @newin{2,6}
   * 
   * @return The pixbuf displayed as logo. The
   * pixbuf is owned by the about dialog. If you want to keep a
   * reference to it, you have to call Glib::object_ref() on it.
   */
  Glib::RefPtr<const Gdk::Pixbuf> get_logo() const;

  
  /** Sets the pixbuf to be displayed as logo in the about dialog.
   * If it is <tt>0</tt>, the default window icon set with
   * Gtk::Window::set_default_icon() will be used.
   * 
   * @newin{2,6}
   * 
   * @param logo A Gdk::Pixbuf, or <tt>0</tt>.
   */
  void set_logo(const Glib::RefPtr<Gdk::Pixbuf>& logo);

  /** Sets the pixbuf to be displayed as logo in the about dialog.
   * The logo is set to the default window icon set with
   * Gtk::Window::set_default_icon() or Gtk::Window::set_default_icon_list().
   *
   * @newin{3,4}
   */
  void set_logo_default();

  
  /** Returns the icon name displayed as logo in the about dialog.
   * 
   * @newin{2,6}
   * 
   * @return The icon name displayed as logo. The string is
   * owned by the dialog. If you want to keep a reference
   * to it, you have to call Glib::strdup() on it.
   */
  Glib::ustring get_logo_icon_name() const;
  
  /** Sets the pixbuf to be displayed as logo in the about dialog.
   * If it is <tt>0</tt>, the default window icon set with
   * Gtk::Window::set_default_icon() will be used.
   * 
   * @newin{2,6}
   * 
   * @param icon_name An icon name, or <tt>0</tt>.
   */
  void set_logo_icon_name(const Glib::ustring& icon_name);

  
  /** Returns whether the license text in @a about is
   * automatically wrapped.
   * 
   * @newin{2,8}
   * 
   * @return <tt>true</tt> if the license text is wrapped.
   */
  bool get_wrap_license() const;
  
  /** Sets whether the license text in @a about is
   * automatically wrapped.
   * 
   * @newin{2,8}
   * 
   * @param wrap_license Whether to wrap the license.
   */
  void set_wrap_license(bool wrap_license);

  
  /** Creates a new section in the Credits page.
   * 
   * @newin{3,4}
   * 
   * @param section_name The name of the section.
   * @param people The people who belong to that section.
   */
  void add_credit_section(const Glib::ustring& section_name, const std::vector<Glib::ustring>& people);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the program. If this is not set, it defaults to g_get_application_name().
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_program_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the program. If this is not set, it defaults to g_get_application_name().
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_program_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The version of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_version() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The version of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_version() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Copyright information for the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_copyright() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Copyright information for the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_copyright() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Comments about the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_comments() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Comments about the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_comments() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The URL for the link to the website of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_website() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The URL for the link to the website of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_website() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The label for the link to the website of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_website_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The label for the link to the website of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_website_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The license of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_license() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The license of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_license() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The license type of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< License > property_license_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The license type of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< License > property_license_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** List of authors of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< std::vector<Glib::ustring> > property_authors() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** List of authors of the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::vector<Glib::ustring> > property_authors() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** List of people documenting the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< std::vector<Glib::ustring> > property_documenters() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** List of people documenting the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::vector<Glib::ustring> > property_documenters() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Credits to the translators. This string should be marked as translatable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< std::vector<Glib::ustring> > property_translator_credits() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Credits to the translators. This string should be marked as translatable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::vector<Glib::ustring> > property_translator_credits() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** List of people who have contributed artwork to the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< std::vector<Glib::ustring> > property_artists() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** List of people who have contributed artwork to the program.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< std::vector<Glib::ustring> > property_artists() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A logo for the about box. If this is not set, it defaults to gtk_window_get_default_icon_list().
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_logo() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A logo for the about box. If this is not set, it defaults to gtk_window_get_default_icon_list().
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> > property_logo() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A named icon to use as the logo for the about box.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_logo_icon_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A named icon to use as the logo for the about box.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_logo_icon_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to wrap the license text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_wrap_license() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to wrap the license text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_wrap_license() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /**
   * @par Slot Prototype:
   * <tt>bool on_my_%activate_link(const std::string& uri)</tt>
   *
   * The signal which gets emitted to activate a URI.
   * Applications may connect to it to override the default behaviour,
   * which is to call gtk_show_uri().
   * 
   * @newin{2,24}
   * 
   * @param uri The URI that is activated.
   * @return <tt>true</tt> if the link has been activated.
   */

  Glib::SignalProxy1< bool,const std::string& > signal_activate_link();


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::AboutDialog
   */
  Gtk::AboutDialog* wrap(GtkAboutDialog* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_ABOUTDIALOG_H */

