// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ENTRY_H
#define _GTKMM_ENTRY_H


#include <glibmm.h>

/* $Id: entry.hg,v 1.12 2006/06/13 17:16:26 murrayc Exp $ */

/* entry.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtkmm/editable.h>
#include <gtkmm/menu.h>
#include <gtkmm/celleditable.h>
#include <gtkmm/entrycompletion.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/image.h> //For ImageType.
#include <gtkmm/border.h>
#include <gtkmm/entrybuffer.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkEntry GtkEntry;
typedef struct _GtkEntryClass GtkEntryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Entry_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum EntryIconPosition
{
  ENTRY_ICON_PRIMARY,
  ENTRY_ICON_SECONDARY
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::EntryIconPosition> : public Glib::Value_Enum<Gtk::EntryIconPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** A single line text entry field.
 *
 * The Gtk::Entry widget is a single line text entry widget. A fairly large
 * set of key bindings are supported by default. If the entered text is
 * longer than the allocation of the widget, the widget will scroll so that
 * the cursor position is visible. 
 *
 * The Entry widget looks like this:
 * @image html entry1.png
 *
 * @ingroup Widgets
 */

class Entry
: public Widget,
  public Editable,
  public CellEditable
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Entry CppObjectType;
  typedef Entry_Class CppClassType;
  typedef GtkEntry BaseObjectType;
  typedef GtkEntryClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Entry();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Entry_Class;
  static CppClassType entry_class_;

  // noncopyable
  Entry(const Entry&);
  Entry& operator=(const Entry&);

protected:
  explicit Entry(const Glib::ConstructParams& construct_params);
  explicit Entry(GtkEntry* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkEntry*       gobj()       { return reinterpret_cast<GtkEntry*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkEntry* gobj() const { return reinterpret_cast<GtkEntry*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_populate_popup(Menu* menu);
  virtual void on_insert_at_cursor(const Glib::ustring& str);
  virtual void on_activate();


private:

  
public:

  Entry();
  explicit Entry(const Glib::RefPtr<EntryBuffer>& buffer);

  
  /** Get the Gtk::EntryBuffer object which holds the text for
   * this widget.
   * 
   * @newin{2,18}
   * @return A Gtk::EntryBuffer object.
   */
  Glib::RefPtr<EntryBuffer> get_buffer();
  
  /** Get the Gtk::EntryBuffer object which holds the text for
   * this widget.
   * 
   * @newin{2,18}
   * @return A Gtk::EntryBuffer object.
   */
  Glib::RefPtr<const EntryBuffer> get_buffer() const;

  
  /** Set the Gtk::EntryBuffer object which holds the text for
   * this widget.
   * 
   * @newin{2,18}
   * @param buffer A Gtk::EntryBuffer.
   */
  void set_buffer(const Glib::RefPtr<EntryBuffer>& buffer);

  
  /** Returns the Gdk::Window which contains the text. This function is
   * useful when drawing something to the entry in an expose-event
   * callback because it enables the callback to distinguish between
   * the text window and entry's icon windows.
   * 
   * See also get_icon_window().
   * 
   * @newin{2,20}
   * @return The entry's text window.
   */
  Glib::RefPtr<Gdk::Window> get_text_window();
  
  /** Returns the Gdk::Window which contains the text. This function is
   * useful when drawing something to the entry in an expose-event
   * callback because it enables the callback to distinguish between
   * the text window and entry's icon windows.
   * 
   * See also get_icon_window().
   * 
   * @newin{2,20}
   * @return The entry's text window.
   */
  Glib::RefPtr<const Gdk::Window> get_text_window() const;
  
  /** Sets whether the contents of the entry are visible or not. 
   * When visibility is set to <tt>false</tt>, characters are displayed 
   * as the invisible char, and will also appear that way when 
   * the text in the entry widget is copied elsewhere.
   * 
   * By default, GTK+ picks the best invisible character available
   * in the current font, but it can be changed with
   * set_invisible_char().
   * @param visible <tt>true</tt> if the contents of the entry are displayed
   * as plaintext.
   */
  void set_visibility(bool visible = true);
  
  /** Retrieves whether the text in @a entry is visible. See
   * set_visibility().
   * @return <tt>true</tt> if the text is currently visible.
   */
  bool get_visibility() const;
  
  /** Sets the character to use in place of the actual text when
   * set_visibility() has been called to set text visibility
   * to <tt>false</tt>. i.e. this is the character used in "password mode" to
   * show the user how many characters have been typed. By default, GTK+
   * picks the best invisible char available in the current font. If you
   * set the invisible char to 0, then the user will get no feedback
   * at all; there will be no text on the screen as they type.
   * @param ch A Unicode character.
   */
  void set_invisible_char(gunichar ch);
  
  /** Unsets the invisible char previously set with
   * set_invisible_char(). So that the
   * default invisible char is used again.
   * 
   * @newin{2,16}
   */
  void unset_invisible_char();
  
  /** Retrieves the character displayed in place of the real characters
   * for entries with visibility set to false. See set_invisible_char().
   * @return The current invisible char, or 0, if the entry does not
   * show invisible text at all.
   */
  gunichar get_invisible_char() const;
  
  /** Sets whether the entry has a beveled frame around it.
   * @param setting New value.
   */
  void set_has_frame(bool setting = true);
  
  /** Gets the value set by set_has_frame().
   * @return Whether the entry has a beveled frame.
   */
  bool get_has_frame() const;

  
  /** Sets %entry's inner-border property to %border, or clears it if <tt>0</tt>
   * is passed. The inner-border is the area around the entry's text, but
   * inside its frame.
   * 
   * If set, this property overrides the inner-border style property.
   * Overriding the style-provided border is useful when you want to do
   * in-place editing of some text in a canvas or list widget, where
   * pixel-exact positioning of the entry is important.
   * 
   * @newin{2,10}
   * @param border A Gtk::Border, or <tt>0</tt>.
   */
  void set_inner_border(const Border& border);
  
  /** This function returns the entry's Gtk::Entry:inner-border property. See
   * set_inner_border() for more information.
   * 
   * @newin{2,10}
   * @return The entry's Gtk::Border, or <tt>0</tt> if none was set.
   */
  Border get_inner_border() const;

  
  /** Sets whether the text is overwritten when typing in the Gtk::Entry.
   * 
   * @newin{2,14}
   * @param overwrite New value.
   */
  void set_overwrite_mode(bool overwrite = true);
  
  /** Gets the value set by set_overwrite_mode().
   * 
   * @newin{2,14}
   * @return Whether the text is overwritten when typing.
   */
  bool get_overwrite_mode() const;
  
  /** Sets the maximum allowed length of the contents of the widget. If
   * the current contents are longer than the given length, then they
   * will be truncated to fit.
   * 
   * This is equivalent to:
   * 
   * <informalexample><programlisting>
   * gtk_entry_buffer_set_max_length (gtk_entry_get_buffer (entry), max);
   * </programlisting></informalexample>
   * @param max The maximum length of the entry, or 0 for no maximum.
   * (other than the maximum length of entries.) The value passed in will
   * be clamped to the range 0-65536.
   */
  void set_max_length(int max);
  
  /** Retrieves the maximum allowed length of the text in
   *  @a entry. See set_max_length().
   * 
   * This is equivalent to:
   * 
   * <informalexample><programlisting>
   * gtk_entry_buffer_get_max_length (gtk_entry_get_buffer (entry));
   * </programlisting></informalexample>
   * @return The maximum allowed number of characters
   * in Gtk::Entry, or 0 if there is no maximum.
   */
  int get_max_length() const;
  
  /** Retrieves the current length of the text in
   *  @a entry. 
   * 
   * This is equivalent to:
   * 
   * <informalexample><programlisting>
   * gtk_entry_buffer_get_length (gtk_entry_get_buffer (entry));
   * </programlisting></informalexample>
   * 
   * @newin{2,14}
   * @return The current number of characters
   * in Gtk::Entry, or 0 if there are none.
   */
  guint16 get_text_length() const;
  
  /** If @a setting is <tt>true</tt>, pressing Enter in the @a entry will activate the default
   * widget for the window containing the entry. This usually means that
   * the dialog box containing the entry will be closed, since the default
   * widget is usually one of the dialog buttons.
   * 
   * (For experts: if @a setting is <tt>true</tt>, the entry calls
   * Gtk::Window::activate_default() on the window containing the entry, in
   * the default handler for the Gtk::Widget::activate signal.)
   * @param setting <tt>true</tt> to activate window's default widget on Enter keypress.
   */
  void set_activates_default(bool setting = true);
  
  /** Retrieves the value set by set_activates_default().
   * @return <tt>true</tt> if the entry will activate the default widget.
   */
  gboolean get_activates_default() const;
  
  /** Changes the size request of the entry to be about the right size
   * for @a n_chars characters. Note that it changes the size
   * <emphasis>request</emphasis>, the size can still be affected by
   * how you pack the widget into containers. If @a n_chars is -1, the
   * size reverts to the default entry size.
   * @param n_chars Width in chars.
   */
  void set_width_chars(int n_chars);
  
  /** Gets the value set by set_width_chars().
   * @return Number of chars to request space for, or negative if unset.
   */
  int get_width_chars() const;
  
  /** Sets the text in the widget to the given
   * value, replacing the current contents.
   * 
   * See Gtk::EntryBuffer::set_text().
   * @param text The new text.
   */
  void set_text(const Glib::ustring &text);
  
  /** Retrieves the contents of the entry widget.
   * See also Gtk::Editable::get_chars().
   * @return The contents of the entry widget.
   */
  Glib::ustring get_text() const;
  
  /** Gets the Pango::Layout used to display the entry.
   * The layout is useful to e.g. convert text positions to
   * pixel positions, in combination with get_layout_offsets().
   * The returned layout is owned by the entry and must not be 
   * modified or freed by the caller.
   * 
   * Keep in mind that the layout text may contain a preedit string, so
   * layout_index_to_text_index() and
   * text_index_to_layout_index() are needed to convert byte
   * indices in the layout to byte indices in the entry contents.
   * @return The Pango::Layout for this entry.
   */
  Glib::RefPtr<Pango::Layout> get_layout();
  
  /** Gets the Pango::Layout used to display the entry.
   * The layout is useful to e.g. convert text positions to
   * pixel positions, in combination with get_layout_offsets().
   * The returned layout is owned by the entry and must not be 
   * modified or freed by the caller.
   * 
   * Keep in mind that the layout text may contain a preedit string, so
   * layout_index_to_text_index() and
   * text_index_to_layout_index() are needed to convert byte
   * indices in the layout to byte indices in the entry contents.
   * @return The Pango::Layout for this entry.
   */
  Glib::RefPtr<const Pango::Layout> get_layout() const;
  
  /** Obtains the position of the Pango::Layout used to render text
   * in the entry, in widget coordinates. Useful if you want to line
   * up the text in an entry with some other text, e.g. when using the
   * entry to implement editable cells in a sheet widget.
   * 
   * Also useful to convert mouse events into coordinates inside the
   * Pango::Layout, e.g. to take some action if some part of the entry text
   * is clicked.
   * 
   * Note that as the user scrolls around in the entry the offsets will
   * change; you'll need to connect to the "notify::scroll-offset"
   * signal to track this. Remember when using the Pango::Layout
   * functions you need to convert to and from pixels using
   * PANGO_PIXELS() or Pango::SCALE.
   * 
   * Keep in mind that the layout text may contain a preedit string, so
   * layout_index_to_text_index() and
   * text_index_to_layout_index() are needed to convert byte
   * indices in the layout to byte indices in the entry contents.
   * @param x Location to store X offset of layout, or <tt>0</tt>.
   * @param y Location to store Y offset of layout, or <tt>0</tt>.
   */
  void get_layout_offsets(int& x, int& y);

  
  /** Converts from a position in the entry contents (returned
   * by get_text()) to a position in the
   * entry's Pango::Layout (returned by get_layout(),
   * with text retrieved via pango_layout_get_text()).
   * @param layout_index Byte index into the entry layout text.
   * @return Byte index into the entry contents.
   */
  int layout_index_to_text_index(int layout_index) const;
  
  /** Converts from a position in the entry's Pango::Layout (returned by
   * get_layout()) to a position in the entry contents
   * (returned by get_text()).
   * @param text_index Byte index into the entry contents.
   * @return Byte index into the entry layout text.
   */
  int text_index_to_layout_index(int text_index) const;

  
  /** Hooks up an adjustment to the cursor position in an entry, so that when 
   * the cursor is moved, the adjustment is scrolled to show that position. 
   * See Gtk::ScrolledWindow::get_hadjustment() for a typical way of obtaining 
   * the adjustment.
   * 
   * The adjustment has to be in pixel units and in the same coordinate system 
   * as the entry. 
   * 
   * @newin{2,12}
   * @param adjustment An adjustment which should be adjusted when the cursor 
   * is moved, or <tt>0</tt>.
   */
  void set_cursor_hadjustment (Adjustment& adjustment);
  
  /** Retrieves the horizontal cursor adjustment for the entry. 
   * See set_cursor_hadjustment().
   * 
   * @newin{2,12}
   * @return The horizontal cursor adjustment, or <tt>0</tt>
   * if none has been set.
   */
  Adjustment* get_cursor_hadjustment();
  
  /** Retrieves the horizontal cursor adjustment for the entry. 
   * See set_cursor_hadjustment().
   * 
   * @newin{2,12}
   * @return The horizontal cursor adjustment, or <tt>0</tt>
   * if none has been set.
   */
  const Adjustment* get_cursor_hadjustment() const;

  
  /** Sets the alignment for the contents of the entry. This controls
   * the horizontal positioning of the contents when the displayed
   * text is shorter than the width of the entry.
   * 
   * @newin{2,4}
   * @param xalign The horizontal alignment, from 0 (left) to 1 (right).
   * Reversed for RTL layouts.
   */
  void set_alignment(float xalign);
  
  /** Sets the alignment for the contents of the entry. This controls
   * the horizontal positioning of the contents when the displayed
   * text is shorter than the width of the entry.
   * 
   * @newin{2,4}
   * @param xalign The horizontal alignment, from 0 (left) to 1 (right).
   * Reversed for RTL layouts.
   */
  void set_alignment(AlignmentEnum xalign); 
  
  /** Gets the value set by set_alignment().
   * 
   * @newin{2,4}
   * @return The alignment.
   */
  float get_alignment() const;

  
  /** Sets @a completion to be the auxiliary completion object to use with @a entry.
   * All further configuration of the completion mechanism is done on
   *  @a completion using the Gtk::EntryCompletion API. Completion is disabled if
   *  @a completion is set to <tt>0</tt>.
   * 
   * @newin{2,4}
   * @param completion The Gtk::EntryCompletion or <tt>0</tt>.
   */
  void set_completion(const Glib::RefPtr<EntryCompletion>& completion);
  
  /** Returns the auxiliary completion object currently in use by @a entry.
   * 
   * @newin{2,4}
   * @return The auxiliary completion object currently in use by @a entry.
   */
  Glib::RefPtr<EntryCompletion> get_completion();
  
  /** Returns the auxiliary completion object currently in use by @a entry.
   * 
   * @newin{2,4}
   * @return The auxiliary completion object currently in use by @a entry.
   */
  Glib::RefPtr<const EntryCompletion> get_completion() const;

  
  /** Causes the entry's progress indicator to "fill in" the given
   * fraction of the bar. The fraction should be between 0.0 and 1.0,
   * inclusive.
   * 
   * @newin{2,16}
   * @param fraction Fraction of the task that's been completed.
   */
  void set_progress_fraction(double fraction);
  
  /** Returns the current fraction of the task that's been completed.
   * See set_progress_fraction().
   * 
   * @newin{2,16}
   * @return A fraction from 0.0 to 1.0.
   */
  double get_progress_fraction() const;
  
  /** Sets the fraction of total entry width to move the progress
   * bouncing block for each call to progress_pulse().
   * 
   * @newin{2,16}
   * @param fraction Fraction between 0.0 and 1.0.
   */
  void set_progress_pulse_step(double fraction);
  
  /** Retrieves the pulse step set with set_progress_pulse_step().
   * 
   * @newin{2,16}
   * @return A fraction from 0.0 to 1.0.
   */
  double get_progress_pulse_step();
  
  /** Indicates that some progress is made, but you don't know how much.
   * Causes the entry's progress indicator to enter "activity mode,"
   * where a block bounces back and forth. Each call to
   * progress_pulse() causes the block to move by a little bit
   * (the amount of movement per pulse is determined by
   * set_progress_pulse_step()).
   * 
   * @newin{2,16}
   */
  void progress_pulse();


  /** Sets the icon shown in the specified position using a pixbuf.
   * 
   * If @a pixbuf is <tt>0</tt>, no icon will be shown in the specified position.
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @param pixbuf A Gdk::Pixbuf, or <tt>0</tt>.
   */

  void set_icon_from_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  
  
  /** Sets the icon shown in the entry at the specified position from
   * a stock image.
   * 
   * If @a stock_id is <tt>0</tt>, no icon will be shown in the specified position.
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @param stock_id The name of the stock item, or <tt>0</tt>.
   */

  void set_icon_from_stock(const StockID& stock_id, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  
  
  /** Sets the icon shown in the entry at the specified position
   * from the current icon theme.
   * 
   * If the icon name isn't known, a "broken image" icon will be displayed
   * instead.
   * 
   * If @a icon_name is <tt>0</tt>, no icon will be shown in the specified position.
   * 
   * @newin{2,16}
   * @param icon_pos The position at which to set the icon.
   * @param icon_name An icon name, or <tt>0</tt>.
   */

  void set_icon_from_icon_name(const Glib::ustring& icon_name, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  

  /** Sets the icon shown in the entry at the specified position
   * from the current icon theme.
   * If the icon isn't known, a "broken image" icon will be displayed
   * instead.
   * 
   * If @a icon is <tt>0</tt>, no icon will be shown in the specified position.
   * 
   * @newin{2,16}
   * @param icon_pos The position at which to set the icon.
   * @param icon The icon to set, or <tt>0</tt>.
   */

  void set_icon_from_gicon(const Glib::RefPtr<Gio::Icon>& icon, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  
    
  /** Gets the type of representation being used by the icon
   * to store image data. If the icon has no image data,
   * the return value will be Gtk::IMAGE_EMPTY.
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @return Image representation being used.
   */
  ImageType get_icon_storage_type(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY) const;
  
  /** Retrieves the image used for the icon.
   * 
   * Unlike the other methods of setting and getting icon data, this
   * method will work regardless of whether the icon was set using a
   * Gdk::Pixbuf, a Icon, a stock item, or an icon name.
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @return A Gdk::Pixbuf, or <tt>0</tt> if no icon is set for this position.
   */
  Glib::RefPtr<Gdk::Pixbuf> get_icon_pixbuf(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  
  /** Retrieves the image used for the icon.
   * 
   * Unlike the other methods of setting and getting icon data, this
   * method will work regardless of whether the icon was set using a
   * Gdk::Pixbuf, a Icon, a stock item, or an icon name.
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @return A Gdk::Pixbuf, or <tt>0</tt> if no icon is set for this position.
   */
  Glib::RefPtr<const Gdk::Pixbuf> get_icon_pixbuf(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY) const;
  
  /** Retrieves the stock id used for the icon, or <tt>0</tt> if there is
   * no icon or if the icon was set by some other method (e.g., by
   * pixbuf, icon name or gicon).
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @return A stock id, or <tt>0</tt> if no icon is set or if the icon
   * wasn't set from a stock id.
   */
  StockID get_icon_stock(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY) const;
  
  /** Retrieves the icon name used for the icon, or <tt>0</tt> if there is
   * no icon or if the icon was set by some other method (e.g., by
   * pixbuf, stock or gicon).
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @return An icon name, or <tt>0</tt> if no icon is set or if the icon
   * wasn't set from an icon name.
   */
  Glib::ustring get_icon_name(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY) const;
  
  /** Retrieves the Icon used for the icon, or <tt>0</tt> if there is
   * no icon or if the icon was set by some other method (e.g., by
   * stock, pixbuf, or icon name).
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @return A Icon, or <tt>0</tt> if no icon is set or if the icon
   * is not a Icon.
   */
  Glib::RefPtr<Gio::Icon> get_icon_gicon(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  
  /** Retrieves the Icon used for the icon, or <tt>0</tt> if there is
   * no icon or if the icon was set by some other method (e.g., by
   * stock, pixbuf, or icon name).
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @return A Icon, or <tt>0</tt> if no icon is set or if the icon
   * is not a Icon.
   */
  Glib::RefPtr<const Gio::Icon> get_icon_gicon(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY) const;

  
  /** Sets whether the icon is activatable.
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @param activatable <tt>true</tt> if the icon should be activatable.
   */

  void set_icon_activatable(bool activatable = true, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  

  /** Returns whether the icon is activatable.
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @return <tt>true</tt> if the icon is activatable.
   */
  bool get_icon_activatable(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY) const;
  
  /** Sets the sensitivity for the specified icon.
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @param sensitive Specifies whether the icon should appear
   * sensitive or insensitive.
   */
  void set_icon_sensitive(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY, bool sensitive = true);
  
  /** Returns whether the icon appears sensitive or insensitive.
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @return <tt>true</tt> if the icon is sensitive.
   */
  bool get_icon_sensitive(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  
  /** Finds the icon at the given position and return its index.
   * If @a x, @a y doesn't lie inside an icon, -1 is returned.
   * This function is intended for use in a Gtk::Widget::query-tooltip
   * signal handler.
   * 
   * @newin{2,16}
   * @param x The x coordinate of the position to find.
   * @param y The y coordinate of the position to find.
   * @return The index of the icon at the given position, or -1.
   */
  int get_icon_at_pos(int x, int y) const;
  
  
  /** Sets @a tooltip as the contents of the tooltip for the icon
   * at the specified position.
   * 
   * Use <tt>0</tt> for @a tooltip to remove an existing tooltip.
   * 
   * See also Gtk::Widget::set_tooltip_text() and 
   * set_icon_tooltip_markup().
   * 
   * @newin{2,16}
   * @param icon_pos The icon position.
   * @param tooltip The contents of the tooltip for the icon, or <tt>0</tt>.
   */

  void set_icon_tooltip_text(const Glib::ustring& tooltip, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
    
  
  /** Gets the contents of the tooltip on the icon at the specified 
   * position in @a entry.
   * 
   * @newin{2,16}
   * @param icon_pos The icon position.
   * @return The tooltip text, or <tt>0</tt>. Free the returned string
   * with Glib::free() when done.
   */
  Glib::ustring get_icon_tooltip_text(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY) const;
  
  
  /** Sets @a tooltip as the contents of the tooltip for the icon at
   * the specified position. @a tooltip is assumed to be marked up with
   * the <link linkend="PangoMarkupFormat">Pango text markup language</link>.
   * 
   * Use <tt>0</tt> for @a tooltip to remove an existing tooltip.
   * 
   * See also Gtk::Widget::set_tooltip_markup() and 
   * gtk_enty_set_icon_tooltip_text().
   * 
   * @newin{2,16}
   * @param icon_pos The icon position.
   * @param tooltip The contents of the tooltip for the icon, or <tt>0</tt>.
   */

  void set_icon_tooltip_markup(const Glib::ustring& tooltip, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
   
  
  /** Gets the contents of the tooltip on the icon at the specified 
   * position in @a entry.
   * 
   * @newin{2,16}
   * @param icon_pos The icon position.
   * @return The tooltip text, or <tt>0</tt>. Free the returned string
   * with Glib::free() when done.
   */
  Glib::ustring get_icon_tooltip_markup(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY) const;
  
  
  /** Sets up the icon at the given position so that GTK+ will start a drag
   * operation when the user clicks and drags the icon.
   * 
   * To handle the drag operation, you need to connect to the usual
   * Gtk::Widget::drag-data-get (or possibly Gtk::Widget::drag-data-delete)
   * signal, and use get_current_icon_drag_source() in
   * your signal handler to find out if the drag was started from
   * an icon.
   * 
   * By default, GTK+ uses the icon as the drag icon. You can use the 
   * Gtk::Widget::drag-begin signal to set a different icon. Note that you 
   * have to use Glib::signal_connect_after() to ensure that your signal handler
   * gets executed after the default handler.
   * 
   * @newin{2,16}
   * @param icon_pos Icon position.
   * @param target_list The targets (data formats) in which the data can be provided.
   * @param actions A bitmask of the allowed drag actions.
   */

  void set_icon_drag_source(const Glib::RefPtr<TargetList>& target_list, Gdk::DragAction actions = Gdk::ACTION_COPY, EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  
    
  /** Returns the index of the icon which is the source of the current
   * DND operation, or -1.
   * 
   * This function is meant to be used in a Gtk::Widget::drag-data-get
   * callback.
   * 
   * @newin{2,16}
   * @return Index of the icon which is the source of the current
   * DND operation, or -1.
   */
  int get_current_icon_drag_source();

  
  /** Returns the Gdk::Window which contains the entry's icon at
   *  @a icon_pos. This function is useful when drawing something to the
   * entry in an expose-event callback because it enables the callback
   * to distinguish between the text window and entry's icon windows.
   * 
   * See also get_text_window().
   * 
   * @newin{2,20}
   * @param icon_pos Icon position.
   * @return The entry's icon window at @a icon_pos.
   */
  Glib::RefPtr<Gdk::Window> get_icon_window(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY);
  
  /** Returns the Gdk::Window which contains the entry's icon at
   *  @a icon_pos. This function is useful when drawing something to the
   * entry in an expose-event callback because it enables the callback
   * to distinguish between the text window and entry's icon windows.
   * 
   * See also get_text_window().
   * 
   * @newin{2,20}
   * @param icon_pos Icon position.
   * @return The entry's icon window at @a icon_pos.
   */
  Glib::RefPtr<const Gdk::Window> get_icon_window(EntryIconPosition icon_pos = ENTRY_ICON_PRIMARY) const;

  
  /**
   * @par Prototype:
   * <tt>void on_my_%populate_popup(Menu* menu)</tt>
   */

  Glib::SignalProxy1< void,Menu* > signal_populate_popup();


  /**
   * @par Prototype:
   * <tt>void on_my_%insert_at_cursor(const Glib::ustring& str)</tt>
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_insert_at_cursor();


  //Key-binding signals:

  //This is a keybinding signal, but it is allowed:
  // http://mail.gnome.org/archives/gtk-devel-list/2003-January/msg00108.html
  // "activate is probably about the only exception"
  
  /**
   * @par Prototype:
   * <tt>void on_my_%activate()</tt>
   */

  Glib::SignalProxy0< void > signal_activate();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%icon_release(EntryIconPosition icon_position, const GdkEventButton* event)</tt>
   */

  Glib::SignalProxy2< void,EntryIconPosition,const GdkEventButton* > signal_icon_release();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%icon_press(EntryIconPosition icon_position, const GdkEventButton* event)</tt>
   */

  Glib::SignalProxy2< void,EntryIconPosition,const GdkEventButton* > signal_icon_press();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Text buffer object which actually stores entry text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<EntryBuffer> > property_buffer() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Text buffer object which actually stores entry text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<EntryBuffer> > property_buffer() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The current position of the insertion cursor in chars.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_cursor_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The position of the opposite end of the selection from the cursor in chars.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_selection_bound() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the entry contents can be edited.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_editable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the entry contents can be edited.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_editable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of characters for this entry. Zero if no maximum.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max_length() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Maximum number of characters for this entry. Zero if no maximum.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** FALSE displays the 'invisible char' instead of the actual text (password mode).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visibility() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** FALSE displays the 'invisible char' instead of the actual text (password mode).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visibility() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** FALSE removes outside bevel from entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_has_frame() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** FALSE removes outside bevel from entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_has_frame() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The character to use when masking entry contents (in 'password mode').
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<gunichar> property_invisible_char() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The character to use when masking entry contents (in 'password mode').
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<gunichar> property_invisible_char() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the invisible char has been set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_invisible_char_set() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the invisible char has been set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_invisible_char_set() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to activate the default widget (such as the default button in a dialog) when Enter is pressed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_activates_default() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to activate the default widget (such as the default button in a dialog) when Enter is pressed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_activates_default() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of characters to leave space for in the entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_width_chars() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of characters to leave space for in the entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_width_chars() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Number of pixels of the entry scrolled off the screen to the left.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_scroll_offset() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Which kind of shadow to draw around the entry when has-frame is set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ShadowType> property_shadow_type() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Which kind of shadow to draw around the entry when has-frame is set.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ShadowType> property_shadow_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The contents of the entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The contents of the entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The horizontal alignment, from 0 (left) to 1 (right). Reversed for RTL layouts.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<float> property_xalign() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The horizontal alignment, from 0 (left) to 1 (right). Reversed for RTL layouts.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<float> property_xalign() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to truncate multiline pastes to one line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_truncate_multiline() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether to truncate multiline pastes to one line.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_truncate_multiline() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether new text overwrites existing text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_overwrite_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether new text overwrites existing text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_overwrite_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Length of the text currently in the entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_text_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether password entries will show a warning when Caps Lock is on.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_caps_lock_warning() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether password entries will show a warning when Caps Lock is on.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_caps_lock_warning() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The current fraction of the task that's been completed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_progress_fraction() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The current fraction of the task that's been completed.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_progress_fraction() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The fraction of total entry width to move the progress bouncing block for each call to gtk_entry_progress_pulse().
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_progress_pulse_step() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The fraction of total entry width to move the progress bouncing block for each call to gtk_entry_progress_pulse().
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_progress_pulse_step() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Primary pixbuf for the entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_primary_icon_pixbuf() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Primary pixbuf for the entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> > property_primary_icon_pixbuf() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Secondary pixbuf for the entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gdk::Pixbuf> > property_secondary_icon_pixbuf() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Secondary pixbuf for the entry.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Pixbuf> > property_secondary_icon_pixbuf() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Stock ID for primary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<StockID> property_primary_icon_stock() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Stock ID for primary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<StockID> property_primary_icon_stock() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Stock ID for secondary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<StockID> property_secondary_icon_stock() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Stock ID for secondary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<StockID> property_secondary_icon_stock() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Icon name for primary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_primary_icon_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Icon name for primary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_primary_icon_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Icon name for secondary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_secondary_icon_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Icon name for secondary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_secondary_icon_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** GIcon for primary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> > property_primary_icon_gicon() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** GIcon for primary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> > property_primary_icon_gicon() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** GIcon for secondary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Gio::Icon> > property_secondary_icon_gicon() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** GIcon for secondary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gio::Icon> > property_secondary_icon_gicon() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The representation being used for primary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ImageType> property_primary_icon_storage_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The representation being used for secondary icon.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ImageType> property_secondary_icon_storage_type() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the primary icon is activatable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_primary_icon_activatable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the primary icon is activatable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_primary_icon_activatable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the secondary icon is activatable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_secondary_icon_activatable() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the secondary icon is activatable.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_secondary_icon_activatable() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the primary icon is sensitive.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_primary_icon_sensitive() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the primary icon is sensitive.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_primary_icon_sensitive() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the secondary icon is sensitive.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_secondary_icon_sensitive() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the secondary icon is sensitive.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_secondary_icon_sensitive() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Which IM module should be used.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_im_module() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Which IM module should be used.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_im_module() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} /* namespace Gtk */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Entry
   */
  Gtk::Entry* wrap(GtkEntry* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_ENTRY_H */

