// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gtkmm/recentinfo.h>
#include <gtkmm/private/recentinfo_p.h>

/* Copyright (C) 2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtkrecentmanager.h>

namespace Gtk
{

bool RecentInfo::equal(const RecentInfo& other) const
{
  return (static_cast<bool>(gtk_recent_info_match(const_cast<GtkRecentInfo*>(this->gobj()),
                                                  const_cast<GtkRecentInfo*>(other.gobj()))));
}

RecentInfo::operator bool() const
{
  return gobj() != 0;
}

Glib::StringArrayHandle RecentInfo::get_applications() const
{
  //We pass 0 for the length output argument, because we don't need it, because the returned array is null-terminated.
  return Glib::StringArrayHandle(gtk_recent_info_get_applications(const_cast<GtkRecentInfo*>(this->gobj()), 0));
}

Glib::StringArrayHandle RecentInfo::get_groups() const
{
  //We pass 0 for the length output argument, because we don't need it, because the returned array is null-terminated.
  return Glib::StringArrayHandle(gtk_recent_info_get_groups(const_cast<GtkRecentInfo*>(this->gobj()), 0));
}

} // namespace Gtk

namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::RecentInfo wrap(GtkRecentInfo* object, bool take_copy)
{
  return Gtk::RecentInfo(object, take_copy);
}

} // namespace Glib


namespace Gtk
{


// static
GType RecentInfo::get_type()
{
  return gtk_recent_info_get_type();
}

RecentInfo::RecentInfo()
:
  gobject_ (0) // Allows creation of invalid wrapper, e.g. for output arguments to methods.
{}

RecentInfo::RecentInfo(const RecentInfo& other)
:
  gobject_ ((other.gobject_) ? gtk_recent_info_ref(other.gobject_) : 0)
{}

RecentInfo::RecentInfo(GtkRecentInfo* gobject, bool make_a_copy)
:
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.
  gobject_ ((make_a_copy && gobject) ? gtk_recent_info_ref(gobject) : gobject)
{}

RecentInfo& RecentInfo::operator=(const RecentInfo& other)
{
  RecentInfo temp (other);
  swap(temp);
  return *this;
}

RecentInfo::~RecentInfo()
{
  if(gobject_)
    gtk_recent_info_unref(gobject_);
}

void RecentInfo::swap(RecentInfo& other)
{
  GtkRecentInfo *const temp = gobject_;
  gobject_ = other.gobject_;
  other.gobject_ = temp;
}

GtkRecentInfo* RecentInfo::gobj_copy() const
{
  return gtk_recent_info_ref(gobject_);
}


Glib::ustring RecentInfo::get_uri() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_recent_info_get_uri(const_cast<GtkRecentInfo*>(gobj())));
}

Glib::ustring RecentInfo::get_display_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_recent_info_get_display_name(const_cast<GtkRecentInfo*>(gobj())));
}

Glib::ustring RecentInfo::get_description() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_recent_info_get_description(const_cast<GtkRecentInfo*>(gobj())));
}

Glib::ustring RecentInfo::get_mime_type() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_recent_info_get_mime_type(const_cast<GtkRecentInfo*>(gobj())));
}

time_t RecentInfo::get_added() const
{
  return gtk_recent_info_get_added(const_cast<GtkRecentInfo*>(gobj()));
}

time_t RecentInfo::get_modified() const
{
  return gtk_recent_info_get_modified(const_cast<GtkRecentInfo*>(gobj()));
}

time_t RecentInfo::get_visited() const
{
  return gtk_recent_info_get_visited(const_cast<GtkRecentInfo*>(gobj()));
}

bool RecentInfo::get_private_hint() const
{
  return gtk_recent_info_get_private_hint(const_cast<GtkRecentInfo*>(gobj()));
}

bool RecentInfo::get_application_info(const Glib::ustring& app_name, Glib::StringArrayHandle& app_exec, guint& count, time_t& time) const
{
  return gtk_recent_info_get_application_info(const_cast<GtkRecentInfo*>(gobj()), app_name.c_str(), const_cast<gchar**>((app_exec).data()), &(count), &(time));
}

Glib::ustring RecentInfo::last_application() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_recent_info_last_application(const_cast<GtkRecentInfo*>(gobj())));
}

bool RecentInfo::has_application(const Glib::ustring& app_name) const
{
  return gtk_recent_info_has_application(const_cast<GtkRecentInfo*>(gobj()), app_name.c_str());
}

bool RecentInfo::has_group(const Glib::ustring& group) const
{
  return gtk_recent_info_has_group(const_cast<GtkRecentInfo*>(gobj()), group.c_str());
}

Glib::RefPtr<Gdk::Pixbuf> RecentInfo::get_icon(int size)
{

  Glib::RefPtr<Gdk::Pixbuf> retvalue = Glib::wrap(gtk_recent_info_get_icon(gobj(), size));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Gdk::Pixbuf> RecentInfo::get_icon(int size) const
{

  Glib::RefPtr<const Gdk::Pixbuf> retvalue = Glib::wrap(gtk_recent_info_get_icon(const_cast<GtkRecentInfo*>(gobj()), size));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::ustring RecentInfo::get_short_name() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_recent_info_get_short_name(const_cast<GtkRecentInfo*>(gobj())));
}

Glib::ustring RecentInfo::get_uri_display() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_recent_info_get_uri_display(const_cast<GtkRecentInfo*>(gobj())));
}

int RecentInfo::get_age() const
{
  return gtk_recent_info_get_age(const_cast<GtkRecentInfo*>(gobj()));
}

bool RecentInfo::is_local() const
{
  return gtk_recent_info_is_local(const_cast<GtkRecentInfo*>(gobj()));
}

bool RecentInfo::exists() const
{
  return gtk_recent_info_exists(const_cast<GtkRecentInfo*>(gobj()));
}


} // namespace Gtk


