// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_EXPANDER_H
#define _GTKMM_EXPANDER_H

#include <glibmm.h>

/* $Id: expander.hg,v 1.6 2004/03/05 20:30:18 murrayc Exp $ */

/* expander.h
 * 
 * Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkExpander GtkExpander;
typedef struct _GtkExpanderClass GtkExpanderClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Expander_Class; } // namespace Gtk
namespace Gtk
{

/** A container which can hide its child.
 *
 * A Expander allows the user to hide or show its child by clicking on an
 * expander triangle similar to the triangles used in a Gtk::TreeView.
 *
 * @ingroup Widgets
 */

class Expander : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Expander CppObjectType;
  typedef Expander_Class CppClassType;
  typedef GtkExpander BaseObjectType;
  typedef GtkExpanderClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Expander();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Expander_Class;
  static CppClassType expander_class_;

  // noncopyable
  Expander(const Expander&);
  Expander& operator=(const Expander&);

protected:
  explicit Expander(const Glib::ConstructParams& construct_params);
  explicit Expander(GtkExpander* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkExpander*       gobj()       { return reinterpret_cast<GtkExpander*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkExpander* gobj() const { return reinterpret_cast<GtkExpander*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

public:

  /** Creates a new Expander.
   *
   * The Expander has an empty label.
   * 
   * Since: 2.4
   */
  Expander();

  /** Creates a new Expander with a label.
   *
   * Creates a new expander using label as the text of the label. Settin @a mnemonic to true
   * will allow you to precede characters in the label with an underscore which will make them
   * underlined. If you need a literal underscore character in a label, use '__' (two underscores).
   * The first underlined character represents a keyboard accelerator called a mnemonic.
   * Pressing Alt and that key activates the button.
   * 
   * @param label The string for the label describing the Expander.
   * @param mnemonic Wether the label may contain underscores to set up accelerators.
   
   * Since: 2.4
   */
  explicit Expander(const Glib::ustring& label, bool mnemonic = false);
  

  /** Sets the state of the expander. Set to <tt>true</tt>, if you want
   * the child widget to be revealed, and <tt>false</tt> if you want the
   * child widget to be hidden.
   * 
   * Since: 2.4
   * @param expanded Whether the child widget is revealed.
   */
  void set_expanded(bool expanded = true);
  
  /** Queries a Gtk::Expander and returns its current state. Returns <tt>true</tt>
   * if the child widget is revealed.
   * 
   * See set_expanded().
   * @return The current state of the expander.
   * 
   * Since: 2.4.
   */
  bool get_expanded() const;

  
  /** Sets the spacing field of @a expander , which is the number of pixels to
   * place between expander and the child.
   * 
   * Since: 2.4
   * @param spacing Distance between the expander and child in pixels.
   */
  void set_spacing(int spacing);
  
  /** Gets the value set by set_spacing().
   * @return Spacing between the expander and child.
   * 
   * Since: 2.4.
   */
  int get_spacing() const;

  
  /** Sets the text of the label of the expander to @a label .
   * 
   * This will also clear any previously set labels.
   * 
   * Since: 2.4
   * @param label A string.
   */
  void set_label(const Glib::ustring& label);
  
  /** Fetches the text from the label of the expander, as set by
   * set_label(). If the label text has not
   * been set the return value will be <tt>0</tt>. This will be the
   * case if you create an empty button with Gtk::Button::new() to
   * use as a container.
   * @return The text of the label widget. This string is owned
   * by the widget and must not be modified or freed.
   * 
   * Since: 2.4.
   */
  Glib::ustring get_label() const;

  
  /** If true, an underline in the text of the expander label indicates
   * the next character should be used for the mnemonic accelerator key.
   * 
   * Since: 2.4
   * @param use_underline <tt>true</tt> if underlines in the text indicate mnemonics.
   */
  void set_use_underline(bool use_underline = true);
  
  /** Returns whether an embedded underline in the expander label indicates a
   * mnemonic. See set_use_underline().
   * @return <tt>true</tt> if an embedded underline in the expander label
   * indicates the mnemonic accelerator keys.
   * 
   * Since: 2.4.
   */
  bool get_use_underline() const;

  
  /** Sets whether the text of the label contains markup in Pango's text markup
   * language. See Gtk::Label::set_markup().
   * 
   * Since: 2.4
   * @param use_markup <tt>true</tt> if the label's text should be parsed for markup.
   */
  void set_use_markup(bool use_markup = true);
  
  /** Returns whether the label's text is interpreted as marked up with
   * the Pango text markup
   * language. See set_use_markup().
   * @return <tt>true</tt> if the label's text will be parsed for markup
   * 
   * Since: 2.4.
   */
  bool get_use_markup() const;

  
  /** Set the label widget for the expander. This is the widget
   * that will appear embedded alongside the expander arrow.
   * 
   * Since: 2.4
   * @param label_widget The new label widget.
   */
  void set_label_widget(Widget& label_widget);
  
  /** Retrieves the label widget for the frame. See
   * set_label_widget().
   * @return The label widget, or <tt>0</tt> if there is none.
   * 
   * Since: 2.4.
   */
  Widget* get_label_widget();
  
  /** Retrieves the label widget for the frame. See
   * set_label_widget().
   * @return The label widget, or <tt>0</tt> if there is none.
   * 
   * Since: 2.4.
   */
  const Widget* get_label_widget() const;

   //keybinding

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_expanded() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_expanded() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_label() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_label() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_underline() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_underline() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_markup() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_markup() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_spacing() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_spacing() const;

    /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Widget*> property_label_widget() ;

  /** You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Widget*> property_label_widget() const;
            

};


} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Expander
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
  Gtk::Expander* wrap(GtkExpander* object, bool take_copy = false);
}
#endif /* _GTKMM_EXPANDER_H */

