// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _PANGOMM_FONTDESCRIPTION_H
#define _PANGOMM_FONTDESCRIPTION_H

#include <glibmm.h>

/* $Id: fontdescription.hg,v 1.1.1.1 2003/01/21 13:41:03 murrayc Exp $ */

/* fontdescription.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <pango/pango-font.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _PangoFontDescription PangoFontDescription; }
#endif

namespace Pango
{


/** @addtogroup pangommEnums Enums and Flags */

/**
 * @ingroup pangommEnums
 */
enum Style
{
  STYLE_NORMAL,
  STYLE_OBLIQUE,
  STYLE_ITALIC
};

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::Style> : public Glib::Value_Enum<Pango::Style>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{

/**
 * @ingroup pangommEnums
 */
enum Variant
{
  VARIANT_NORMAL,
  VARIANT_SMALL_CAPS
};

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::Variant> : public Glib::Value_Enum<Pango::Variant>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{

/**
 * @ingroup pangommEnums
 */
enum Stretch
{
  STRETCH_ULTRA_CONDENSED,
  STRETCH_EXTRA_CONDENSED,
  STRETCH_CONDENSED,
  STRETCH_SEMI_CONDENSED,
  STRETCH_NORMAL,
  STRETCH_SEMI_EXPANDED,
  STRETCH_EXPANDED,
  STRETCH_EXTRA_EXPANDED,
  STRETCH_ULTRA_EXPANDED
};

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::Stretch> : public Glib::Value_Enum<Pango::Stretch>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{

/**
 * @ingroup pangommEnums
 */
enum Weight
{
  WEIGHT_ULTRALIGHT = 200,
  WEIGHT_LIGHT = 300,
  WEIGHT_NORMAL = 400,
  WEIGHT_BOLD = 700,
  WEIGHT_ULTRABOLD = 800,
  WEIGHT_HEAVY = 900
};

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::Weight> : public Glib::Value_Enum<Pango::Weight>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{

/**
 * @ingroup pangommEnums
 * @par Bitwise operators:
 * <tt>%FontMask operator|(FontMask, FontMask)</tt><br>
 * <tt>%FontMask operator&(FontMask, FontMask)</tt><br>
 * <tt>%FontMask operator^(FontMask, FontMask)</tt><br>
 * <tt>%FontMask operator~(FontMask)</tt><br>
 * <tt>%FontMask& operator|=(FontMask&, FontMask)</tt><br>
 * <tt>%FontMask& operator&=(FontMask&, FontMask)</tt><br>
 * <tt>%FontMask& operator^=(FontMask&, FontMask)</tt><br>
 */
enum FontMask
{
  FONT_MASK_FAMILY = 1 << 0,
  FONT_MASK_STYLE = 1 << 1,
  FONT_MASK_VARIANT = 1 << 2,
  FONT_MASK_WEIGHT = 1 << 3,
  FONT_MASK_STRETCH = 1 << 4,
  FONT_MASK_SIZE = 1 << 5
};

/** @ingroup pangommEnums */
inline FontMask operator|(FontMask lhs, FontMask rhs)
  { return static_cast<FontMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup pangommEnums */
inline FontMask operator&(FontMask lhs, FontMask rhs)
  { return static_cast<FontMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup pangommEnums */
inline FontMask operator^(FontMask lhs, FontMask rhs)
  { return static_cast<FontMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup pangommEnums */
inline FontMask operator~(FontMask flags)
  { return static_cast<FontMask>(~static_cast<unsigned>(flags)); }

/** @ingroup pangommEnums */
inline FontMask& operator|=(FontMask& lhs, FontMask rhs)
  { return (lhs = static_cast<FontMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup pangommEnums */
inline FontMask& operator&=(FontMask& lhs, FontMask rhs)
  { return (lhs = static_cast<FontMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup pangommEnums */
inline FontMask& operator^=(FontMask& lhs, FontMask rhs)
  { return (lhs = static_cast<FontMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Pango


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::FontMask> : public Glib::Value_Flags<Pango::FontMask>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Pango
{


/** A Pango::FontDescription represents the description of an ideal font.
 * It is used both to list what fonts are available on the system and also for specifying the characteristics of a font to load.
 */
class FontDescription
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FontDescription CppObjectType;
  typedef PangoFontDescription BaseObjectType;

  static GType get_type() G_GNUC_CONST;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  FontDescription();

  explicit FontDescription(PangoFontDescription* gobject, bool make_a_copy = true);

  FontDescription(const FontDescription& other);
  FontDescription& operator=(const FontDescription& other);

  ~FontDescription();

  void swap(FontDescription& other);

  ///Provides access to the underlying C instance.
  PangoFontDescription*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const PangoFontDescription* gobj() const { return gobject_; }

  // The caller is responsible for freeing it. Use when directly setting fields in structs.
  PangoFontDescription* gobj_copy() const;

protected:
  PangoFontDescription* gobject_;

private:

  
  /* These functions are dangerous! The first casts the "const" from the parameter away
   * copying the pointer and keep it hanging around.
   * So desc.set_family_static("some_family") would lead to a segfault.
   * The latter makes a shallow copy of the parameter's "family" data member.
   * So if the FontDescription you passed in dies, a pointer to its (deleted)
   * family data member still hangs around!
   * This is why we can't wrap these functions!
   */
  

public:
  /** Constructs a font description from a string representation.
   * @a font_name must have the form
   * "[FAMILY-LIST] [STYLE-OPTIONS] [SIZE]", where FAMILY-LIST is a comma separated
   * list of families optionally terminated by a comma, STYLE_OPTIONS is a whitespace
   * separated list of words where each WORD describes one of style, variant, weight,
   * or stretch, and SIZE is an decimal number (size in points). Any one of the
   * options may be absent. If FAMILY-LIST is absent, then the family_name field
   * of the resulting font description will be initialized to 0. If STYLE-OPTIONS
   * is missing, then all style options will be set to the default values. If SIZE
   * is missing, the size in the resulting font description will be set to 0.
   * @param font_name String representation of a font description.
   */
  explicit FontDescription(const Glib::ustring& font_name);

  
  guint hash() const;
  
  void set_family(const Glib::ustring& family);
  
  Glib::ustring get_family() const;
  
  void set_style(Style style);
  
  Style get_style() const;
  
  void set_variant(Variant variant);
  
  Variant get_variant() const;
  
  void set_weight(Weight weight);
  
  Weight get_weight() const;
  
  void set_stretch(Stretch stretch);
  
  Stretch get_stretch() const;
  
  void set_size(int size);
  
  int get_size() const;
  
  FontMask get_set_fields() const;
  
  void unset_fields(FontMask to_unset);
  
  void merge(const FontDescription& desc_to_merge, bool replace_existing);
  
  bool better_match(const FontDescription& old_match, const FontDescription& new_match) const;
  
  Glib::ustring to_string() const;
  
  Glib::ustring to_filename() const;


};

} //namespace Pango


namespace Pango
{

/** @relates Pango::FontDescription */
bool operator==(const FontDescription& lhs, const FontDescription& rhs);

/** @relates Pango::FontDescription */
bool operator!=(const FontDescription& lhs, const FontDescription& rhs);


} // namespace Pango


namespace Pango
{

/** @relates Pango::FontDescription */
inline void swap(FontDescription& lhs, FontDescription& rhs)
  { lhs.swap(rhs); }

} // namespace Pango

namespace Glib
{

/** @relates Pango::FontDescription */
Pango::FontDescription wrap(PangoFontDescription* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Pango::FontDescription> : public Glib::Value_Boxed<Pango::FontDescription>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib

#endif /* _PANGOMM_FONTDESCRIPTION_H */

