// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_SPINBUTTON_H
#define _GTKMM_SPINBUTTON_H

#include <glibmm.h>

/* $Id: spinbutton.hg,v 1.2 2003/01/22 23:04:19 murrayc Exp $ */

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/entry.h>
#include <gtkmm/editable.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSpinButton GtkSpinButton;
typedef struct _GtkSpinButtonClass GtkSpinButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class SpinButton_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum SpinButtonUpdatePolicy
{
  UPDATE_ALWAYS,
  UPDATE_IF_VALID
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SpinButtonUpdatePolicy> : public Glib::Value_Enum<Gtk::SpinButtonUpdatePolicy>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum SpinType
{
  SPIN_STEP_FORWARD,
  SPIN_STEP_BACKWARD,
  SPIN_PAGE_FORWARD,
  SPIN_PAGE_BACKWARD,
  SPIN_HOME,
  SPIN_END,
  SPIN_USER_DEFINED
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SpinType> : public Glib::Value_Enum<Gtk::SpinType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/** @ingroup gtkmmEnums */
enum { INPUT_ERROR = -1 };

class Adjustment;

/** numeric Entry with up/down buttons
 * Slightly misnamed, this should be called a SpinEntry.
 *
 * @ingroup Widgets
 */

class SpinButton : public Entry
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef SpinButton CppObjectType;
  typedef SpinButton_Class CppClassType;
  typedef GtkSpinButton BaseObjectType;
  typedef GtkSpinButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~SpinButton();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class SpinButton_Class;
  static CppClassType spinbutton_class_;

  // noncopyable
  SpinButton(const SpinButton&);
  SpinButton& operator=(const SpinButton&);

protected:
  explicit SpinButton(const Glib::ConstructParams& construct_params);
  explicit SpinButton(GtkSpinButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkSpinButton*       gobj()       { return reinterpret_cast<GtkSpinButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkSpinButton* gobj() const { return reinterpret_cast<GtkSpinButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual int on_input(double* new_value);
  virtual bool on_output();
  virtual void on_value_changed();


private:

  
public:

  //: create instance
  // adjustment: see Gtk::Adjustment
  // climb_rate:
  // digits: number of decimal digits (has to be < 6)
  SpinButton(double climb_rate = 0.0, guint digits = 0);
  explicit SpinButton(Adjustment& adjustment, double climb_rate = 0.0, guint digits = 0);


  void configure(Adjustment& adjustment, double climb_rate, guint digits);

  
  void set_adjustment(Adjustment& adjustment);
  void unset_adjustment();
  
  Gtk::Adjustment* get_adjustment();
  
  const Gtk::Adjustment* get_adjustment() const;

  
  void set_digits(guint digits);
  
  guint get_digits() const;

  
  void set_increments(double step, double page);
  
  void get_increments(double& step, double& page) const;

  
  void set_range(double min, double max);
  
  void get_range(double& min, double& max) const;

  
  double get_value() const;
  
  int get_value_as_int() const;
  
  void set_value(double value);

  
  void set_update_policy(SpinButtonUpdatePolicy policy);
  
  SpinButtonUpdatePolicy get_update_policy() const;

  
  void set_numeric(bool numeric = true);
  
  bool get_numeric() const;

  
  void spin(SpinType direction, double increment);

  
  void set_wrap(bool wrap = true);
  
  bool get_wrap() const;

  
  void set_snap_to_ticks(bool snap_to_ticks = true);
  
  bool get_snap_to_ticks() const;

  
  void update();

  /** Convert the Entry text to a number.
   * The computed number should be written to <tt>*new_value</tt>.
   * @return
   * @li <tt>false</tt>: No conversion done, continue with default handler.
   * @li <tt>true</tt>: Conversion successful, don't call default handler.
   * @li <tt>Gtk::INPUT_ERROR</tt>: Conversion failed, don't call default handler.
   */
  
  /**
   * @par Prototype:
   * <tt>int %input(double* new_value)</tt>
   */
  Glib::SignalProxy1<int,double*> signal_input();


  /** Convert the Adjustment position to text.
   * The computed text should be written via Gtk::Entry::set_text().
   * @return
   * @li <tt>false</tt>: No conversion done, continue with default handler.
   * @li <tt>true</tt>: Conversion successful, don't call default handler.
   */
  
  /**
   * @par Prototype:
   * <tt>bool %output()</tt>
   */
  Glib::SignalProxy0<bool> signal_output();


  /**
   * @par Prototype:
   * <tt>void %value_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_value_changed();


  //Keybinding signals:
  

  Glib::PropertyProxy<Gtk::Adjustment*> property_adjustment();

  Glib::PropertyProxy<double> property_climb_rate();

  Glib::PropertyProxy<guint> property_digits();

  Glib::PropertyProxy<bool> property_snap_to_ticks();

  Glib::PropertyProxy<bool> property_numeric();

  Glib::PropertyProxy<bool> property_wrap();

  Glib::PropertyProxy<SpinButtonUpdatePolicy> property_update_policy();

  Glib::PropertyProxy<double> property_value();


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::SpinButton */
  Gtk::SpinButton* wrap(GtkSpinButton* object, bool take_copy = false);
}
#endif /* _GTKMM_SPINBUTTON_H */

