// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDKMM_GC_H
#define _GDKMM_GC_H

#include <glibmm.h>

/* $Id: gc.hg,v 1.2 2003/03/13 14:46:00 srittau Exp $ */

/* gc.h
 *
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <gdkmm/drawable.h>
#include <gdkmm/types.h>
#include <gdkmm/rectangle.h>
#include <gdkmm/screen.h>
#include <gdk/gdkgc.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdkGC GdkGC;
typedef struct _GdkGCClass GdkGCClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{ class GC_Class; } // namespace Gdk
namespace Gdk
{


/** @addtogroup gdkmmEnums Enums and Flags */

/**
 * @ingroup gdkmmEnums
 */
enum LineStyle
{
  LINE_SOLID,
  LINE_ON_OFF_DASH,
  LINE_DOUBLE_DASH
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::LineStyle> : public Glib::Value_Enum<Gdk::LineStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum CapStyle
{
  CAP_NOT_LAST,
  CAP_BUTT,
  CAP_ROUND,
  CAP_PROJECTING
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::CapStyle> : public Glib::Value_Enum<Gdk::CapStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum JoinStyle
{
  JOIN_MITER,
  JOIN_ROUND,
  JOIN_BEVEL
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::JoinStyle> : public Glib::Value_Enum<Gdk::JoinStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum Fill
{
  SOLID,
  TILED,
  STIPPLED,
  OPAQUE_STIPPLED
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Fill> : public Glib::Value_Enum<Gdk::Fill>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum Function
{
  COPY,
  INVERT,
  XOR,
  CLEAR,
  AND,
  AND_REVERSE,
  AND_INVERT,
  NOOP,
  OR,
  EQUIV,
  OR_REVERSE,
  COPY_INVERT,
  OR_INVERT,
  NAND,
  NOR,
  SET
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Function> : public Glib::Value_Enum<Gdk::Function>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 */
enum SubwindowMode
{
  CLIP_BY_CHILDREN,
  INCLUDE_INFERIORS
};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::SubwindowMode> : public Glib::Value_Enum<Gdk::SubwindowMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @ingroup gdkmmEnums
 * @par Bitwise operators:
 * <tt>%GCValuesMask operator|(GCValuesMask, GCValuesMask)</tt><br>
 * <tt>%GCValuesMask operator&(GCValuesMask, GCValuesMask)</tt><br>
 * <tt>%GCValuesMask operator^(GCValuesMask, GCValuesMask)</tt><br>
 * <tt>%GCValuesMask operator~(GCValuesMask)</tt><br>
 * <tt>%GCValuesMask& operator|=(GCValuesMask&, GCValuesMask)</tt><br>
 * <tt>%GCValuesMask& operator&=(GCValuesMask&, GCValuesMask)</tt><br>
 * <tt>%GCValuesMask& operator^=(GCValuesMask&, GCValuesMask)</tt><br>
 */
enum GCValuesMask
{
  GC_FOREGROUND = 1 << 0,
  GC_BACKGROUND = 1 << 1,
  GC_FONT = 1 << 2,
  GC_FUNCTION = 1 << 3,
  GC_FILL = 1 << 4,
  GC_TILE = 1 << 5,
  GC_STIPPLE = 1 << 6,
  GC_CLIP_MASK = 1 << 7,
  GC_SUBWINDOW = 1 << 8,
  GC_TS_X_ORIGIN = 1 << 9,
  GC_TS_Y_ORIGIN = 1 << 10,
  GC_CLIP_X_ORIGIN = 1 << 11,
  GC_CLIP_Y_ORIGIN = 1 << 12,
  GC_EXPOSURES = 1 << 13,
  GC_LINE_WIDTH = 1 << 14,
  GC_LINE_STYLE = 1 << 15,
  GC_CAP_STYLE = 1 << 16,
  GC_JOIN_STYLE = 1 << 17
};

/** @ingroup gdkmmEnums */
inline GCValuesMask operator|(GCValuesMask lhs, GCValuesMask rhs)
  { return static_cast<GCValuesMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline GCValuesMask operator&(GCValuesMask lhs, GCValuesMask rhs)
  { return static_cast<GCValuesMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline GCValuesMask operator^(GCValuesMask lhs, GCValuesMask rhs)
  { return static_cast<GCValuesMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gdkmmEnums */
inline GCValuesMask operator~(GCValuesMask flags)
  { return static_cast<GCValuesMask>(~static_cast<unsigned>(flags)); }

/** @ingroup gdkmmEnums */
inline GCValuesMask& operator|=(GCValuesMask& lhs, GCValuesMask rhs)
  { return (lhs = static_cast<GCValuesMask>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline GCValuesMask& operator&=(GCValuesMask& lhs, GCValuesMask rhs)
  { return (lhs = static_cast<GCValuesMask>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gdkmmEnums */
inline GCValuesMask& operator^=(GCValuesMask& lhs, GCValuesMask rhs)
  { return (lhs = static_cast<GCValuesMask>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::GCValuesMask> : public Glib::Value_Flags<Gdk::GCValuesMask>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{


class Drawable;


class GC : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef GC CppObjectType;
  typedef GC_Class CppClassType;
  typedef GdkGC BaseObjectType;
  typedef GdkGCClass BaseClassType;

private:
  friend class GC_Class;
  static CppClassType gc_class_;

  // noncopyable
  GC(const GC&);
  GC& operator=(const GC&);

protected:
  explicit GC(const Glib::ConstructParams& construct_params);
  explicit GC(GdkGC* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~GC();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkGC*       gobj()       { return reinterpret_cast<GdkGC*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkGC* gobj() const { return reinterpret_cast<GdkGC*>(gobject_); }

  GdkGC* gobj_copy();

private:

  
protected:
  GC();
  explicit GC(const Glib::RefPtr<Drawable>& drawable);

public:
  
  static Glib::RefPtr<GC> create();

  
  static Glib::RefPtr<GC> create(const Glib::RefPtr<Drawable>& drawable);


  // Custom wrap these, maybe with a Gdk::GC::Value class. Need to do take care of refcounts of GdkGCValue's fields.
  //_WRAP_METHOD(void get_values(GdkGCValues& values) const, gdk_gc_get_values)
  //_WRAP_METHOD(void set_values(const GdkGCValues& values, GCValuesMask values_mask), gdk_gc_set_values)

  
  void set_foreground(const Color& color);
  
  void set_background(const Color& color);
  
  void set_function(Function function);
  
  void set_fill(Fill fill);
  
  void set_tile(const Glib::RefPtr<Pixmap>& tile);
  
  void set_stipple(const Glib::RefPtr<Pixmap>& stipple);
  
  void set_ts_origin(int x, int y);
  
  void set_clip_origin(int x, int y);
  
  void set_clip_mask(const Glib::RefPtr<Bitmap>& mask);
  
  void set_clip_rectangle(Rectangle& rectangle);
  
  void set_clip_region(GdkRegion* region);
  
  void set_subwindow(SubwindowMode mode);
  
  void set_exposures(bool exposures);
  
  void set_line_attributes(int line_width, LineStyle line_style, CapStyle cap_style, JoinStyle join_style);
  
  void set_dashes(int dash_offset, gint8* dash_list, int n);
  
  void offset(int x_offset, int y_offset);
  
  void set_colormap(const Glib::RefPtr<Colormap>& colormap);
  
  Glib::RefPtr<Colormap> get_colormap();
  
  void set_rgb_fg_color(const Color& color);
  
  void set_rgb_bg_color(const Color& color);

  
  Glib::RefPtr<Screen> get_screen();
  
  Glib::RefPtr<const Screen> get_screen() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} /* namespace Gdk */


namespace Glib
{
  /** @relates Gdk::GC */
  Glib::RefPtr<Gdk::GC> wrap(GdkGC* object, bool take_copy = false);
}


#endif /* _GDKMM_GC_H */

