// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_TREEVIEW_H
#define _GTKMM_TREEVIEW_H

#include <glibmm.h>

/* $Id: treeview.hg,v 1.7 2003/10/17 16:18:25 murrayc Exp $ */

/* Copyright(C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/listhandle.h>
#include <gtkmm/container.h>
#include <gtkmm/adjustment.h>
#include <gdkmm/pixmap.h>
#include <gtkmm/treeviewcolumn.h>
#include <gtkmm/treeselection.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/cellrenderer.h>
#include <gtkmm/targetentry.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkTreeView GtkTreeView;
typedef struct _GtkTreeViewClass GtkTreeViewClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class TreeView_Class; } // namespace Gtk
namespace Gtk
{


/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum TreeViewDropPosition
{
  TREE_VIEW_DROP_BEFORE,
  TREE_VIEW_DROP_AFTER,
  TREE_VIEW_DROP_INTO_OR_BEFORE,
  TREE_VIEW_DROP_INTO_OR_AFTER
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TreeViewDropPosition> : public Glib::Value_Enum<Gtk::TreeViewDropPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


#ifndef DOXYGEN_SHOULD_SKIP_THIS

class TreeView;

namespace TreeView_Private
{
/* This helper function is not a member of TreeView just for the reason that
 * there are compilers that have problems compiling it otherwise. E.g. in gcc
 * 2.95.3 a compiler bug prevents member functions from refering to specialized
 * member function templates and that's what we do here: In function
 * _connect_auto_store_editable_signal_handler we build a slot from
 * TreeView::_auto_store_on_cellrenderer_*_edited. (The latter must be member
 * functions of TreeView since we connect them to signals and we want the
 * connections to vanish when the TreeView dies, of course.)
 */
  template <class ColumnType> inline
  void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer, const Gtk::TreeModelColumn<ColumnType>& model_column);

  template<class ColumnType> inline
  void _auto_store_on_cellrenderer_text_edited_string(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, Gtk::TreeView*);

  template <class ColumnType> inline
  void _auto_store_on_cellrenderer_text_edited_numerical(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, Gtk::TreeView*);
}

#endif //DOXYGEN_SHOULD_SKIP_THIS


//class TreeViewColumn;
class TreeModel;

/** @defgroup TreeView TreeView Classes
 * These classes are used with the Gtk::TreeView widget.
 */

/**
 * @ingroup Widgets
 * @ingroup Containers
 * @ingroup TreeView
 */

class TreeView : public Container
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TreeView CppObjectType;
  typedef TreeView_Class CppClassType;
  typedef GtkTreeView BaseObjectType;
  typedef GtkTreeViewClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~TreeView();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class TreeView_Class;
  static CppClassType treeview_class_;

  // noncopyable
  TreeView(const TreeView&);
  TreeView& operator=(const TreeView&);

protected:
  explicit TreeView(const Glib::ConstructParams& construct_params);
  explicit TreeView(GtkTreeView* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkTreeView*       gobj()       { return reinterpret_cast<GtkTreeView*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkTreeView* gobj() const { return reinterpret_cast<GtkTreeView*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment);
  virtual void on_row_activated(const TreeModel::Path& path, TreeViewColumn* column);
  virtual bool on_test_expand_row(const TreeModel::iterator& iter, const TreeModel::Path& path);
  virtual bool on_test_collapse_row(const TreeModel::iterator& iter, const TreeModel::Path& path);
  virtual void on_row_expanded(const TreeModel::iterator& iter, const TreeModel::Path& path);
  virtual void on_row_collapsed(const TreeModel::iterator& iter, const TreeModel::Path& path);
  virtual void on_cursor_changed();
  virtual void on_columns_changed();


private:

  
public:
  typedef TreeViewColumn Column;
  typedef TreeSelection Selection;

  TreeView();
  explicit TreeView(const Glib::RefPtr<TreeModel>& model);

  
  Glib::RefPtr<TreeModel> get_model();
  
  Glib::RefPtr<const TreeModel> get_model() const;
  
  void set_model(const Glib::RefPtr<TreeModel>& model);
  
  Glib::RefPtr<TreeSelection> get_selection();
  
  Glib::RefPtr<const TreeSelection> get_selection() const;
  
  Adjustment* get_hadjustment();
  
  const Adjustment* get_hadjustment() const;
  
  void set_hadjustment(Adjustment& adjustment);
  void unset_hadjustment();
  
  Adjustment* get_vadjustment();
  
  const Adjustment* get_vadjustment() const;
  
  void set_vadjustment(Adjustment& adjustment);
  void unset_vadjustment();
  
  bool get_headers_visible() const;
  
  void set_headers_visible(bool headers_visible);
  
  void columns_autosize();
  
  void set_headers_clickable(bool setting = true);
  
  void set_rules_hint(bool setting = true);
  
  bool get_rules_hint() const;

  
  int append_column(TreeViewColumn& column);

  /** Appends a View column with the appropriate CellRenderer for the Model column.
   * The CellRenderer can only be created automatically for some basic
   * column types, such as Glib::ustring, int, bool, Gdk::Pixbuf. Also,
   * the default CellRenderer might not be setup exactly as needed.
   * You might prefer to create the TreeViewColumn and or CellRenderer
   * manually. You might provide a callback that converts the type into a
   * string representation with TreeViewColumn::set_cell_data_func().
   * Otherwise, if the type is not supported, at run-time no text will
   * appear in the column while the following warning will be generated repeatedly:
   * GLib-GObject-WARNING **: unable to set property `text' of type
   * `gchararray' from value of type `glibmm__CustomBoxed_t'
   * TODO: Give a more specific warning and/or do more compile-time checks.
   */
  template <class ColumnType> inline
  int append_column(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column);

  //TODO: danielk suggested use of Glib::Value to simplify/improve this.
  /** Appends a View column with the appropriate CellRenderer for the Model
   * column.  The compiler will attempt to instantiate appropriate template
   * code to automatically store user changes in the model.  To intercept the
   * user's change and implement non-default logic, or if the compiler can't
   * instantiate appropriate code for your model type, you should use
   * append_column() and connect a signal handler to the CellRenderer.
   */
  template <class ColumnType> inline
  int append_column_editable(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column);


  /// Creates a View column containing the CellRenderer, and appends it.
  int append_column(const Glib::ustring& title, CellRenderer& cell);

  
  int remove_column(TreeViewColumn& column);

  /// Removes all View columns.
  void remove_all_columns();

  
  int insert_column(TreeViewColumn& column, int position);

  /// Creates a View column containing the CellRenderer, and inserts it.
  int insert_column(const Glib::ustring& title, CellRenderer& cell, int position);

  
  /// Inserts a View column with the appropriate CellRenderer for the Model column.
  template <class ColumnType> inline
  int insert_column(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, int position);

  /** Inserts a View column with the appropriate CellRenderer for the Model
   * column.  The compiler will attempt to instantiate appropriate template
   * code to automatically store user changes in the model.  To intercept the
   * user's change and implement non-default logic, or if the compiler can't
   * instantiate appropriate code for your model type, you should use
   * append_column() and connect a signal handler to the CellRenderer.
   */
  template <class ColumnType> inline
  int insert_column_editable(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, int position);

  typedef TreeViewColumn::SlotCellData SlotCellData;
  int insert_column_with_data_func(int position, const Glib::ustring& title, CellRenderer& cell, const SlotCellData& slot);

  
  TreeViewColumn* get_column(int n);
  
  const TreeViewColumn* get_column(int n) const;

  /** Gets the CellRenderer for that column.
    * You should dynamic_cast<> to the expected derived CellRenderer type.
    * This assumes that the TreeViewColumn contains only one CellRenderer.
    */
  CellRenderer* get_column_cell_renderer(int n);

  /** Gets the CellRenderer for that column.
    * You should dynamic_cast<> to the expected derived CellRenderer type.
    * This assumes that the TreeViewColumn contains only one CellRenderer.
    */
  const CellRenderer* get_column_cell_renderer(int n) const;

  
  Glib::ListHandle<TreeViewColumn*> get_columns();
  
  Glib::ListHandle<const TreeViewColumn*> get_columns() const;
  
  void move_column_after(TreeViewColumn& column, TreeViewColumn& base_column);
  
  void set_expander_column(TreeViewColumn& column);
  void unset_expander_column();
  
  TreeViewColumn* get_expander_column();
  
  const TreeViewColumn* get_expander_column() const;

  //bool on_column_drop(TreeView*, tree_view, TreeViewColumn* column, TreeViewColumn* prev_column,TreeViewColumn* next_column)
  typedef SigC::Slot4<bool, TreeView*, TreeViewColumn*,  TreeViewColumn*, TreeViewColumn*> SlotColumnDrop;
  void set_column_drag_function(const SlotColumnDrop& slot);
  

  void scroll_to_point(int tree_x, int tree_y);

  /** Moves the alignments of tree view to the position specified by @a column and @a path.
   * @a row_align determines where the row is placed, and @a col_align determines where
   * column is placed. Both are expected to be between 0.0 and 1.0. 0.0 means left/top
   * alignment, 1.0 means right/bottom alignment, 0.5 means center.
   *
   * This function only works if the model is set, and @a path is a valid row on the model.
   * If the model changes before the tree view is realized, the centered path will be
   * modified to reflect this change.
   *
   * @param path The path of the row to move to.
   * @param column The Gtk::TreeViewColumn to move horizontally to.
   * @param row_align The vertical alignment of the row specified by @a path.
   * @param col_align The horizontal alignment of the column specified by @a column.
   */
  void scroll_to_cell(const TreeModel::Path& path, TreeViewColumn& column, float row_align, float col_align);
  

  /** Moves the alignments of tree view to the position specified by @a column and @a path.
   * The tree does the minimum amount of work to scroll the cell onto the screen. This means
   * that the cell will be scrolled to the edge closest to it's current position. If the cell
   * is currently visible on the screen, nothing is done.
   *
   * This function only works if the model is set, and @a path is a valid row on the model.
   * If the model changes before the tree_view is realized, the centered path will be modified
   * to reflect this change.
   *
   * @param path The path of the row to move to.
   * @param column The Gtk::TreeViewColumn to move horizontally to.
   */
  void scroll_to_cell(const TreeModel::Path& path, TreeViewColumn& column);

  /** Moves the alignments of tree view to the position specified by @a path.
   * @a row_align determines where the row is placed, and is expected to be between 0.0
   * and 1.0.  0.0 means top alignment, 1.0 means bottom alignment, 0.5 means center.
   *
   * This function only works if the model is set, and @a path is a valid row on the model.
   * If the model changes before the tree view is realized, the centered path will be
   * modified to reflect this change.
   *
   * @param path The path of the row to move to.
   * @param row_align The vertical alignment of the row specified by @a path.
   */
  void scroll_to_row(const TreeModel::Path& path, float row_align);

  /** Moves the alignments of tree view to the position specified by @a path.
   * The tree does the minimum amount of work to scroll the row onto the screen. This means
   * that the row will be scrolled to the edge closest to it's current position. If the row
   * is currently visible on the screen, nothing is done.
   *
   * This function only works if the model is set, and @a path is a valid row on the model.
   * If the model changes before the tree view is realized, the centered path will be
   * modified to reflect this change.
   *
   * @param path The path of the row to move to.
   */
  void scroll_to_row(const TreeModel::Path& path);

  /** Moves the alignments of tree view to the position specified by @a column.
   * @a col_align determines where the column is placed, and is expected to be between 0.0
   * and 1.0.  0.0 means left alignment, 1.0 means right alignment, 0.5 means center.
   *
   * This function only works if the model is set.  If the model changes before the tree
   * view is realized, the centered path will be modified to reflect this change.
   *
   * @param column The Gtk::TreeViewColumn to move horizontally to.
   * @param col_align The horizontal alignment of the column specified by @a column.
   */
  void scroll_to_column(TreeViewColumn& column, float col_align);

  /** Moves the alignments of tree view to the position specified by @a column.
   * The tree does the minimum amount of work to scroll the column onto the screen. This means
   * that the column will be scrolled to the edge closest to it's current position. If the column
   * is currently visible on the screen, nothing is done.
   *
   * This function only works if the model is set.  If the model changes before the
   * tree view is realized, the centered path will be modified to reflect this change.
   *
   * @param column The Gtk::TreeViewColumn to move horizontally to.
   */
  void scroll_to_column(TreeViewColumn& column);

  
  void row_activated(const TreeModel::Path& path,TreeViewColumn& column);
  
  void expand_all();
  
  void collapse_all();
  
  void expand_to_path(const TreeModel::Path& path);
  
  bool expand_row(const TreeModel::Path& path, bool open_all);
  
  bool collapse_row(const TreeModel::Path& path);

  //void on_map_expanded_rows(TreeView* tree_view, const TreeModel::Path& path);
  typedef SigC::Slot2<void, TreeView*, const TreeModel::Path&> SlotMapping;
  void map_expanded_rows(const SlotMapping& slot);
  

  bool row_expanded(const TreeModel::Path& path);
  
  void set_reorderable(bool reorderable = true);
  
  bool get_reorderable() const;
  
  void set_cursor(const TreeModel::Path& path, TreeViewColumn& focus_column, bool start_editing = false);
  
  void set_cursor(const TreeModel::Path& path, TreeViewColumn& focus_column, CellRenderer& cell, bool start_editing = false);

  void set_cursor(const TreeModel::Path& path); //TODO: Add bool start_editing = false?, even though a true value doesn't actually start editing?
  void get_cursor(TreeModel::Path& path, TreeViewColumn*& focus_column);

/* Layout information */
  
  Glib::RefPtr<Gdk::Window> get_bin_window();
  
  Glib::RefPtr<const Gdk::Window> get_bin_window() const;
  bool get_path_at_pos(int x, int y, TreeModel::Path& path, TreeViewColumn*& column, int& cell_x, int& cell_y);
  
  void get_cell_area(const TreeModel::Path& path, TreeViewColumn& column, Gdk::Rectangle&  rect);
//We ignore the fact that one of the arguments can be 0 - it does not seem useful.

  
  void get_background_area(const TreeModel::Path& path, TreeViewColumn& column, Gdk::Rectangle& rect);
  //We ignore the fact that one of the arguments can be 0 - it does not seem useful.

  
  void get_visible_rect(Gdk::Rectangle&  visible_rect);
  
  void widget_to_tree_coords(int wx, int wy, int& tx, int& ty);
  
  void tree_to_widget_coords(int tx, int ty, int& wx, int& wy);

/* Drag-and-Drop support */
  

  void enable_model_drag_source(const ArrayHandle_TargetEntry& targets,
                                Gdk::ModifierType start_button_mask = Gdk::MODIFIER_MASK,
                                Gdk::DragAction actions = Gdk::ACTION_COPY | Gdk::ACTION_MOVE);

  // Uses the default "GTK_TREE_MODEL_ROW" target, which the TreeView can handle automatically.                              
  void enable_model_drag_source(Gdk::ModifierType start_button_mask = Gdk::MODIFIER_MASK,
                                Gdk::DragAction actions = Gdk::ACTION_COPY | Gdk::ACTION_MOVE);                                                                                              

  
  void enable_model_drag_dest(const ArrayHandle_TargetEntry& targets, Gdk::DragAction actions = Gdk::ACTION_COPY | Gdk::ACTION_MOVE);

  // Uses the default "GTK_TREE_MODEL_ROW" target, which the TreeView can handle automatically.
  void enable_model_drag_dest(Gdk::DragAction actions = Gdk::ACTION_COPY | Gdk::ACTION_MOVE);

    
  void unset_rows_drag_source();
  
  void unset_rows_drag_dest();


/* These are useful to implement your own custom stuff. */
  
  void set_drag_dest_row(const TreeModel::Path& path, TreeViewDropPosition pos);
  void get_drag_dest_row(TreeModel::Path& path, TreeViewDropPosition& pos);
  bool get_dest_row_at_pos(int drag_x, int drag_y, TreeModel::Path& path, TreeViewDropPosition& pos);
  
  Glib::RefPtr<Gdk::Pixmap> create_row_drag_icon(const TreeModel::Path& path);

/* Interactive search */
  
  void set_enable_search(bool enable_search = true);
  
  bool get_enable_search() const;
  
  int get_search_column() const;
  
  void set_search_column(const TreeModelColumnBase& column);
  
  void set_search_column(int column);

  ///void on_search_equal(const Glib::RefPtr<TreeModel>& model, int column, const Glib::ustring& key, const TreeModel::iterator& iter)
  typedef SigC::Slot4<bool, const Glib::RefPtr<TreeModel>&, int, const Glib::ustring&, const TreeModel::iterator&> SlotSearchEqual;
  //SlotSearchEqual get_search_equal_func();
  
  void set_search_equal_func(const SlotSearchEqual& slot);
  

  /**
   * @par Prototype:
   * <tt>void %set_scroll_adjustments(Adjustment* hadjustment, Adjustment* vadjustment)</tt>
   */
  Glib::SignalProxy2<void,Adjustment*,Adjustment*> signal_set_scroll_adjustments();

  
  /**
   * @par Prototype:
   * <tt>void %row_activated(const TreeModel::Path& path, TreeViewColumn* column)</tt>
   */
  Glib::SignalProxy2<void,const TreeModel::Path&,TreeViewColumn*> signal_row_activated();

  
  /**
   * @par Prototype:
   * <tt>bool %test_expand_row(const TreeModel::iterator& iter, const TreeModel::Path& path)</tt>
   */
  Glib::SignalProxy2<bool,const TreeModel::iterator&,const TreeModel::Path&> signal_test_expand_row();

  
  /**
   * @par Prototype:
   * <tt>bool %test_collapse_row(const TreeModel::iterator& iter, const TreeModel::Path& path)</tt>
   */
  Glib::SignalProxy2<bool,const TreeModel::iterator&,const TreeModel::Path&> signal_test_collapse_row();

  
  /**
   * @par Prototype:
   * <tt>void %row_expanded(const TreeModel::iterator& iter, const TreeModel::Path& path)</tt>
   */
  Glib::SignalProxy2<void,const TreeModel::iterator&,const TreeModel::Path&> signal_row_expanded();

  
  /**
   * @par Prototype:
   * <tt>void %row_collapsed(const TreeModel::iterator& iter, const TreeModel::Path& path)</tt>
   */
  Glib::SignalProxy2<void,const TreeModel::iterator&,const TreeModel::Path&> signal_row_collapsed();

  
  /**
   * @par Prototype:
   * <tt>void %cursor_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_cursor_changed();

  
  /**
   * @par Prototype:
   * <tt>void %columns_changed()</tt>
   */
  Glib::SignalProxy0<void> signal_columns_changed();


  //Don't wrap these. They are keybinding signals, and their API broke for GTK+ 2.2.
  
  
  Glib::PropertyProxy< Glib::RefPtr<TreeModel> > property_model();

  Glib::PropertyProxy<Adjustment*> property_hadjustment();

  Glib::PropertyProxy<Adjustment*> property_vadjustment();

  Glib::PropertyProxy<bool> property_headers_visible();

  Glib::PropertyProxy_WriteOnly<bool> property_headers_clickable();

  Glib::PropertyProxy<TreeViewColumn*> property_expander_column();

  Glib::PropertyProxy<bool> property_reorderable();

  Glib::PropertyProxy<bool> property_rules_hint();

  Glib::PropertyProxy<bool> property_enable_search();

  Glib::PropertyProxy<int> property_search_column();


protected:

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  template<class ColumnType> friend
  void _auto_store_on_cellrenderer_text_edited_string(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, Gtk::TreeView*);

  template <class ColumnType> friend
  void _auto_store_on_cellrenderer_text_edited_numerical(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, Gtk::TreeView*);
  
  void _auto_store_on_cellrenderer_toggle_edited(const Glib::ustring& path_string, int model_column);

  template<class ColumnType> friend
  void TreeView_Private::_connect_auto_store_editable_signal_handler(TreeView*, CellRenderer*, const TreeModelColumn<ColumnType>&);
#endif //DOXYGEN_SHOULD_SKIP_THIS


};


template <class ColumnType> inline
int TreeView::append_column(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column)
{
  // compilation will fail if there is no appropriate TreeViewColumn
  // constructor for this model column type.
  TreeViewColumn *const pViewColumn = Gtk::manage( new TreeViewColumn(title, model_column) );

  return append_column(*pViewColumn);
}

template <class ColumnType> inline
int TreeView::append_column_editable(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column)
{
  g_assert(model_column.type() != 0);

  // compilation will fail if there is no appropriate TreeViewColumn
  // constructor for this model column type.
  TreeViewColumn *const pViewColumn = Gtk::manage( new TreeViewColumn(title, model_column) );

  //connect signal handlers for auto-storing of edited cell data
  CellRenderer* pCellRender = pViewColumn->get_first_cell_renderer();
  TreeView_Private::_connect_auto_store_editable_signal_handler<ColumnType>(this, pCellRender, model_column);

  return append_column(*pViewColumn);
}

template <class ColumnType> inline
int TreeView::insert_column(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, int position)
{
  // compilation will fail if there is no appropriate TreeViewColumn
  // constructor for this model column type.
  TreeViewColumn *const pViewColumn = Gtk::manage( new TreeViewColumn(title, model_column) );

  return insert_column(*pViewColumn, position);
}

template <class ColumnType> inline
int TreeView::insert_column_editable(const Glib::ustring& title, const TreeModelColumn<ColumnType>& model_column, int position)
{
  // compilation will fail if there is no appropriate TreeViewColumn
  // constructor for this model column type.
  TreeViewColumn *const pViewColumn = Gtk::manage( new TreeViewColumn(title, model_column) );

   //connect signal handlers for auto-storing of edited cell data
  CellRenderer* pCellRender = pViewColumn->get_first_cell_renderer();
  TreeView_Private::_connect_auto_store_editable_signal_handler(this, pCellRender, model_column);

  return insert_column(*pViewColumn, position);
}


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace TreeView_Private
{

//Template specializations, for different model column types:
//TODO: Move these specializations into the .ccg file - I tried, but the int specialization was not used by the compiler. murrayc.

//bool specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<bool>& model_column)
{
  Gtk::CellRendererToggle* pCellToggle = dynamic_cast<Gtk::CellRendererToggle*>(pCellRenderer);
  if(pCellToggle)
  {
    //Set the appropriate property,
    pCellToggle->property_activatable() = true;

    //Connect to the appropriate signal, sending the model_column too,
    pCellToggle->signal_toggled().connect(
      SigC::bind( SigC::slot(*this_p, &Gtk::TreeView::_auto_store_on_cellrenderer_toggle_edited), model_column.index()) );
  }
}

//int specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<int>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Connect to the appropriate signal, sending the model_column too,
    pCellText->signal_edited().connect(
      SigC::bind( SigC::slot(_auto_store_on_cellrenderer_text_edited_numerical<int>), model_column.index(), this_p) );
  }
}

//unsigned int specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<unsigned int>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Connect to the appropriate signal, sending the model_column too,
    pCellText->signal_edited().connect(
      SigC::bind( SigC::slot(_auto_store_on_cellrenderer_text_edited_numerical<unsigned int>), model_column.index(), this_p) );
  }
}

//long specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<long>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Connect to the appropriate signal, sending the model_column too,
    pCellText->signal_edited().connect(
      SigC::bind( SigC::slot(_auto_store_on_cellrenderer_text_edited_numerical<long>), model_column.index(), this_p) );
  }
}

//unsigned long specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<unsigned long>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Connect to the appropriate signal, sending the model_column too,
    pCellText->signal_edited().connect(
      SigC::bind( SigC::slot(_auto_store_on_cellrenderer_text_edited_numerical<unsigned long>), model_column.index(), this_p) );
  }
}

//unsigned long specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<float>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Connect to the appropriate signal, sending the model_column too,
    pCellText->signal_edited().connect(
      SigC::bind( SigC::slot(_auto_store_on_cellrenderer_text_edited_numerical<float>), model_column.index(), this_p) );
  }
}

//unsigned long specialization:
template<> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<double>& model_column)
{
  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);
  if(pCellText)
  {
    //Set the appropriate property,
    pCellText->property_editable() = true;

    //Connect to the appropriate signal, sending the model_column too,
    pCellText->signal_edited().connect(
      SigC::bind( SigC::slot(_auto_store_on_cellrenderer_text_edited_numerical<double>), model_column.index(), this_p) );
  }
}


} // namespace TreeView_Private
#endif //DOXYGEN_SHOULD_SKIP_THIS


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace TreeView_Private
{

template <class ColumnType> inline
void _connect_auto_store_editable_signal_handler(Gtk::TreeView* this_p, Gtk::CellRenderer* pCellRenderer,  const Gtk::TreeModelColumn<ColumnType>& model_column)
{
  g_assert(model_column.type() != 0);

  //The different CellRenderers have different "edited" signals,
  //and numerical values need to convert the text value to a number,
  //so there are specializations for this tempate.

  Gtk::CellRendererText* pCellText = dynamic_cast<Gtk::CellRendererText*>(pCellRenderer);

  //Set the appropriate property,
  //and connect to the appropriate signal, sending the model_column too,
  if(pCellText)
  {
    pCellText->property_editable() = true;

    pCellText->signal_edited().connect(
      SigC::bind( SigC::slot(_auto_store_on_cellrenderer_text_edited_string<ColumnType>), model_column.index(), this_p) );
  }
}

template <class ColumnType> inline
void _auto_store_on_cellrenderer_text_edited_string(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, Gtk::TreeView* this_p)
{
  Gtk::TreePath path(path_string);

  //Get the row from the path:
  Glib::RefPtr<TreeModel> refModel = this_p->get_model();
  Gtk::TreeModel::iterator iter = refModel->get_iter(path);
  if(iter)
  {
      //Store the user's new text in the model:
      Gtk::TreeRow row = *iter;
      row.set_value(model_column, (ColumnType)new_text);
  }
}

template <class ColumnType> inline
void _auto_store_on_cellrenderer_text_edited_numerical(const Glib::ustring& path_string, const Glib::ustring& new_text, int model_column, Gtk::TreeView* this_p)
{
  //This is used on numerical model columns:

  Gtk::TreePath path(path_string);

  //Get the row from the path:
  Glib::RefPtr<TreeModel> refModel = this_p->get_model();
  Gtk::TreeModel::iterator iter = refModel->get_iter(path);
  if(iter)
  { 
    //std::istringstream astream(new_text); //Put it in a stream.
    //ColumnType new_value = ColumnType();
    //new_value << astream; //Get it out of the stream as the numerical type.
    
    //Convert the text to a number, using the same logic used by GtkCellRendererText when it stores numbers.
    char* pchEnd = 0;
    ColumnType new_value = static_cast<ColumnType>( strtod(new_text.c_str(), &pchEnd) );

    //Store the user's new text in the model:
    Gtk::TreeRow row = *iter;
    row.set_value(model_column, (ColumnType)new_value);
  }
}

} // namespace TreeView_Private
#endif //DOXYGEN_SHOULD_SKIP_THIS


} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::TreeView */
  Gtk::TreeView* wrap(GtkTreeView* object, bool take_copy = false);
}
#endif /* _GTKMM_TREEVIEW_H */

