// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_FRAME_H
#define _GTKMM_FRAME_H

#include <glibmm.h>

/* $Id: frame.hg,v 1.1.1.1 2003/01/21 13:38:50 murrayc Exp $ */

/* frame.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <gtkmm/bin.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkFrame GtkFrame;
typedef struct _GtkFrameClass GtkFrameClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Frame_Class; } // namespace Gtk
namespace Gtk
{

/** A Gtk::Bin with a decorative frame and optional label.
 *
 * The Frame widget surrounds its single child with a decorative frame and
 * an optional label.  If present, the label is drawn in a gap in the top
 * side of the frame. The position of the label can be controlled with
 * set_label_align().
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class Frame : public Bin
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Frame CppObjectType;
  typedef Frame_Class CppClassType;
  typedef GtkFrame BaseObjectType;
  typedef GtkFrameClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Frame();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Frame_Class;
  static CppClassType frame_class_;

  // noncopyable
  Frame(const Frame&);
  Frame& operator=(const Frame&);

protected:
  explicit Frame(const Glib::ConstructParams& construct_params);
  explicit Frame(GtkFrame* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkFrame*       gobj()       { return reinterpret_cast<GtkFrame*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkFrame* gobj() const { return reinterpret_cast<GtkFrame*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
  virtual void compute_child_allocation_vfunc(GtkAllocation* allocation);

  //Default Signal Handlers::


private:

public:

  Frame();
  explicit Frame(const Glib::ustring& label);

  /** Set the label to appear in the top edge of the frame.
   * Label alignment defaults to the upper left corner of the frame.
   */
  
  void set_label(const Glib::ustring& label);
  void unset_label();
  
  Glib::ustring get_label() const;

  
  void set_label_widget(Widget& label_widget);
  
  Widget* get_label_widget();
  
  const Widget* get_label_widget() const;

  /** Set the alignment of the Frame's label.
   * @param xalign The position of the label along the top edge of the widget.
   * A value of 0.0 represents left alignment; 1.0 represents right alignment.
   * The default value for a newly created Frame is 0.0.
   * @param yalign The y alignment of the label. Currently ignored.
   */
  
  void set_label_align(float xalign = 0.0, float yalign = 0.5);
  
  void set_label_align(AlignmentEnum xalign, AlignmentEnum yalign = Gtk::ALIGN_CENTER);

  
  void get_label_align(float& xalign, float& yalign) const;

  /** Sets shadow type of the frame.
   */
  
  void set_shadow_type(ShadowType type);
  
  ShadowType get_shadow_type() const;

  
  Glib::PropertyProxy<Glib::ustring> property_label();

  Glib::PropertyProxy<double> property_label_xalign();

  Glib::PropertyProxy<double> property_label_yalign();

  Glib::PropertyProxy<ShadowType> property_shadow_type();

  Glib::PropertyProxy<Widget*> property_label_widget();


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::Frame */
  Gtk::Frame* wrap(GtkFrame* object, bool take_copy = false);
}
#endif /* _GTKMM_FRAME_H */

