// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_FILESELECTION_H
#define _GTKMM_FILESELECTION_H

#include <glibmm.h>

/* $Id: fileselection.hg,v 1.1.1.1 2003/01/21 13:38:49 murrayc Exp $ */


/* fileselection.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/dialog.h>
#include <gtkmm/button.h>
#include <gtkmm/entry.h>
#include <gtkmm/label.h>
#include <gtkmm/box.h>
#include <gtkmm/treeview.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/optionmenu.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkFileSelection GtkFileSelection;
typedef struct _GtkFileSelectionClass GtkFileSelectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class FileSelection_Class; } // namespace Gtk
namespace Gtk
{

/** Prompt the user for a file or directory name.
 *
 * Gtk::FileSelection should be used to retrieve file or directory names from
 * the user. It will create a new dialog window containing a directory list,
 * and a file list corresponding to the current working directory. The
 * filesystem can be navigated using the directory list or the drop-down
 * history menu. Alternatively, the TAB key can be used to navigate using
 * filename completion - common in text based editors such as emacs and jed.
 *
 * @ingroup Dialogs
 */

class FileSelection : public Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef FileSelection CppObjectType;
  typedef FileSelection_Class CppClassType;
  typedef GtkFileSelection BaseObjectType;
  typedef GtkFileSelectionClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~FileSelection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class FileSelection_Class;
  static CppClassType fileselection_class_;

  // noncopyable
  FileSelection(const FileSelection&);
  FileSelection& operator=(const FileSelection&);

protected:
  explicit FileSelection(const Glib::ConstructParams& construct_params);
  explicit FileSelection(GtkFileSelection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GtkFileSelection*       gobj()       { return reinterpret_cast<GtkFileSelection*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GtkFileSelection* gobj() const { return reinterpret_cast<GtkFileSelection*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:

  
public:

  FileSelection();
  explicit FileSelection(const Glib::ustring& title);

  
  void set_filename(const std::string& filename);

  
  std::string get_filename() const;

  
  void complete(const Glib::ustring& pattern);
  
  void show_fileop_buttons();
  
  void hide_fileop_buttons();

  
  Glib::ArrayHandle<std::string> get_selections() const;

  
  void set_select_multiple(bool select_multiple = true);
  
  bool get_select_multiple() const;

  //: Accessors
  TreeView* get_dir_list();
  const TreeView* get_dir_list() const;
  TreeView* get_file_list();
  const TreeView* get_file_list() const;
  OptionMenu* get_history_pulldown();
  const OptionMenu* get_history_pulldown() const;
  Entry* get_selection_entry();
  const Entry* get_selection_entry() const;
  Label* get_selection_text();
  const Label* get_selection_text() const;
  VBox* get_main_vbox();
  const VBox* get_main_vbox() const;
  Button* get_ok_button();
  const Button* get_ok_button() const;
  Button* get_cancel_button();
  const Button* get_cancel_button() const;
  Button* get_help_button();
  const Button* get_help_button() const;
  HButtonBox* get_button_area();
  const HButtonBox* get_button_area() const;
  HBox* get_action_area();
  const HBox* get_action_area() const;

  Glib::PropertyProxy<bool> property_show_fileops();

  Glib::PropertyProxy<std::string> property_filename();

  Glib::PropertyProxy<bool> property_select_multiple();


};

} // namespace Gtk


namespace Glib
{
  /** @relates Gtk::FileSelection */
  Gtk::FileSelection* wrap(GtkFileSelection* object, bool take_copy = false);
}
#endif /* _GTKMM_FILESELECTION_H */

