// Generated by gtkmmproc -- DO NOT MODIFY!


#include <glibmm.h>

#include <gdkmm/pixmap.h>
#include <gdkmm/private/pixmap_p.h>


// -*- c++ -*-
/* $Id: pixmap.ccg,v 1.4 2004/03/10 01:17:36 murrayc Exp $ */

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gdkmm/window.h>
#include <gdkmm/display.h>
#include <gdk/gdk.h>


namespace Gdk
{

Glib::ObjectBase* Pixmap_Class::wrap_new(GObject* object)
{
  GdkPixmapObject *const pixmap_object = GDK_PIXMAP_OBJECT(object);

  g_return_val_if_fail(pixmap_object != 0, 0);

  // GdkPixmap and GdkBitmap are actually both of type GdkPixmapObject.
  // A Bitmap is is a Pixmap with a depth of 1.  Since these are distinct
  // types in gtkmm, we dynamically create either a Pixmap or a Bitmap,
  // depending on the depth field.

  if(pixmap_object->depth != 1)
    return new Gdk::Pixmap((GdkPixmap*) pixmap_object);
  else
    return new Gdk::Bitmap((GdkBitmap*) pixmap_object);
}


Pixmap::Pixmap(const Glib::RefPtr<Drawable>& drawable, int width, int height, int depth)
:
  Drawable((GdkDrawable*) gdk_pixmap_new(Glib::unwrap(drawable), width, height, depth))
{
  //gdk_pixmap_new() is implemented differently for x11, win32, etc,
  //so we can't really derived a new GType for GdkPixmap.
}

Pixmap::Pixmap(const Glib::RefPtr<Drawable>& drawable, const char* data, int width, int height, int depth,
               const Color& fg, const Color& bg)
:
  Drawable((GdkDrawable*) gdk_pixmap_create_from_data(
      Glib::unwrap(drawable), data, width, height, depth,
      const_cast<GdkColor*>(fg.gobj()), const_cast<GdkColor*>(bg.gobj())))
{
  //gdk_pixmap_new() is implemented differently for x11, win32, etc,
  //so we can't really derived a new GType for GdkPixmap.
}

Pixmap::Pixmap(const Glib::RefPtr<Display>& display, NativeWindow anid)
:
  Drawable( (GdkDrawable*) gdk_pixmap_foreign_new_for_display(Glib::unwrap(display), anid) )
{
  //gdk_pixmap_new() is implemented differently for x11, win32, etc,
  //so we can't really derived a new GType for GdkPixmap.
}

Glib::RefPtr<Pixmap> Pixmap::create_from_data(const Glib::RefPtr<const Drawable>& drawable,
                                              const char* data, int width, int height, int depth,
                                              const Color& fg, const Color& bg)
{
  GdkPixmap *const pixmap = gdk_pixmap_create_from_data(
      const_cast<GdkDrawable*>(Glib::unwrap<Drawable>(drawable)),
      const_cast<char*>(data), width, height, depth,
      const_cast<GdkColor*>(fg.gobj()),
      const_cast<GdkColor*>(bg.gobj()));

  return Glib::wrap((GdkPixmapObject*) pixmap);
}


Glib::RefPtr<Pixmap> Pixmap::create_from_xpm(const Glib::RefPtr<const Drawable>& drawable,
                                             const Color& transparent_color,
                                             const std::string& filename)
{
  GdkPixmap *const pixmap = gdk_pixmap_create_from_xpm(
      const_cast<GdkDrawable*>(Glib::unwrap<Drawable>(drawable)), 0,
      const_cast<GdkColor*>(transparent_color.gobj()),
      const_cast<char*>(filename.c_str()));

  return Glib::wrap((GdkPixmapObject*) pixmap);
}

Glib::RefPtr<Pixmap> Pixmap::create_from_xpm(const Glib::RefPtr<const Drawable>& drawable,
                                             Glib::RefPtr<Bitmap>& mask,
                                             const Color& transparent_color,
                                             const std::string& filename)
{
  GdkBitmap* bitmap = 0;

  GdkPixmap *const pixmap = gdk_pixmap_create_from_xpm(
      const_cast<GdkDrawable*>(Glib::unwrap<Drawable>(drawable)), &bitmap,
      const_cast<GdkColor*>(transparent_color.gobj()),
      const_cast<char*>(filename.c_str()));

  mask = Glib::RefPtr<Bitmap>::cast_dynamic(Glib::wrap((GdkPixmapObject*) bitmap));
  return Glib::wrap((GdkPixmapObject*) pixmap);
}

Glib::RefPtr<Pixmap> Pixmap::create_from_xpm(const Glib::RefPtr<const Drawable>& drawable,
                                             const Glib::RefPtr<Colormap>& colormap,
                                             Glib::RefPtr<Bitmap>& mask,
                                             const Color& transparent_color,
                                             const std::string& filename)
{
  GdkBitmap* bitmap = 0;

  GdkPixmap *const pixmap = gdk_pixmap_colormap_create_from_xpm(
      const_cast<GdkDrawable*>(Glib::unwrap<Drawable>(drawable)),
      Glib::unwrap(colormap), &bitmap,
      const_cast<GdkColor*>(transparent_color.gobj()),
      const_cast<char*>(filename.c_str()));

  mask = Glib::RefPtr<Bitmap>::cast_dynamic(Glib::wrap((GdkPixmapObject*) bitmap));
  return Glib::wrap((GdkPixmapObject*) pixmap);
}


Glib::RefPtr<Pixmap> Pixmap::create_from_xpm(const Glib::RefPtr<const Drawable>& drawable,
                                             Glib::RefPtr<Bitmap>& mask,
                                             const Color& transparent_color,
                                             const char* const* data)
{
  GdkBitmap* bitmap = 0;

  GdkPixmap *const pixmap = gdk_pixmap_create_from_xpm_d(
      const_cast<GdkDrawable*>(Glib::unwrap<Drawable>(drawable)),
      &bitmap,
      const_cast<GdkColor*>(transparent_color.gobj()),
      const_cast<char**>(data));

  mask = Glib::RefPtr<Bitmap>::cast_dynamic(Glib::wrap((GdkPixmapObject*) bitmap));
  return Glib::wrap((GdkPixmapObject*) pixmap);
}

Glib::RefPtr<Pixmap> Pixmap::create_from_xpm(const Glib::RefPtr<const Drawable>& drawable,
                                             const Glib::RefPtr<Colormap>& colormap,
                                             Glib::RefPtr<Bitmap>& mask,
                                             const Color& transparent_color,
                                             const char* const* data)
{
  GdkBitmap* bitmap = 0;

  GdkPixmap *const pixmap = gdk_pixmap_colormap_create_from_xpm_d(
      const_cast<GdkDrawable*>(Glib::unwrap<Drawable>(drawable)),
      Glib::unwrap(colormap), &bitmap,
      const_cast<GdkColor*>(transparent_color.gobj()),
      const_cast<char**>(data));

  mask = Glib::RefPtr<Bitmap>::cast_dynamic(Glib::wrap((GdkPixmapObject*) bitmap));
  return Glib::wrap((GdkPixmapObject*) pixmap);
}

Glib::RefPtr<Pixmap> Pixmap::create_from_xpm(const Glib::RefPtr<Colormap>& colormap,
                                             Glib::RefPtr<Bitmap>& mask,
                                             const Color& transparent_color,
                                             const char* const* data)
{
  GdkBitmap* bitmap = 0;

  GdkPixmap *const pixmap = gdk_pixmap_colormap_create_from_xpm_d(
      0, // drawable
      Glib::unwrap(colormap), &bitmap,
      const_cast<GdkColor*>(transparent_color.gobj()),
      const_cast<char**>(data));

  mask = Glib::RefPtr<Bitmap>::cast_dynamic(Glib::wrap((GdkPixmapObject*) bitmap));
  return Glib::wrap((GdkPixmapObject*) pixmap);
}

Glib::RefPtr<Pixmap> Pixmap::create_from_xpm(const Glib::RefPtr<Colormap>& colormap,
                                             Glib::RefPtr<Bitmap>& mask,
                                             const char* const* data)
{
  GdkBitmap* bitmap = 0;

  GdkPixmap *const pixmap = gdk_pixmap_colormap_create_from_xpm_d(
      0, // drawable
      Glib::unwrap(colormap), &bitmap,
      0, // transparent_color
      const_cast<char**>(data));

  mask = Glib::RefPtr<Bitmap>::cast_dynamic(Glib::wrap((GdkPixmapObject*) bitmap));
  return Glib::wrap((GdkPixmapObject*) pixmap);
}

} // namespace Gdk


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gdk::Pixmap> wrap(GdkPixmapObject* object, bool take_copy)
{
  return Glib::RefPtr<Gdk::Pixmap>( dynamic_cast<Gdk::Pixmap*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gdk
{


/* The *_Class implementation: */

const Glib::Class& Pixmap_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Pixmap_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gdk_pixmap_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Pixmap_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


}


/* The implementation: */

GdkPixmap* Pixmap::gobj_copy()
{
  reference();
  return gobj();
}

Pixmap::Pixmap(const Glib::ConstructParams& construct_params)
:
  Gdk::Drawable(construct_params)
{

}

Pixmap::Pixmap(GdkPixmap* castitem)
:
  Gdk::Drawable((GdkDrawable*)(castitem))
{}


Pixmap::~Pixmap()
{}


Pixmap::CppClassType Pixmap::pixmap_class_; // initialize static member

GType Pixmap::get_type()
{
  return pixmap_class_.init().get_type();
}


GType Pixmap::get_base_type()
{
  return gdk_pixmap_get_type();
}


Pixmap::Pixmap()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gdk::Drawable(Glib::ConstructParams(pixmap_class_.init()))
{
  

}

Glib::RefPtr<Pixmap> Pixmap::create(const Glib::RefPtr<Drawable>& drawable, int width, int height, int depth)
{
  return Glib::RefPtr<Pixmap>( new Pixmap(drawable, width, height, depth) );
}

Glib::RefPtr<Pixmap> Pixmap::create(const Glib::RefPtr<Drawable>& drawable, const char* data, int width, int height, int depth, const Color& fg, const Color& bg)
{
  return Glib::RefPtr<Pixmap>( new Pixmap(drawable, data, width, height, depth, fg, bg) );
}

Glib::RefPtr<Pixmap> Pixmap::create(const Glib::RefPtr<Display>& display, NativeWindow anid)
{
  return Glib::RefPtr<Pixmap>( new Pixmap(display, anid) );
}


} // namespace Gdk


