// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ACTION_H
#define _GTKMM_ACTION_H


#include <glibmm.h>

/* $Id: action.hg,v 1.19 2006/05/10 20:59:27 murrayc Exp $ */

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtkmm/accelgroup.h>
#include <gtkmm/stockid.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkAction GtkAction;
typedef struct _GtkActionClass GtkActionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class Action_Class; } // namespace Gtk
namespace Gtk
{

class ActionGroup;
class Menu;
class MenuItem;
class ToolItem;
class Image;

/** An action which can be triggered by a menu or toolbar item.
 *
 * Actions represent operations that the user can perform, along with 
 * some information about how it should be presented in the user interface. 
 * Each action provides methods to create icons, menu items and toolbar 
 * items representing itself.
 *
 * As well as the callback that is called when the action is activated, 
 * the following is also associated with the action:
 *
 *  - a name (not translated, for path lookup)
 *  - a label (translated, for display)
 *  - an accelerator
 *  - whether the label indicates a stock id
 *  - a tooltip (optional, translated)
 *  - a toolbar label (optional, shorter than label)
 *
 * The action will also have some state information:
 *
 *  - visible (shown/hidden)
 *  - sensitive (enabled/disabled)
 *
 * Apart from regular actions, there are toggle actions, 
 * which can be toggled between two states and radio actions, 
 * of which only one in a group can be in the "active" state. 
 * Other actions can be implemented as Gtk::Action subclasses.
 * 
 * Each action can have one or more proxy menu item, toolbar button or other proxy widgets. 
 * Proxies mirror the state of the action (text label, tooltip, icon, visible, sensitive, etc), and should change when the action's state changes. When the proxy is activated, it should activate its action.
 */

class Action : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Action CppObjectType;
  typedef Action_Class CppClassType;
  typedef GtkAction BaseObjectType;
  typedef GtkActionClass BaseClassType;

private:  friend class Action_Class;
  static CppClassType action_class_;

private:
  // noncopyable
  Action(const Action&);
  Action& operator=(const Action&);

protected:
  explicit Action(const Glib::ConstructParams& construct_params);
  explicit Action(GtkAction* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Action();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkAction*       gobj()       { return reinterpret_cast<GtkAction*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkAction* gobj() const { return reinterpret_cast<GtkAction*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkAction* gobj_copy();

private:

 
protected:
  /** Creates an empty action. */
  Action();

  /** Creates an action with a stock ID.
   * The stock ID is used to set a default icon, text and accelerator for the
   * action.
   *
   * @param name     A unique name for the action.
   * @param stock_id The stock icon to display in widgets representing the
   *                 action.
   * @param label    The label displayed in menu items and on buttons.
   * @param tooltip  A tooltip for the action.
   */
  explicit Action(const Glib::ustring& name, const StockID& stock_id = StockID(), const Glib::ustring& label = Glib::ustring(), const Glib::ustring& tooltip = Glib::ustring());

  /** Creates an action with an icon name.
   * The action's icon will reflect the specified icon name in the user's
   * icon theme.
   *
   * @param name      A unique name for the action.
   * @param icon_name An IconTheme icon name used for widgets representing the
   *                  action.
   * @param label     The label displayed in menu items and on buttons.
   * @param tooltip   A tooltip for the action.
   */
  explicit Action(const Glib::ustring& name, const Glib::ustring& icon_name, const Glib::ustring& label = Glib::ustring(), const Glib::ustring& tooltip = Glib::ustring());

public:
  //Note that gtk_action_new() does not allow name to be NULL, which suggests that we should not have a default constructor,
  //but it's OK to set the name later:
  
  static Glib::RefPtr<Action> create();


  /** Creates an action.
   *
   * @param name    A unique name for the action.
   * @param label   The label displayed in menu items and on buttons.
   * @param tooltip A tooltip for the action.
   *
   * @return A new Action.
   */
  static Glib::RefPtr<Action> create(const Glib::ustring& name, const Glib::ustring& label = Glib::ustring(), const Glib::ustring& tooltip = Glib::ustring());

  /** Creates an action with a stock ID.
   * The stock ID is used to set a default icon, text and accelerator for the
   * action.
   *
   * @param name     A unique name for the action.
   * @param stock_id The stock icon to display in widgets representing the
   *                 action.
   * @param label    The label displayed in menu items and on buttons.
   * @param tooltip  A tooltip for the action.
   *
   * @return A new Action.
   */
  static Glib::RefPtr<Action> create(const Glib::ustring& name, const Gtk::StockID& stock_id, const Glib::ustring& label = Glib::ustring(), const Glib::ustring& tooltip = Glib::ustring());

  /** Create an action with an icon name.
   * The action's icon will reflect the specified icon name in the user's
   * icon theme.
   *
   * @param name      A unique name for the action.
   * @param icon_name An IconTheme icon name used for widgets representing the
   *                  action.
   * @param label     The label displayed in menu items and on buttons.
   * @param tooltip   A tooltip for the action.
   *
   * @return A new Action.
   */
  static Glib::RefPtr<Action> create_with_icon_name(const Glib::ustring& name, const Glib::ustring& icon_name, const Glib::ustring& label, const Glib::ustring& tooltip);

  
  /** Return value: the name of the action. The string belongs to GTK+ and should not
   * @return The name of the action. The string belongs to GTK+ and should not
   * be freed.
   * 
   * @newin2p4.
   */
  Glib::ustring get_name() const;

  
  /** Return value: <tt>true</tt> if the action and its associated action group
   * @return <tt>true</tt> if the action and its associated action group 
   * are both sensitive.
   * 
   * @newin2p4.
   */
  bool is_sensitive() const;
  
  /** Return value: <tt>true</tt> if the action itself is sensitive.
   * @return <tt>true</tt> if the action itself is sensitive.
   * 
   * @newin2p4.
   */
  bool get_sensitive() const;

   void set_tooltip(const Glib::ustring& tooltip);

  
  /** Sets the ::sensitive property of the action to @a sensitive. Note that 
   * this doesn't necessarily mean effective sensitivity. See 
   * is_sensitive() 
   * for that.
   * 
   * @newin2p6
   * @param sensitive <tt>true</tt> to make the action sensitive.
   */
  void set_sensitive(bool sensitive = true);

  
  /** Return value: <tt>true</tt> if the action and its associated action group
   * @return <tt>true</tt> if the action and its associated action group 
   * are both visible.
   * 
   * @newin2p4.
   */
  bool is_visible() const;
  
  /** Return value: <tt>true</tt> if the action itself is visible.
   * @return <tt>true</tt> if the action itself is visible.
   * 
   * @newin2p4.
   */
  bool get_visible() const;
  
  /** Sets the ::visible property of the action to @a visible. Note that 
   * this doesn't necessarily mean effective visibility. See 
   * is_visible() 
   * for that.
   * 
   * @newin2p6
   * @param visible <tt>true</tt> to make the action visible.
   */
  void set_visible(bool visible = true);

  
  /** Emits the "activate" signal on the specified action, if it isn't 
   * insensitive. This gets called by the proxy widgets when they get 
   * activated.
   * 
   * It can also be used to manually activate an action.
   * 
   * @newin2p4
   */
  void activate();
  
  /** This function is intended for use by action implementations to
   * create icons displayed in the proxy widgets.
   * @param icon_size The size of the icon that should be created.
   * @return A widget that displays the icon for this action.
   * 
   * @newin2p4.
   */
  Image* create_icon(IconSize icon_size);
  
  /** Creates a menu item widget that proxies for the given action.
   * @return A menu item connected to the action.
   * 
   * @newin2p4.
   */
  MenuItem* create_menu_item();
  
  /** Creates a toolbar item widget that proxies for the given action.
   * @return A toolbar item connected to the action.
   * 
   * @newin2p4.
   */
  ToolItem* create_tool_item();
  
  /** If @a action provides a Gtk::Menu widget as a submenu for the menu
   * item or the toolbar item it creates, this function returns an
   * instance of that menu.
   * @return The menu item provided by the action, or <tt>0</tt>.
   * 
   * @newin2p12.
   */
  Menu* create_menu();
  
  /** Connects a widget to an action object as a proxy.  Synchronises 
   * various properties of the action with the widget (such as label 
   * text, icon, tooltip, etc), and attaches a callback so that the 
   * action gets activated when the proxy widget does.
   * 
   * If the widget is already connected to an action, it is disconnected
   * first.
   * 
   * @newin2p4
   * @param proxy The proxy widget.
   */
  void connect_proxy(Widget& proxy);
  
  /** Disconnects a proxy widget from an action.  
   * Does <em>not</em> destroy the widget, however.
   * 
   * @newin2p4
   * @param proxy The proxy widget.
   */
  void disconnect_proxy(Widget& proxy);

  
  /** Return value: a SList of proxy widgets. The list is owned by GTK+
   * @return A SList of proxy widgets. The list is owned by GTK+
   * and must not be modified.
   * 
   * @newin2p4.
   */
  Glib::SListHandle<Widget*> get_proxies();
  
  /** Return value: a SList of proxy widgets. The list is owned by GTK+
   * @return A SList of proxy widgets. The list is owned by GTK+
   * and must not be modified.
   * 
   * @newin2p4.
   */
  Glib::SListHandle<const Widget*> get_proxies() const;

  
  /** Installs the accelerator for @a action if @a action has an
   * accel path and group. See set_accel_path() and 
   * set_accel_group()
   * 
   * Since multiple proxies may independently trigger the installation
   * of the accelerator, the @a action counts the number of times this
   * function has been called and doesn't remove the accelerator until
   * disconnect_accelerator() has been called as many times.
   * 
   * @newin2p4
   */
  void connect_accelerator();
  
  /** Undoes the effect of one call to connect_accelerator().
   * 
   * @newin2p4
   */
  void disconnect_accelerator();
  
  
  /** Returns: the accel path for this action, or <tt>0</tt>
   * @return The accel path for this action, or <tt>0</tt>
   * if none is set. The returned string is owned by GTK+ 
   * and must not be freed or modified.
   */
  Glib::ustring get_accel_path() const;

  /// For instance, void on_activate();
  typedef sigc::slot<void> SlotActivate;
  
  /** The "activate" signal is emitted when the action is activated.
   *
   * @par Prototype:
   * <tt>void on_my_%activate()</tt>
   */

  Glib::SignalProxy0< void > signal_activate();


  //Used by AccelGroup:
  
  /** Sets the accel path for this action.  All proxy widgets associated
   * with the action will have this accel path, so that their
   * accelerators are consistent.
   * 
   * @newin2p4
   * @param accel_path The accelerator path.
   */
  void set_accel_path(const Glib::ustring& accel_path);
  
  /** Sets the Gtk::AccelGroup in which the accelerator for this action
   * will be installed.
   * 
   * @newin2p4
   * @param accel_group A Gtk::AccelGroup or <tt>0</tt>.
   */
  void set_accel_group(const Glib::RefPtr<AccelGroup>& accel_group);


  //gtk_action_get_accel_closure() is too C-specific:
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A unique name for the action.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The label used for menu items and buttons that activate this action.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The label used for menu items and buttons that activate this action.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A shorter label that may be used on toolbar buttons.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_short_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A shorter label that may be used on toolbar buttons.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_short_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A tooltip for this action.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_tooltip() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A tooltip for this action.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_tooltip() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The stock icon displayed in widgets representing this action.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<StockID> property_stock_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The stock icon displayed in widgets representing this action.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<StockID> property_stock_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the icon from the icon theme.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_icon_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the icon from the icon theme.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_icon_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a horizontal orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible_horizontal() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a horizontal orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible_horizontal() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a vertical orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible_vertical() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the toolbar item is visible when the toolbar is in a vertical orientation.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible_vertical() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** When TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible_overflown() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** When TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible_overflown() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the action is considered important. When TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_is_important() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the action is considered important. When TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_important() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** When TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_hide_if_empty() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** When TRUE
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_hide_if_empty() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the action is enabled.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_sensitive() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the action is enabled.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_sensitive() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the action is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the action is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkActionGroup this GtkAction is associated with
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<ActionGroup> > property_action_group() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The GtkActionGroup this GtkAction is associated with
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ActionGroup> > property_action_group() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
  //For use by child actions:  
  
  /** Disables calls to the activate()
   * function by signals on the given proxy widget.  This is used to
   * break notification loops for things like check or radio actions.
   * 
   * This function is intended for use by action implementations.
   * 
   * @newin2p4
   * @param proxy A proxy widget.
   */
  void block_activate_from(Widget& proxy);
  
  /** Re-enables calls to the activate()
   * function by signals on the given proxy widget.  This undoes the
   * blocking done by block_activate_from().
   * 
   * This function is intended for use by action implementations.
   * 
   * @newin2p4
   * @param proxy A proxy widget.
   */
  void unblock_activate_from(Widget& proxy);


protected: 
  //Widget-creation routines:
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Widget* create_menu_item_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Widget* create_tool_item_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void connect_proxy_vfunc(Widget* proxy);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void disconnect_proxy_vfunc(Widget* proxy);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_activate();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Action
   */
  Glib::RefPtr<Gtk::Action> wrap(GtkAction* object, bool take_copy = false);
}


#endif /* _GTKMM_ACTION_H */

