// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_FILECHOOSER_H
#define _GTKMM_FILECHOOSER_H


#include <glibmm.h>

/* $Id: filechooser.hg,v 1.23 2006/04/18 13:28:56 murrayc Exp $ */

/* Copyright (C) 2003 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/widget.h>
#include <gtkmm/filefilter.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkFileChooser GtkFileChooser;
typedef struct _GtkFileChooserClass GtkFileChooserClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class FileChooser_Class; } // namespace Gtk
namespace Gtk
{

/** @addtogroup gtkmmEnums Enums and Flags */

/**
 * @ingroup gtkmmEnums
 */
enum FileChooserAction
{
  FILE_CHOOSER_ACTION_OPEN,
  FILE_CHOOSER_ACTION_SAVE,
  FILE_CHOOSER_ACTION_SELECT_FOLDER,
  FILE_CHOOSER_ACTION_CREATE_FOLDER
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::FileChooserAction> : public Glib::Value_Enum<Gtk::FileChooserAction>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{

/**
 * @ingroup gtkmmEnums
 */
enum FileChooserConfirmation
{
  FILE_CHOOSER_CONFIRMATION_CONFIRM,
  FILE_CHOOSER_CONFIRMATION_ACCEPT_FILENAME,
  FILE_CHOOSER_CONFIRMATION_SELECT_AGAIN
};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::FileChooserConfirmation> : public Glib::Value_Enum<Gtk::FileChooserConfirmation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


//TODO: //Is GTK_FILE_SYSTEM_ERROR really part of the public API? For instance, do app writers ever need to check for it?.
//If so, then it needs to have a generated get_type() function, like the others. murrayc.
//_TODO_GERROR(FileSystemError,GtkFileSystemError,GTK_FILE_SYSTEM_ERROR)

/** Exception class for Gdk::FileChooser errors.
 */
class FileChooserError : public Glib::Error
{
public:
  enum Code
  {
    NONEXISTENT,
    BAD_FILENAME,
    ALREADY_EXISTS
  };

  FileChooserError(Code error_code, const Glib::ustring& error_message);
  explicit FileChooserError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::FileChooserError::Code> : public Glib::Value_Enum<Gtk::FileChooserError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{


/**
 * Gtk::FileChooser is an interface that can be implemented by file selection
 * widgets. In gtkmm, the main objects that implement this interface are
 * FileChooserWidget and FileChooserDialog. You do not need to write an
 * object that implements the FileChooser interface unless you are trying to
 * adapt an existing file selector to expose a standard programming interface.
 *
 * @par File Names and Encodings
 * When the user is finished selecting files in a FileChooser, your program
 * can get the selected names either as filenames or as URIs. For URIs, the
 * normal escaping rules are applied if the URI contains non-ASCII characters.
 * However, filenames are always returned in the character set specified by the
 * G_FILENAME_ENCODING environment variable. Please see the Glib documentation
 * for more details about this variable.
 *
 * @par Important
 * This means that while you can pass the result of FileChooser::get_filename()
 * to <tt>open(2)</tt> or <tt>fopen(3)</tt>, you may not be able to directly
 * set it as the text of a Gtk::Label widget unless you convert it first to
 * UTF-8, which all gtkmm widgets expect. You should use
 * Glib::filename_to_utf8() to convert filenames into strings that can be
 * passed to gtkmm widgets.
 *
 * @note
 * The gtkmm FileChooser API is broken in that methods return Glib::ustring
 * even though the returned string is not necessarily UTF-8 encoded.  Any
 * FileChooser method that takes or returns a filename (not a URI) should
 * have std::string as parameter or return type.  Fortunately this mistake
 * doesn't prevent you from handling filenames correctly in your application.
 * Just pretend that the API uses std::string and call Glib::filename_to_utf8()
 * or Glib::filename_from_utf8() as appropriate.
 *
 * See http://bugzilla.gnome.org/show_bug.cgi?id=142138 for more information.
 */

class FileChooser : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef FileChooser CppObjectType;
  typedef FileChooser_Class CppClassType;
  typedef GtkFileChooser BaseObjectType;
  typedef GtkFileChooserClass BaseClassType;

private:
  friend class FileChooser_Class;
  static CppClassType filechooser_class_;

  // noncopyable
  FileChooser(const FileChooser&);
  FileChooser& operator=(const FileChooser&);

protected:
  FileChooser(); // you must derive from this class
  explicit FileChooser(GtkFileChooser* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~FileChooser();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkFileChooser*       gobj()       { return reinterpret_cast<GtkFileChooser*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GtkFileChooser* gobj() const { return reinterpret_cast<GtkFileChooser*>(gobject_); }

private:

public:

  
  /** Sets the type of operation that the chooser is performing; the
   * user interface is adapted to suit the selected action. For example,
   * an option to create a new folder might be shown if the action is
   * Gtk::FILE_CHOOSER_ACTION_SAVE but not if the action is
   * Gtk::FILE_CHOOSER_ACTION_OPEN.
   * 
   * @newin2p4
   * @param action The action that the file selector is performing.
   */
  void set_action(FileChooserAction action);
  
  /** Gets the type of operation that the file chooser is performing; see
   * set_action().
   * @return The action that the file selector is performing
   * 
   * @newin2p4.
   */
  FileChooserAction get_action() const;
  
  /** Sets whether only local files can be selected in the
   * file selector. If @a local_only  is <tt>true</tt> (the default),
   * then the selected file are files are guaranteed to be
   * accessible through the operating systems native file
   * file system and therefore the application only
   * needs to worry about the filename functions in
   * Gtk::FileChooser, like get_filename(),
   * rather than the URI functions like
   * get_uri(),
   * 
   * @newin2p4
   * @param local_only <tt>true</tt> if only local files can be selected.
   */
  void set_local_only(bool local_only = true);
  
  /** Gets whether only local files can be selected in the
   * file selector. See set_local_only()
   * @return <tt>true</tt> if only local files can be selected.
   * 
   * @newin2p4.
   */
  bool get_local_only() const;
  
  /** Sets whether multiple files can be selected in the file selector.  This is
   * only relevant if the action is set to be GTK_FILE_CHOOSER_ACTION_OPEN or
   * GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER.  
   * 
   * @newin2p4
   * @param select_multiple <tt>true</tt> if multiple files can be selected.
   */
  void set_select_multiple(bool select_multiple = true);
  
  /** Gets whether multiple files can be selected in the file
   * selector. See set_select_multiple().
   * @return <tt>true</tt> if multiple files can be selected.
   * 
   * @newin2p4.
   */
  bool get_select_multiple() const;

  
  /** Sets whether hidden files and folders are displayed in the file selector.  
   * 
   * @newin2p6
   * @param show_hidden <tt>true</tt> if hidden files and folders should be displayed.
   */
  void set_show_hidden(bool show_hidden = true);
  
  /** Gets whether hidden files and folders are displayed in the file selector.   
   * See set_show_hidden().
   * @return <tt>true</tt> if hidden files and folders are displayed.
   * 
   * @newin2p6.
   */
  bool get_show_hidden() const;

  
  /** Sets whether a file chooser in GTK_FILE_CHOOSER_ACTION_SAVE mode will present
   * a confirmation dialog if the user types a file name that already exists.  This
   * is <tt>false</tt> by default.
   * 
   * Regardless of this setting, the @a chooser  will emit the "confirm-overwrite"
   * signal when appropriate.
   * 
   * If all you need is the stock confirmation dialog, set this property to <tt>true</tt>.
   * You can override the way confirmation is done by actually handling the
   * "confirm-overwrite" signal; please refer to its documentation for the
   * details.
   * 
   * @newin2p8
   * @param do_overwrite_confirmation Whether to confirm overwriting in save mode.
   */
  void set_do_overwrite_confirmation(bool do_overwrite_confirmation = true);
  
  /** Queries whether a file chooser is set to confirm for overwriting when the user
   * types a file name that already exists.
   * @return <tt>true</tt> if the file chooser will present a confirmation dialog;
   * <tt>false</tt> otherwise.
   * 
   * @newin2p8.
   */
  bool get_do_overwrite_confirmation() const;

  
  /** Sets the current name in the file selector, as if entered
   * by the user. Note that the name passed in here is a UTF-8
   * string rather than a filename. This function is meant for
   * such uses as a suggested name in a "Save As..." dialog.
   * 
   * If you want to preselect a particular existing file, you should use
   * set_filename() or set_uri() instead.
   * Please see the documentation for those functions for an example of using
   * set_current_name() as well.
   * 
   * @newin2p4
   * @param name The filename to use, as a UTF-8 string.
   */
  void set_current_name(const Glib::ustring& name);
  
  /** Gets the filename for the currently selected file in
   * the file selector. If multiple files are selected,
   * one of the filenames will be returned at random.
   * 
   * If the file chooser is in folder mode, this function returns the selected
   * folder.
   * @return The currently selected filename, or an empty string
   * if no file is selected, or the selected file can't
   * be represented with a local filename.
   */
  Glib::ustring get_filename() const;
  
  /** Sets @a filename  as the current filename for the file chooser, by changing
   * to the file's parent folder and actually selecting the file in list.  If
   * the @a chooser  is in Gtk::FILE_CHOOSER_ACTION_SAVE mode, the file's base name
   * will also appear in the dialog's file name entry.
   * 
   * If the file name isn't in the current folder of @a chooser , then the current
   * folder of @a chooser  will be changed to the folder containing @a filename . This
   * is equivalent to a sequence of unselect_all() followed by
   * select_filename().
   * 
   * Note that the file must exist, or nothing will be done except
   * for the directory change.
   * 
   * If you are implementing a &lt;guimenuitem&gt;File/Save As...&lt;/guimenuitem&gt; dialog, you
   * should use this function if you already have a file name to which the user may save; for example,
   * when the user opens an existing file and then does &lt;guimenuitem&gt;File/Save As...&lt;/guimenuitem&gt;
   * on it.  If you don't have a file name already  @htmlonly&mdash;@endhtmlonly  for example, if the user just created
   * a new file and is saving it for the first time, do not call this function.  Instead, use
   * something similar to this:
   * 
   * 
   * if (document_is_new)
   * {
   * /&lt;!-- --&gt;* the user just created a new document *&lt;!-- --&gt;/
   * gtk_file_chooser_set_current_folder (chooser, default_folder_for_saving);
   * gtk_file_chooser_set_current_name (chooser, "Untitled document");
   * }
   * else
   * {
   * /&lt;!-- --&gt;* the user edited an existing document *&lt;!-- --&gt;/ 
   * gtk_file_chooser_set_filename (chooser, existing_filename);
   * }
   * 
   * @param filename The filename to set as current.
   * @return <tt>true</tt> if both the folder could be changed and the file was
   * selected successfully, <tt>false</tt> otherwise.
   * 
   * @newin2p4.
   */
  bool set_filename(const Glib::ustring& filename);
  
  /** Selects a filename. If the file name isn't in the current
   * folder of @a chooser , then the current folder of @a chooser  will
   * be changed to the folder containing @a filename .
   * @param filename The filename to select.
   * @return <tt>true</tt> if both the folder could be changed and the file was
   * selected successfully, <tt>false</tt> otherwise.
   * 
   * @newin2p4.
   */
  bool select_filename(const Glib::ustring& filename);
  
  /** Unselects a currently selected filename. If the filename
   * is not in the current directory, does not exist, or
   * is otherwise not currently selected, does nothing.
   * 
   * @newin2p4
   * @param filename The filename to unselect.
   */
  void unselect_filename(const Glib::ustring& filename);
  
  /** Selects all the files in the current folder of a file chooser.
   * 
   * @newin2p4
   */
  void select_all();
  
  /** Unselects all the files in the current folder of a file chooser.
   * 
   * @newin2p4
   */
  void unselect_all();
  
  /** Lists all the selected files and subfolders in the current folder of
   *  @a chooser . The returned names are full absolute paths. If files in the current
   * folder cannot be represented as local filenames they will be ignored. (See
   * get_uris())
   * @return A list containing the filenames of all selected
   * files and subfolders in the current folder.
   * 
   * @newin2p4.
   */
  Glib::SListHandle<Glib::ustring> get_filenames() const;
  
  /** Sets the current folder for @a chooser  from a local filename.
   * The user will be shown the full contents of the current folder,
   * plus user interface elements for navigating to other folders.
   * @param filename The full path of the new current folder.
   * @return <tt>true</tt> if the folder could be changed successfully, <tt>false</tt>
   * otherwise.
   * 
   * @newin2p4.
   */
  bool set_current_folder(const Glib::ustring& filename);
  
  /** Gets the current folder of @a chooser  as a local filename.
   * See set_current_folder().
   * @return The full path of the current folder, possibly empty if the current
   * path cannot be represented as a local filename.  This function may also return
   * and empty string if the file chooser was unable to load the last folder that was
   * requested from it; for example, as would be for calling
   * set_current_folder() on a nonexistent folder.
   * 
   * @newin2p4.
   */
  Glib::ustring get_current_folder() const;


/* URI manipulation
 */
  
  /** Gets the URI for the currently selected file in
   * the file selector. If multiple files are selected,
   * one of the filenames will be returned at random.
   * 
   * If the file chooser is in folder mode, this function returns the selected
   * folder.
   * @return The currently selected URI, or an empty string
   * if no file is selected.
   */
  Glib::ustring get_uri() const;
  
  /** Sets the file referred to by @a uri  as the current file for the file chooser,
   * by changing to the URI's parent folder and actually selecting the URI in the
   * list.  If the @a chooser  is Gtk::FILE_CHOOSER_ACTION_SAVE mode, the URI's base
   * name will also appear in the dialog's file name entry.
   * 
   * If the URI isn't in the current folder of @a chooser , then the current folder
   * of @a chooser  will be changed to the folder containing @a uri . This is equivalent
   * to a sequence of unselect_all() followed by
   * select_uri().
   * 
   * Note that the URI must exist, or nothing will be done except
   * for the directory change.
   * If you are implementing a &lt;guimenuitem&gt;File/Save As...&lt;/guimenuitem&gt; dialog, you
   * should use this function if you already have a file name to which the user may save; for example,
   * when the user opens an existing file and then does &lt;guimenuitem&gt;File/Save As...&lt;/guimenuitem&gt;
   * on it.  If you don't have a file name already  @htmlonly&mdash;@endhtmlonly  for example, if the user just created
   * a new file and is saving it for the first time, do not call this function.  Instead, use
   * something similar to this:
   * 
   * 
   * if (document_is_new)
   * {
   * /&lt;!-- --&gt;* the user just created a new document *&lt;!-- --&gt;/
   * gtk_file_chooser_set_current_folder_uri (chooser, default_folder_for_saving);
   * gtk_file_chooser_set_current_name (chooser, "Untitled document");
   * }
   * else
   * {
   * /&lt;!-- --&gt;* the user edited an existing document *&lt;!-- --&gt;/ 
   * gtk_file_chooser_set_uri (chooser, existing_uri);
   * }
   * 
   * @param uri The URI to set as current.
   * @return <tt>true</tt> if both the folder could be changed and the URI was
   * selected successfully, <tt>false</tt> otherwise.
   * 
   * @newin2p4.
   */
  bool set_uri(const Glib::ustring& uri);
  
  /** Selects the file to by @a uri . If the URI doesn't refer to a
   * file in the current folder of @a chooser , then the current folder of
   *  @a chooser  will be changed to the folder containing @a filename .
   * @param uri The URI to select.
   * @return <tt>true</tt> if both the folder could be changed and the URI was
   * selected successfully, <tt>false</tt> otherwise.
   * 
   * @newin2p4.
   */
  bool select_uri(const Glib::ustring& uri);
  
  /** Unselects the file referred to by @a uri . If the file
   * is not in the current directory, does not exist, or
   * is otherwise not currently selected, does nothing.
   * 
   * @newin2p4
   * @param uri The URI to unselect.
   */
  void unselect_uri(const Glib::ustring& uri);
  
  /** Lists all the selected files and subfolders in the current folder of
   *  @a chooser . The returned names are full absolute URIs.
   * @return A list containing the URIs of all selected
   * files and subfolders in the current folder.
   * 
   * @newin2p4.
   */
  Glib::SListHandle<Glib::ustring> get_uris() const;

  
  /** Sets the current folder for @a chooser  from an URI.
   * The user will be shown the full contents of the current folder,
   * plus user interface elements for navigating to other folders.
   * @param uri The URI for the new current folder.
   * @return <tt>true</tt> if the folder could be changed successfully, <tt>false</tt>
   * otherwise.
   * 
   * @newin2p4.
   */
  bool set_current_folder_uri(const Glib::ustring& uri);
  
  /** Gets the current folder of @a chooser  as an URI.
   * See set_current_folder_uri().
   * 
   * Note that this is the folder that the file chooser is currently displaying
   * (e.g. "file:///home/username/Documents"), which is <em>not the same</em>
   * as the currently-selected folder if the chooser is in
   * Gtk::FILE_CHOOSER_SELECT_FOLDER mode
   * (e.g. "file:///home/username/Documents/selected-folder/".  To get the
   * currently-selected folder in that mode, use get_uri() as the
   * usual way to get the selection.
   * @return The URI for the current folder.
   */
  Glib::ustring get_current_folder_uri() const;

/* Preview widget
 */
  
  /** Sets an application-supplied widget to use to display a custom preview
   * of the currently selected file. To implement a preview, after setting the
   * preview widget, you connect to the ::update-preview
   * signal, and call get_preview_filename() or
   * get_preview_uri() on each change. If you can
   * display a preview of the new file, update your widget and
   * set the preview active using set_preview_widget_active().
   * Otherwise, set the preview inactive.
   * 
   * When there is no application-supplied preview widget, or the
   * application-supplied preview widget is not active, the file chooser
   * may display an internally generated preview of the current file or
   * it may display no preview at all.
   * 
   * @newin2p4
   * @param preview_widget Widget for displaying preview.
   */
  void set_preview_widget(Gtk::Widget& preview_widget);
  
  /** Gets the current preview widget; see
   * set_preview_widget().
   * @return The current preview widget, or <tt>0</tt>
   * 
   * @newin2p4.
   */
  const Gtk::Widget* get_preview_widget() const;
  
  /** Gets the current preview widget; see
   * set_preview_widget().
   * @return The current preview widget, or <tt>0</tt>
   * 
   * @newin2p4.
   */
  Gtk::Widget* get_preview_widget();
  
  /** Sets whether the preview widget set by
   * set_preview_widget() should be shown for the
   * current filename. When @a active  is set to false, the file chooser
   * may display an internally generated preview of the current file
   * or it may display no preview at all. See
   * set_preview_widget() for more details.
   * 
   * @newin2p4
   * @param active Whether to display the user-specified preview widget.
   */
  void set_preview_widget_active(bool active = true);
  
  /** Gets whether the preview widget set by set_preview_widget()
   * should be shown for the current filename. See
   * set_preview_widget_active().
   * @return <tt>true</tt> if the preview widget is active for the current filename.
   * 
   * @newin2p4.
   */
  bool get_preview_widget_active() const;

  
  /** Sets whether the file chooser should display a stock label with the name of
   * the file that is being previewed; the default is <tt>true</tt>.  Applications that
   * want to draw the whole preview area themselves should set this to <tt>false</tt> and
   * display the name themselves in their preview widget.
   * 
   * See also: set_preview_widget()
   * 
   * @newin2p4
   * @param use_label Whether to display a stock label with the name of the previewed file.
   */
  void set_use_preview_label(bool use_label = true);
  
  /** Gets whether a stock label should be drawn with the name of the previewed
   * file.  See set_use_preview_label().
   * @return <tt>true</tt> if the file chooser is set to display a label with the
   * name of the previewed file, <tt>false</tt> otherwise.
   */
  bool get_use_preview_label() const;

  
  /** Gets the filename that should be previewed in a custom preview
   * widget. See set_preview_widget().
   * @return The filename to preview, or an empty string if no file
   * is selected, or if the selected file cannot be represented
   * as a local filename.
   */
  Glib::ustring get_preview_filename() const;
  
  /** Gets the URI that should be previewed in a custom preview
   * widget. See set_preview_widget().
   * @return The URI for the file to preview, or an empty string if no file is
   * selected.
   */
  Glib::ustring get_preview_uri() const;

/* Extra widget
 */
  
  /** Sets an application-supplied widget to provide extra options to the user.
   * 
   * @newin2p4
   * @param extra_widget Widget for extra options.
   */
  void set_extra_widget(Gtk::Widget& extra_widget);
  
  /** Gets the current preview widget; see
   * set_extra_widget().
   * @return The current extra widget, or <tt>0</tt>
   * 
   * @newin2p4.
   */
  Gtk::Widget* get_extra_widget();
  
  /** Gets the current preview widget; see
   * set_extra_widget().
   * @return The current extra widget, or <tt>0</tt>
   * 
   * @newin2p4.
   */
  const Gtk::Widget* get_extra_widget() const;

/* List of user selectable filters
 */
  
  /** Adds @a filter  to the list of filters that the user can select between.
   * When a filter is selected, only files that are passed by that
   * filter are displayed. 
   * 
   * Note that the @a chooser  takes ownership of the filter, so you have to 
   * ref and sink it if you want to keep a reference.
   * 
   * @newin2p4
   * @param filter A Gtk::FileFilter.
   */
  void add_filter(const FileFilter& filter);
  
  /** Removes @a filter  from the list of filters that the user can select between.
   * 
   * @newin2p4
   * @param filter A Gtk::FileFilter.
   */
  void remove_filter (const FileFilter& filter);

  
  /** Lists the current set of user-selectable filters; see
   * add_filter(), remove_filter().
   * @return A list containing the current set of
   * user selectable filters.
   * 
   * @newin2p4.
   */
  Glib::SListHandle< FileFilter* > list_filters();
  
  /** Lists the current set of user-selectable filters; see
   * add_filter(), remove_filter().
   * @return A list containing the current set of
   * user selectable filters.
   * 
   * @newin2p4.
   */
  Glib::SListHandle< const FileFilter* > list_filters() const;
  
/* Current filter
 */
  
  /** Sets the current filter; only the files that pass the
   * filter will be displayed. If the user-selectable list of filters
   * is non-empty, then the filter should be one of the filters
   * in that list. Setting the current filter when the list of
   * filters is empty is useful if you want to restrict the displayed
   * set of files without letting the user change it.
   * 
   * @newin2p4
   * @param filter A Gtk::FileFilter.
   */
  void set_filter(const FileFilter& filter);
  
  /** Gets the current filter; see set_filter().
   * @return The current filter, or <tt>0</tt>
   * 
   * @newin2p4.
   */
  FileFilter* get_filter();
  
  /** Gets the current filter; see set_filter().
   * @return The current filter, or <tt>0</tt>
   * 
   * @newin2p4.
   */
  const FileFilter* get_filter() const;
  
/* Per-application shortcut folders */

  
  /** Adds a folder to be displayed with the shortcut folders in a file chooser.
   * Note that shortcut folders do not get saved, as they are provided by the
   * application.  For example, you can use this to add a
   * "/usr/share/mydrawprogram/Clipart" folder to the volume list.
   * @param folder Filename of the folder to add.
   * @return <tt>true</tt> if the folder could be added successfully, <tt>false</tt>
   * otherwise.  In the latter case, the @a error  will be set as appropriate.
   * 
   * @newin2p4.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool add_shortcut_folder(const Glib::ustring& folder);
#else
  bool add_shortcut_folder(const Glib::ustring& folder, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Removes a folder from a file chooser's list of shortcut folders.
   * @param folder Filename of the folder to remove.
   * @return <tt>true</tt> if the operation succeeds, <tt>false</tt> otherwise.  
   * In the latter case, the @a error  will be set as appropriate.
   * 
   * See also: add_shortcut_folder()
   * 
   * @newin2p4.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool remove_shortcut_folder(const Glib::ustring& folder);
#else
  bool remove_shortcut_folder(const Glib::ustring& folder, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Queries the list of shortcut folders in the file chooser, as set by
   * add_shortcut_folder().
   * 
   * @newin2p4
   * @return A list of folder filenames, if there are any shortcut
   * folders..
   */
  Glib::SListHandle<Glib::ustring> list_shortcut_folders() const;

  
  /** Adds a folder URI to be displayed with the shortcut folders in a file
   * chooser.  Note that shortcut folders do not get saved, as they are provided
   * by the application.  For example, you can use this to add a
   * "file:///usr/share/mydrawprogram/Clipart" folder to the volume list.
   * @param uri URI of the folder to add.
   * @return <tt>true</tt> if the folder could be added successfully, <tt>false</tt>
   * otherwise.  In the latter case, the @a error  will be set as appropriate.
   * 
   * @newin2p4.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool add_shortcut_folder_uri(const Glib::ustring& uri);
#else
  bool add_shortcut_folder_uri(const Glib::ustring& uri, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Removes a folder URI from a file chooser's list of shortcut folders.
   * @param uri URI of the folder to remove.
   * @return <tt>true</tt> if the operation succeeds, <tt>false</tt> otherwise.  
   * In the latter case, the @a error  will be set as appropriate.
   * 
   * See also: add_shortcut_folder_uri()
   * 
   * @newin2p4.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool remove_shortcut_folder_uri(const Glib::ustring& uri);
#else
  bool remove_shortcut_folder_uri(const Glib::ustring& uri, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Queries the list of shortcut folders in the file chooser, as set by
   * add_shortcut_folder_uri().
   * @return A list of folder URIs
   * 
   * @newin2p4.
   */
  Glib::SListHandle<Glib::ustring> list_shortcut_folder_uris() const;

  
  /** This signal is emitted when the current folder in a FileChooser
   * changes.  This can happen due to the user performing some action that
   * changes folders, such as selecting a bookmark or visiting a folder on the
   * file list.  It can also happen as a result of calling a function to
   * explicitly change the current folder in a file chooser.
   *
   * Normally you do not need to connect to this signal, unless you need to keep
   * track of which folder a file chooser is showing.
   *
   * @see set_current_folder(), get_current_folder(),
   * set_current_folder_uri(), get_current_folder_uri().
   *
   * @par Prototype:
   * <tt>void on_my_%current_folder_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_current_folder_changed();

  
  /** This signal is emitted when there is a change in the set of selected files
   * in a #GtkFileChooser.  This can happen when the user modifies the selection
   * with the mouse or the keyboard, or when explicitly calling functions to
   * change the selection.
   *
   * Normally you do not need to connect to this signal, as it is easier to wait
   * for the file chooser to finish running, and then to get the list of
   * selected files using the functions mentioned below.
   *
   * @see select_filename(), unselect_filename(), get_filename(),
   * get_filenames(), select_uri(),
   * unselect_uri(), get_uri(),
   * get_uris().
   *
   * @par Prototype:
   * <tt>void on_my_%selection_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_selection_changed();

  
  /** This signal is emitted when the preview in a file chooser should be
   * regenerated.  For example, this can happen when the currently selected file
   * changes.  You should use this signal if you want your file chooser to have
   * a preview widget.
   *
   * Once you have installed a preview widget with
   * set_preview_widget(), you should update it when this
   * signal is emitted.  You can use the functions
   * get_preview_filename() or get_preview_uri() to get the name of the file to preview.
   * Your widget may not be able to preview all kinds of files; your signal handler
   * must call set_preview_wiget_active() to inform the file
   * chooser about whether the preview was generated successfully or not.
   *
   * @see set_preview_widget(), set_preview_widget_active(),
   * set_use_preview_label(), get_preview_filename(), get_preview_uri().
   *
   * @par Prototype:
   * <tt>void on_my_%update_preview()</tt>
   */

  Glib::SignalProxy0< void > signal_update_preview();

  
  /** This signal is emitted when the user "activates" a file in the file
   * chooser.  This can happen by double-clicking on a file in the file list, or
   * by pressing <keycap>Enter</keycap>.
   *
   * Normally you do not need to connect to this signal.  It is used internally
   * by FileChooserDialog to know when to activate the default button in the
   * dialog.
   *
   * @see get_filename(), get_filenames(), get_uri(), get_uris().
   *
   * @par Prototype:
   * <tt>void on_my_%file_activated()</tt>
   */

  Glib::SignalProxy0< void > signal_file_activated();


  /** TODO
   *
   * @par Prototype:
   * <tt>FileChooserConfirmation on_my_%confirm_overwrite()</tt>
   */

  Glib::SignalProxy0< FileChooserConfirmation > signal_confirm_overwrite();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<FileChooserAction> property_action() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<FileChooserAction> property_action() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  //TODO: _WRAP_PROPERTY("file-system", FileSystem) //FileSystem is not really public API.
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<FileFilter*> property_filter() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<FileFilter*> property_filter() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_folder_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_folder_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_local_only() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_local_only() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Widget*> property_preview_widget() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Widget*> property_preview_widget() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_preview_widget_active() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_preview_widget_active() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_use_preview_label() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_use_preview_label() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Widget*> property_extra_widget() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Widget*> property_extra_widget() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_select_multiple() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_select_multiple() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_show_hidden() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_show_hidden() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_do_overwrite_confirmation() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_do_overwrite_confirmation() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::FileChooser
   */
  Glib::RefPtr<Gtk::FileChooser> wrap(GtkFileChooser* object, bool take_copy = false);

} // namespace Glib


#endif /* _GTKMM_FILECHOOSER_H */

