// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKMM_ASPECTFRAME_H
#define _GTKMM_ASPECTFRAME_H

#include <glibmm.h>

/* $Id: aspectframe.hg,v 1.18 2002/10/28 11:16:09 murrayc Exp $ */

/* aspectframe.h
 * 
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/frame.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkAspectFrame GtkAspectFrame;
typedef struct _GtkAspectFrameClass GtkAspectFrameClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gtk
{ class AspectFrame_Class; } // namespace Gtk
namespace Gtk
{

/** A frame that constrains its child to a particular aspect ratio.
 *
 * The Gtk::AspectFrame is useful when you want pack a widget so that it can
 * resize but always retains the same aspect ratio.  For instance, one might
 * be drawing a small preview of a larger image. Because it derives from
 * Gtk::Frame, it can draw a label and a frame around the child. The frame
 * will be "shrink-wrapped" to the size of the child.
 *
 * @ingroup Widgets
 * @ingroup Containers
 */

class AspectFrame : public Frame
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AspectFrame CppObjectType;
  typedef AspectFrame_Class CppClassType;
  typedef GtkAspectFrame BaseObjectType;
  typedef GtkAspectFrameClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~AspectFrame();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class AspectFrame_Class;
  static CppClassType aspectframe_class_;

  // noncopyable
  AspectFrame(const AspectFrame&);
  AspectFrame& operator=(const AspectFrame&);

protected:
  explicit AspectFrame(const Glib::ConstructParams& construct_params);
  explicit AspectFrame(GtkAspectFrame* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  GtkAspectFrame*       gobj()       { return reinterpret_cast<GtkAspectFrame*>(gobject_); }
  const GtkAspectFrame* gobj() const { return reinterpret_cast<GtkAspectFrame*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


private:


public:

  explicit AspectFrame(const Glib::ustring& label = Glib::ustring(),
    AlignmentEnum xalign = Gtk::ALIGN_CENTER, AlignmentEnum yalign = Gtk::ALIGN_CENTER,
    float ratio = 1.0, bool obey_child = false);

  explicit AspectFrame(const Glib::ustring& label,
    float xalign, float yalign,
    float ratio = 1.0, bool obey_child = false);

  //TODO: Is "obey_child = true" a good default?
  
  void set(float xalign, float yalign, float ratio, bool obey_child = true);
  
  void set(AlignmentEnum xalign, AlignmentEnum yalign, float ratio, bool obey_child = true);

  Glib::PropertyProxy<float> property_xalign();

  Glib::PropertyProxy<float> property_yalign();

  Glib::PropertyProxy<float> property_ratio();

  Glib::PropertyProxy<bool> property_obey_child();


};

} /* namespace Gtk */


namespace Glib
{
  /** @relates Gtk::AspectFrame */
  Gtk::AspectFrame* wrap(GtkAspectFrame* object, bool take_copy = false);
}
#endif /* _GTKMM_ASPECTFRAME_H */

