// Generated by gtkmmproc -- DO NOT MODIFY!

#include <gtkmm/treepath.h>
#include <gtkmm/private/treepath_p.h>

// -*- c++ -*-
/* $Id: treepath.ccg,v 1.15 2002/10/11 18:06:00 murrayc Exp $ */

/*
 *
 * Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtkmm/treemodel.h>
#include <glibmm/utility.h>
#include <gtk/gtktreemodel.h>


namespace Gtk
{

TreePath::TreePath(bool root /* = false */)
{
  if(root)
    gobject_ = gtk_tree_path_new_root();
  else
    gobject_ = gtk_tree_path_new();
}

TreePath::TreePath(const Glib::ustring& path)
{
  gobject_ = gtk_tree_path_new_from_string(path.c_str());
}

TreePath::TreePath(const TreeModel::iterator& iter)
{
  // The GtkTreePath* is always newly created.
  gobject_ = gtk_tree_model_get_path(
      iter.get_model_gobject(), const_cast<GtkTreeIter*>(iter.gobj()));
}


Glib::ArrayHandle<int> TreePath::get_indices() const
{
  return Glib::ArrayHandle<int>(
      gtk_tree_path_get_indices(const_cast<GtkTreePath*>(gobj())),
      gtk_tree_path_get_depth(const_cast<GtkTreePath*>(gobj())),
      Glib::OWNERSHIP_NONE); //It seems like we don't need to free this.
}

} /* namespace Gtk */


namespace
{
} // anonymous namespace


namespace Glib
{

Gtk::TreePath wrap(GtkTreePath* object, bool take_copy)
{
  return Gtk::TreePath(object, take_copy);
}

} // namespace Glib


namespace Gtk
{


// static
GType TreePath::get_type()
{
  return gtk_tree_path_get_type();
}


TreePath::TreePath(const TreePath& src)
:
  gobject_ ((src.gobject_) ? gtk_tree_path_copy(src.gobject_) : 0)
{}

TreePath::TreePath(GtkTreePath* castitem, bool make_a_copy)
{
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.

  if(make_a_copy)
  {
    if(castitem)
      gobject_ = gtk_tree_path_copy(castitem);
    else
      gobject_ = 0;
  }
  else
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
}

TreePath& TreePath::operator=(const TreePath& src)
{
  GtkTreePath *const new_gobject = (src.gobject_) ? gtk_tree_path_copy(src.gobject_) : 0;

  if(gobject_)
    gtk_tree_path_free(gobject_);
  gobject_ = new_gobject;

  return *this;
}

TreePath::~TreePath()
{
  if(gobject_)
    gtk_tree_path_free(gobject_);}


GtkTreePath* TreePath::gobj_copy() const
{
  return gtk_tree_path_copy(gobject_);
}

Glib::ustring TreePath::to_string() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_tree_path_to_string(const_cast<GtkTreePath*>(gobj())));
}

void TreePath::append_index(int index)
{
  gtk_tree_path_append_index(gobj(), index);
}

void TreePath::prepend_index(int index)
{
  gtk_tree_path_prepend_index(gobj(), index);
}

int TreePath::get_depth() const
{
  return gtk_tree_path_get_depth(const_cast<GtkTreePath*>(gobj()));
}

void TreePath::next()
{
  gtk_tree_path_next(gobj());
}

bool TreePath::prev()
{
  return gtk_tree_path_prev(gobj());
}

bool TreePath::up()
{
  return gtk_tree_path_up(gobj());
}

void TreePath::down()
{
  gtk_tree_path_down(gobj());
}

bool TreePath::is_ancestor(TreePath& descendant) const
{
  return gtk_tree_path_is_ancestor(const_cast<GtkTreePath*>(gobj()), (descendant).gobj());
}

bool TreePath::is_descendant(TreePath& ancestor) const
{
  return gtk_tree_path_is_descendant(const_cast<GtkTreePath*>(gobj()), (ancestor).gobj());
}


bool operator==(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) == 0);
}

bool operator!=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) != 0);
}

bool operator<(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) < 0);
}

bool operator>(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) > 0);
}

bool operator<=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) <= 0);
}

bool operator>=(const TreePath& lhs, const TreePath& rhs)
{
  return (gtk_tree_path_compare(lhs.gobj(), rhs.gobj()) >= 0);
}


} // namespace Gtk


