// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_CAPS_H
#define _GSTREAMERMM_CAPS_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/miniobject.h>


namespace Gst
{
/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var CapsIntersectMode CAPS_INTERSECT_ZIG_ZAG
 * Zig-zags over both caps.
 * 
 *  @var CapsIntersectMode CAPS_INTERSECT_FIRST
 * Keeps the first caps order.
 * 
 *  @enum CapsIntersectMode
 * 
 * Modes of caps intersection
 * 
 *  @a GST_CAPS_INTERSECT_ZIG_ZAG tries to preserve overall order of both caps
 * by iterating on the caps' structures as the following matrix shows:
 * 
 * [C example ellipted]
 * Used when there is no explicit precedence of one caps over the other. e.g.
 * tee's sink pad getcaps function, it will probe its src pad peers' for their
 * caps and intersect them with this mode.
 * 
 *  @a GST_CAPS_INTERSECT_FIRST is useful when an element wants to preserve
 * another element's caps priority order when intersecting with its own caps.
 * Example: If caps1 is [A, B, C] and caps2 is [E, B, D, A], the result
 * would be [A, B], maintaining the first caps priority on the intersection.
 *
 * @ingroup gstreamermmEnums
 */
enum CapsIntersectMode
{
  CAPS_INTERSECT_ZIG_ZAG,
  CAPS_INTERSECT_FIRST
};


/** 
 *  @var CapsFlags CAPS_FLAG_ANY
 * Caps has no specific content, but can contain
 * anything.
 * 
 *  @enum CapsFlags
 * 
 * Extra flags for a caps.
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%CapsFlags operator|(CapsFlags, CapsFlags)</tt><br>
 * <tt>%CapsFlags operator&(CapsFlags, CapsFlags)</tt><br>
 * <tt>%CapsFlags operator^(CapsFlags, CapsFlags)</tt><br>
 * <tt>%CapsFlags operator~(CapsFlags)</tt><br>
 * <tt>%CapsFlags& operator|=(CapsFlags&, CapsFlags)</tt><br>
 * <tt>%CapsFlags& operator&=(CapsFlags&, CapsFlags)</tt><br>
 * <tt>%CapsFlags& operator^=(CapsFlags&, CapsFlags)</tt><br>
 */
enum CapsFlags
{
  CAPS_FLAG_ANY = (GST_MINI_OBJECT_FLAG_LAST << 0)
};

/** @ingroup gstreamermmEnums */
inline CapsFlags operator|(CapsFlags lhs, CapsFlags rhs)
  { return static_cast<CapsFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline CapsFlags operator&(CapsFlags lhs, CapsFlags rhs)
  { return static_cast<CapsFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline CapsFlags operator^(CapsFlags lhs, CapsFlags rhs)
  { return static_cast<CapsFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline CapsFlags operator~(CapsFlags flags)
  { return static_cast<CapsFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline CapsFlags& operator|=(CapsFlags& lhs, CapsFlags rhs)
  { return (lhs = static_cast<CapsFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline CapsFlags& operator&=(CapsFlags& lhs, CapsFlags rhs)
  { return (lhs = static_cast<CapsFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline CapsFlags& operator^=(CapsFlags& lhs, CapsFlags rhs)
  { return (lhs = static_cast<CapsFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::CapsFlags> : public Glib::Value_Flags<Gst::CapsFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


class Structure;
class CapsFeatures;

/** Structure describing sets of media formats.
 * Caps (capabilities) are lightweight refcounted objects describing media types.
 *
 * They are composed of an array of Gst::Structure.
 *
 * Caps are exposed on Gst::PadTemplate to describe all possible types a
 * given pad can handle. They are also stored in the Gst::Registry along with
 * a description of the Gst::Element.
 *
 * Caps are exposed on the element pads using the Gst::Pad::query_caps() pad
 * method. This function describes the possible types that the pad can
 * handle or produce at runtime.
 *
 * @code
 * Glib::RefPtr<Gst::Caps> caps = Gst::Caps::create_simple("video/x-raw",
 *                                 "format", Gst::Fourcc('I', '4', '2', '0'),
 *                                 "framerate", Gst::Fraction(25, 1),
 *                                 "pixel-aspect-ratio", Gst::Fraction(1, 1),
 *                                 "width", 320,
 *                                 "height", 240);
 * @endcode
 *
 * A Gst::Caps is fixed when it has no properties with ranges or lists. Use
 * Gst::Caps::is_fixed() to test for fixed caps. Fixed caps can be used in a
 * caps event to notify downstream elements of the current media type.
 *
 * Various methods exist to work with the media types such as subtracting
 * or intersecting.
 *
 * Be aware that the current Gst::Caps / Gst::Structure serialization into string
 * has limited support for nested Gst::Caps / Gst::Structure fields. It can only
 * support one level of nesting. Using more levels will lead to unexpected
 * behavior when using serialization features, such as Gst::Caps::to_string() or
 * gst_value_serialize() and their counterparts.
 *
 * Last reviewed on 2016-05-16 (1.8.0)
 *
 */
class Caps : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Caps;
  using BaseObjectType = GstCaps;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  static Glib::RefPtr<Caps> create();

  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstCaps*       gobj();

  ///Provides access to the underlying C instance.
  const GstCaps* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstCaps* gobj_copy() const;

  Caps() = delete;

  // noncopyable
  Caps(const Caps&) = delete;
  Caps& operator=(const Caps&) = delete;

protected:
  // Do not derive this.  Gst::Caps can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

  
public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type() G_GNUC_CONST;
#endif

public:
  /** Creates a new Gst::Caps that contains one Gst::Structure.
   *
   * @param media_type The media type of the structure.
   * @param ...further_data further data to set in format: name, data (data
   * value can be any supported C++ type).
   *
   * @return The new Gst::Caps.
   */
  template<class ...DataTypes>
  static Glib::RefPtr<Gst::Caps> create_simple(const Glib::ustring& media_type, DataTypes... further_data);

  /** Creates a new Gst::Caps and adds the given Gst::Structure.
   * Use append_structure() to add additional structures.
   *
   * @param first_struct The first structure to add.
   * @return Returns the new Gst::Caps.
   */
  static Glib::RefPtr<Gst::Caps> create(const Structure& first_struct);

  
  /** Converts @a caps from a string representation.
   * 
   * The current implementation of serialization will lead to unexpected results
   * when there are nested Gst::Caps / Gst::Structure deeper than one level.
   * 
   * @param string A string to convert to Gst::Caps.
   * @return A newly allocated Gst::Caps.
   */
  static Glib::RefPtr<Gst::Caps> create_from_string(const Glib::ustring& string);

  
  /** Creates a new Gst::Caps and appends a copy of the nth structure
   * contained in @a caps.
   * 
   * @param nth The nth structure to copy.
   * @return The new Gst::Caps.
   */
  Glib::RefPtr<Gst::Caps> copy_nth(guint nth) const;

  
  /** Appends the structures contained in @a caps to @a caps1. The structures in
   *  @a caps are not copied -- they are transferred to @a caps1, and then @a caps is
   * freed. If either caps is ANY, the resulting caps will be ANY.
   * 
   * @param caps The Gst::Caps to append.
   */
  void append(Glib::RefPtr<Gst::Caps>&& caps);

  Glib::RefPtr<Gst::Caps> merge(Glib::RefPtr<Gst::Caps>&& caps);
  

  /** Appends a structure to caps.
   *
   * @param structure The Gst::Structure to append.
   */
  void append_structure(const Structure& structure);

  
  /** Appends @a structure to @a caps.  The structure is not copied; @a caps
   * becomes the owner of @a structure.
   * 
   * @param structure The Gst::Structure to append.
   */
  void append_structure(Gst::Structure&& structure);

  /** Appends a structure to caps.
   *
   * @param structure The Gst::Structure to append.
   * @param features The Gst::CapsFeatures to append.
   */
  void append_structure(const Structure& structure, const CapsFeatures& features);
  

  /** Appends a structure to caps if its not already expressed by caps.
   *
   * @param structure The Gst::Structure to merge.
   */
  Glib::RefPtr<Gst::Caps> merge_structure(const Structure& structure);
  

  /** Appends a structure to caps if its not already expressed by caps.
   *
   * @param structure The Gst::Structure to merge.
   * @param features The Gst::CapsFeatures to merge.
   */
  Glib::RefPtr<Gst::Caps> merge_structure(const Structure& structure, const CapsFeatures& features);
  

  /** Finds the structure in caps that has the index @a idx, and returns it.
   *
   * @param idx The index of the structure.
   * @return The Gst::Structure corresponding to index.
   */
  const Structure get_structure(guint idx) const;

  
  /** removes the structure with the given index from the list of structures
   * contained in @a caps.
   * 
   * @param idx Index of the structure to remove.
   */
  void remove_structure(guint idx);
  
  /** Gets the number of structures contained in @a caps.
   * 
   * @return The number of structures that @a caps contains.
   */
  guint size() const;

// There's no need to take an extra reference because we are stealing the
// structure.
 

  /** Retrieves the structure with the given index from the list of structures
   * contained in @a caps. The caller becomes the owner of the returned structure.
   * 
   * @param index Index of the structure to retrieve.
   * @return A pointer to the Gst::Structure corresponding
   * to @a index.
   */
  Structure steal_structure(guint index);

  /** Sets fields in a simple Gst::Caps. A simple Gst::Caps is one that only
   * has one structure. This method, like the Gst::Structure::set_field()
   * methods, translates certain GTypes to GStreamer specific GTypes for
   * functional compatibility.
   *
   * @param name Field to set.
   * @param value The value which the field should be set to.
   */
  void set_simple(const Glib::ustring& name, const Glib::ValueBase& value);
  

  /** Sets fields in a simple Gst::Caps. A simple Gst::Caps is one that only
   * has one structure. This method, like the Gst::Structure::set_field()
   * methods, translates certain GTypes to GStreamer specific GTypes for
   * functional compatibility.
   *
   * @param name Field to set.
   * @param data A value which the field should be set to (this can be any
   * supported C++ type).
   * @param ...further_data further data to set in format: name, data.
   */
  template<class DataType, class ...DataTypes>
  void set_simple(const Glib::ustring & name, const DataType& data, DataTypes ...further_data);

  /** Sets fields in a simple Gst::Caps. A simple Gst::Caps is one that only
   * has one structure.
   *
   * @param name Field to set.
   * @param data A C string (const char*) which the field should be set to.
   */
  void set_simple(const Glib::ustring& name, const char* data);

  
  /** Sets the given @a field on all structures of @a caps to the given @a value.
   * This is a convenience function for calling Gst::Structure::set_value() on
   * all structures of @a caps.
   * 
   * @param field Name of the field to set.
   * @param value Value to set the field to.
   */
  void set_value(const Glib::ustring& field, const Glib::ValueBase& value);

  /** Sets the given @a field on all structures to the given value. This is a
   * convenience function for calling Gst::Structure::set_value()  on all
   * structures.
   *
   * @param name Field to set.
   * @param data A value which the field should be set to (this can be any
   * supported C++ type).
   */
  template <class DataType>
  void set_value(const Glib::ustring& name, const DataType& data);

  
  /** Determines if @a caps represents any media format.
   * 
   * @return <tt>true</tt> if @a caps represents any format.
   */
  bool is_any() const;
  
  /** Determines if @a caps represents no media formats.
   * 
   * @return <tt>true</tt> if @a caps represents no formats.
   */
  bool empty() const;
  
  /** Fixed Gst::Caps describe exactly one format, that is, they have exactly
   * one structure, and each field in the structure describes a fixed type.
   * Examples of non-fixed types are GST_TYPE_INT_RANGE and GST_TYPE_LIST.
   * 
   * @return <tt>true</tt> if @a caps is fixed.
   */
  bool is_fixed() const;
  
  /** Checks if the given caps represent the same set of caps.
   * 
   * @param other_caps Another Gst::Caps.
   * @return <tt>true</tt> if both caps are equal.
   */
  bool equals(const Glib::RefPtr<const Gst::Caps>& other_caps) const;
  
  /** Tests if two Gst::Caps are equal.  This function only works on fixed
   * Gst::Caps.
   * 
   * @param other_caps The Gst::Caps to test.
   * @return <tt>true</tt> if the arguments represent the same format.
   */
  bool equals_fixed(const Glib::RefPtr<const Gst::Caps>& other_caps) const;
  
  /** A given Gst::Caps structure is always compatible with another if
   * every media format that is in the first is also contained in the
   * second.  That is, @a caps1 is a subset of @a other_caps.
   * 
   * @param other_caps The Gst::Caps to test.
   * @return <tt>true</tt> if @a caps1 is a subset of @a other_caps.
   */
  bool is_always_compatible(const Glib::RefPtr<const Gst::Caps>& other_caps) const;
  
  /** Checks if all caps represented by @a subset are also represented by @a superset_caps.
   * 
   * @param superset_caps A potentially greater Gst::Caps.
   * @return <tt>true</tt> if @a subset is a subset of @a superset_caps.
   */
  bool is_subset(const Glib::RefPtr<const Gst::Caps>& superset_caps) const;
  
  /** Tries intersecting @a caps1 and @a caps2 and reports whether the result would not
   * be empty
   * 
   * @param caps2 A Gst::Caps to intersect.
   * @return <tt>true</tt> if intersection would be not empty.
   */
  bool can_intersect(const Glib::RefPtr<const Gst::Caps>& caps2) const;
  
  /** Modifies the given @a caps into a representation with only fixed
   * values. First the caps will be truncated and then the first structure will be
   * fixated with Gst::Structure::fixate().
   * 
   * This function takes ownership of @a caps and will call gst_caps_make_writable()
   * on it so you must not use @a caps afterwards unless you keep an additional
   * reference to it with ref().
   * 
   * @return The fixated caps.
   */
  Glib::RefPtr<Gst::Caps> fixate() const;
  
  /** Checks if the given caps are exactly the same set of caps.
   * 
   * @param caps2 Another Gst::Caps.
   * @return <tt>true</tt> if both caps are strictly equal.
   */
  bool is_strictly_equal(const Glib::RefPtr<const Gst::Caps>& caps2) const;
  
  /** Creates a new Gst::Caps as a copy of the old @a caps. The new caps will have a
   * refcount of 1, owned by the caller. The structures are copied as well.
   * 
   * Note that this function is the semantic equivalent of a ref()
   * followed by a gst_caps_make_writable(). If you only want to hold on to a
   * reference to the data, you should use ref().
   * 
   * When you are finished with the caps, call unref() on it.
   * 
   * @return The new Gst::Caps.
   */
  Glib::RefPtr<Gst::Caps> copy() const;
  
  /** Checks if @a structure is a subset of @a caps. See is_subset()
   * for more information.
   * 
   * @param structure A potential Gst::Structure subset of @a caps.
   * @return <tt>true</tt> if @a structure is a subset of @a caps.
   */
  bool is_subset_structure(const Gst::Structure& structure) const;
  
  /** Checks if @a structure is a subset of @a caps. See is_subset()
   * for more information.
   * 
   * @param structure A potential Gst::Structure subset of @a caps.
   * @param features A Gst::CapsFeatures for @a structure.
   * @return <tt>true</tt> if @a structure is a subset of @a caps.
   */
  bool is_subset_structure(const Gst::Structure& structure, const Gst::CapsFeatures& features) const;


  /** Creates a new Gst::Caps that indicates that it is compatible with
   * any media format.
   * 
   * @return The new Gst::Caps.
   */
  static Glib::RefPtr<Gst::Caps> create_any();

  //This is const (returns a non const) because it always creates a new instance:
  
  /** Creates a new Gst::Caps that contains all the formats that are common
   * to both @a caps1 and @a other_caps. Defaults to Gst::CAPS_INTERSECT_ZIG_ZAG mode.
   * 
   * @param other_caps A Gst::Caps to intersect.
   * @return The new Gst::Caps.
   */
  Glib::RefPtr<Gst::Caps> get_intersect(const Glib::RefPtr<const Gst::Caps>& other_caps) const;

  //This is const (returns a non const) because it always creates a new instance:
  
  /** Creates a new Gst::Caps that contains all the formats that are common
   * to both @a caps1 and @a other_caps, the order is defined by the Gst::CapsIntersectMode
   * used.
   * 
   * @param other_caps A Gst::Caps to intersect.
   * @param p2 The intersection algorithm/mode to use.
   * @return The new Gst::Caps.
   */
  Glib::RefPtr<Gst::Caps> get_intersect(const Glib::RefPtr<const Gst::Caps>& other_caps, CapsIntersectMode p2) const;

  //This is const (returns a non const) because it always creates a new instance:
  
  /** Returns a Gst::Caps that represents the same set of formats as
   *  @a caps, but contains no lists.  Each list is expanded into separate
   *  @a GstStructures.
   * 
   * This function takes ownership of @a caps and will call gst_caps_make_writable()
   * on it so you must not use @a caps afterwards unless you keep an additional
   * reference to it with ref().
   * 
   * @return The normalized Gst::Caps.
   */
  Glib::RefPtr<Gst::Caps> get_normal() const;

  //This is const (returns a non const) because it always creates a new instance:
  
  /** Converts the given @a caps into a representation that represents the
   * same set of formats, but in a simpler form.  Component structures that are
   * identical are merged.  Component structures that have values that can be
   * merged are also merged.
   * 
   * This function takes ownership of @a caps and will call gst_caps_make_writable()
   * on it if necessary, so you must not use @a caps afterwards unless you keep an
   * additional reference to it with ref().
   * 
   * This method does not preserve the original order of @a caps.
   * 
   * @return The simplified caps.
   */
  Glib::RefPtr<Gst::Caps> simplify();

  
  /** Converts @a caps to a string representation.  This string representation
   * can be converted back to a Gst::Caps by from_string().
   * 
   * For debugging purposes its easier to do something like this:
   * 
   * [C example ellipted]
   * This prints the caps in human readable form.
   * 
   * The current implementation of serialization will lead to unexpected results
   * when there are nested Gst::Caps / Gst::Structure deeper than one level.
   * 
   * @return A newly allocated string representing @a caps.
   */
  Glib::ustring to_string() const;

  //This is const (returns a non const) because it always creates a new instance:
  
  /** Subtracts the @a subtrahend_caps from the @a minuend.
   * <note>This function does not work reliably if optional properties for caps
   * are included on one caps and omitted on the other.</note>
   * 
   * @param subtrahend_caps Gst::Caps to subtract.
   * @return The resulting caps.
   */
  Glib::RefPtr<Gst::Caps> get_difference(const Glib::RefPtr<const Gst::Caps>& subtrahend_caps) const;

  /**
   * Returns a writable copy of @a caps.
   *
   * If there is only one reference count on Gst::Caps object , the caller must be
   * the owner, and so this function will return the caps object unchanged. If on
   * the other hand there is more than one reference on the object, a new caps object
   * will be returned.
   * @return A buffer (possibly the same pointer) that is writable.
   */
  Glib::RefPtr<Gst::Caps> create_writable();

  /** Discard all but the first structure from @a caps. Useful when
   * fixating.
   * 
   * @return Truncated caps.
   */
  Glib::RefPtr<Gst::Caps> truncate();
  

  /**
   * Finds the features in caps that has the index index , and returns it.
   *
   * @param index the index of the structure.
   * @return The new Gst::CapsFeatures corresponding to index.
   */
  CapsFeatures get_features(guint index) const;
  

  /**
   * Sets the Gst::CapsFeatures for the structure at index.
   *
   * @param index The index of the structure.
   * @param features The Gst::CapsFeatures to set.
   */
  void set_features(guint index, const CapsFeatures& features);
  

private:
  // This method is used for varadic template recursion
  void set_simple() {}


};

/******************************* Gst::Caps *******************************/

#ifndef DOXYGEN_SHOULD_SKIP_THIS

template<class DataType, class ...DataTypes>
void Caps::set_simple(const Glib::ustring & name, const DataType& data, DataTypes ...further_data)
{
  this->set_value(name, data);
  this->set_simple(further_data...);
}

template<class ...DataTypes>
Glib::RefPtr<Gst::Caps> Caps::create_simple(const Glib::ustring& media_type, DataTypes... data)
{
/*
  This method is implemented because gst_caps_new_simple is a variable argument
  function and cannot be wrapped.  In addition, because gst_caps_new_simple
  creates a GstStructure for the GstCaps and will not be called, we must create
  our own GstStructure here and append it to the GstCaps.
*/
  Glib::RefPtr<Gst::Caps> result(reinterpret_cast<Gst::Caps*>(gst_caps_new_empty()));
  Gst::Structure gst_struct(media_type, data...);
  result->append_structure(gst_struct);
  return result;
}

template <class DataType>
void Caps::set_value(const Glib::ustring& name, const DataType& data)
{
  typedef Glib::Value<DataType> ValueType;

  ValueType value;
  value.init(ValueType::value_type());
  value.set(data);
  this->set_value(name, reinterpret_cast<Glib::ValueBase&>(value));
}

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} //namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value< Glib::RefPtr<Gst::Caps> > : public ValueBase_Boxed
{
public:
  static GType value_type() { return Gst::Caps::get_type(); }
  void set(const Glib::RefPtr<Gst::Caps>& caps) { set_boxed(Glib::unwrap(caps)); }
  Glib::RefPtr<Gst::Caps> get();
};

}
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{

  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Caps
   */
  Glib::RefPtr<Gst::Caps> wrap(GstCaps* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_CAPS_H */

