// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_AUDIOBASESINK_H
#define _GSTREAMERMM_AUDIOBASESINK_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/audio/audio.h>
#include <gst/audio/gstaudiobasesink.h>
#include <gstreamermm/basesink.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstAudioBaseSink GstAudioBaseSink;
typedef struct _GstAudioBaseSinkClass GstAudioBaseSinkClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class AudioBaseSink_Class; } // namespace Gst
namespace Gst
{

class AudioRingBuffer;

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var AudioBaseSinkSlaveMethod AUDIO_BASE_SINK_SLAVE_RESAMPLE
 *  Resample to match the master clock.
 * 
 *  @var AudioBaseSinkSlaveMethod AUDIO_BASE_SINK_SLAVE_SKEW
 *  Adjust playout pointer when master clockdrifts too much.
 * 
 *  @var AudioBaseSinkSlaveMethod AUDIO_BASE_SINK_SLAVE_NONE
 *  No adjustment is done.
 * 
 *  @enum AudioBaseSinkSlaveMethod
 * 
 * Different possible clock slaving algorithms used when the internal audio
 * clock is not selected as the pipeline master clock.
 * @ingroup gstreamermmEnums
 */
enum AudioBaseSinkSlaveMethod
{
  AUDIO_BASE_SINK_SLAVE_RESAMPLE,
  AUDIO_BASE_SINK_SLAVE_SKEW,
  AUDIO_BASE_SINK_SLAVE_NONE
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::AudioBaseSinkSlaveMethod> : public Glib::Value_Enum<Gst::AudioBaseSinkSlaveMethod>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** The base class for audio sinks.
 * This is the base class for audio sinks. Subclasses need to implement the
 * create_ringbuffer_vfunc vmethod. This base class will then take care of
 * writing samples to the audioringbuffer, synchronisation, clipping and flushing.
 *
 * Last reviewed on 2006-09-27 (0.10.12).
 *
 * @ingroup GstBaseClasses
 */

class AudioBaseSink : public Gst::BaseSink
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef AudioBaseSink CppObjectType;
  typedef AudioBaseSink_Class CppClassType;
  typedef GstAudioBaseSink BaseObjectType;
  typedef GstAudioBaseSinkClass BaseClassType;

private:  friend class AudioBaseSink_Class;
  static CppClassType audiobasesink_class_;

private:
  // noncopyable
  AudioBaseSink(const AudioBaseSink&);
  AudioBaseSink& operator=(const AudioBaseSink&);

protected:
  explicit AudioBaseSink(const Glib::ConstructParams& construct_params);
  explicit AudioBaseSink(GstAudioBaseSink* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~AudioBaseSink();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstAudioBaseSink*       gobj()       { return reinterpret_cast<GstAudioBaseSink*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstAudioBaseSink* gobj() const { return reinterpret_cast<GstAudioBaseSink*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstAudioBaseSink* gobj_copy();

private:


public:
  /** Get the Gst::Clock of the Gst::AudioBaseSink.
   */
   Glib::RefPtr<Gst::Clock> get_provided_clock();
  Glib::RefPtr<const Gst::Clock> get_provided_clock() const;
 
  
  /** Create and return the Gst::AudioRingBuffer for @a sink. This function will call the
   * ::create_ringbuffer vmethod and will set @a sink as the parent of the returned
   * buffer (see Gst::Object::set_parent()).
   * @return The new audioringbuffer of @a sink.
   */
  Glib::RefPtr<Gst::AudioRingBuffer> create_ring_buffer();
  
  /** Controls whether @a sink will provide a clock or not. If @a provide is <tt>true</tt>,
   * Gst::Element::provide_clock() will return a clock that reflects the datarate
   * of @a sink. If @a provide is <tt>false</tt>, Gst::Element::provide_clock() will return <tt>0</tt>.
   * @param provide New state.
   */
  void set_provide_clock(bool provide);
  
  /** Queries whether @a sink will provide a clock or not. See also
   * gst_audio_base_sink_set_provide_clock.
   * @return <tt>true</tt> if @a sink will provide a clock.
   */
  bool get_provide_clock() const;

  
  /** Controls how clock slaving will be performed in @a sink.
   * @param method The new slave method.
   */
  void set_slave_method(Gst::AudioBaseSinkSlaveMethod method);
  
  /** Get the current slave method used by @a sink.
   * @return The current slave method used by @a sink.
   */
  Gst::AudioBaseSinkSlaveMethod get_slave_method() const;

  
  /** Get the current drift tolerance, in microseconds, used by @a sink.
   * @return The current drift tolerance used by @a sink.
   */
  gint64 get_drift_tolerance() const;
  
  /** Controls the sink's drift tolerance.
   * @param drift_tolerance The new drift tolerance in microseconds.
   */
  void set_drift_tolerance(gint64 drift_tolerance);

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Timestamp alignment threshold in nanoseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint64 > property_alignment_threshold() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Timestamp alignment threshold in nanoseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint64 > property_alignment_threshold() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Size of audio buffer in microseconds, this is the minimum latency that the sink reports.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< gint64 > property_buffer_time() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Size of audio buffer in microseconds, this is the minimum latency that the sink reports.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gint64 > property_buffer_time() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Allow pull-based scheduling.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_can_activate_pull() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Allow pull-based scheduling.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_can_activate_pull() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Window of time in nanoseconds to wait before creating a discontinuity.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< guint64 > property_discont_wait() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Window of time in nanoseconds to wait before creating a discontinuity.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< guint64 > property_discont_wait() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Tolerance for clock drift in microseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< gint64 > property_drift_tolerance() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Tolerance for clock drift in microseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gint64 > property_drift_tolerance() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The minimum amount of data to write in each iteration in microseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< gint64 > property_latency_time() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The minimum amount of data to write in each iteration in microseconds.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gint64 > property_latency_time() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Provide a clock to be used as the global pipeline clock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_provide_clock() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Provide a clock to be used as the global pipeline clock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_provide_clock() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Algorithm to use to match the rate of the masterclock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gst::AudioBaseSinkSlaveMethod > property_slave_method() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Algorithm to use to match the rate of the masterclock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gst::AudioBaseSinkSlaveMethod > property_slave_method() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  /** vfunc to create and return a Gst::AudioRingBuffer to write to.
   */
    virtual Glib::RefPtr<Gst::AudioRingBuffer> create_ring_buffer_vfunc();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::AudioBaseSink
   */
  Glib::RefPtr<Gst::AudioBaseSink> wrap(GstAudioBaseSink* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_AUDIOBASESINK_H */

