// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/bin.h>
#include <gstreamermm/private/bin_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdexcept>
#include <gst/gstbin.h>
#include <gst/gstutils.h>
#include <gstreamermm/pad.h>
#include <gstreamermm/iterator.h>


namespace Gst
{

Glib::RefPtr<Bin> Bin::add(const Glib::RefPtr<Element>& element)
{
  const bool result = gst_bin_add(gobj(), element->gobj());

  // If addition successful, return RefPtr<..> to this bin, otherwise return
  // NULL RefPtr<...>
  if(result)
   {
     // When adding bins to a bin/pipeline (yes this is possible), an extra ref
     // is needed because parent bin takes ownership of element and wants to
     // unref the child bin itself when the parent bin is destroyed.
     if (GST_IS_BIN(element->gobj()))
       element->reference();

      return Glib::wrap(gobj(), true);
   }
  else
    throw std::runtime_error("Failed to add " + element->get_name() + " element");
}

Glib::RefPtr<Bin> Bin::remove(const Glib::RefPtr<Element>& element)
{
  const bool result = gst_bin_remove(gobj(), element->gobj());

  // If removal successful, return RefPtr<..> to this bin, otherwise return
  // NULL RefPtr<...>
  if(result)
    return Glib::wrap(gobj(), true);
  else
    return Glib::RefPtr<Bin>(0);
}

} //namespace Gst


namespace
{


static void Bin_signal_element_added_callback(GstBin* self, GstElement* p0,void* data)
{
  using namespace Gst;
  typedef sigc::slot< void,const Glib::RefPtr<Element>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Bin_signal_element_added_info =
{
  "element-added",
  (GCallback) &Bin_signal_element_added_callback,
  (GCallback) &Bin_signal_element_added_callback
};


static void Bin_signal_element_removed_callback(GstBin* self, GstElement* p0,void* data)
{
  using namespace Gst;
  typedef sigc::slot< void,const Glib::RefPtr<Element>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Bin_signal_element_removed_info =
{
  "element-removed",
  (GCallback) &Bin_signal_element_removed_callback,
  (GCallback) &Bin_signal_element_removed_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gst::Bin> wrap(GstBin* object, bool take_copy)
{
  return Glib::RefPtr<Gst::Bin>( dynamic_cast<Gst::Bin*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Bin_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Bin_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_bin_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  ChildProxy::add_interface(get_type());

  }

  return *this;
}

void Bin_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
  klass->add_element = &add_element_vfunc_callback;
  klass->remove_element = &remove_element_vfunc_callback;
  klass->handle_message = &handle_message_vfunc_callback;
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->element_added = &element_added_callback;
  klass->element_removed = &element_removed_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
gboolean Bin_Class::add_element_vfunc_callback(GstBin* self, GstElement* element)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->add_element_vfunc(Glib::wrap(element, true)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->add_element)
    return (*base->add_element)(self, element);


  typedef gboolean RType;
  return RType();
}
gboolean Bin_Class::remove_element_vfunc_callback(GstBin* self, GstElement* element)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->remove_element_vfunc(Glib::wrap(element, true)
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->remove_element)
    return (*base->remove_element)(self, element);


  typedef gboolean RType;
  return RType();
}
void Bin_Class::handle_message_vfunc_callback(GstBin* self, GstMessage* message)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->handle_message_vfunc(Gst::Message::wrap(message)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->handle_message)
    (*base->handle_message)(self, message);

}
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Bin_Class::element_added_callback(GstBin* self, GstElement* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_element_added(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->element_added)
    (*base->element_added)(self, p0);
}
void Bin_Class::element_removed_callback(GstBin* self, GstElement* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_element_removed(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->element_removed)
    (*base->element_removed)(self, p0);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Bin_Class::wrap_new(GObject* object)
{
  return new Bin((GstBin*)object);
}


/* The implementation: */

GstBin* Bin::gobj_copy()
{
  reference();
  return gobj();
}

Bin::Bin(const Glib::ConstructParams& construct_params)
:
  Element(construct_params)
{

}

Bin::Bin(GstBin* castitem)
:
  Element((GstElement*)(castitem))
{}

Bin::~Bin()
{}


Bin::CppClassType Bin::bin_class_; // initialize static member

GType Bin::get_type()
{
  return bin_class_.init().get_type();
}

GType Bin::get_base_type()
{
  return gst_bin_get_type();
}


Bin::Bin(const Glib::ustring& name)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Element(Glib::ConstructParams(bin_class_.init(), "name", name.c_str(), static_cast<char*>(0)))
{
  

}

Glib::RefPtr<Bin> Bin::create(const Glib::ustring& name)
{
  return Glib::RefPtr<Bin>( new Bin(name) );
}
Glib::RefPtr<Element> Bin::get_element(const Glib::ustring& name)
{
  return Glib::wrap(gst_bin_get_by_name(gobj(), name.c_str()));
}

Glib::RefPtr<const Element> Bin::get_element(const Glib::ustring& name) const
{
  return Glib::wrap(gst_bin_get_by_name(const_cast<GstBin*>(gobj()), name.c_str()));
}

Glib::RefPtr<Element> Bin::get_element_recurse_up(const Glib::ustring& name)
{
  return Glib::wrap(gst_bin_get_by_name_recurse_up(gobj(), name.c_str()));
}

Glib::RefPtr<const Element> Bin::get_element_recurse_up(const Glib::ustring& name) const
{
  return Glib::wrap(gst_bin_get_by_name_recurse_up(const_cast<GstBin*>(gobj()), name.c_str()));
}

Glib::RefPtr<Element> Bin::get_element(GType interface)
{
  return Glib::wrap(gst_bin_get_by_interface(gobj(), interface));
}

Glib::RefPtr<const Element> Bin::get_element(GType interface) const
{
  return Glib::wrap(gst_bin_get_by_interface(const_cast<GstBin*>(gobj()), interface));
}

Glib::RefPtr<Pad> Bin::find_unlinked_pad(PadDirection dir)
{
  return Glib::wrap(gst_bin_find_unlinked_pad(gobj(), ((GstPadDirection)(dir))));
}

Glib::RefPtr<const Pad> Bin::find_unlinked_pad(PadDirection dir) const
{
  return Glib::wrap(gst_bin_find_unlinked_pad(const_cast<GstBin*>(gobj()), ((GstPadDirection)(dir))));
}

Iterator<Element> Bin::iterate_elements()
{
  return Iterator<Element>::Iterator(gst_bin_iterate_elements(gobj()));
}

Iterator<Element> Bin::iterate_recurse()
{
  return Iterator<Element>::Iterator(gst_bin_iterate_recurse(gobj()));
}

Iterator<Element> Bin::iterate_sorted()
{
  return Iterator<Element>::Iterator(gst_bin_iterate_sorted(gobj()));
}

Iterator<Element> Bin::iterate_sources()
{
  return Iterator<Element>::Iterator(gst_bin_iterate_sources(gobj()));
}

Iterator<Element> Bin::iterate_sinks()
{
  return Iterator<Element>::Iterator(gst_bin_iterate_sinks(gobj()));
}

Iterator<Element> Bin::iterate_by_interface(GType iface)
{
  return Iterator<Element>::Iterator(gst_bin_iterate_all_by_interface(gobj(), iface));
}

 Glib::ListHandle< Glib::RefPtr<Element> > Bin::get_children() const
{
  return Glib::ListHandle< Glib::RefPtr<Element> >(gobj()->children, Glib::OWNERSHIP_SHALLOW);
}
 
 int Bin::get_num_children() const
{
  return gobj()->numchildren;
}
 

Glib::SignalProxy1< void,const Glib::RefPtr<Element>& > Bin::signal_element_added()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Element>& >(this, &Bin_signal_element_added_info);
}


Glib::SignalProxy1< void,const Glib::RefPtr<Element>& > Bin::signal_element_removed()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<Element>& >(this, &Bin_signal_element_removed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Bin::property_async_handling() 
{
  return Glib::PropertyProxy<bool>(this, "async-handling");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Bin::property_async_handling() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "async-handling");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Gst::Bin::on_element_added(const Glib::RefPtr<Element>& element)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->element_added)
    (*base->element_added)(gobj(),Glib::unwrap(element));
}
void Gst::Bin::on_element_removed(const Glib::RefPtr<Element>& element)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->element_removed)
    (*base->element_removed)(gobj(),Glib::unwrap(element));
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
bool Gst::Bin::add_element_vfunc(const Glib::RefPtr<Element>& element) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->add_element)
    return (*base->add_element)(gobj(),Glib::unwrap(element));

  typedef bool RType;
  return RType();
}
bool Gst::Bin::remove_element_vfunc(const Glib::RefPtr<Element>& element) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->remove_element)
    return (*base->remove_element)(gobj(),Glib::unwrap(element));

  typedef bool RType;
  return RType();
}
void Gst::Bin::handle_message_vfunc(const Glib::RefPtr<Message>& message) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->handle_message)
    (*base->handle_message)(gobj(),Glib::unwrap(message));
}
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


