// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_FILTER_H
#define _GSTREAMERMM_FILTER_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Gst
{

/** Gst::Filter — A utility function to filter Lists.
 */
class Filter
{

public:
  /** For example, bool on_filter(const Glib::RefPtr<Glib::Object>& object);
   * The filter function should return true if object is a match, false
   * otherwise.
   */
  typedef sigc::slot<bool, const Glib::RefPtr<Glib::Object>& > SlotFilter;

  /**
   * Iterates over the elements in the list, calling the slot with each
   * object.  If the slot returns true, the object is
   * prepended to the list of results returned.  If first is true,
   * the search is halted after the first result is found.
   *
   * @param list A list of objects.
   * @param slot The slot to execute for each item.
   * @param first Flag to stop execution after a successful item.
   *
   * @return The list of results.
   */
  static Glib::ListHandle< Glib::RefPtr<Glib::Object> > run(const Glib::ListHandle<Glib::RefPtr<Glib::Object> >& list, const SlotFilter& slot, bool first);
};

} // namespace Gst


#endif /* _GSTREAMERMM_FILTER_H */

