// Generated by gtkmmproc -- DO NOT MODIFY!


#include <gstreamermm/event.h>
#include <gstreamermm/private/event_p.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gstenumtypes.h>
#include <gstreamermm/structure.h>
#include <gstreamermm/taglist.h>


namespace Gst
{

namespace Enums
{

Glib::ustring get_name(EventType t)
{
  return gst_event_type_get_name(GstEventType(t));
}

Glib::QueryQuark get_quark(EventType t)
{
  return Glib::QueryQuark(gst_event_type_to_quark(GstEventType(t)));
}

} //namespace Enums

Structure Event::get_structure() const
{
  static Structure structure;

  GstStructure* gst_structure = const_cast<GstStructure*>(gst_event_get_structure(const_cast<GstEvent*>(gobj())));
  return Structure(gst_structure, true /* take_copy */);
}

bool Event::is_downstream() const
{
  return GST_EVENT_IS_DOWNSTREAM(gobj());
}

bool Event::is_upstream() const
{
  return GST_EVENT_IS_UPSTREAM(gobj());
}

bool Event::is_serialized() const
{
  return GST_EVENT_IS_SERIALIZED(gobj());
}

EventBufferSize::EventBufferSize(GstEvent* castitem) :
Event(castitem)
{
}

Glib::RefPtr<Event> EventBufferSize::create(Format format, gint64 minsize, gint64 maxsize, bool async)
{
  GstEvent* event = gst_event_new_buffer_size(GstFormat(format), minsize, maxsize, async);
  return Gst::Event::wrap(event, false);
}

void EventBufferSize::parse(Format& format, gint64& minsize, gint64& maxsize, bool& async)
{
  gboolean result;
  gst_event_parse_buffer_size(gobj(), (GstFormat*)&format, &minsize, &maxsize, &result);
  async = result;
}

EventEos::EventEos(GstEvent* castitem) :
Event(castitem)
{
}

Glib::RefPtr<Event> EventEos::create()
{
  GstEvent* event = gst_event_new_eos();
  return Gst::Event::wrap(event, false);
}

EventFlushStart::EventFlushStart(GstEvent* castitem) :
Event(castitem)
{
}

Glib::RefPtr<Event> EventFlushStart::create()
{
  GstEvent* event = gst_event_new_flush_start();
  return Gst::Event::wrap(event, false);
}

EventFlushStop::EventFlushStop(GstEvent* castitem) :
Event(castitem)
{
}

Glib::RefPtr<Event> EventFlushStop::create()
{
  GstEvent* event = gst_event_new_flush_stop();
  return Gst::Event::wrap(event, false);
}

EventLatency::EventLatency(GstEvent* castitem) :
Event(castitem)
{
}

void EventLatency::parse(ClockTime& latency)
{
  gst_event_parse_latency(gobj(), &latency);
}

Glib::RefPtr<Event> EventLatency::create(ClockTime time)
{
  GstEvent* event = gst_event_new_latency(GstClockTime(time));
  return Gst::Event::wrap(event, false);
}

EventNavigation::EventNavigation(GstEvent* castitem) :
Event(castitem)
{
}

Glib::RefPtr<Event> EventNavigation::create(Structure& structure)
{
  GstEvent* event = gst_event_new_navigation(structure.gobj());
  return Gst::Event::wrap(event, false);
}

EventNewSegment::EventNewSegment(GstEvent* castitem) :
Event(castitem)
{
}

Glib::RefPtr<Event> EventNewSegment::create(bool update, double rate, Format format, gint64 start, gint64 stop, gint64 position, double applied_rate)
{
  GstEvent* event = gst_event_new_new_segment_full(update, rate, applied_rate, GstFormat(format), start, stop, position);
  return Gst::Event::wrap(event, false);
}

void EventNewSegment::parse(bool& update, double& rate, Format& format, gint64& start, gint64& stop, gint64& position)
{
  gboolean result;
  gst_event_parse_new_segment(gobj(), &result, &rate, (GstFormat*)&format, &start, &stop, &position);
  update = result;
}

void EventNewSegment::parse(bool& update, double& rate, Format& format, gint64& start, gint64& stop, gint64& position, double& applied_rate)
{
  gboolean result;
  gst_event_parse_new_segment_full(gobj(), &result, &rate, &applied_rate, (GstFormat*)&format, &start, &stop, &position);
  update = result;
}

EventQos::EventQos(GstEvent* castitem) :
Event(castitem)
{
}

Glib::RefPtr<Event> EventQos::create(double proportion, ClockTimeDiff diff, ClockTime timestamp)
{
  GstEvent* event = gst_event_new_qos(proportion, GstClockTimeDiff(diff), GstClockTime(timestamp));
  return Gst::Event::wrap(event, false);
}

void EventQos::parse(double& proportion, ClockTimeDiff& diff, ClockTime& timestamp)
{
  gst_event_parse_qos(gobj(), &proportion, &diff, &timestamp);
}

EventSeek::EventSeek(GstEvent* castitem) :
Event(castitem)
{
}

Glib::RefPtr<Event> EventSeek::create(double rate, Format format, SeekFlags flags, SeekType start_type, gint64 start, SeekType stop_type, gint64 stop)
{
  GstEvent* event = gst_event_new_seek(rate, GstFormat(format), GstSeekFlags(flags), GstSeekType(start_type), start, GstSeekType(stop_type), stop);
  return Gst::Event::wrap(event, false);
}

void EventSeek::parse(double& rate, Format& format, SeekFlags& flags, SeekType& start_type, gint64& start, SeekType& stop_type, gint64& stop)
{
  gst_event_parse_seek(gobj(), &rate, (GstFormat*)&format, (GstSeekFlags*)&flags, (GstSeekType*)&start_type, &start, (GstSeekType*)&stop_type, &stop);
}

EventTag::EventTag(GstEvent* castitem) :
Event(castitem)
{
}

Glib::RefPtr<Event> EventTag::create(const TagList& taglist)
{
  //We create a copy because gst_event_new_tag() takes ownership:
  GstTagList* c_taglist = gst_tag_list_copy(taglist.gobj());
  GstEvent* event = gst_event_new_tag(c_taglist);
  return Gst::Event::wrap(event, false);
}

TagList EventTag::parse()
{
  GstTagList* gst_taglist = gst_tag_list_new();
  gst_event_parse_tag(gobj(), &gst_taglist);
  return TagList(gst_taglist);
}

Glib::RefPtr<Event> Event::wrap(GstEvent* event, bool take_copy) {

  Glib::RefPtr<Event> result;

  if(!event)
    return result;

  switch (GST_EVENT_TYPE(event)) {
    case GST_EVENT_FLUSH_START:
      result = Glib::RefPtr<Event>( new Gst::EventFlushStart(event) );
      break;
    case GST_EVENT_FLUSH_STOP:
      result = Glib::RefPtr<Event>( new Gst::EventFlushStop(event) );
      break;
    case GST_EVENT_EOS:
      result = Glib::RefPtr<Event>( new Gst::EventEos(event) );
      break;
    case GST_EVENT_NEWSEGMENT:
      result = Glib::RefPtr<Event>( new Gst::EventNewSegment(event) );
      break;
    case GST_EVENT_TAG:
      result = Glib::RefPtr<Event>( new Gst::EventTag(event) );
      break;
    case GST_EVENT_BUFFERSIZE:
      result = Glib::RefPtr<Event>( new Gst::EventBufferSize(event) );
      break;
    case GST_EVENT_QOS:
      result = Glib::RefPtr<Event>( new Gst::EventQos(event) );
      break;
    case GST_EVENT_SEEK:
      result = Glib::RefPtr<Event>( new Gst::EventSeek(event) );
      break;
    case GST_EVENT_NAVIGATION:
      result = Glib::RefPtr<Event>( new Gst::EventNavigation(event) );
      break;
    case GST_EVENT_LATENCY:
      result = Glib::RefPtr<Event>( new Gst::EventLatency(event) );
      break;
    default:
      result = Gst::wrap(event, false);
  }

  if(result && take_copy)
    result->reference();

  return result;
}

} //namespace Gst

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gst::SeekType>::value_type()
{
  return gst_seek_type_get_type();
}

// static
GType Glib::Value<Gst::SeekFlags>::value_type()
{
  return gst_seek_flags_get_type();
}

// static
GType Glib::Value<Gst::EventTypeFlags>::value_type()
{
  return gst_event_type_flags_get_type();
}


namespace Gst
{

Glib::RefPtr<Gst::Event> wrap(GstEvent* object, bool take_copy)
{
  //Note that we use Gst::wrap() instead of Glib::wrap() 
  //because we are dealing with a GstMiniObject, not a GObject:
  return Glib::RefPtr<Gst::Event>( dynamic_cast<Gst::Event*> (Gst::wrap_auto ((GstMiniObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Gst */


namespace Gst
{


/* The *_Class implementation: */

const Glib::Class& Event_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Event_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gst_event_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Event_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Event_Class::wrap_new(GstMiniObject* object)
{
  return new Event((GstEvent*)object);
}


/* The implementation: */

GstEvent* Event::gobj_copy()
{
  reference();
  return gobj();
}


Event::Event(GstEvent* castitem)
:
  Gst::MiniObject((GstMiniObject*)(castitem))
{}

Event::~Event()
{}


Event::CppClassType Event::event_class_; // initialize static member

GType Event::get_type()
{
  return event_class_.init().get_type();
}

GType Event::get_base_type()
{
  return gst_event_get_type();
}


 EventType Event::get_event_type() const
{
  return ((EventType)(gobj()->type));
}
 
 ClockTime Event::get_timestamp() const
{
  return (ClockTime (gobj()->timestamp));
}
 
 Glib::RefPtr<Gst::Object> Event::get_source()
{
  Glib::RefPtr<Gst::Object> ref_ptr(Glib::wrap(gobj()->src));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}

Glib::RefPtr<const Gst::Object> Event::get_source() const
{
  Glib::RefPtr<const Gst::Object> ref_ptr(Glib::wrap(gobj()->src));

  if(ref_ptr)
    ref_ptr->reference();

  return ref_ptr;
}
 

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gst


