// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_BUS_H
#define _GSTREAMERMM_BUS_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/object.h>
#include <gstreamermm/clock.h>
#include <gstreamermm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstBus GstBus;
typedef struct _GstBusClass GstBusClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Bus_Class; } // namespace Gst
namespace Gst
{

class Message;


class Bus : public Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Bus CppObjectType;
  typedef Bus_Class CppClassType;
  typedef GstBus BaseObjectType;
  typedef GstBusClass BaseClassType;

private:  friend class Bus_Class;
  static CppClassType bus_class_;

private:
  // noncopyable
  Bus(const Bus&);
  Bus& operator=(const Bus&);

protected:
  explicit Bus(const Glib::ConstructParams& construct_params);
  explicit Bus(GstBus* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Bus();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstBus*       gobj()       { return reinterpret_cast<GstBus*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstBus* gobj() const { return reinterpret_cast<GstBus*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBus* gobj_copy();

private:


protected:
  Bus();

public:
  /** For example,
   * bool on_bus_watch(const Glib::RefPtr<Bus>& bus, const
   * Glib::RefPtr<Message>& message);
   */
  typedef sigc::slot< bool, const Glib::RefPtr<Bus>&, const Glib::RefPtr<Message>& > SlotWatch;

  static Glib::RefPtr<Bus> create();
  
  /** Post a message on the given bus. Ownership of the message
   * is taken by the bus.
   * @param message The Gst::Message to post.
   * @return <tt>true</tt> if the message could be posted, <tt>false</tt> if the bus is flushing.
   * 
   * MT safe.
   */
  bool post(const Glib::RefPtr<Message>& message);
  
  /** Check if there are pending messages on the bus that
   * should be handled.
   * @return <tt>true</tt> if there are messages on the bus to be handled, <tt>false</tt> 
   * otherwise.
   * 
   * MT safe.
   */
  bool have_pending() const;

  
  /** Peek the message on the top of the bus' queue. The message will remain
   * on the bus' message queue. A reference is returned, and needs to be unreffed
   * by the caller.
   * @return The Gst::Message that is on the bus, or <tt>0</tt> if the bus is empty.
   * 
   * MT safe.
   */
  Glib::RefPtr<Message> peek();
  
  /** Peek the message on the top of the bus' queue. The message will remain
   * on the bus' message queue. A reference is returned, and needs to be unreffed
   * by the caller.
   * @return The Gst::Message that is on the bus, or <tt>0</tt> if the bus is empty.
   * 
   * MT safe.
   */
  Glib::RefPtr<const Message> peek() const;

  
  /** Get a message from the bus.
   * @return The Gst::Message that is on the bus, or <tt>0</tt> if the bus is empty.
   * The message is taken from the bus and needs to be unreffed with
   * gst_message_unref() after usage.
   * 
   * MT safe.
   */
  Glib::RefPtr<Message> pop();
  
  /** Get a message matching @a type from the bus.  Will discard all messages on
   * the bus that do not match @a type and that have been posted before the first
   * message that does match @a type.  If there is no message matching @a type on
   * the bus, all messages will be discarded.
   * @param types Message types to take into account.
   * @return The next Gst::Message matching @a type that is on the bus, or <tt>0</tt> if
   * the bus is empty or there is no message matching @a type.
   * The message is taken from the bus and needs to be unreffed with
   * gst_message_unref() after usage.
   * 
   * MT safe.
   * 
   * Since: 0.10.15.
   */
  Glib::RefPtr<Message> pop(MessageType message_type);
  
  /** Get a message from the bus, waiting up to the specified timeout.
   * 
   * If @a timeout is 0, this function behaves like pop(). If @a timeout is
   * Gst::CLOCK_TIME_NONE, this function will block forever until a message was
   * posted on the bus.
   * @param timeout A timeout.
   * @return The Gst::Message that is on the bus after the specified timeout
   * or <tt>0</tt> if the bus is empty after the timeout expired.
   * The message is taken from the bus and needs to be unreffed with
   * gst_message_unref() after usage.
   * 
   * MT safe.
   * 
   * Since: 0.10.12.
   */
  Glib::RefPtr<Message> pop(ClockTime timeout);
  
  /** Get a message from the bus whose type matches the message type mask @a types,
   * waiting up to the specified timeout (and discarding any messages that do not
   * match the mask provided).
   * 
   * If @a timeout is 0, this function behaves like pop_filtered(). If
   *  @a timeout is Gst::CLOCK_TIME_NONE, this function will block forever until a
   * matching message was posted on the bus.
   * @param timeout A timeout in nanoseconds, or GST_CLOCK_TIME_NONE to wait forever.
   * @param types Message types to take into account, GST_MESSAGE_ANY for any type.
   * @return A Gst::Message matching the filter in @a types, or <tt>0</tt> if no matching
   * message was found on the bus until the timeout expired.
   * The message is taken from the bus and needs to be unreffed with
   * gst_message_unref() after usage.
   * 
   * MT safe.
   * 
   * Since: 0.10.15.
   */
  Glib::RefPtr<Message> pop(ClockTime timeout, MessageType message_type);

  
  /** If @a flushing, flush out and unref any messages queued in the bus. Releases
   * references to the message origin objects. Will flush future messages until
   * set_flushing() sets @a flushing to #<tt>false</tt>.
   * 
   * MT safe.
   * @param flushing Whether or not to flush the bus.
   */
  void set_flushing(bool flushing = true);

  guint add_watch(const SlotWatch& slot, int priority = Glib::PRIORITY_DEFAULT);
  bool remove_watch(guint watch_id);
  

  /** Instructs GStreamer to stop emitting the "sync-message" signal for this bus.
   * See enable_sync_message_emission() for more information.
   * 
   * In the event that multiple pieces of code have called
   * enable_sync_message_emission(), the sync-message emissions will only
   * be stopped after all calls to enable_sync_message_emission() were
   * "cancelled" by calling this function. In this way the semantics are exactly
   * the same as Gst::Object::ref() that which calls enable should also call
   * disable.
   * 
   * MT safe.
   */
  void disable_sync_message_emission();
  
  /** Instructs GStreamer to emit the "sync-message" signal after running the bus's
   * sync handler. This function is here so that code can ensure that they can
   * synchronously receive messages without having to affect what the bin's sync
   * handler is. 
   * 
   * This function may be called multiple times. To clean up, the caller is
   * responsible for calling disable_sync_message_emission() as many times
   * as this function is called.
   * 
   * While this function looks similar to add_signal_watch(), it is not
   * exactly the same -- this function enables <em>synchronous</em> emission of
   * signals when messages arrive; add_signal_watch() adds an idle callback
   * to pop messages off the bus <em>asynchronously</em>. The sync-message signal
   * comes from the thread of whatever object posted the message; the "message"
   * signal is marshalled to the main thread via the main loop.
   * 
   * MT safe.
   */
  void enable_sync_message_emission();

  
  /** Adds a bus signal watch to the default main context with the given priority.
   * After calling this statement, the bus will emit the "message" signal for each
   * message posted on the bus when the main loop is running.
   * 
   * This function may be called multiple times. To clean up, the caller is
   * responsible for calling remove_signal_watch() as many times as this
   * function is called.
   * 
   * MT safe.
   * @param priority The priority of the watch.
   */
  void add_signal_watch(int priority = Glib::PRIORITY_DEFAULT);
  
  /** Removes a signal watch previously added with add_signal_watch().
   * 
   * MT safe.
   */
  void remove_signal_watch();
  
  /** Poll the bus for messages. Will block while waiting for messages to come.
   * You can specify a maximum time to poll with the @a timeout parameter. If
   *  @a timeout is negative, this function will block indefinitely.
   * 
   * All messages not in @a events will be popped off the bus and will be ignored.
   * 
   * Because poll is implemented using the "message" signal enabled by
   * add_signal_watch(), calling poll() will cause the "message"
   * signal to be emitted for every message that poll sees. Thus a "message"
   * signal handler will see the same messages that this function sees -- neither
   * will steal messages from the other.
   * 
   * This function will run a main loop from the default main context when
   * polling.
   * @param events A mask of Gst::MessageType, representing the set of message types to
   * poll for.
   * @param timeout The poll timeout, as a Gst::ClockTimeDiff, or -1 to poll indefinitely.
   * @return The message that was received, or <tt>0</tt> if the poll timed out.
   * The message is taken from the bus and needs to be unreffed with
   * gst_message_unref() after usage.
   */
  Glib::RefPtr<Message> poll(MessageType message_type, ClockTimeDiff timeout);
  

  /**
   * @par Prototype:
   * <tt>void on_my_%message(const Glib::RefPtr<Message>& message)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Message>& > signal_message();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%sync_message(const Glib::RefPtr<Message>& message)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Message>& > signal_sync_message();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_message(const Glib::RefPtr<Message>& message);
  virtual void on_sync_message(const Glib::RefPtr<Message>& message);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} //namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Bus
   */
  Glib::RefPtr<Gst::Bus> wrap(GstBus* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_BUS_H */

