// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_CLOCK_H
#define _GSTREAMERMM_CLOCK_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/object.h>
#include <gstreamermm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstClock GstClock;
typedef struct _GstClockClass GstClockClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class Clock_Class; } // namespace Gst
namespace Gst
{

class ClockID
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef ClockID CppObjectType;
  typedef GstClockID BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  // For use with Glib::RefPtr<> only.
  void reference()   const;
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstClockID*       gobj();

  ///Provides access to the underlying C instance.
  const GstClockID* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstClockID* gobj_copy() const;

protected:
  // Do not derive this.  Gst::ClockID can neither be constructed nor deleted.
  ClockID();
  void operator delete(void*, size_t);

private:
  // noncopyable
  ClockID(const ClockID&);
  ClockID& operator=(const ClockID&);


};

typedef GstClockTime ClockTime;
typedef GstClockTimeDiff ClockTimeDiff;
const ClockTime CLOCK_TIME_NONE = GST_CLOCK_TIME_NONE;

//Note that ClockTime is an enum.  That's why these are not member functions of a class

guint get_hours(ClockTime time);
guint get_minutes(ClockTime time);
guint get_seconds(ClockTime time);
guint get_milliseconds(ClockTime time);
guint get_microseconds(ClockTime time);
guint get_nanoseconds(ClockTime time);
guint get_fractional_seconds(ClockTime time);


class Clock : public Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Clock CppObjectType;
  typedef Clock_Class CppClassType;
  typedef GstClock BaseObjectType;
  typedef GstClockClass BaseClassType;

private:  friend class Clock_Class;
  static CppClassType clock_class_;

private:
  // noncopyable
  Clock(const Clock&);
  Clock& operator=(const Clock&);

protected:
  explicit Clock(const Glib::ConstructParams& construct_params);
  explicit Clock(GstClock* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Clock();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstClock*       gobj()       { return reinterpret_cast<GstClock*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstClock* gobj() const { return reinterpret_cast<GstClock*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstClock* gobj_copy();

private:


protected:
  //TODO: What C function does this correspond to?
  //TODO: Add a create()?
  Clock();

public:
  
  bool add_observation(ClockTime slave_time, ClockTime master_time, gdouble* result);
  
  bool set_master(const Clock& master_clock);
  
  Glib::RefPtr<Clock> get_master();
  
  ClockTime set_resolution(ClockTime resolution);
  
  ClockTime get_resolution() const;
  
  ClockTime get_time() const;
  //  _WRAP_METHOD(Glib::RefPtr<ClockID> new_single_shot_id(ClockTime time), gst_clock_new_single_shot_id)
  //  _WRAP_METHOD(Glib::RefPtr<ClockID> new_periodic_id(ClockTime start_time, ClockTime intervals), gst_clock_new_periodic_id)
  
  ClockTime get_internal_time() const;
  
  ClockTime adjust_unlocked(ClockTime internal_time);
  
  ClockTime unadjust_unlocked(ClockTime external_time);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} //namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::ClockID
   */
  Glib::RefPtr<Gst::ClockID> wrap(GstClockID* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Clock
   */
  Glib::RefPtr<Gst::Clock> wrap(GstClock* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_CLOCK_H */

