
/* autogenerated from tvtime.orc */

#include <orc/orc.h>
#include <orc-test/orctest.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#endif
#endif
typedef union { orc_int32 i; float f; } orc_union32;
typedef union { orc_int64 i; double f; } orc_union64;
#endif

/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
/* end Orc C target preamble */


/* deinterlace_line_vfir */
static void
_backup_deinterlace_line_vfir (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  orc_int8 var7;
  const orc_int8 * ptr7;
  orc_int8 var8;
  const orc_int8 * ptr8;
  const orc_int16 var16 = 2;
  const orc_int16 var17 = 1;
  const orc_int16 var18 = 4;
  const orc_int16 var19 = 3;
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;
  orc_int16 var40;
  orc_int16 var41;
  orc_int16 var42;
  orc_int16 var43;
  orc_int16 var44;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];
  ptr8 = (orc_int8 *)ex->arrays[8];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    var8 = *ptr8;
    ptr8++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: convubw */
    var33 = (orc_uint8)var8;
    /* 2: addw */
    var35 = var32 + var33;
    /* 3: convubw */
    var36 = (orc_uint8)var5;
    /* 4: convubw */
    var34 = (orc_uint8)var7;
    /* 5: addw */
    var37 = var36 + var34;
    /* 6: shlw */
    var38 = var37 << var16;
    /* 7: convubw */
    var39 = (orc_uint8)var6;
    /* 8: shlw */
    var40 = var39 << var17;
    /* 9: subw */
    var41 = var38 - var35;
    /* 10: addw */
    var42 = var41 + var40;
    /* 11: addw */
    var43 = var42 + var18;
    /* 12: shrsw */
    var44 = var43 >> var19;
    /* 13: convsuswb */
    var0 = ORC_CLAMP_UB(var44);
    *ptr0 = var0;
    ptr0++;
  }

}

/* deinterlace_line_linear */
static void
_backup_deinterlace_line_linear (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgub */
    var0 = ((orc_uint8)var4 + (orc_uint8)var5 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* deinterlace_line_linear_blend */
static void
_backup_deinterlace_line_linear_blend (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  const orc_int16 var16 = 2;
  const orc_int16 var17 = 2;
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: convubw */
    var33 = (orc_uint8)var5;
    /* 2: convubw */
    var34 = (orc_uint8)var6;
    /* 3: addw */
    var35 = var32 + var33;
    /* 4: addw */
    var36 = var34 + var34;
    /* 5: addw */
    var37 = var35 + var36;
    /* 6: addw */
    var38 = var37 + var16;
    /* 7: shrsw */
    var39 = var38 >> var17;
    /* 8: convsuswb */
    var0 = ORC_CLAMP_UB(var39);
    *ptr0 = var0;
    ptr0++;
  }

}


static int quiet = 0;
static int benchmark = 0;

static void help (const char *argv0)
{
  printf("Usage:\n");
  printf("  %s [OPTION]\n", argv0);
  printf("Help Options:\n");
  printf("  -h, --help          Show help options\n");
  printf("Application Options:\n");
  printf("  -b, --benchmark     Run benchmark and show results\n");
  printf("  -q, --quiet         Don't output anything except on failures\n");

  exit(0);
}

int
main (int argc, char *argv[])
{
  int error = FALSE;
  int i;

  orc_test_init ();

  for(i=1;i<argc;i++) {
    if (strcmp(argv[i], "--help") == 0 ||
      strcmp(argv[i], "-h") == 0) {
      help(argv[0]);
    } else if (strcmp(argv[i], "--quiet") == 0 ||
      strcmp(argv[i], "-q") == 0) {
      quiet = 1;
      benchmark = 0;
    } else if (strcmp(argv[i], "--benchmark") == 0 ||
      strcmp(argv[i], "-b") == 0) {
      benchmark = 1;
      quiet = 0;
    }
  }

  /* deinterlace_line_vfir */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("deinterlace_line_vfir:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "deinterlace_line_vfir");
    orc_program_set_backup_function (p, _backup_deinterlace_line_vfir);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_source (p, 1, "s4");
    orc_program_add_source (p, 1, "s5");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 1, "c2");
      orc_program_add_constant (p, 2, 4, "c3");
      orc_program_add_constant (p, 2, 3, "c4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S5, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T3, ORC_VAR_S4, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3);
    orc_program_append (p, "shlw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "convubw", ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "shlw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C2);
    orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3);
    orc_program_append (p, "shrsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* deinterlace_line_linear */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("deinterlace_line_linear:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "deinterlace_line_linear");
    orc_program_set_backup_function (p, _backup_deinterlace_line_linear);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* deinterlace_line_linear_blend */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("deinterlace_line_linear_blend:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "deinterlace_line_linear_blend");
    orc_program_set_backup_function (p, _backup_deinterlace_line_linear_blend);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T3);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T3);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }


  if (error) {
    return 1;
  };
  return 0;
}
