// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GOOCANVASMM_ITEM_H
#define _GOOCANVASMM_ITEM_H


#include <glibmm.h>


/* Copyright (C) 1998-2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <goocanvasmm/bounds.h>
#include <goocanvasmm/enums.h>
#include <goocanvasmm/style.h>
#include <cairomm/cairomm.h>
#include <goocanvasitem.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef union _GooCanvasPathCommand GooCanvasPathCommand; }
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GooCanvasItem GooCanvasItem;
typedef struct _GooCanvasItemClass GooCanvasItemClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{ class Item_Class; } // namespace Goocanvas
namespace Goocanvas
{

class Canvas ;
class ItemModel ;


class Item : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Item CppObjectType;
  typedef Item_Class CppClassType;
  typedef GooCanvasItem BaseObjectType;
  typedef GooCanvasItemIface BaseClassType;

private:
  friend class Item_Class;
  static CppClassType item_class_;

  // noncopyable
  Item(const Item&);
  Item& operator=(const Item&);

protected:
  Item(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit Item(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit Item(GooCanvasItem* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Item();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GooCanvasItem*       gobj()       { return reinterpret_cast<GooCanvasItem*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GooCanvasItem* gobj() const { return reinterpret_cast<GooCanvasItem*>(gobject_); }

private:


public:

  
  /** Returns: the Goo::Canvas.
   * @return The Goo::Canvas.
   */
  Canvas* get_canvas();
  
  /** Returns: the Goo::Canvas.
   * @return The Goo::Canvas.
   */
  const Canvas* get_canvas() const;
  // TODO: should this be passed by reference instead of by pointer?
  
  /** This function is only intended to be used when implementing new canvas
   * items, specifically container items such as Goo::CanvasGroup.
   * 
   * It sets the canvas of the item.
   * @param canvas A Goo::Canvas.
   */
  void set_canvas(Canvas* canvas);

  
  /** Checks if the item is visible.
   * 
   * This entails checking the item's own visibility setting, as well as those
   * of its ancestors.
   * 
   * Note that the item may be scrolled off the screen and so may not
   * be actually visible to the user.
   * @return <tt>true</tt> if the item is visible.
   */
  bool is_visible() const;

  
  /** Gets the model of the given canvas item.
   * @return The item's model, or <tt>0</tt> if it has no model.
   */
  Glib::RefPtr<ItemModel> get_model();
  
  /** Gets the model of the given canvas item.
   * @return The item's model, or <tt>0</tt> if it has no model.
   */
  Glib::RefPtr<const ItemModel> get_model() const;
  
  /** Sets the model of the given canvas item.
   * @param model A Goo::CanvasItemModel.
   */
  void set_model(const Glib::RefPtr<ItemModel>& model);

  
  /** Gets the parent of the given item.
   * @return The parent item, or <tt>0</tt> if the item has no parent.
   */
  Glib::RefPtr<Item> get_parent();
  
  /** Gets the parent of the given item.
   * @return The parent item, or <tt>0</tt> if the item has no parent.
   */
  Glib::RefPtr<const Item> get_parent() const;
  
  /** This function is only intended to be used when implementing new canvas
   * items, specifically container items such as Goo::CanvasGroup.
   * 
   * It sets the parent of the item.
   * @param parent The new parent item.
   */
  void set_parent(const Glib::RefPtr<Item>& parent);
  
  /** Removes an item from its parent. If the item is in a canvas it will be
   * removed.
   * 
   * This would normally also result in the item being freed.
   */
  void remove();

  
  /** Tests to see if the given item is a container.
   * @return <tt>true</tt> if the item is a container.
   */
  bool is_container() const;
  
  /** Gets the number of children of the container.
   * @return The number of children.
   */
  int get_n_children() const;
  
  /** Gets the child item at the given stack position.
   * @param child_num The position of a child in the container's stack.
   * @return The child item at the given stack position.
   */
  Glib::RefPtr<Item> get_child(int child_num);
  
  /** Gets the child item at the given stack position.
   * @param child_num The position of a child in the container's stack.
   * @return The child item at the given stack position.
   */
  Glib::RefPtr<const Item> get_child(int child_num) const;
  
  /** Attempts to find the given child item with the container's stack.
   * @param child The child item to find.
   * @return The position of the given @a child item, or -1 if it isn't found.
   */
  int find_child(const Glib::RefPtr<Item>& child);
  
  /** Adds a child item to a container item at the given stack position.
   * @param child The item to add.
   * @param position The position of the item, or -1 to place it last (at the top of
   * the stacking order).
   */
  void add_child(const Glib::RefPtr<Item>& child, int pos);
  void add_child(const Glib::RefPtr<Item>& child);
  
  /** Gets a child property of @a child.
   * @param child A child Goo::CanvasItem.
   * @param property_name The name of the child property to get.
   * @param value A location to return the value.
   */
  void get_child_property(const Glib::RefPtr<Item>& child, const Glib::ustring& property_name, Glib::ValueBase& value) const;
  
  /** Sets a child property of @a child.
   * @param child A child Goo::CanvasItem.
   * @param property_name The name of the child property to set.
   * @param value The value to set the property to.
   */
  void set_child_property(const Glib::RefPtr<Item>& child, const Glib::ustring& property_name, const Glib::ValueBase& value);

  
  /** Moves a child item to a new stack position within the container.
   * @param old_position The current position of the child item.
   * @param new_position The new position of the child item.
   */
  void move_child(int old_position, int new_position);
  
  /** Removes the child item at the given position.
   * @param child_num The position of the child item to remove.
   */
  void remove_child(int child_num);

  
  /** Raises an item in the stacking order.
   * @param above The item to raise @a item above, or <tt>0</tt> to raise @a item to the top
   * of the stack.
   */
  void raise(const Glib::RefPtr<Item>& above);

  /** Raise the item to the top of the stack.
   */
  void raise();

  
  /** Lowers an item in the stacking order.
   * @param below The item to lower @a item below, or <tt>0</tt> to lower @a item to the
   * bottom of the stack.
   */
  void lower(const Glib::RefPtr<Item>& below);

  /** Lower the item to the bottom of the stack.
   */
  void lower();

  Bounds get_bounds() const;
  

  /** This function is only intended to be used when implementing new canvas
   * items.
   * 
   * It requests that an update of the item is scheduled. It will be performed
   * as soon as the application is idle, and before the canvas is redrawn.
   */
  void request_update();
  
  /** This function is only intended to be used when implementing new canvas
   * items.
   * 
   * It updates the canvas immediately, if an update is scheduled.
   * This ensures that all item bounds are up-to-date.
   */
  void ensure_upated();
  
  /** This function is only intended to be used when implementing new canvas
   * items, specifically container items such as Goo::CanvasGroup.
   * 
   * Updates the item, if needed, and any children.
   * @param entire_tree If the entire subtree should be updated.
   * @param cr A cairo context.
   * @param bounds A Goo::CanvasBounds to return the new bounds in.
   */
  void update(bool entire_tree, const Cairo::RefPtr<Cairo::Context>& context, Bounds& bounds);
  
  /** This function is only intended to be used when implementing new canvas
   * items, specifically container items such as Goo::CanvasGroup.
   * 
   * It paints the item and all children if they intersect the given bounds.
   * 
   * Note that the @a scale argument may be different to the current scale in the
   * Goo::CanvasItem, e.g. when the canvas is being printed.
   * @param cr A cairo context.
   * @param bounds The bounds that need to be repainted.
   * @param scale The scale to use to determine whether an item should be painted.
   * See Goo::CanvasItem:visibility-threshold.
   */
  void paint(const Cairo::RefPtr<Cairo::Context>& context, const Bounds& bounds, double scale);
  
  /** This function is only intended to be used when implementing new canvas
   * items, specifically layout items such as Goo::CanvasTable.
   * 
   * It gets the requested area of a child item.
   * @param cr A cairo context.
   * @param requested_area A Goo::CanvasBounds to return the requested area in, in the
   * parent's coordinate space.
   * @return <tt>true</tt> if the item should be allocated space.
   */
  bool get_requested_area(const Cairo::RefPtr<Cairo::Context>& context, Bounds& bounds) const;
  
  /** This function is only intended to be used when implementing new canvas
   * items, specifically layout items such as Goo::CanvasTable.
   * 
   * It gets the requested height of a child item, assuming it is allocated the
   * given width. This is useful for text items whose requested height may change
   * depending on the allocated width.
   * @param cr A cairo context.
   * @param width The width that the item may be allocated.
   * @return The requested height of the item, given the allocated width,
   * or %-1 if the item doesn't support this method or its height doesn't
   * change when allocated different widths.
   */
  double get_requested_height(const Cairo::RefPtr<Cairo::Context>& context, double width) const;
  
  /** This function is only intended to be used when implementing new canvas
   * items, specifically layout items such as Goo::CanvasTable.
   * 
   * It allocates an area to a child Goo::CanvasItem.
   * 
   * Note that the parent layout item will use a transform to move each of its
   * children for the layout, so there is no need for the child item to
   * reposition itself. It only needs to recalculate its device bounds.
   * 
   * To help recalculate the item's device bounds, the @a x_offset and @a y_offset
   * of the child item's allocated position from its requested position are
   * provided. Simple items can just add these to their bounds.
   * @param cr A cairo context.
   * @param requested_area The area that the item originally requested, in the
   * parent's coordinate space.
   * @param allocated_area The area that the item has been allocated, in the parent's
   * coordinate space.
   * @param x_offset The x offset of the allocated area from the requested area in
   * the device coordinate space.
   * @param y_offset The y offset of the allocated area from the requested area in
   * the device coordinate space.
   */
  void allocate_area(const Cairo::RefPtr<Cairo::Context>& context, const Bounds& requested_area, const Bounds& allocated_area, double x_offset, double y_offset);


  // Note the semantics of the C version: The returned list is the same as the
  // one fed into the function, with possibly some elements added to the head.
 

  /** This function is only intended to be used when implementing new canvas
   * items, specifically container items such as Goo::CanvasGroup.
   * 
   * It gets the items at the given point.
   * @param x The x coordinate of the point.
   * @param y The y coordinate of the point.
   * @param cr A cairo contect.
   * @param is_pointer_event <tt>true</tt> if the "pointer-events" properties of items should
   * be used to determine which parts of the item are tested.
   * @param parent_is_visible <tt>true</tt> if the parent item is visible (which
   * implies that all ancestors are also visible).
   * @param found_items The list of items found so far.
   * @return The @a found_items list, with any more found items added onto
   * the start of the list, leaving the top item first.
   */
  Glib::ListHandle< Glib::RefPtr<Item> > get_items_at(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool parent_is_visible, const Glib::ListHandle< Glib::RefPtr<Item> >& found_items);
  
  /** This function is only intended to be used when implementing new canvas
   * items, specifically container items such as Goo::CanvasGroup.
   * 
   * It gets the items at the given point.
   * @param x The x coordinate of the point.
   * @param y The y coordinate of the point.
   * @param cr A cairo contect.
   * @param is_pointer_event <tt>true</tt> if the "pointer-events" properties of items should
   * be used to determine which parts of the item are tested.
   * @param parent_is_visible <tt>true</tt> if the parent item is visible (which
   * implies that all ancestors are also visible).
   * @param found_items The list of items found so far.
   * @return The @a found_items list, with any more found items added onto
   * the start of the list, leaving the top item first.
   */
  Glib::ListHandle< Glib::RefPtr<const Item> > get_items_at(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool parent_is_visible, const Glib::ListHandle< Glib::RefPtr<const Item> >& found_items) const;

  // Use this if you don't have a list already:
  Glib::ListHandle< Glib::RefPtr<Item> > get_items_at(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool parent_is_visible);
  Glib::ListHandle< Glib::RefPtr<const Item> > get_items_at(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool parent_is_visible) const;

  //TODO: Use Cairo::RefPtr?
  
  /** Gets the transformation matrix of an item.
   * @param transform The place to store the transform.
   * @return <tt>true</tt> if a transform is set.
   */
  bool get_transform(Cairo::Matrix* matrix);
  
  /** Sets the transformation matrix of an item.
   * @param transform The new transformation matrix, or <tt>0</tt> to reset the
   * transformation to the identity matrix.
   */
  void set_transform(const Cairo::Matrix* matrix);

  
  /** A convenience function to set the item's transformation matrix.
   * @param x The x coordinate of the origin of the item's coordinate space.
   * @param y The y coordinate of the origin of the item's coordinate space.
   * @param scale The scale of the item.
   * @param rotation The clockwise rotation of the item, in degrees.
   */
  void set_simple_transform(double x, double y, double scale, double rotation);
  
  bool get_simple_transform(double& x, double& y, double& scale, double& rotation) const;
  
  /** Translates the origin of the item's coordinate system by the given amounts.
   * @param tx The amount to move the origin in the horizontal direction.
   * @param ty The amount to move the origin in the vertical direction.
   */
  void translate(double tx, double ty);
  
  /** Scales the item's coordinate system by the given amounts.
   * @param sx The amount to scale the horizontal axis.
   * @param sy The amount to scale the vertical axis.
   */
  void scale(double sx, double sy);
  
  /** Rotates the item's coordinate system by the given amount, about the given
   * origin.
   * @param degrees The clockwise angle of rotation.
   * @param cx The x coordinate of the origin of the rotation.
   * @param cy The y coordinate of the origin of the rotation.
   */
  void rotate(double degrees, double cx, double cy);
  
  /** Skews the item's coordinate system along the x axis by the given amount,
   * about the given origin.
   * @param degrees The skew angle.
   * @param cx The x coordinate of the origin of the skew transform.
   * @param cy The y coordinate of the origin of the skew transform.
   */
  void skew_x(double degrees, double cx, double cy);
  
  /** Skews the item's coordinate system along the y axis by the given amount,
   * about the given origin.
   * @param degrees The skew angle.
   * @param cx The x coordinate of the origin of the skew transform.
   * @param cy The y coordinate of the origin of the skew transform.
   */
  void skew_y(double degrees, double cx, double cy);

  
  /** Gets the transformation matrix of an item combined with any special
   * transform needed for the given child. These special transforms are used
   * by layout items such as Goo::CanvasTable.
   * @param child A child of @a item.
   * @param transform The place to store the transform.
   * @return <tt>true</tt> if a transform is set.
   */
  bool get_transform_for_child(const Glib::RefPtr<Item>& child, Cairo::Matrix* transform);

  
  /** Gets the item's style. If the item doesn't have its own style it will return
   * its parent's style.
   * @return The item's style.
   */
  Glib::RefPtr<Style> get_style();
  
  /** Gets the item's style. If the item doesn't have its own style it will return
   * its parent's style.
   * @return The item's style.
   */
  Glib::RefPtr<const Style> get_style() const;
  
  /** Sets the item's style, by copying the properties from the given style.
   * @param style A style.
   */
  void set_style(const Glib::RefPtr<Style>& style);

  
  /** Animates an item from its current position to the given offsets, scale
   * and rotation.
   * @param x The final x coordinate.
   * @param y The final y coordinate.
   * @param scale The final scale.
   * @param degrees The final rotation. This can be negative to rotate anticlockwise,
   * and can also be greater than 360 to rotate a number of times.
   * @param absolute If the @a x, @a y, @a scale and @a degrees values are absolute, or
   * relative to the current transform. Note that absolute animations only work
   * if the item currently has a simple transform. If the item has a shear or
   * some other complicated transform it may result in strange animations.
   * @param duration The duration of the animation, in milliseconds (1/1000ths of a
   * second).
   * @param step_time The time between each animation step, in milliseconds.
   * @param type Specifies what happens when the animation finishes.
   */
  void animate(double x, double y, double scale, double degrees, bool absolute, int duration, int step_time, GooCanvasAnimateType type);
  
  /** Stops any current animation for the given item, leaving it at its current
   * position.
   */
  void stop_animation();


  //_WRAP_SIGNAL(void child_added(int child_num), "child_added")
  //_WRAP_SIGNAL(void child_moved(int old_position, int new_position), "child_moved")
  //_WRAP_SIGNAL(void child_removed(int child_num), "child_removed")
  //_WRAP_SIGNAL(void changed(bool recompute_bounds), "changed")

 
  /**
   * @par Prototype:
   * <tt>bool on_my_%enter_notify_event(const Glib::RefPtr<Item>& target, GdkEventCrossing* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventCrossing* > signal_enter_notify_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%leave_notify_event(const Glib::RefPtr<Item>& target, GdkEventCrossing* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventCrossing* > signal_leave_notify_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%motion_notify_event(const Glib::RefPtr<Item>& target, GdkEventMotion* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventMotion* > signal_motion_notify_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_press_event(const Glib::RefPtr<Item>& target, GdkEventButton* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventButton* > signal_button_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%button_release_event(const Glib::RefPtr<Item>& target, GdkEventButton* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventButton* > signal_button_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%focus_in_event(const Glib::RefPtr<Item>& target, GdkEventFocus* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventFocus* > signal_focus_in_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%focus_out_event(const Glib::RefPtr<Item>& target, GdkEventFocus* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventFocus* > signal_focus_out_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_press_event(const Glib::RefPtr<Item>& target, GdkEventKey* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventKey* > signal_key_press_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%key_release_event(const Glib::RefPtr<Item>& target, GdkEventKey* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventKey* > signal_key_release_event();

  
  /**
   * @par Prototype:
   * <tt>bool on_my_%grab_broken_event(const Glib::RefPtr<Item>& target, GdkEventGrabBroken* event)</tt>
   */

  Glib::SignalProxy2< bool,const Glib::RefPtr<Item>&,GdkEventGrabBroken* > signal_grab_broken_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%child_notify(GParamSpec* pspec)</tt>
   */

  Glib::SignalProxy1< void,GParamSpec* > signal_child_notify();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The parent item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Item> > property_parent() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The parent item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Item> > property_parent() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
;
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** When the canvas item is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ItemVisibility> property_visibility() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** When the canvas item is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ItemVisibility> property_visibility() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The scale threshold at which the item becomes visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_visibility_threshold() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The scale threshold at which the item becomes visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_visibility_threshold() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The transformation matrix of the item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Cairo::Matrix*> property_transform() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The transformation matrix of the item.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Cairo::Matrix*> property_transform() const;
#endif //#GLIBMM_PROPERTIES_ENABLED
;
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Specifies when the item receives pointer events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<PointerEvents> property_pointer_events() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Specifies when the item receives pointer events.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<PointerEvents> property_pointer_events() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A short context-rich description of the item for use by assistive technologies.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A short context-rich description of the item for use by assistive technologies.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** A description of the item for use by assistive technologies.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_description() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** A description of the item for use by assistive technologies.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_description() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If the item can take the keyboard focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_can_focus() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If the item can take the keyboard focus.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_can_focus() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:

 
;
 

/* Virtual methods that group items must implement. */
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual int get_n_children_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Item> get_child_vfunc(int child_num) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void request_update_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Canvas* get_canvas_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_canvas_vfunc(Canvas* canvas);
#endif //GLIBMM_VFUNCS_ENABLED


  /* Virtual methods that group items may implement. */

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void add_child_vfunc(const Glib::RefPtr<Item>& child, int position);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void move_child_vfunc(int old_position, int new_position);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void remove_child_vfunc(int child_num);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void get_child_property_vfunc(const Glib::RefPtr<Item>& child, guint property_id, Glib::ValueBase& value, GParamSpec* pspec) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_child_property_vfunc(const Glib::RefPtr<Item>& child, guint property_id, const Glib::ValueBase& value, GParamSpec* pspec);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_transform_for_child_vfunc(const Glib::RefPtr<Item>& child, Cairo::Matrix* transform) const;
#endif //GLIBMM_VFUNCS_ENABLED


  /* Virtual methods that all canvas items must implement. */

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Item> get_parent_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_parent_vfunc(const Glib::RefPtr<Item>& parent);
#endif //GLIBMM_VFUNCS_ENABLED


#ifdef GLIBMM_VFUNCS_ENABLED
  // Hand code, since Bounds can only copy a GooCanvasBounds* but not ref one.
  virtual void get_bounds_vfunc(Bounds& bounds) const;
  virtual Glib::ListHandle<Glib::RefPtr<Item> > get_items_at_vfunc(double x, double y, const Cairo::RefPtr<Cairo::Context>& context, bool is_pointer_event, bool is_parent_visible, const Glib::ListHandle<Glib::RefPtr<Item> >& found_items) const;
#endif


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void update_vfunc(bool entire_tree, const Cairo::RefPtr<Cairo::Context>& cr, Bounds& bounds);
#endif //GLIBMM_VFUNCS_ENABLED


;
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void paint_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, const Bounds& bounds, double scale);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_requested_area_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, GooCanvasBounds* requested_area) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void allocate_area_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, const Bounds& requested_area, const Bounds& allocated_area, double x_offset, double y_offset);
#endif //GLIBMM_VFUNCS_ENABLED


  /* Virtual methods that canvas items may implement. */

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool get_transform_vfunc(Cairo::Matrix* transform) const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_transform_vfunc(const Cairo::Matrix* transform);
#endif //GLIBMM_VFUNCS_ENABLED


  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<Style> get_style_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_style_vfunc(const Glib::RefPtr<Style>& style);
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual bool is_visible_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual double get_requested_height_vfunc(const Cairo::RefPtr<Cairo::Context>& cr, double width);
#endif //GLIBMM_VFUNCS_ENABLED


  /* Virtual methods that model/view items must implement. */
 

;
 

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual Glib::RefPtr<ItemModel> get_model_vfunc() const;
#endif //GLIBMM_VFUNCS_ENABLED

  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void set_model_vfunc(const Glib::RefPtr<ItemModel>& model);
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual bool on_enter_notify_event(const Glib::RefPtr<Item>& target, GdkEventCrossing* event);
  virtual bool on_leave_notify_event(const Glib::RefPtr<Item>& target, GdkEventCrossing* event);
  virtual bool on_motion_notify_event(const Glib::RefPtr<Item>& target, GdkEventMotion* event);
  virtual bool on_button_press_event(const Glib::RefPtr<Item>& target, GdkEventButton* event);
  virtual bool on_button_release_event(const Glib::RefPtr<Item>& target, GdkEventButton* event);
  virtual bool on_focus_in_event(const Glib::RefPtr<Item>& target, GdkEventFocus* event);
  virtual bool on_focus_out_event(const Glib::RefPtr<Item>& target, GdkEventFocus* event);
  virtual bool on_key_press_event(const Glib::RefPtr<Item>& target, GdkEventKey* event);
  virtual bool on_key_release_event(const Glib::RefPtr<Item>& target, GdkEventKey* event);
  virtual bool on_grab_broken_event(const Glib::RefPtr<Item>& target, GdkEventGrabBroken* event);
  virtual void on_child_notify(GParamSpec* pspec);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} //namespace Goocanvas


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Goocanvas::Item
   */
  Glib::RefPtr<Goocanvas::Item> wrap(GooCanvasItem* object, bool take_copy = false);

} // namespace Glib


#endif /* _GOOCANVASMM_ITEM_H */

