/* A Bison parser, made from parse.y
   by GNU bison 1.35.  */

#define YYBISON 1  /* Identify Bison output.  */

# define	CLASS	257
# define	FROM	258
# define	CONST	259
# define	VOID	260
# define	STRUCT	261
# define	UNION	262
# define	ENUM	263
# define	THREEDOTS	264
# define	SIGNED	265
# define	UNSIGNED	266
# define	LONG	267
# define	SHORT	268
# define	INT	269
# define	FLOAT	270
# define	DOUBLE	271
# define	CHAR	272
# define	TOKEN	273
# define	NUMBER	274
# define	TYPETOKEN	275
# define	ARRAY_DIM	276
# define	SINGLE_CHAR	277
# define	CCODE	278
# define	HTCODE	279
# define	PHCODE	280
# define	HCODE	281
# define	ACODE	282
# define	ATCODE	283
# define	STRING	284
# define	PUBLIC	285
# define	PRIVATE	286
# define	PROTECTED	287
# define	CLASSWIDE	288
# define	PROPERTY	289
# define	ARGUMENT	290
# define	VIRTUAL	291
# define	SIGNAL	292
# define	OVERRIDE	293
# define	NICK	294
# define	BLURB	295
# define	MAXIMUM	296
# define	MINIMUM	297
# define	DEFAULT_VALUE	298
# define	ERROR	299
# define	FLAGS	300
# define	TYPE	301
# define	FLAGS_TYPE	302
# define	ENUM_TYPE	303
# define	PARAM_TYPE	304
# define	BOXED_TYPE	305
# define	OBJECT_TYPE	306

#line 22 "parse.y"


#include "config.h"
#include <glib.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "treefuncs.h"
#include "main.h"
#include "util.h"

/* FIXME: add gettext support */
#define _(x) (x)
	
GList *nodes = NULL;

static GList *class_nodes = NULL;
Node *class = NULL;
GList *enums = NULL;
static GList *enum_vals = NULL;
static GList *flag_vals = NULL;
static GList *error_vals = NULL;

static char *chunk_size = NULL;
static char *bonobo_object_class = NULL;
static GList *interfaces = NULL;
static GList *typestack = NULL;
static GList *funcargs = NULL;
static GList *checks = NULL;
static int has_self = FALSE;
static int vararg = FALSE;
static Method *last_added_method = NULL;

/* destructor and initializer for variables */
static gboolean destructor_unref = FALSE;
static char *destructor = NULL;
static int destructor_line = 0;
static gboolean destructor_simple = TRUE;
static char *initializer = NULL;
static int initializer_line = 0;

static char *onerror = NULL;
static char *defreturn = NULL;

static GList *gtktypes = NULL;

static Property *property = NULL;

/* this can be a global as we will only do one function at a time
   anyway */
static int the_scope = NO_SCOPE;

void free(void *ptr);
int yylex(void);

extern int ccode_line;
extern int line_no;

extern char *yytext;

static void
yyerror(char *str)
{
	char *out=NULL;
	char *p;
	
	if(strcmp(yytext,"\n")==0) {
		out=g_strconcat("Error: ",str," before newline",NULL);
	} else if(yytext[0]=='\0') {
		out=g_strconcat("Error: ", str, " at end of input", NULL);
	} else {
		char *tmp = g_strdup(yytext);
		while((p=strchr(tmp, '\n')))
			*p='.';

		out=g_strconcat("Error: ", str, " before '", tmp, "'", NULL);
		g_free(tmp);
	}

	fprintf(stderr, "%s:%d: %s\n", filename, line_no, out);
	g_free(out);
	
	exit(1);
}

static Type *
pop_type(void)
{
	Type *type = typestack->data;
	typestack = g_list_remove(typestack,typestack->data);
	return type;
}

static void
push_variable (char *name, int scope, int line_no, char *postfix)
{
	Node *var;
	Type *type = pop_type ();

	type->postfix = postfix;
	
	var = node_new (VARIABLE_NODE,
			"scope", scope,
			"vtype:steal", type,
			"id:steal", name,
			"line_no", line_no,
			"destructor_unref", destructor_unref,
			"destructor:steal", destructor,
			"destructor_line", destructor_line,
			"destructor_simple", destructor_simple,
			"initializer:steal", initializer,
			"initializer_line", initializer_line,
			NULL);
	class_nodes = g_list_append(class_nodes, var);
}

static void
push_function (int scope, int method, char *oid, char *id,
	       GString *cbuf, int line_no, int ccode_line,
	       gboolean vararg, GList *flags)
{
	Node *node;
	Type *type;
	char *c_cbuf;

	g_assert(scope != CLASS_SCOPE);
       
	if(method == INIT_METHOD || method == CLASS_INIT_METHOD) {
		type = (Type *)node_new (TYPE_NODE,
					 "name", "void",
					 NULL);
	} else {
		type = pop_type();
	}
	
	/* a complicated and ugly test to figure out if we have
	   the wrong number of types for a signal */
	if((method == SIGNAL_FIRST_METHOD ||
	    method == SIGNAL_LAST_METHOD) &&
	   g_list_length(gtktypes) != g_list_length(funcargs) &&
	   !(g_list_length(funcargs) == 1 &&
	     g_list_length(gtktypes) == 2 &&
	     strcmp(gtktypes->next->data, "NONE")==0)) {
		error_print(GOB_WARN, line_no,
			    _("The number of GTK arguments and "
			      "function arguments for a signal "
			      "don't seem to match"));
	}
	if(g_list_length(gtktypes) > 2) {
		GList *li;
		for(li = gtktypes->next; li; li = li->next) {
			if(strcmp(li->data, "NONE")==0) {
				error_print(GOB_ERROR, line_no,
					    _("NONE can only appear in an "
					      "argument list by itself"));
			}
		}
	}
	if(cbuf) {
		char *p;
		c_cbuf = p = cbuf->str;
		while(p && *p && (*p==' ' || *p=='\t' || *p=='\n' || *p=='\r'))
			p++;
		if(!p || !*p)
			c_cbuf = NULL;
	} else
		c_cbuf = NULL;

	node = node_new (METHOD_NODE,
			 "scope", scope,
			 "method", method,
			 "mtype:steal", type,
			 "otype:steal", oid,
			 "gtktypes:steal", gtktypes,
			 "flags:steal", flags,
			 "id:steal", id,
			 "args:steal", funcargs,
			 "onerror:steal", onerror,
			 "defreturn:steal", defreturn,
			 "cbuf:steal", c_cbuf,
			 "line_no", line_no,
			 "ccode_line", ccode_line,
			 "vararg", vararg,
			 "unique_id", method_unique_id++,
			 NULL);

	last_added_method = (Method *)node;

	if(cbuf)
		g_string_free(cbuf,
			      /*only free segment if we haven't passed it
				above */
			      c_cbuf?FALSE:TRUE);
	gtktypes = NULL;
	funcargs = NULL;

	onerror = NULL;
	defreturn = NULL;

	class_nodes = g_list_append(class_nodes, node);
}

static void
free_all_global_state(void)
{
	g_free(onerror);
	onerror = NULL;
	g_free(defreturn);
	defreturn = NULL;

	g_free(chunk_size);
	chunk_size = NULL;
	
	g_list_foreach(gtktypes, (GFunc)g_free, NULL);
	g_list_free(gtktypes);
	gtktypes = NULL;

	node_list_free (funcargs);
	funcargs = NULL;
}

static void
push_funcarg(char *name, char *postfix)
{
	Node *node;
	Type *type = pop_type();

	type->postfix = postfix;
	
	node = node_new (FUNCARG_NODE,
			 "atype:steal", type,
			 "name:steal", name,
			 "checks:steal", checks,
			 NULL);
	checks = NULL;
	
	funcargs = g_list_append(funcargs, node);
}

static void
push_init_arg(char *name, int is_class)
{
	Node *node;
	Node *type;
	char *tn;
	
	if(is_class)
		tn = g_strconcat(((Class *)class)->otype,":Class",NULL);
	else
		tn = g_strdup(((Class *)class)->otype);

	type = node_new (TYPE_NODE,
			 "name:steal", tn,
			 "pointer", "*",
			 NULL);
	node = node_new (FUNCARG_NODE,
			 "atype:steal", (Type *)type,
			 "name:steal", name,
			 NULL);
	funcargs = g_list_prepend(funcargs, node);
}

static void
push_self(char *id, gboolean constant)
{
	Node *node;
	Node *type;
	GList *ch = NULL;
	type = node_new (TYPE_NODE,
			 "name", ((Class *)class)->otype,
			 "pointer", constant ? "const *" : "*",
			 NULL);
	ch = g_list_append (ch, node_new (CHECK_NODE,
					  "chtype", NULL_CHECK,
					  NULL));
	ch = g_list_append (ch, node_new (CHECK_NODE,
					  "chtype", TYPE_CHECK,
					  NULL));
	node = node_new (FUNCARG_NODE,
			 "atype:steal", (Type *)type,
			 "name:steal", id,
			 "checks:steal", ch,
			 NULL);
	funcargs = g_list_prepend(funcargs, node);
}

static Variable *
find_var_or_die(const char *id, int line)
{
	GList *li;

	for(li = class_nodes; li != NULL; li = li->next) {
		Variable *var;
		Node *node = li->data;
		if(node->type != VARIABLE_NODE)
			continue;
		var = li->data;
		if(strcmp(var->id, id)==0)
			return var;
	}

	error_printf(GOB_ERROR, line, _("Variable %s not defined here"), id);

	g_assert_not_reached();
	return NULL;
}

static gboolean
set_return_value(char *type, char *val)
{
	if(strcmp(type, "onerror")==0) {
		if(!onerror) {
			onerror = val;
			return TRUE;
		} else
			return FALSE;
	} else if(strcmp(type, "defreturn")==0) {
		if(!defreturn) {
			defreturn = val;
			return TRUE;
		} else
			return FALSE;
	}
	return FALSE;
}

static void
export_accessors (const char *var_name,
		  gboolean do_get,
		  int get_lineno,
		  gboolean do_set,
		  int set_lineno,
		  Type *type,
		  const char *gtktype,
		  int lineno)
{	
	Type *the_type;

	if (type != NULL)
		the_type = (Type *)node_copy ((Node *)type);
	else
		the_type = get_tree_type (gtktype, TRUE);

	if (the_type == NULL) {
		error_print (GOB_ERROR, line_no,
			     _("Cannot determine type of property or argument"));
		return;
	}

	if (do_get) {
		char *get_id = g_strdup_printf ("get_%s", var_name);
		GString *get_cbuf = g_string_new (NULL);
		Node *node1 = node_new (TYPE_NODE,
					"name", the_type->name,
					"pointer", the_type->pointer,
					"postfix", the_type->postfix,
					NULL);
		Node *node3 = node_new (TYPE_NODE,
					"name", class->class.otype,
					"pointer", "*",
					NULL);

		g_string_sprintf (get_cbuf,
				  "\t%s%s val; "
				  "g_object_get (G_OBJECT (self), \"%s\", "
				  "&val, NULL); "
				  "return val;\n",
				  the_type->name, 
				  the_type->pointer ? the_type->pointer : "",
				  var_name);
		
		typestack = g_list_prepend (typestack, node1);
		typestack = g_list_prepend (typestack, node3);
		
		push_funcarg ("self", FALSE);
		
		push_function (PUBLIC_SCOPE, REGULAR_METHOD, NULL,
			       get_id, get_cbuf, get_lineno,
			       lineno, FALSE, NULL);
	}
	
	if (do_set) {
		char *set_id = g_strdup_printf ("set_%s", var_name);
		GString *set_cbuf = g_string_new (NULL);
		Node *node1 = node_new (TYPE_NODE, 
					"name", the_type->name,
					"pointer", the_type->pointer,
					"postfix", the_type->postfix,
					NULL);
		Node *node2 = node_new (TYPE_NODE, 
					"name", "void",
					NULL);
		Node *node3 = node_new (TYPE_NODE, 
					"name", class->class.otype,
					"pointer", "*",
					NULL);

		g_string_sprintf (set_cbuf,
				  "\tg_object_set (G_OBJECT (self), "
				  "\"%s\", val, NULL);\n",
				  var_name);

		typestack = g_list_prepend (typestack, node2);
		typestack = g_list_prepend (typestack, node1);
		typestack = g_list_prepend (typestack, node3);
		
		push_funcarg ("self", FALSE);
		push_funcarg ("val", FALSE);
	
		typestack = g_list_prepend (typestack, node2);
		push_function (PUBLIC_SCOPE, REGULAR_METHOD, NULL,
			       set_id, set_cbuf, set_lineno,
			       lineno, FALSE, NULL);
	}

	node_free ((Node *)the_type);
}

static char *
get_prop_enum_flag_cast (Property *prop)
{
	char *tmp, *ret;
	if (prop->extra_gtktype == NULL ||
	/* HACK!  just in case someone made this
	 * work with 2.0.0 by using the TYPE
	 * macro directly */
	    ((strstr (prop->extra_gtktype, "_TYPE_") != NULL ||
	      strstr (prop->extra_gtktype, "TYPE_") == prop->extra_gtktype) &&
	     strchr (prop->extra_gtktype, ':') == NULL)) {
		if (prop->ptype != NULL)
			return get_type (prop->ptype, TRUE);
		else
			return g_strdup ("");
	}
	tmp = remove_sep (prop->extra_gtktype);
	ret = g_strdup_printf ("(%s) ", tmp);
	g_free (tmp);
	return ret;
}

static void
property_link_and_export (Node *node)
{
	Property *prop = (Property *)node;

	if (prop->link) {
		const char *root;
		char *get = NULL, *set = NULL;
		Variable *var;

		if (prop->set != NULL ||
		    prop->get != NULL) {	
			error_print (GOB_ERROR, prop->line_no,
				     _("Property linking requested, but "
				       "getters and setters exist"));
		}

		var = find_var_or_die (prop->name, prop->line_no);
		if(var->scope == PRIVATE_SCOPE) {
			root = "self->_priv";
		} else if (var->scope == CLASS_SCOPE) {
			root = "SELF_GET_CLASS(self)";
			if (no_self_alias)
				error_print (GOB_ERROR, prop->line_no,
					     _("Self aliases needed when autolinking to a classwide member"));
		} else {
			root = "self";
		}

		if (strcmp (prop->gtktype, "STRING") == 0) {
			set = g_strdup_printf("{ char *old = %s->%s; "
					      "%s->%s = g_value_dup_string (VAL); g_free (old); }",
					      root, prop->name,
					      root, prop->name);
			get = g_strdup_printf("g_value_set_string (VAL, %s->%s);",
					      root, prop->name);
		} else if (strcmp (prop->gtktype, "OBJECT") == 0) {
			char *cast;
			if (prop->extra_gtktype != NULL) {
				cast = remove_sep (prop->extra_gtktype);
			} else {
				cast = g_strdup ("void");
			}
			set = g_strdup_printf("{ GObject *___old = (GObject *)%s->%s; "
					      "%s->%s = (%s *)g_value_dup_object (VAL); "
					      "if (___old != NULL) { "
					        "g_object_unref (G_OBJECT (___old)); "
					      "} "
					      "}",
					      root, prop->name,
					      root, prop->name,
					      cast);
			get = g_strdup_printf ("g_value_set_object (VAL, "
					       "(gpointer)%s->%s);",
					       root, prop->name);
			g_free (cast);
		} else if (strcmp (prop->gtktype, "BOXED") == 0) {
			if (prop->extra_gtktype == NULL) {
				error_print (GOB_ERROR, prop->line_no,
					     _("Property linking requested for BOXED, but "
					       "boxed_type not set"));
			}
			set = g_strdup_printf("{ gpointer ___old = (gpointer)%s->%s; "
					      "gpointer ___new = (gpointer)g_value_get_boxed (VAL); "
					      "if (___new != ___old) { "
					        "if (___old != NULL) g_boxed_free (%s, ___old); "
					        "if (___new != NULL) %s->%s = g_boxed_copy (%s, ___new); "
					        "else %s->%s = NULL;"
					      "} "
					      "}",
					      root, prop->name,
					      prop->extra_gtktype,
					      root, prop->name,
					      prop->extra_gtktype,
					      root, prop->name);
			get = g_strdup_printf("g_value_set_boxed (VAL, %s->%s);",
					      root, prop->name);
		} else {
			char *set_func;
			char *get_func;
			const char *getcast = "";
			const char *setcast = "";
			char *to_free = NULL;
			set_func = g_strdup_printf ("g_value_set_%s", prop->gtktype);
			g_strdown (set_func);
			get_func = g_strdup_printf ("g_value_get_%s", prop->gtktype);
			g_strdown (get_func);

			if (strcmp (prop->gtktype, "FLAGS") == 0) {
				setcast = "(guint) ";
				getcast = to_free =
					get_prop_enum_flag_cast (prop);
			} else if (strcmp (prop->gtktype, "ENUM") == 0) {
				setcast = "(gint) ";
				getcast = to_free =
					get_prop_enum_flag_cast (prop);
			}

			set = g_strdup_printf("%s->%s = %s%s (VAL);",
					      root, prop->name,
					      getcast,
					      get_func);
			get = g_strdup_printf("%s (VAL, %s%s->%s);",
					      set_func,
					      setcast,	
					      root, prop->name);

			g_free (get_func);
			g_free (set_func);
			g_free (to_free);
		}

		node_set (node,
			  "get:steal", get,
			  "get_line", prop->line_no,
			  "set:steal", set,
			  "set_line", prop->line_no,
			  NULL);
	}

	if (prop->export) {
		export_accessors (prop->name,
				  prop->get != NULL, prop->get_line,
				  prop->set != NULL,  prop->set_line,
				  prop->ptype,
				  prop->gtktype,
				  prop->line_no);
	} 
}


static char *
debool (char *s)
{
	if (strcmp (s, "BOOL") == 0) {
		error_print (GOB_WARN, line_no,
			    _("BOOL type is deprecated, please use BOOLEAN"));
		g_free (s);
		return g_strdup ("BOOLEAN");
	} else {
		return s;
	}
}

static void
ensure_property (void)
{
	if (property == NULL)
		property = (Property *)node_new (PROPERTY_NODE, NULL);
}


#line 616 "parse.y"
#ifndef YYSTYPE
typedef union {
	char *id;
	GString *cbuf;
	GList *list;
	int line;
	int sigtype;
} yystype;
# define YYSTYPE yystype
# define YYSTYPE_IS_TRIVIAL 1
#endif
#ifndef YYDEBUG
# define YYDEBUG 1
#endif



#define	YYFINAL		398
#define	YYFLAG		-32768
#define	YYNTBASE	66

/* YYTRANSLATE(YYLEX) -- Bison token number corresponding to YYLEX. */
#define YYTRANSLATE(x) ((unsigned)(x) <= 306 ? yytranslate[x] : 118)

/* YYTRANSLATE[YYLEX] -- Bison token number corresponding to YYLEX. */
static const char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    64,     2,     2,     2,     2,     2,     2,
      55,    56,    61,     2,    59,    65,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    57,
      63,    58,    62,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    53,    60,    54,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    48,    49,    50,    51,    52
};

#if YYDEBUG
static const short yyprhs[] =
{
       0,     0,     4,     7,    10,    12,    14,    16,    18,    20,
      22,    24,    27,    30,    33,    36,    38,    40,    42,    44,
      49,    53,    59,    60,    66,    72,    78,    81,    83,    85,
      88,    92,    94,    96,    98,   100,   102,   104,   106,   108,
     111,   115,   118,   122,   125,   128,   130,   132,   133,   139,
     146,   159,   169,   176,   180,   181,   193,   202,   208,   212,
     213,   217,   219,   221,   226,   228,   230,   234,   238,   242,
     246,   250,   254,   258,   262,   266,   270,   274,   278,   282,
     286,   290,   294,   298,   300,   306,   308,   312,   313,   317,
     319,   322,   324,   326,   328,   331,   334,   337,   341,   345,
     348,   351,   354,   356,   359,   361,   364,   366,   368,   370,
     372,   374,   376,   378,   380,   382,   384,   386,   388,   390,
     393,   396,   400,   403,   405,   409,   413,   416,   418,   423,
     427,   429,   432,   434,   445,   457,   467,   477,   486,   498,
     507,   513,   516,   521,   522,   524,   527,   529,   531,   534,
     537,   541,   546,   551,   553,   557,   559,   563,   565,   568,
     572,   579,   587,   590,   592,   594,   597,   600,   604,   608,
     612,   616,   624,   633,   637,   639,   643,   645,   653,   662,
     666,   668,   676,   685,   689,   691,   693,   696,   698
};
static const short yyrhs[] =
{
      68,    69,    68,     0,    69,    68,     0,    68,    69,     0,
      69,     0,    24,     0,    27,     0,    25,     0,    26,     0,
      28,     0,    29,     0,    68,    67,     0,    68,   110,     0,
      68,   113,     0,    68,   115,     0,    67,     0,   110,     0,
     113,     0,   115,     0,    70,    53,    72,    54,     0,    70,
      53,    54,     0,     3,    21,     4,    21,    71,     0,     0,
      55,    19,    19,    56,    71,     0,    55,    19,    21,    56,
      71,     0,    55,    19,    20,    56,    71,     0,    72,    73,
       0,    73,     0,   101,     0,    19,   101,     0,    19,    21,
     101,     0,    78,     0,    79,     0,    81,     0,    57,     0,
      31,     0,    32,     0,    33,     0,    34,     0,    19,    19,
       0,    19,    53,    24,     0,    58,   117,     0,    58,    53,
      24,     0,    75,    76,     0,    76,    75,     0,    76,     0,
      75,     0,     0,    74,    90,    19,    77,    57,     0,    74,
      90,    19,    22,    77,    57,     0,    36,    88,    87,    19,
      80,    19,    53,    24,    19,    53,    24,    57,     0,    36,
      88,    87,    19,    80,    19,    53,    24,    57,     0,    36,
      88,    87,    19,    80,    19,     0,    55,    19,    56,     0,
       0,    35,    19,    19,    82,    19,    53,    24,    19,    53,
      24,    57,     0,    35,    19,    19,    82,    19,    53,    24,
      57,     0,    35,    19,    19,    82,    57,     0,    55,    83,
      56,     0,     0,    83,    59,    86,     0,    86,     0,    30,
       0,    19,    55,    30,    56,     0,   117,     0,    84,     0,
      40,    58,    84,     0,    41,    58,    84,     0,    42,    58,
     117,     0,    43,    58,   117,     0,    44,    58,    85,     0,
      46,    58,    89,     0,    47,    58,    90,     0,    48,    58,
      21,     0,    48,    58,    19,     0,    49,    58,    21,     0,
      49,    58,    19,     0,    50,    58,    21,     0,    50,    58,
      19,     0,    51,    58,    21,     0,    51,    58,    19,     0,
      52,    58,    21,     0,    52,    58,    19,     0,    19,     0,
      19,    55,    19,    90,    56,     0,    19,     0,    55,    89,
      56,     0,     0,    19,    60,    89,     0,    19,     0,    91,
      95,     0,    91,     0,    92,     0,    19,     0,     5,    19,
       0,    19,     5,     0,    94,    19,     0,     5,    94,    19,
       0,    94,    19,     5,     0,    93,    92,     0,    21,    92,
       0,     5,    92,     0,    21,     0,    21,     5,     0,    93,
       0,    93,     5,     0,     6,     0,    18,     0,    14,     0,
      15,     0,    13,     0,    16,     0,    17,     0,    11,     0,
      12,     0,     7,     0,     8,     0,     9,     0,    61,     0,
      61,     5,     0,    61,    95,     0,    61,     5,    95,     0,
      19,    98,     0,    98,     0,    74,    19,    98,     0,    19,
      74,    98,     0,    74,    98,     0,    96,     0,    19,    55,
      99,    56,     0,    99,    59,    19,     0,    19,     0,    53,
      24,     0,    57,     0,    38,    88,    97,    90,    19,    55,
     104,    56,   102,   100,     0,    74,    38,    88,    96,    90,
      19,    55,   104,    56,   102,   100,     0,    37,    74,    90,
      19,    55,   104,    56,   102,   100,     0,    74,    37,    90,
      19,    55,   104,    56,   102,   100,     0,    37,    90,    19,
      55,   104,    56,   102,   100,     0,    39,    55,    21,    56,
      90,    19,    55,   104,    56,   102,   100,     0,    74,    90,
      19,    55,   104,    56,   102,   100,     0,    19,    55,    19,
      56,   100,     0,    19,   103,     0,    19,   103,    19,   103,
       0,     0,   117,     0,    53,    24,     0,     6,     0,    19,
       0,    19,     5,     0,     5,    19,     0,    19,    59,   105,
       0,    19,     5,    59,   105,     0,     5,    19,    59,   105,
       0,   105,     0,   106,    59,    10,     0,   106,     0,   106,
      59,   107,     0,   107,     0,    90,    19,     0,    90,    19,
      22,     0,    90,    19,    55,    19,   108,    56,     0,    90,
      19,    22,    55,    19,   108,    56,     0,   108,   109,     0,
     109,     0,    19,     0,    62,   117,     0,    63,   117,     0,
      62,    58,   117,     0,    63,    58,   117,     0,    58,    58,
     117,     0,    64,    58,   117,     0,     9,    19,    53,   111,
      54,    21,    57,     0,     9,    19,    53,   111,    59,    54,
      21,    57,     0,   111,    59,   112,     0,   112,     0,    19,
      58,   117,     0,    19,     0,    46,    19,    53,   114,    54,
      21,    57,     0,    46,    19,    53,   114,    59,    54,    21,
      57,     0,   114,    59,    19,     0,    19,     0,    45,    19,
      53,   116,    54,    21,    57,     0,    45,    19,    53,   116,
      59,    54,    21,    57,     0,   116,    59,    19,     0,    19,
       0,    20,     0,    65,    20,     0,    23,     0,    19,     0
};

#endif

#if YYDEBUG
/* YYRLINE[YYN] -- source line where rule number YYN was defined. */
static const short yyrline[] =
{
       0,   637,   638,   639,   640,   643,   652,   661,   670,   679,
     688,   699,   700,   701,   702,   703,   704,   705,   706,   709,
     714,   721,   735,   736,   748,   757,   771,   772,   775,   776,
     785,   797,   798,   799,   800,   803,   804,   805,   806,   809,
     829,   853,   857,   865,   866,   867,   868,   869,   875,   878,
     883,   951,  1005,  1094,  1102,  1107,  1155,  1191,  1207,  1208,
    1211,  1212,  1215,  1216,  1228,  1229,  1232,  1238,  1244,  1250,
    1256,  1262,  1268,  1275,  1281,  1287,  1293,  1299,  1305,  1311,
    1317,  1323,  1329,  1335,  1355,  1364,  1370,  1371,  1374,  1377,
    1383,  1390,  1399,  1402,  1405,  1409,  1413,  1417,  1422,  1430,
    1434,  1439,  1443,  1446,  1450,  1453,  1458,  1459,  1460,  1461,
    1462,  1463,  1464,  1465,  1466,  1469,  1470,  1471,  1474,  1475,
    1476,  1480,  1487,  1499,  1505,  1517,  1529,  1532,  1538,  1543,
    1546,  1551,  1552,  1556,  1572,  1588,  1604,  1620,  1631,  1637,
    1647,  1670,  1681,  1700,  1706,  1707,  1713,  1714,  1725,  1736,
    1747,  1757,  1767,  1777,  1780,  1781,  1784,  1785,  1788,  1791,
    1794,  1802,  1812,  1813,  1816,  1833,  1840,  1847,  1854,  1861,
    1868,  1877,  1886,  1897,  1898,  1901,  1921,  1931,  1940,  1951,
    1954,  1959,  1968,  1979,  1982,  1988,  1989,  1993,  1994
};
#endif


#if (YYDEBUG) || defined YYERROR_VERBOSE

/* YYTNAME[TOKEN_NUM] -- String name of the token TOKEN_NUM. */
static const char *const yytname[] =
{
  "$", "error", "$undefined.", "CLASS", "FROM", "CONST", "VOID", "STRUCT", 
  "UNION", "ENUM", "THREEDOTS", "SIGNED", "UNSIGNED", "LONG", "SHORT", 
  "INT", "FLOAT", "DOUBLE", "CHAR", "TOKEN", "NUMBER", "TYPETOKEN", 
  "ARRAY_DIM", "SINGLE_CHAR", "CCODE", "HTCODE", "PHCODE", "HCODE", 
  "ACODE", "ATCODE", "STRING", "PUBLIC", "PRIVATE", "PROTECTED", 
  "CLASSWIDE", "PROPERTY", "ARGUMENT", "VIRTUAL", "SIGNAL", "OVERRIDE", 
  "NICK", "BLURB", "MAXIMUM", "MINIMUM", "DEFAULT_VALUE", "ERROR", 
  "FLAGS", "TYPE", "FLAGS_TYPE", "ENUM_TYPE", "PARAM_TYPE", "BOXED_TYPE", 
  "OBJECT_TYPE", "'{'", "'}'", "'('", "')'", "';'", "'='", "','", "'|'", 
  "'*'", "'>'", "'<'", "'!'", "'-'", "prog", "ccode", "ccodes", "class", 
  "classdec", "classflags", "classcode", "thing", "scope", "destructor", 
  "initializer", "varoptions", "variable", "argument", "export", 
  "property", "param_spec", "param_spec_list", "string", "anyval", 
  "param_spec_value", "argtype", "flags", "flaglist", "type", 
  "specifier_list", "spec_list", "specifier", "strunionenum", "pointer", 
  "simplesigtype", "fullsigtype", "sigtype", "tokenlist", "codenocode", 
  "method", "returnvals", "retcode", "funcargs", "arglist", "arglist1", 
  "arg", "checklist", "check", "enumcode", "enumvals", "enumval", 
  "flagcode", "flagvals", "errorcode", "errorvals", "numtok", 0
};
#endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives. */
static const short yyr1[] =
{
       0,    66,    66,    66,    66,    67,    67,    67,    67,    67,
      67,    68,    68,    68,    68,    68,    68,    68,    68,    69,
      69,    70,    71,    71,    71,    71,    72,    72,    73,    73,
      73,    73,    73,    73,    73,    74,    74,    74,    74,    75,
      75,    76,    76,    77,    77,    77,    77,    77,    78,    78,
      79,    79,    79,    80,    80,    81,    81,    81,    82,    82,
      83,    83,    84,    84,    85,    85,    86,    86,    86,    86,
      86,    86,    86,    86,    86,    86,    86,    86,    86,    86,
      86,    86,    86,    86,    87,    87,    88,    88,    89,    89,
      90,    90,    91,    91,    91,    91,    91,    91,    91,    92,
      92,    92,    92,    92,    92,    92,    93,    93,    93,    93,
      93,    93,    93,    93,    93,    94,    94,    94,    95,    95,
      95,    95,    96,    96,    97,    97,    97,    97,    98,    99,
      99,   100,   100,   101,   101,   101,   101,   101,   101,   101,
     101,   102,   102,   102,   103,   103,   104,   104,   104,   104,
     104,   104,   104,   104,   105,   105,   106,   106,   107,   107,
     107,   107,   108,   108,   109,   109,   109,   109,   109,   109,
     109,   110,   110,   111,   111,   112,   112,   113,   113,   114,
     114,   115,   115,   116,   116,   117,   117,   117,   117
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN. */
static const short yyr2[] =
{
       0,     3,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     1,     1,     1,     1,     4,
       3,     5,     0,     5,     5,     5,     2,     1,     1,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     2,     3,     2,     2,     1,     1,     0,     5,     6,
      12,     9,     6,     3,     0,    11,     8,     5,     3,     0,
       3,     1,     1,     4,     1,     1,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     1,     5,     1,     3,     0,     3,     1,
       2,     1,     1,     1,     2,     2,     2,     3,     3,     2,
       2,     2,     1,     2,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     3,     2,     1,     3,     3,     2,     1,     4,     3,
       1,     2,     1,    10,    11,     9,     9,     8,    11,     8,
       5,     2,     4,     0,     1,     2,     1,     1,     2,     2,
       3,     4,     4,     1,     3,     1,     3,     1,     2,     3,
       6,     7,     2,     1,     1,     2,     2,     3,     3,     3,
       3,     7,     8,     3,     1,     3,     1,     7,     8,     3,
       1,     7,     8,     3,     1,     1,     2,     1,     1
};

/* YYDEFACT[S] -- default rule to reduce with in state S when YYTABLE
   doesn't specify something else to do.  Zero means the default is an
   error. */
static const short yydefact[] =
{
       0,     0,     0,     5,     7,     8,     6,     9,    10,     0,
       0,    15,     0,     4,     0,    16,    17,    18,     0,     0,
       0,     0,    11,     3,    12,    13,    14,     2,     0,     0,
       0,     0,     0,     1,     0,    35,    36,    37,    38,     0,
      87,     0,    87,     0,    20,    34,     0,    27,     0,    31,
      32,    33,    28,    22,   176,     0,   174,   184,     0,   180,
       0,     0,     0,     0,     0,    29,     0,     0,     0,     0,
     106,   115,   116,   117,   113,   114,   110,   108,   109,   111,
     112,   107,    93,   102,     0,     0,    91,    92,   104,     0,
       0,     0,    19,    26,     0,    87,     0,     0,    21,     0,
       0,     0,     0,     0,     0,     0,    30,     0,     0,    59,
      89,     0,    85,     0,     0,    94,   101,     0,    95,   103,
     100,     0,     0,   118,    90,   105,    99,    96,     0,     0,
     127,     0,   123,     0,     0,     0,    47,     0,   188,   185,
     187,     0,   175,     0,     0,   173,     0,   183,     0,     0,
     179,     0,     0,     0,     0,     0,     0,    86,     0,    54,
      97,     0,     0,   119,   120,    98,     0,     0,     0,   122,
       0,   126,     0,     0,     0,     0,     0,     0,    47,     0,
       0,    46,    45,     0,     0,     0,     0,   186,   171,     0,
     181,     0,   177,     0,     0,   132,   140,    83,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    61,     0,    57,    88,     0,     0,     0,     0,     0,
     106,    93,     0,     0,   153,   155,   157,   121,   130,     0,
     125,   124,     0,     0,     0,     0,    39,     0,     0,     0,
       0,    41,    43,    44,    48,    22,    22,    22,   172,   182,
     178,   131,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    58,     0,     0,     0,     0,    52,
       0,    94,    95,     0,   158,   143,     0,   128,     0,     0,
       0,     0,     0,    40,    49,   143,    42,    23,    25,    24,
       0,    62,    66,    67,    68,    69,   188,    65,    70,    64,
      71,    72,    74,    73,    76,    75,    78,    77,    80,    79,
      82,    81,    60,     0,    84,    53,     0,   143,     0,     0,
     150,   159,     0,     0,     0,   154,   156,   129,     0,     0,
     143,     0,     0,     0,     0,    56,     0,     0,   152,   151,
       0,     0,     0,   141,   144,   137,   143,     0,     0,     0,
     139,     0,     0,     0,    51,   135,     0,   164,     0,     0,
       0,     0,     0,   163,   145,     0,     0,   143,   136,   143,
      63,     0,     0,     0,     0,     0,   165,     0,   166,     0,
     160,   162,   142,   133,     0,     0,    55,     0,   161,   169,
     167,   168,   170,   138,   134,    50,     0,     0,     0
};

static const short yydefgoto[] =
{
     396,    11,    12,    13,    14,    98,    46,    47,    48,   181,
     182,   183,    49,    50,   217,    51,   155,   210,   292,   298,
     211,   113,    68,   111,   222,    86,    87,    88,    89,   124,
     130,   131,   132,   229,   196,    52,   324,   343,   223,   224,
     225,   226,   362,   363,    15,    55,    56,    16,    60,    17,
      58,   344
};

static const short yypact[] =
{
     137,    16,    24,-32768,-32768,-32768,-32768,-32768,-32768,    45,
      99,-32768,   137,   170,    72,-32768,-32768,-32768,   106,    73,
      81,    98,-32768,   170,-32768,-32768,-32768,   170,   154,   111,
     151,   183,   186,   170,   215,-32768,-32768,-32768,-32768,   187,
     158,   310,   158,   182,-32768,-32768,   188,-32768,   276,-32768,
  -32768,-32768,-32768,   195,   210,    69,-32768,-32768,   113,-32768,
     115,   214,   301,   190,   276,-32768,   248,   252,   254,   357,
  -32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
  -32768,-32768,   269,   425,   374,   267,   235,-32768,   439,   284,
     444,   290,-32768,-32768,   374,   158,   293,   311,-32768,    74,
     315,    76,   316,    84,   339,    90,-32768,   321,   348,   329,
     334,   345,   356,   399,   453,-32768,-32768,   409,-32768,   453,
  -32768,   413,   378,     2,-32768,   453,-32768,   429,   224,   416,
  -32768,   374,-32768,   392,   428,   430,   126,   220,-32768,-32768,
  -32768,   441,-32768,   405,   451,-32768,   422,-32768,   452,   423,
  -32768,   460,   -32,   427,   258,    21,   252,-32768,   464,   431,
  -32768,   432,   391,   235,-32768,-32768,   433,   465,   466,-32768,
      -6,-32768,   470,   374,   435,    -6,   374,    26,     0,   391,
       7,   434,   472,   436,   438,   440,   442,-32768,-32768,   443,
  -32768,   445,-32768,   446,   471,-32768,-32768,-32768,   447,   448,
     449,   450,   454,   455,   456,   457,   458,   459,   461,   462,
      91,-32768,   468,-32768,-32768,   374,   478,   480,   391,   408,
     467,     6,   482,   469,-32768,   463,-32768,-32768,-32768,   112,
  -32768,-32768,   473,   485,   391,   490,-32768,   486,   474,   476,
     487,-32768,-32768,-32768,-32768,   195,   195,   195,-32768,-32768,
  -32768,-32768,     1,     1,    74,    74,     9,   252,   374,   139,
     157,   191,   209,   212,-32768,   258,   494,   477,   479,   481,
     483,   121,   144,   374,    94,   505,   340,-32768,   507,   391,
     475,   484,   488,-32768,-32768,   505,-32768,-32768,-32768,-32768,
     489,-32768,-32768,-32768,-32768,-32768,   489,-32768,-32768,-32768,
  -32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
  -32768,-32768,-32768,    47,-32768,-32768,   503,   505,   374,   374,
  -32768,   491,   510,    27,   -32,-32768,-32768,-32768,   492,   391,
     505,   391,   -32,   506,   496,-32768,    54,   -32,-32768,-32768,
     518,    57,   514,   522,-32768,-32768,   505,   495,   -32,   497,
  -32768,   498,   521,   499,-32768,-32768,    57,-32768,   500,    64,
      66,   501,    50,-32768,-32768,    27,   -32,   505,-32768,   505,
  -32768,   493,   523,    79,    74,    74,-32768,    74,-32768,    74,
  -32768,-32768,-32768,-32768,   -32,   -32,-32768,   504,-32768,-32768,
  -32768,-32768,-32768,-32768,-32768,-32768,   542,   555,-32768
};

static const short yypgoto[] =
{
  -32768,   202,   104,   544,-32768,    17,-32768,   511,   -29,   380,
     379,   385,-32768,-32768,-32768,-32768,-32768,-32768,   -52,-32768,
     299,-32768,   -27,  -152,   -40,-32768,   -66,-32768,   -60,  -107,
     437,-32768,   -93,-32768,  -314,   -20,  -279,   200,  -177,  -218,
  -32768,   291,   213,  -266,   205,-32768,   502,   232,-32768,   239,
  -32768,   -99
};


#define	YYLAST		603


static const short yytable[] =
{
     142,    85,   239,   116,   214,    64,   332,   163,    96,   117,
     345,   272,    84,   166,    65,    90,   164,   120,   350,   177,
     290,   194,   126,   355,   108,   195,   138,   139,   296,   139,
     140,   291,   140,    64,   368,   169,   171,    18,   337,   291,
     212,   270,   106,    19,   121,   236,   138,   139,   116,   167,
     140,   348,   383,   116,   134,   320,   227,   281,   180,   116,
     240,   129,  -147,   123,    20,   273,   334,   366,   135,   357,
     393,   394,   141,   353,   141,   230,   357,   231,   213,   237,
     342,   241,   169,   138,   139,   138,   139,   140,   384,   140,
     385,   172,   141,   138,   139,    54,   381,   140,   357,   168,
     338,   339,   328,   147,   335,   300,   380,   381,   358,   150,
      29,   354,   359,   360,   361,   358,   321,    27,    21,   359,
     360,   361,   375,   100,   377,    28,    30,    33,   101,   141,
     144,   141,    53,   233,    31,   388,   235,   358,   148,   141,
       1,   359,   360,   361,   151,   177,     2,   264,   178,   322,
     265,    32,   347,   116,   349,   294,   295,   299,   302,   117,
     303,     3,     4,     5,     6,     7,     8,   102,   277,   104,
      54,   278,   103,    34,   105,   267,   304,  -149,   305,     2,
     318,   179,     9,    10,   180,    35,    36,    37,    38,    39,
      40,    41,    42,    43,     3,     4,     5,     6,     7,     8,
    -148,   293,    57,   319,   297,    59,    66,    34,    44,   107,
     306,    45,   307,    67,    22,     9,    10,    24,   301,    35,
      36,    37,    38,    39,    40,    41,    42,    43,   308,    22,
     309,   310,    24,   311,    61,    22,    62,    91,    24,   184,
     185,   186,    92,   166,    25,    45,    35,    36,    37,    38,
      97,    26,    41,    42,    43,    35,    36,    37,    38,    25,
     376,   378,   287,   288,   289,    25,    26,   109,    99,    63,
      63,   110,    26,   112,   118,   389,   390,   197,   391,   167,
     392,    69,    70,    71,    72,    73,   122,    74,    75,    76,
      77,    78,    79,    80,    81,    82,   123,    83,   198,   199,
     200,   201,   202,   127,   203,   204,   205,   206,   207,   208,
     209,   133,   136,    94,    95,    69,    70,    71,    72,    73,
      61,    74,    75,    76,    77,    78,    79,    80,    81,    82,
     137,    83,    35,    36,    37,    38,   143,   146,    41,    42,
      43,    35,    36,    37,    38,    69,    70,    71,    72,    73,
     325,    74,    75,    76,    77,    78,    79,    80,    81,    82,
     149,    83,   114,    70,    71,    72,    73,   153,    74,    75,
      76,    77,    78,    79,    80,    81,   115,   152,    83,    69,
      70,    71,    72,    73,   154,    74,    75,    76,    77,    78,
      79,    80,    81,    82,   156,    83,   219,   220,    71,    72,
      73,   157,    74,    75,    76,    77,    78,    79,    80,    81,
     221,   158,    83,   114,    70,    71,    72,    73,   159,    74,
      75,    76,    77,    78,    79,    80,    81,   271,   160,    83,
     119,    70,   161,   162,   165,   170,    74,    75,    76,    77,
      78,    79,    80,    81,   125,    70,    83,   174,   173,   175,
      74,    75,    76,    77,    78,    79,    80,    81,   114,    70,
      83,   187,   188,   128,    74,    75,    76,    77,    78,    79,
      80,    81,   189,   191,    83,    35,    36,    37,    38,   190,
     192,   193,   179,   215,   228,   166,   216,   218,   167,   232,
     234,   177,   180,   244,   245,   251,   246,   268,   247,   269,
     248,   274,   249,   250,   280,   252,   253,   254,   255,   282,
     283,   286,   256,   257,   258,   259,   260,   261,   313,   262,
     263,   266,   276,  -146,   323,   275,   327,   336,   279,   341,
     329,   284,   285,   314,   316,   315,   351,   356,   364,   317,
     330,   365,   397,   331,   333,   371,   340,   387,   346,   352,
     386,   367,   372,   369,   370,   398,    23,    93,   374,   379,
     242,   395,   243,   238,   312,   382,     0,   326,     0,   373,
       0,     0,   176,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   145
};

static const short yycheck[] =
{
      99,    41,   179,    69,   156,    34,   285,     5,    48,    69,
     324,     5,    41,    19,    34,    42,   123,    83,   332,    19,
      19,    53,    88,   337,    64,    57,    19,    20,    19,    20,
      23,    30,    23,    62,   348,   128,   129,    21,   317,    30,
      19,   218,    62,    19,    84,    19,    19,    20,   114,    55,
      23,   330,   366,   119,    94,   273,   163,   234,    58,   125,
      53,    90,    56,    61,    19,    59,    19,   346,    95,    19,
     384,   385,    65,    19,    65,   168,    19,   170,    57,    53,
      53,   180,   175,    19,    20,    19,    20,    23,   367,    23,
     369,   131,    65,    19,    20,    19,   362,    23,    19,   128,
     318,   319,   279,    19,    57,   257,    56,   373,    58,    19,
       4,    57,    62,    63,    64,    58,    22,    13,    19,    62,
      63,    64,    58,    54,    58,    53,    53,    23,    59,    65,
      54,    65,    21,   173,    53,    56,   176,    58,    54,    65,
       3,    62,    63,    64,    54,    19,     9,    56,    22,    55,
      59,    53,   329,   219,   331,   254,   255,   256,    19,   219,
      21,    24,    25,    26,    27,    28,    29,    54,    56,    54,
      19,    59,    59,    19,    59,   215,    19,    56,    21,     9,
      59,    55,    45,    46,    58,    31,    32,    33,    34,    35,
      36,    37,    38,    39,    24,    25,    26,    27,    28,    29,
      56,   253,    19,    59,   256,    19,    19,    19,    54,    19,
      19,    57,    21,    55,    12,    45,    46,    12,   258,    31,
      32,    33,    34,    35,    36,    37,    38,    39,    19,    27,
      21,    19,    27,    21,    19,    33,    21,    55,    33,    19,
      20,    21,    54,    19,    12,    57,    31,    32,    33,    34,
      55,    12,    37,    38,    39,    31,    32,    33,    34,    27,
     359,   360,   245,   246,   247,    33,    27,    19,    58,    55,
      55,    19,    33,    19,     5,   374,   375,    19,   377,    55,
     379,     5,     6,     7,     8,     9,    19,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    61,    21,    40,    41,
      42,    43,    44,    19,    46,    47,    48,    49,    50,    51,
      52,    21,    19,    37,    38,     5,     6,     7,     8,     9,
      19,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      19,    21,    31,    32,    33,    34,    21,    21,    37,    38,
      39,    31,    32,    33,    34,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      21,    21,     5,     6,     7,     8,     9,    19,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    56,    21,     5,
       6,     7,     8,     9,    55,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    60,    21,     5,     6,     7,     8,
       9,    56,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    55,    21,     5,     6,     7,     8,     9,    19,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    19,    21,
       5,     6,    19,    55,     5,    19,    11,    12,    13,    14,
      15,    16,    17,    18,     5,     6,    21,    19,    56,    19,
      11,    12,    13,    14,    15,    16,    17,    18,     5,     6,
      21,    20,    57,    19,    11,    12,    13,    14,    15,    16,
      17,    18,    21,    21,    21,    31,    32,    33,    34,    57,
      57,    21,    55,    19,    19,    19,    55,    55,    55,    19,
      55,    19,    58,    57,    56,    24,    56,    19,    56,    19,
      57,    19,    57,    57,    19,    58,    58,    58,    58,    19,
      24,    24,    58,    58,    58,    58,    58,    58,    24,    58,
      58,    53,    59,    56,    19,    56,    19,    24,    55,    19,
      55,    57,    56,    56,    53,    56,    30,    19,    24,    56,
      56,    19,     0,    55,    55,    24,    55,    24,    56,    53,
      57,    56,    53,    56,    56,     0,    12,    46,    58,    58,
     181,    57,   182,   178,   265,   365,    -1,   276,    -1,   356,
      -1,    -1,   135,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   101
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/share/bison/bison.simple"

/* Skeleton output parser for bison,

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software
   Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser when
   the %semantic_parser declaration is not specified in the grammar.
   It was written by Richard Stallman by simplifying the hairy parser
   used when %semantic_parser is specified.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

#if ! defined (yyoverflow) || defined (YYERROR_VERBOSE)

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || defined (YYERROR_VERBOSE) */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
# if YYLSP_NEEDED
  YYLTYPE yyls;
# endif
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAX (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# if YYLSP_NEEDED
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAX)
# else
#  define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAX)
# endif

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAX;	\
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif


#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");			\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).

   When YYLLOC_DEFAULT is run, CURRENT is set the location of the
   first token.  By default, to implement support for ranges, extend
   its range to the last symbol.  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)       	\
   Current.last_line   = Rhs[N].last_line;	\
   Current.last_column = Rhs[N].last_column;
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#if YYPURE
# if YYLSP_NEEDED
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, &yylloc, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval, &yylloc)
#  endif
# else /* !YYLSP_NEEDED */
#  ifdef YYLEX_PARAM
#   define YYLEX		yylex (&yylval, YYLEX_PARAM)
#  else
#   define YYLEX		yylex (&yylval)
#  endif
# endif /* !YYLSP_NEEDED */
#else /* !YYPURE */
# define YYLEX			yylex ()
#endif /* !YYPURE */


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)
/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
#endif /* !YYDEBUG */

/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif

#ifdef YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif
#endif

#line 315 "/usr/share/bison/bison.simple"


/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
#  define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL
# else
#  define YYPARSE_PARAM_ARG YYPARSE_PARAM
#  define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
# endif
#else /* !YYPARSE_PARAM */
# define YYPARSE_PARAM_ARG
# define YYPARSE_PARAM_DECL
#endif /* !YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
# ifdef YYPARSE_PARAM
int yyparse (void *);
# else
int yyparse (void);
# endif
#endif

/* YY_DECL_VARIABLES -- depending whether we use a pure parser,
   variables are global, or local to YYPARSE.  */

#define YY_DECL_NON_LSP_VARIABLES			\
/* The lookahead symbol.  */				\
int yychar;						\
							\
/* The semantic value of the lookahead symbol. */	\
YYSTYPE yylval;						\
							\
/* Number of parse errors so far.  */			\
int yynerrs;

#if YYLSP_NEEDED
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES			\
						\
/* Location data for the lookahead symbol.  */	\
YYLTYPE yylloc;
#else
# define YY_DECL_VARIABLES			\
YY_DECL_NON_LSP_VARIABLES
#endif


/* If nonreentrant, generate the variables here. */

#if !YYPURE
YY_DECL_VARIABLES
#endif  /* !YYPURE */

int
yyparse (YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  /* If reentrant, generate the variables here. */
#if YYPURE
  YY_DECL_VARIABLES
#endif  /* !YYPURE */

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yychar1 = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack. */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;

#if YYLSP_NEEDED
  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
#endif

#if YYLSP_NEEDED
# define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
# define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  YYSIZE_T yystacksize = YYINITDEPTH;


  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
#if YYLSP_NEEDED
  YYLTYPE yyloc;
#endif

  /* When reducing, the number of symbols on the RHS of the reduced
     rule. */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
#if YYLSP_NEEDED
  yylsp = yyls;
#endif
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  */
# if YYLSP_NEEDED
	YYLTYPE *yyls1 = yyls;
	/* This used to be a conditional around just the two extra args,
	   but that might be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
# else
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yystacksize);
# endif
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
# if YYLSP_NEEDED
	YYSTACK_RELOCATE (yyls);
# endif
# undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
#if YYLSP_NEEDED
      yylsp = yyls + yysize - 1;
#endif

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yychar1 = YYTRANSLATE (yychar);

#if YYDEBUG
     /* We have to keep this `#if YYDEBUG', since we use variables
	which are defined only if `YYDEBUG' is set.  */
      if (yydebug)
	{
	  YYFPRINTF (stderr, "Next token is %d (%s",
		     yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise
	     meaning of a token, for further debugging info.  */
# ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
# endif
	  YYFPRINTF (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %d (%s), ",
	      yychar, yytname[yychar1]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to the semantic value of
     the lookahead token.  This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

#if YYLSP_NEEDED
  /* Similarly for the default location.  Let the user run additional
     commands if for instance locations are ranges.  */
  yyloc = yylsp[1-yylen];
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
#endif

#if YYDEBUG
  /* We have to keep this `#if YYDEBUG', since we use variables which
     are defined only if `YYDEBUG' is set.  */
  if (yydebug)
    {
      int yyi;

      YYFPRINTF (stderr, "Reducing via rule %d (line %d), ",
		 yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (yyi = yyprhs[yyn]; yyrhs[yyi] > 0; yyi++)
	YYFPRINTF (stderr, "%s ", yytname[yyrhs[yyi]]);
      YYFPRINTF (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif

  switch (yyn) {

case 1:
#line 637 "parse.y"
{ ; }
    break;
case 2:
#line 638 "parse.y"
{ ; }
    break;
case 3:
#line 639 "parse.y"
{ ; }
    break;
case 4:
#line 640 "parse.y"
{ ; }
    break;
case 5:
#line 643 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", C_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					}
    break;
case 6:
#line 652 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", H_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					}
    break;
case 7:
#line 661 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", HT_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					}
    break;
case 8:
#line 670 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", PH_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					}
    break;
case 9:
#line 679 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", A_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					}
    break;
case 10:
#line 688 "parse.y"
{
			Node *node = node_new (CCODE_NODE,
					       "cctype", AT_CCODE,
					       "cbuf:steal", (yyvsp[0].cbuf)->str,
					       "line_no", ccode_line,
					       NULL);
			nodes = g_list_append(nodes,node);
			g_string_free(yyvsp[0].cbuf,FALSE);
					}
    break;
case 11:
#line 699 "parse.y"
{ ; }
    break;
case 12:
#line 700 "parse.y"
{ ; }
    break;
case 13:
#line 701 "parse.y"
{ ; }
    break;
case 14:
#line 702 "parse.y"
{ ; }
    break;
case 15:
#line 703 "parse.y"
{ ; }
    break;
case 16:
#line 704 "parse.y"
{ ; }
    break;
case 17:
#line 705 "parse.y"
{ ; }
    break;
case 18:
#line 706 "parse.y"
{ ; }
    break;
case 19:
#line 709 "parse.y"
{
			((Class *)class)->nodes = class_nodes;
			class_nodes = NULL;
			nodes = g_list_append(nodes,class);
						}
    break;
case 20:
#line 714 "parse.y"
{
			((Class *)class)->nodes = NULL;
			class_nodes = NULL;
			nodes = g_list_append(nodes,class);
						}
    break;
case 21:
#line 721 "parse.y"
{
			class = node_new (CLASS_NODE,
					  "otype:steal", yyvsp[-3].id,
					  "ptype:steal", yyvsp[-1].id,
					  "bonobo_object_class:steal", bonobo_object_class,
					  "interfaces:steal", interfaces,
					  "chunk_size:steal", chunk_size,
					  NULL);
			bonobo_object_class = NULL;
			chunk_size = NULL;
			interfaces = NULL;
						}
    break;
case 23:
#line 736 "parse.y"
{
			if(strcmp(yyvsp[-3].id,"chunks") == 0) {
				g_free (chunk_size);
				chunk_size = g_strdup(yyvsp[-2].id);
			} else if(strcmp(yyvsp[-3].id,"BonoboObject") == 0) {
				g_free (bonobo_object_class);
				bonobo_object_class = g_strdup(yyvsp[-2].id);
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;
case 24:
#line 748 "parse.y"
{
			if (strcmp (yyvsp[-3].id, "interface") == 0) {
				interfaces = g_list_append (interfaces,
							    g_strdup (yyvsp[-2].id));
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;
case 25:
#line 757 "parse.y"
{
			if(strcmp(yyvsp[-3].id,"chunks") == 0) {
				g_free (chunk_size);
				if(atoi(yyvsp[-2].id) != 0)
					chunk_size = g_strdup(yyvsp[-2].id);
				else
					chunk_size = NULL;
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
		}
    break;
case 26:
#line 771 "parse.y"
{ ; }
    break;
case 27:
#line 772 "parse.y"
{ ; }
    break;
case 28:
#line 775 "parse.y"
{ ; }
    break;
case 29:
#line 776 "parse.y"
{
			if (strcmp (yyvsp[-1].id, "BonoboObject") != 0) {
				g_free (yyvsp[-1].id);
				yyerror (_("parse error"));
				YYERROR;
			}
			g_free (yyvsp[-1].id);
			last_added_method->bonobo_object_func = TRUE;
						}
    break;
case 30:
#line 785 "parse.y"
{
			if (strcmp (yyvsp[-2].id, "interface") != 0) {
				g_free (yyvsp[-2].id);
				g_free (yyvsp[-1].id);
				yyerror (_("parse error"));
				YYERROR;
			}
			g_free (yyvsp[-2].id);
			node_set ((Node *)last_added_method,
				  "interface:steal", yyvsp[-1].id,
				  NULL);
						}
    break;
case 31:
#line 797 "parse.y"
{ ; }
    break;
case 32:
#line 798 "parse.y"
{ ; }
    break;
case 33:
#line 799 "parse.y"
{ ; }
    break;
case 34:
#line 800 "parse.y"
{ ; }
    break;
case 35:
#line 803 "parse.y"
{ the_scope = PUBLIC_SCOPE; }
    break;
case 36:
#line 804 "parse.y"
{ the_scope = PRIVATE_SCOPE; }
    break;
case 37:
#line 805 "parse.y"
{ the_scope = PROTECTED_SCOPE; }
    break;
case 38:
#line 806 "parse.y"
{ the_scope = CLASS_SCOPE; }
    break;
case 39:
#line 809 "parse.y"
{
			if (strcmp (yyvsp[-1].id, "destroywith") == 0) {
				g_free (yyvsp[-1].id);
				destructor_unref = FALSE;
				destructor = yyvsp[0].id;
				destructor_line = line_no;
				destructor_simple = TRUE;
			} else if (strcmp (yyvsp[-1].id, "unrefwith") == 0) {
				g_free (yyvsp[-1].id);
				destructor_unref = TRUE;
				destructor = yyvsp[0].id;
				destructor_line = line_no;
				destructor_simple = TRUE;
			} else {
				g_free (yyvsp[-1].id);
				g_free (yyvsp[0].id);
				yyerror (_("parse error"));
				YYERROR;
			}
				}
    break;
case 40:
#line 829 "parse.y"
{
			if (strcmp (yyvsp[-2].id, "destroy") == 0) {
				g_free(yyvsp[-2].id);
				destructor_unref = FALSE;
				destructor = (yyvsp[0].cbuf)->str;
				g_string_free(yyvsp[0].cbuf, FALSE);
				destructor_line = ccode_line;
				destructor_simple = FALSE;
			} else if (strcmp (yyvsp[-2].id, "unref") == 0) {
				g_free (yyvsp[-2].id);
				destructor_unref = TRUE;
				destructor = (yyvsp[0].cbuf)->str;
				g_string_free (yyvsp[0].cbuf, FALSE);
				destructor_line = ccode_line;
				destructor_simple = FALSE;
			} else {
				g_free (yyvsp[-2].id);
				g_string_free (yyvsp[0].cbuf, TRUE);
				yyerror (_("parse error"));
				YYERROR;
			}
					}
    break;
case 41:
#line 853 "parse.y"
{
			initializer = yyvsp[0].id;
			initializer_line = ccode_line;
				}
    break;
case 42:
#line 857 "parse.y"
{
			initializer = (yyvsp[0].cbuf)->str;
			initializer_line = ccode_line;
			g_string_free(yyvsp[0].cbuf, FALSE);
				}
    break;
case 43:
#line 865 "parse.y"
{ ; }
    break;
case 44:
#line 866 "parse.y"
{ ; }
    break;
case 45:
#line 867 "parse.y"
{ destructor = NULL; }
    break;
case 46:
#line 868 "parse.y"
{ initializer = NULL; }
    break;
case 47:
#line 869 "parse.y"
{
			destructor = NULL;
			initializer = NULL;
					}
    break;
case 48:
#line 875 "parse.y"
{
			push_variable(yyvsp[-2].id, the_scope,yyvsp[-4].line, NULL);
						}
    break;
case 49:
#line 878 "parse.y"
{
			push_variable(yyvsp[-3].id, the_scope, yyvsp[-5].line, yyvsp[-2].id);
						}
    break;
case 50:
#line 883 "parse.y"
{
			Node *node = NULL;
			if(strcmp(yyvsp[-6].id,"get")==0 &&
			   strcmp(yyvsp[-3].id,"set")==0) {
				Type *type = pop_type();
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", yyvsp[-9].id,
						 "atype:steal", type,
						 "flags:steal", yyvsp[-10].list,
						 "name:steal", yyvsp[-8].id,
						 "get:steal", (yyvsp[-4].cbuf)->str,
						 "get_line", yyvsp[-5].line,
						 "set:steal", (yyvsp[-1].cbuf)->str,
						 "set_line", yyvsp[-2].line,
						 "line_no", yyvsp[-11].line,
						 NULL);

				class_nodes = g_list_append(class_nodes,node);

				g_string_free (yyvsp[-4].cbuf, FALSE);
				g_string_free (yyvsp[-1].cbuf, FALSE);

			} else if(strcmp(yyvsp[-6].id,"set")==0 &&
				strcmp(yyvsp[-3].id,"get")==0) {
				Type *type = pop_type();
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", yyvsp[-9].id,
						 "atype:steal", type,
						 "flags:steal", yyvsp[-10].list,
						 "name:steal", yyvsp[-8].id,
						 "get:steal", (yyvsp[-1].cbuf)->str,
						 "get_line", yyvsp[-2].line,
						 "set:steal", (yyvsp[-4].cbuf)->str,
						 "set_line", yyvsp[-5].line,
						 "line_no", yyvsp[-11].line,
						 NULL);
				g_string_free (yyvsp[-1].cbuf, FALSE);
				g_string_free (yyvsp[-4].cbuf, FALSE);
				class_nodes = g_list_append(class_nodes,node);
			} else {
				g_free (yyvsp[-9].id); 
				g_free (yyvsp[-8].id);
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
				g_list_foreach (yyvsp[-10].list, (GFunc)g_free, NULL);
				g_list_free (yyvsp[-10].list);
				g_string_free (yyvsp[-1].cbuf, TRUE);
				g_string_free (yyvsp[-4].cbuf, TRUE);
				yyerror (_("parse error"));
				YYERROR;
			}

			if (yyvsp[-7].id != NULL) {
				Argument *arg = (Argument *)node;
				export_accessors (arg->name,
						  arg->get != NULL, arg->get_line,
						  arg->set != NULL, arg->set_line,
						  arg->atype,
						  arg->gtktype,
						  arg->line_no);
				g_free (yyvsp[-7].id);
			} 

						}
    break;
case 51:
#line 951 "parse.y"
{
			Node *node = NULL;
			if(strcmp(yyvsp[-3].id, "get") == 0) {
				Type *type = pop_type();
				g_free (yyvsp[-3].id);
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", yyvsp[-6].id,
						 "atype:steal", type,
						 "flags:steal", yyvsp[-7].list,
						 "name:steal", yyvsp[-5].id,
						 "get:steal", (yyvsp[-1].cbuf)->str,
						 "get_line", yyvsp[-2].line,
						 "line_no", yyvsp[-8].line,
						 NULL);

				g_string_free (yyvsp[-1].cbuf, FALSE);
				class_nodes = g_list_append(class_nodes, node);
			} else if(strcmp(yyvsp[-3].id, "set") == 0) {
				Type *type = pop_type();
				g_free (yyvsp[-3].id);
				node = node_new (ARGUMENT_NODE,
						 "gtktype:steal", yyvsp[-6].id,
						 "atype:steal", type,
						 "flags:steal", yyvsp[-7].list,
						 "name:steal", yyvsp[-5].id,
						 "set:steal", (yyvsp[-1].cbuf)->str,
						 "set_line", yyvsp[-2].line,
						 "line_no", yyvsp[-8].line,
						 NULL);

				g_string_free (yyvsp[-1].cbuf, FALSE);
				class_nodes = g_list_append (class_nodes, node);
			} else {
				g_free (yyvsp[-3].id); 
				g_free (yyvsp[-6].id);
				g_free (yyvsp[-5].id);
				g_list_foreach (yyvsp[-7].list, (GFunc)g_free, NULL);
				g_list_free (yyvsp[-7].list);
				g_string_free (yyvsp[-1].cbuf, TRUE);
				yyerror(_("parse error"));
				YYERROR;
			}

			if (yyvsp[-4].id != NULL) {
				Argument *arg = (Argument *)node;
				export_accessors (arg->name,
						  arg->get != NULL, arg->get_line,
						  arg->set != NULL, arg->set_line,
						  arg->atype,
						  arg->gtktype,
						  arg->line_no);
				g_free (yyvsp[-4].id);
			} 
						}
    break;
case 52:
#line 1005 "parse.y"
{
			Node *node;
			char *get, *set = NULL;
			Variable *var;
			Type *type;
			const char *root;
			
			if(strcmp(yyvsp[0].id, "link")!=0 &&
			   strcmp(yyvsp[0].id, "stringlink")!=0 && 
			   strcmp(yyvsp[0].id, "objectlink")!=0) {
				g_free(yyvsp[0].id); 
				g_free(yyvsp[-3].id);
				g_free(yyvsp[-2].id);
				g_list_foreach(yyvsp[-4].list,(GFunc)g_free,NULL);
				g_list_free(yyvsp[-4].list);
				yyerror(_("parse error"));
				YYERROR;
			}

			type = pop_type();

			var = find_var_or_die(yyvsp[-2].id, yyvsp[-5].line);
			if(var->scope == PRIVATE_SCOPE) {
				root = "self->_priv";
			} else if(var->scope == CLASS_SCOPE) {
				root = "SELF_GET_CLASS(self)";
				if(no_self_alias)
					error_print(GOB_ERROR, yyvsp[-5].line,
						    _("Self aliases needed when autolinking to a classwide member"));
			} else {
				root = "self";
			}

			if(strcmp(yyvsp[0].id, "link")==0) {
				set = g_strdup_printf("%s->%s = ARG;",
						      root, yyvsp[-2].id);
			} else if(strcmp(yyvsp[0].id, "stringlink")==0) {
				set = g_strdup_printf("g_free (%s->%s); "
						      "%s->%s = g_strdup (ARG);",
						      root, yyvsp[-2].id,
						      root, yyvsp[-2].id);
			} else if(strcmp(yyvsp[0].id, "objectlink")==0) {
				set = g_strdup_printf(
				  "if (ARG != NULL) "
				   "g_object_ref (G_OBJECT (ARG)); "
				  "if (%s->%s != NULL) "
				   "g_object_unref (G_OBJECT (%s->%s)); "
				  "%s->%s = ARG;",
				  root, yyvsp[-2].id,
				  root, yyvsp[-2].id,
				  root, yyvsp[-2].id);
			} else {
				g_assert_not_reached();
			}

			get = g_strdup_printf("ARG = %s->%s;", root, yyvsp[-2].id);
  
			g_free (yyvsp[0].id);

			if (type == NULL)
				type = (Type *)node_copy ((Node *)var->vtype);

			node = node_new (ARGUMENT_NODE,
					 "gtktype:steal", yyvsp[-3].id,
					 "atype:steal", type,
					 "flags:steal", yyvsp[-4].list,
					 "name:steal", yyvsp[-2].id,
					 "get:steal", get,
					 "get_line", yyvsp[-5].line,
					 "set:steal", set,
					 "set_line", yyvsp[-5].line,
					 "line_no", yyvsp[-5].line,
					 NULL);

			if (yyvsp[-1].id != NULL) {
				Argument *arg = (Argument *)node;
				export_accessors (arg->name,
						  arg->get != NULL, arg->get_line,
						  arg->set != NULL, arg->set_line,
						  arg->atype,
						  arg->gtktype,
						  arg->line_no);
				g_free (yyvsp[-1].id);
			} 

			class_nodes = g_list_append (class_nodes, node);
						}
    break;
case 53:
#line 1094 "parse.y"
{
			if (strcmp (yyvsp[-1].id, "export")!=0) {
				g_free (yyvsp[-1].id); 
				yyerror (_("parse error"));
				YYERROR;
			}
			yyval.id = yyvsp[-1].id;
						}
    break;
case 54:
#line 1102 "parse.y"
{
			yyval.id = NULL;
						}
    break;
case 55:
#line 1107 "parse.y"
{
			ensure_property ();
			node_set ((Node *)property,
				  "line_no", yyvsp[-10].line,
				  "gtktype:steal", debool (yyvsp[-9].id),
				  "name:steal", yyvsp[-8].id,
				  NULL);
			if (strcmp (yyvsp[-6].id, "get") == 0 &&
			    strcmp (yyvsp[-3].id, "set") == 0) {
				node_set ((Node *)property,
					  "get:steal", (yyvsp[-4].cbuf)->str,
					  "get_line", yyvsp[-5].line,
					  "set:steal", (yyvsp[-1].cbuf)->str,
					  "set_line", yyvsp[-2].line,
					  NULL);
				g_string_free (yyvsp[-4].cbuf, FALSE);
				g_string_free (yyvsp[-1].cbuf, FALSE);
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
			} else if (strcmp (yyvsp[-6].id, "set") == 0 &&
				   strcmp (yyvsp[-3].id, "get") == 0) {
				node_set ((Node *)property,
					  "get:steal", (yyvsp[-1].cbuf)->str,
					  "get_line", yyvsp[-2].line,
					  "set:steal", (yyvsp[-4].cbuf)->str,
					  "set_line", yyvsp[-5].line,
					  NULL);
				g_string_free (yyvsp[-4].cbuf, FALSE);
				g_string_free (yyvsp[-1].cbuf, FALSE);
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
			} else {
				g_string_free (yyvsp[-4].cbuf, TRUE);
				g_string_free (yyvsp[-1].cbuf, TRUE);
				g_free (yyvsp[-6].id); 
				g_free (yyvsp[-3].id);
				node_free ((Node *)property);
				property = NULL;
				yyerror (_("parse error"));
				YYERROR;
			}
			property_link_and_export ((Node *)property);
			if (property != NULL) {
				class_nodes = g_list_append (class_nodes,
							     property);
				property = NULL;
			}
		}
    break;
case 56:
#line 1155 "parse.y"
{
			ensure_property ();
			node_set ((Node *)property,
				  "line_no", yyvsp[-7].line,
				  "gtktype:steal", debool (yyvsp[-6].id),
				  "name:steal", yyvsp[-5].id,
				  NULL);
			if (strcmp (yyvsp[-3].id, "get") == 0) {
				node_set ((Node *)property,
					  "get:steal", (yyvsp[-1].cbuf)->str,
					  "get_line", yyvsp[-2].line,
					  NULL);
				g_string_free (yyvsp[-1].cbuf, FALSE);
				g_free (yyvsp[-3].id); 
			} else if (strcmp (yyvsp[-3].id, "set") == 0) {
				node_set ((Node *)property,
					  "set:steal", (yyvsp[-1].cbuf)->str,
					  "set_line", yyvsp[-2].line,
					  NULL);
				g_string_free (yyvsp[-1].cbuf, FALSE);
				g_free (yyvsp[-3].id); 
			} else {
				g_string_free (yyvsp[-1].cbuf, TRUE);
				g_free (yyvsp[-3].id); 
				node_free ((Node *)property);
				property = NULL;
				yyerror (_("parse error"));
				YYERROR;
			}
			property_link_and_export ((Node *)property);
			if (property != NULL) {
				class_nodes = g_list_append (class_nodes,
							     property);
				property = NULL;
			}
		}
    break;
case 57:
#line 1191 "parse.y"
{
			ensure_property ();
			node_set ((Node *)property,
				  "line_no", yyvsp[-4].line,
				  "gtktype:steal", debool (yyvsp[-3].id),
				  "name:steal", yyvsp[-2].id,
				  NULL);
			property_link_and_export ((Node *)property);
			if (property != NULL) {
				class_nodes = g_list_append (class_nodes,
							     property);
				property = NULL;
			}
		}
    break;
case 58:
#line 1207 "parse.y"
{ ; }
    break;
case 59:
#line 1208 "parse.y"
{ ; }
    break;
case 60:
#line 1211 "parse.y"
{ ; }
    break;
case 61:
#line 1212 "parse.y"
{ ; }
    break;
case 62:
#line 1215 "parse.y"
{ yyval.id = yyvsp[0].id; }
    break;
case 63:
#line 1216 "parse.y"
{
			if (strcmp (yyvsp[-3].id, "_") != 0) {
				g_free (yyvsp[-3].id);
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free (yyvsp[-3].id);
			yyval.id = g_strconcat ("_(", yyvsp[-1].id, ")", NULL);
			g_free (yyvsp[-1].id);
		}
    break;
case 64:
#line 1228 "parse.y"
{ yyval.id = yyvsp[0].id; }
    break;
case 65:
#line 1229 "parse.y"
{ yyval.id = yyvsp[0].id; }
    break;
case 66:
#line 1232 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "nick:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 67:
#line 1238 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "blurb:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 68:
#line 1244 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "maximum:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 69:
#line 1250 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "minimum:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 70:
#line 1256 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "default_value:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 71:
#line 1262 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "flags:steal", yyvsp[0].list,
			  NULL);
		  }
    break;
case 72:
#line 1268 "parse.y"
{
		Type *type = pop_type ();
		ensure_property ();
		node_set ((Node *)property,
			  "ptype:steal", type,
			  NULL);
		  }
    break;
case 73:
#line 1275 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 74:
#line 1281 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 75:
#line 1287 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 76:
#line 1293 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 77:
#line 1299 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 78:
#line 1305 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 79:
#line 1311 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 80:
#line 1317 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 81:
#line 1323 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 82:
#line 1329 "parse.y"
{
		ensure_property ();
		node_set ((Node *)property,
			  "extra_gtktype:steal", yyvsp[0].id,
			  NULL);
		  }
    break;
case 83:
#line 1335 "parse.y"
{
		ensure_property ();
		if (strcmp (yyvsp[0].id, "link") == 0) {
			g_free(yyvsp[0].id);
			node_set ((Node *)property,
				  "link", TRUE,
				  NULL);
		} else if (strcmp (yyvsp[0].id, "export") == 0) {
			g_free(yyvsp[0].id);
			node_set ((Node *)property,
				  "export", TRUE,
				  NULL);
		} else {
			g_free(yyvsp[0].id);
			yyerror(_("parse error"));
			YYERROR;
		}
		  }
    break;
case 84:
#line 1355 "parse.y"
{
			if(strcmp(yyvsp[-2].id,"type")!=0) {
				g_free(yyvsp[-4].id);
				g_free(yyvsp[-2].id);
				yyerror(_("parse error"));
				YYERROR;
			}
			yyval.id = debool (yyvsp[-4].id);
						}
    break;
case 85:
#line 1364 "parse.y"
{
			yyval.id = debool (yyvsp[0].id);
			typestack = g_list_prepend(typestack,NULL);
						}
    break;
case 86:
#line 1370 "parse.y"
{ yyval.list = yyvsp[-1].list; }
    break;
case 87:
#line 1371 "parse.y"
{ yyval.list = NULL; }
    break;
case 88:
#line 1374 "parse.y"
{
			yyval.list = g_list_append(yyvsp[0].list,yyvsp[-2].id);
						}
    break;
case 89:
#line 1377 "parse.y"
{
			yyval.list = g_list_append(NULL,yyvsp[0].id);
						}
    break;
case 90:
#line 1383 "parse.y"
{
			Node *node = node_new (TYPE_NODE, 
					       "name:steal", yyvsp[-1].id,
					       "pointer:steal", yyvsp[0].id,
					       NULL);
			typestack = g_list_prepend(typestack,node);
							}
    break;
case 91:
#line 1390 "parse.y"
{
			Node *node = node_new (TYPE_NODE, 
					       "name:steal", yyvsp[0].id,
					       NULL);
			typestack = g_list_prepend(typestack,node);
							}
    break;
case 92:
#line 1399 "parse.y"
{
			yyval.id = yyvsp[0].id;
							}
    break;
case 93:
#line 1402 "parse.y"
{
			yyval.id = yyvsp[0].id;
							}
    break;
case 94:
#line 1405 "parse.y"
{
			yyval.id = g_strconcat("const ", yyvsp[0].id, NULL);
			g_free(yyvsp[0].id);
							}
    break;
case 95:
#line 1409 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " const", NULL);
			g_free(yyvsp[-1].id);
							}
    break;
case 96:
#line 1413 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " ", yyvsp[0].id, NULL);
			g_free(yyvsp[0].id);
							}
    break;
case 97:
#line 1417 "parse.y"
{
			yyval.id = g_strconcat("const ", yyvsp[-1].id, " ",
					     yyvsp[0].id, NULL);
			g_free(yyvsp[0].id);
							}
    break;
case 98:
#line 1422 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-2].id, " ",
					     yyvsp[-1].id, " const", NULL);
			g_free(yyvsp[-1].id);
							}
    break;
case 99:
#line 1430 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " ", yyvsp[0].id, NULL);
			g_free(yyvsp[0].id);
							}
    break;
case 100:
#line 1434 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " ", yyvsp[0].id, NULL);
			g_free(yyvsp[-1].id);
			g_free(yyvsp[0].id);
							}
    break;
case 101:
#line 1439 "parse.y"
{
			yyval.id = g_strconcat("const ", yyvsp[0].id, NULL);
			g_free(yyvsp[0].id);
							}
    break;
case 102:
#line 1443 "parse.y"
{
			yyval.id = yyvsp[0].id;
							}
    break;
case 103:
#line 1446 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " const", NULL);
			g_free(yyvsp[-1].id);
							}
    break;
case 104:
#line 1450 "parse.y"
{
			yyval.id = g_strdup(yyvsp[0].id);
							}
    break;
case 105:
#line 1453 "parse.y"
{
			yyval.id = g_strconcat(yyvsp[-1].id, " const", NULL);
							}
    break;
case 106:
#line 1458 "parse.y"
{ yyval.id = "void"; }
    break;
case 107:
#line 1459 "parse.y"
{ yyval.id = "char"; }
    break;
case 108:
#line 1460 "parse.y"
{ yyval.id = "short"; }
    break;
case 109:
#line 1461 "parse.y"
{ yyval.id = "int"; }
    break;
case 110:
#line 1462 "parse.y"
{ yyval.id = "long"; }
    break;
case 111:
#line 1463 "parse.y"
{ yyval.id = "float"; }
    break;
case 112:
#line 1464 "parse.y"
{ yyval.id = "double"; }
    break;
case 113:
#line 1465 "parse.y"
{ yyval.id = "signed"; }
    break;
case 114:
#line 1466 "parse.y"
{ yyval.id = "unsigned"; }
    break;
case 115:
#line 1469 "parse.y"
{ yyval.id = "struct"; }
    break;
case 116:
#line 1470 "parse.y"
{ yyval.id = "union"; }
    break;
case 117:
#line 1471 "parse.y"
{ yyval.id = "enum"; }
    break;
case 118:
#line 1474 "parse.y"
{ yyval.id = g_strdup("*"); }
    break;
case 119:
#line 1475 "parse.y"
{ yyval.id = g_strdup("* const"); }
    break;
case 120:
#line 1476 "parse.y"
{
				yyval.id = g_strconcat("*", yyvsp[0].id, NULL);
				g_free(yyvsp[0].id);
					}
    break;
case 121:
#line 1480 "parse.y"
{
				yyval.id = g_strconcat("* const", yyvsp[0].id, NULL);
				g_free(yyvsp[0].id);
					}
    break;
case 122:
#line 1487 "parse.y"
{
			if(strcmp(yyvsp[-1].id, "first")==0)
				yyval.sigtype = SIGNAL_FIRST_METHOD;
			else if(strcmp(yyvsp[-1].id, "last")==0)
				yyval.sigtype = SIGNAL_LAST_METHOD;
			else {
				yyerror(_("signal must be 'first' or 'last'"));
				g_free(yyvsp[-1].id);
				YYERROR;
			}
			g_free(yyvsp[-1].id);
					}
    break;
case 123:
#line 1499 "parse.y"
{
			yyval.sigtype = SIGNAL_LAST_METHOD;
					}
    break;
case 124:
#line 1505 "parse.y"
{
			if(strcmp(yyvsp[-1].id,"first")==0)
				yyval.sigtype = SIGNAL_FIRST_METHOD;
			else if(strcmp(yyvsp[-1].id,"last")==0)
				yyval.sigtype = SIGNAL_LAST_METHOD;
			else {
				yyerror(_("signal must be 'first' or 'last'"));
				g_free(yyvsp[-1].id);
				YYERROR;
			}
			g_free(yyvsp[-1].id);
					}
    break;
case 125:
#line 1517 "parse.y"
{
			if(strcmp(yyvsp[-2].id,"first")==0)
				yyval.sigtype = SIGNAL_FIRST_METHOD;
			else if(strcmp(yyvsp[-2].id,"last")==0)
				yyval.sigtype = SIGNAL_LAST_METHOD;
			else {
				yyerror(_("signal must be 'first' or 'last'"));
				g_free(yyvsp[-2].id);
				YYERROR;
			}
			g_free(yyvsp[-2].id);
					}
    break;
case 126:
#line 1529 "parse.y"
{
			yyval.sigtype = SIGNAL_LAST_METHOD;
					}
    break;
case 127:
#line 1532 "parse.y"
{
			/* the_scope was default thus public */
			the_scope = PUBLIC_SCOPE;
					}
    break;
case 128:
#line 1538 "parse.y"
{
			gtktypes = g_list_prepend(gtktypes, debool (yyvsp[-3].id));
						}
    break;
case 129:
#line 1543 "parse.y"
{
			gtktypes = g_list_append(gtktypes, debool (yyvsp[0].id));
						}
    break;
case 130:
#line 1546 "parse.y"
{ 
			gtktypes = g_list_append(gtktypes, debool (yyvsp[0].id));
       						}
    break;
case 131:
#line 1551 "parse.y"
{ yyval.cbuf = yyvsp[0].cbuf; }
    break;
case 132:
#line 1552 "parse.y"
{ yyval.cbuf = NULL; }
    break;
case 133:
#line 1556 "parse.y"
{
			if(!has_self) {
				yyerror(_("signal without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, yyvsp[-7].sigtype,NULL,
				      yyvsp[-5].id, yyvsp[0].cbuf,yyvsp[-9].line,
				      ccode_line, vararg, yyvsp[-8].list);
									}
    break;
case 134:
#line 1572 "parse.y"
{
			if(!has_self) {
				yyerror(_("signal without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, yyvsp[-7].sigtype, NULL,
				      yyvsp[-5].id, yyvsp[0].cbuf, yyvsp[-9].line,
				      ccode_line, vararg, yyvsp[-8].list);
									}
    break;
case 135:
#line 1588 "parse.y"
{
			if(!has_self) {
				yyerror(_("virtual method without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, VIRTUAL_METHOD, NULL, yyvsp[-5].id,
				      yyvsp[0].cbuf, yyvsp[-8].line,
				      ccode_line, vararg, NULL);
									}
    break;
case 136:
#line 1604 "parse.y"
{
			if(!has_self) {
				yyerror(_("virtual method without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, VIRTUAL_METHOD, NULL, yyvsp[-5].id,
				      yyvsp[0].cbuf, yyvsp[-7].line,
				      ccode_line, vararg, NULL);
									}
    break;
case 137:
#line 1620 "parse.y"
{
			if(!has_self) {
				yyerror(_("virtual method without 'self' as "
					  "first parameter"));
				free_all_global_state();
				YYERROR;
			}
			push_function(PUBLIC_SCOPE, VIRTUAL_METHOD, NULL,
				      yyvsp[-5].id, yyvsp[0].cbuf, yyvsp[-7].line,
				      ccode_line, vararg, NULL);
									}
    break;
case 138:
#line 1631 "parse.y"
{
			push_function(NO_SCOPE, OVERRIDE_METHOD, yyvsp[-8].id,
				      yyvsp[-5].id, yyvsp[0].cbuf,
				      yyvsp[-10].line, ccode_line,
				      vararg, NULL);
									}
    break;
case 139:
#line 1637 "parse.y"
{
			if(the_scope == CLASS_SCOPE) {
				yyerror(_("a method cannot be of class scope"));
				free_all_global_state();
				YYERROR;
			}
			push_function(the_scope, REGULAR_METHOD, NULL, yyvsp[-5].id,
				      yyvsp[0].cbuf, yyvsp[-7].line, ccode_line,
				      vararg, NULL);
								}
    break;
case 140:
#line 1647 "parse.y"
{
			if(strcmp(yyvsp[-4].id, "init")==0) {
				push_init_arg(yyvsp[-2].id,FALSE);
				push_function(NO_SCOPE, INIT_METHOD, NULL,
					      yyvsp[-4].id, yyvsp[0].cbuf, yyvsp[-3].line,
					      ccode_line, FALSE, NULL);
			} else if(strcmp(yyvsp[-4].id, "class_init")==0) {
				push_init_arg(yyvsp[-2].id,TRUE);
				push_function(NO_SCOPE, CLASS_INIT_METHOD, NULL,
					      yyvsp[-4].id, yyvsp[0].cbuf, yyvsp[-3].line,
					      ccode_line, FALSE, NULL);
			} else {
				g_free(yyvsp[-4].id);
				g_free(yyvsp[-2].id);
				g_string_free(yyvsp[0].cbuf,TRUE);
				yyerror(_("parse error "
					  "(untyped blocks must be init or "
					  "class_init)"));
				YYERROR;
			}
						}
    break;
case 141:
#line 1670 "parse.y"
{
			g_free(onerror); onerror = NULL;
			g_free(defreturn); defreturn = NULL;
			if(!set_return_value(yyvsp[-1].id, yyvsp[0].id)) {
				g_free(yyvsp[-1].id);
				g_free(yyvsp[0].id);
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free(yyvsp[-1].id);
					}
    break;
case 142:
#line 1681 "parse.y"
{
			g_free(onerror); onerror = NULL;
			g_free(defreturn); defreturn = NULL;
			if(!set_return_value(yyvsp[-3].id, yyvsp[-2].id)) {
				g_free(yyvsp[-3].id); g_free(yyvsp[-2].id);
				g_free(yyvsp[-1].id); g_free(yyvsp[0].id);
				yyerror(_("parse error"));
				YYERROR;
			}
			if(!set_return_value(yyvsp[-1].id, yyvsp[0].id)) {
				onerror = defreturn = NULL;
				g_free(yyvsp[-3].id); g_free(yyvsp[-2].id);
				g_free(yyvsp[-1].id); g_free(yyvsp[0].id);
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free(yyvsp[-3].id);
			g_free(yyvsp[-1].id);
						}
    break;
case 143:
#line 1700 "parse.y"
{
			g_free(onerror); onerror = NULL;
			g_free(defreturn); defreturn = NULL;
					}
    break;
case 144:
#line 1706 "parse.y"
{ yyval.id = yyvsp[0].id; }
    break;
case 145:
#line 1707 "parse.y"
{
			yyval.id = (yyvsp[0].cbuf)->str;
			g_string_free(yyvsp[0].cbuf, FALSE);
					}
    break;
case 146:
#line 1713 "parse.y"
{ vararg = FALSE; has_self = FALSE; }
    break;
case 147:
#line 1714 "parse.y"
{
			vararg = FALSE;
			has_self = TRUE;
			if(strcmp(yyvsp[0].id,"self")==0)
				push_self(yyvsp[0].id, FALSE);
			else {
				g_free(yyvsp[0].id);
				yyerror(_("parse error"));
				YYERROR;
			}
       					}
    break;
case 148:
#line 1725 "parse.y"
{
			vararg = FALSE;
			has_self = TRUE;
			if(strcmp(yyvsp[-1].id,"self")==0)
				push_self(yyvsp[-1].id, TRUE);
			else {
				g_free(yyvsp[-1].id);
				yyerror(_("parse error"));
				YYERROR;
			}
       					}
    break;
case 149:
#line 1736 "parse.y"
{
			vararg = FALSE;
			has_self = TRUE;
			if(strcmp(yyvsp[0].id,"self")==0)
				push_self(yyvsp[0].id, TRUE);
			else {
				g_free(yyvsp[0].id);
				yyerror(_("parse error"));
				YYERROR;
			}
       					}
    break;
case 150:
#line 1747 "parse.y"
{
			has_self = TRUE;
			if(strcmp(yyvsp[-2].id,"self")==0)
				push_self(yyvsp[-2].id, FALSE);
			else {
				g_free(yyvsp[-2].id);
				yyerror(_("parse error"));
				YYERROR;
			}
					}
    break;
case 151:
#line 1757 "parse.y"
{
			has_self = TRUE;
			if(strcmp(yyvsp[-3].id,"self")==0)
				push_self(yyvsp[-3].id, TRUE);
			else {
				g_free(yyvsp[-3].id);
				yyerror(_("parse error"));
				YYERROR;
			}
					}
    break;
case 152:
#line 1767 "parse.y"
{
			has_self = TRUE;
			if(strcmp(yyvsp[-2].id,"self")==0)
				push_self(yyvsp[-2].id, TRUE);
			else {
				g_free(yyvsp[-2].id);
				yyerror(_("parse error"));
				YYERROR;
			}
					}
    break;
case 153:
#line 1777 "parse.y"
{ has_self = FALSE; }
    break;
case 154:
#line 1780 "parse.y"
{ vararg = TRUE; }
    break;
case 155:
#line 1781 "parse.y"
{ vararg = FALSE; }
    break;
case 156:
#line 1784 "parse.y"
{ ; }
    break;
case 157:
#line 1785 "parse.y"
{ ; }
    break;
case 158:
#line 1788 "parse.y"
{
			push_funcarg(yyvsp[0].id,NULL);
								}
    break;
case 159:
#line 1791 "parse.y"
{
			push_funcarg(yyvsp[-1].id,yyvsp[0].id);
								}
    break;
case 160:
#line 1794 "parse.y"
{
			if(strcmp(yyvsp[-2].id,"check")!=0) {
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free(yyvsp[-2].id);
			push_funcarg(yyvsp[-4].id,NULL);
								}
    break;
case 161:
#line 1802 "parse.y"
{
			if(strcmp(yyvsp[-2].id,"check")!=0) {
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free(yyvsp[-2].id);
			push_funcarg(yyvsp[-5].id,yyvsp[-4].id);
								}
    break;
case 162:
#line 1812 "parse.y"
{ ; }
    break;
case 163:
#line 1813 "parse.y"
{ ; }
    break;
case 164:
#line 1816 "parse.y"
{
			if(strcmp(yyvsp[0].id,"type")==0) {
				Node *node = node_new (CHECK_NODE,
						       "chtype", TYPE_CHECK,
						       NULL);
				checks = g_list_append(checks,node);
			} else if(strcmp(yyvsp[0].id,"null")==0) {
				Node *node = node_new (CHECK_NODE,
						       "chtype", NULL_CHECK,
						       NULL);
				checks = g_list_append(checks,node);
			} else {
				yyerror(_("parse error"));
				YYERROR;
			}
			g_free(yyvsp[0].id);
					}
    break;
case 165:
#line 1833 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", GT_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;
case 166:
#line 1840 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", LT_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;
case 167:
#line 1847 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", GE_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;
case 168:
#line 1854 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", LE_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;
case 169:
#line 1861 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", EQ_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;
case 170:
#line 1868 "parse.y"
{
			Node *node = node_new (CHECK_NODE,
					       "chtype", NE_CHECK,
					       "number:steal", yyvsp[0].id,
					       NULL);
			checks = g_list_append(checks,node);
					}
    break;
case 171:
#line 1877 "parse.y"
{
			Node *node = node_new (ENUMDEF_NODE,
					       "etype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-5].id,
					       "values:steal", enum_vals,
					       NULL);
			enum_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;
case 172:
#line 1886 "parse.y"
{
			Node *node = node_new (ENUMDEF_NODE,
					       "etype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-6].id,
					       "values:steal", enum_vals,
					       NULL);
			enum_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;
case 173:
#line 1897 "parse.y"
{;}
    break;
case 174:
#line 1898 "parse.y"
{;}
    break;
case 175:
#line 1901 "parse.y"
{
			Node *node;
			char *num = yyvsp[0].id;

			/* A float value, that's a bad enum */
			if (num[0] >= '0' &&
			    num[0] <= '9' &&
			    strchr (num, '.') != NULL) {
				g_free (yyvsp[-2].id);
				g_free (num);
				yyerror(_("parse error (enumerator value not integer constant)"));
				YYERROR;
			}
		       
			node = node_new (ENUMVALUE_NODE,
					 "name:steal", yyvsp[-2].id,
					 "value:steal", num,
					 NULL);
			enum_vals = g_list_append (enum_vals, node);
			}
    break;
case 176:
#line 1921 "parse.y"
{
			Node *node;

			node = node_new (ENUMVALUE_NODE,
					 "name:steal", yyvsp[0].id,
					 NULL);
			enum_vals = g_list_append (enum_vals, node);
	}
    break;
case 177:
#line 1931 "parse.y"
{
			Node *node = node_new (FLAGS_NODE,
					       "ftype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-5].id,
					       "values:steal", flag_vals,
					       NULL);
			flag_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;
case 178:
#line 1940 "parse.y"
{
			Node *node = node_new (FLAGS_NODE,
					       "ftype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-6].id,
					       "values:steal", flag_vals,
					       NULL);
			flag_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;
case 179:
#line 1951 "parse.y"
{
			flag_vals = g_list_append (flag_vals, yyvsp[0].id);
		}
    break;
case 180:
#line 1954 "parse.y"
{
			flag_vals = g_list_append (flag_vals, yyvsp[0].id);
		}
    break;
case 181:
#line 1959 "parse.y"
{
			Node *node = node_new (ERROR_NODE,
					       "etype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-5].id,
					       "values:steal", error_vals,
					       NULL);
			error_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;
case 182:
#line 1968 "parse.y"
{
			Node *node = node_new (ERROR_NODE,
					       "etype:steal", yyvsp[-1].id,
					       "prefix:steal", yyvsp[-6].id,
					       "values:steal", error_vals,
					       NULL);
			error_vals = NULL;
			nodes = g_list_append (nodes, node);
			}
    break;
case 183:
#line 1979 "parse.y"
{
			error_vals = g_list_append (error_vals, yyvsp[0].id);
		}
    break;
case 184:
#line 1982 "parse.y"
{
			error_vals = g_list_append (error_vals, yyvsp[0].id);
		}
    break;
case 185:
#line 1988 "parse.y"
{ yyval.id = yyvsp[0].id; }
    break;
case 186:
#line 1989 "parse.y"
{
			yyval.id = g_strconcat("-",yyvsp[0].id,NULL);
			g_free(yyvsp[0].id);
					}
    break;
case 187:
#line 1993 "parse.y"
{ yyval.id = yyvsp[0].id; }
    break;
case 188:
#line 1994 "parse.y"
{ yyval.id = yyvsp[0].id; }
    break;
}

#line 705 "/usr/share/bison/bison.simple"


  yyvsp -= yylen;
  yyssp -= yylen;
#if YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;
#if YYLSP_NEEDED
  *++yylsp = yyloc;
#endif

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("parse error, unexpected ") + 1;
	  yysize += yystrlen (yytname[YYTRANSLATE (yychar)]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "parse error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[YYTRANSLATE (yychar)]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exhausted");
	}
      else
#endif /* defined (YYERROR_VERBOSE) */
	yyerror ("parse error");
    }
  goto yyerrlab1;


/*--------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action |
`--------------------------------------------------*/
yyerrlab1:
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;
      YYDPRINTF ((stderr, "Discarding token %d (%s).\n",
		  yychar, yytname[yychar1]));
      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;


/*-------------------------------------------------------------------.
| yyerrdefault -- current state does not do anything special for the |
| error token.                                                       |
`-------------------------------------------------------------------*/
yyerrdefault:
#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */

  /* If its default is to accept any token, ok.  Otherwise pop it.  */
  yyn = yydefact[yystate];
  if (yyn)
    goto yydefault;
#endif


/*---------------------------------------------------------------.
| yyerrpop -- pop the current state because it cannot handle the |
| error token                                                    |
`---------------------------------------------------------------*/
yyerrpop:
  if (yyssp == yyss)
    YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#if YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG
  if (yydebug)
    {
      short *yyssp1 = yyss - 1;
      YYFPRINTF (stderr, "Error: state stack now");
      while (yyssp1 != yyssp)
	YYFPRINTF (stderr, " %d", *++yyssp1);
      YYFPRINTF (stderr, "\n");
    }
#endif

/*--------------.
| yyerrhandle.  |
`--------------*/
yyerrhandle:
  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;
#if YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

/*---------------------------------------------.
| yyoverflowab -- parser overflow comes here.  |
`---------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}
#line 1997 "parse.y"

