#ifndef GNUMERIC_IO_CONTEXT_H
#define GNUMERIC_IO_CONTEXT_H

#include "gnumeric.h"
#include <glib-object.h>
#include <stdarg.h>

/* typedef struct _IOContext IOContext; */
typedef struct _IOContextClass IOContextClass;

#define TYPE_IO_CONTEXT    (io_context_get_type ())
#define IO_CONTEXT(obj)    (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IO_CONTEXT, IOContext))
#define IS_IO_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IO_CONTEXT))

typedef enum {
	WB_PROGRESS_CELLS  = 1,
	WB_PROGRESS_ALL    = (WB_PROGRESS_CELLS)
} WbProgressElements;

GType      io_context_get_type (void);
IOContext *gnumeric_io_context_new        (CommandContext *cc);

/*
 * These are the exceptions that can arise.
 * NOTE : The selection is quite limited by IDL's intentional non-support for
 *        inheritance (single or multiple).
 */
void       gnumeric_io_error_system       (IOContext *context, char const *msg);
void       gnumeric_io_error_read         (IOContext *context, char const *msg);
void       gnumeric_io_error_save         (IOContext *context, char const *msg);
void       gnumeric_io_error_unknown      (IOContext *context);

void       gnumeric_io_error_info_set     (IOContext *context, ErrorInfo *error);
void       gnumeric_io_error_string       (IOContext *context, const gchar *str);
void       gnumeric_io_error_push         (IOContext *context, ErrorInfo *error);
ErrorInfo *gnumeric_io_error_pop          (IOContext *context);
void       gnumeric_io_error_clear        (IOContext *context);
void       gnumeric_io_error_display      (IOContext *context);

void       gnumeric_io_clear_error        (IOContext *context);
gboolean   gnumeric_io_error_occurred     (IOContext *context);

void       io_progress_message      (IOContext *io_context, const gchar *msg);
void       io_progress_update       (IOContext *io_context, gdouble f);
void       io_progress_range_push   (IOContext *io_context, gdouble min, gdouble max);
void       io_progress_range_pop    (IOContext *io_context);

void       count_io_progress_set    (IOContext *io_context, gint total, gint step);
void       count_io_progress_update (IOContext *io_context, gint inc);

void       value_io_progress_set    (IOContext *io_context, gint total, gint step);
void       value_io_progress_update (IOContext *io_context, gint value);

void       workbook_io_progress_set    (IOContext *io_context, Workbook *wb,
                                        WbProgressElements elements, gint step);
void       workbook_io_progress_update (IOContext *io_context, gint inc);

void       io_progress_unset      (IOContext *io_context);

char *gnm_io_get_password        	 (IOContext *context, char const *msg);
void  gnm_io_warning        		 (IOContext *context, char const *fmt, ...) G_GNUC_PRINTF (2, 3);
void  gnm_io_warning_unknown_font	 (IOContext *context, char const *font_name);
void  gnm_io_warning_unknown_function	 (IOContext *context, char const *funct_name);
void  gnm_io_warning_unsupported_feature (IOContext *context, char const *feature);

#endif /* GNUMERIC_IO_CONTEXT_H */
