#ifndef GNUMERIC_EXPR_NAME_H
#define GNUMERIC_EXPR_NAME_H

#include "gnumeric.h"
#include "expr.h"
#include "func.h"
#include "parse-util.h"

struct _GnmNamedExpr {
	int	    ref_count;
	String     *name;
	ParsePos    pos;
	GHashTable *dependents;
	gboolean    active  : 1;
	gboolean    builtin : 1;
	union {
		GnmExpr const *expr_tree;
		FunctionArgs   expr_func;
	} t;
};

GnmNamedExpr *expr_name_new	  (char const *name, gboolean builtin);
GnmNamedExpr *expr_name_lookup (ParsePos const *pos, char const *name);
GnmNamedExpr *expr_name_add    (ParsePos const *pp, char const *name,
				   GnmExpr const *expr, char const **error_msg);
GnmNamedExpr *expr_name_create (ParsePos const *pp, char const *name,
				   char const *expr_str, ParseError *error);

void	 expr_name_ref	      (GnmNamedExpr *exprn);
void	 expr_name_unref      (GnmNamedExpr *exprn);
void     expr_name_remove     (GnmNamedExpr *exprn);
Value   *expr_name_eval       (GnmNamedExpr const *ne, EvalPos const *ep,
			       GnmExprEvalFlags flags);
char    *expr_name_as_string  (GnmNamedExpr const *ne, ParsePos const *pp);
gboolean expr_name_set_scope  (GnmNamedExpr *ne, Sheet *sheet);
void	 expr_name_set_expr   (GnmNamedExpr *ne, GnmExpr const *new_expr);
void	 expr_name_add_dep    (GnmNamedExpr *ne, Dependent *dep);
void	 expr_name_remove_dep (GnmNamedExpr *ne, Dependent *dep);

GList	 *expr_name_list_destroy	  (GList *names);

void expr_name_init       (void);
void expr_name_shutdown   (void);

GList *sheet_get_available_names (Sheet const *sheet);

#endif /* GNUMERIC_EXPR_NAME_H */
