#ifndef GNUMERIC_GCONF_PRIV_H
#define GNUMERIC_GCONF_PRIV_H

/*
 *  Note: This file must stay synchronized with the corresponding schema file!
 *
 *        This file should only be included into gnumeric-gconf.c  and
 *        dialogs/dialog-preferences.c
 */


/*
 *  schemas/gnumeric-dialogs.schemas
 */
#define FUNCTION_SELECT_GCONF_RECENT "/apps/gnumeric/functionselector/recentfunctions"
#define FUNCTION_SELECT_GCONF_NUM_OF_RECENT "/apps/gnumeric/functionselector/num-of-recent"

#define PLUGIN_GCONF_DIRECTORY "/apps/gnumeric/plugins"
#define PLUGIN_GCONF_ACTIVATE_NEW PLUGIN_GCONF_DIRECTORY "/activate-new"
#define PLUGIN_GCONF_ACTIVE PLUGIN_GCONF_DIRECTORY "/active"
#define PLUGIN_GCONF_FILE_STATES PLUGIN_GCONF_DIRECTORY "/file-states"
#define PLUGIN_GCONF_EXTRA_DIRS PLUGIN_GCONF_DIRECTORY "/extra-dirs"

#define AUTOFORMAT_GCONF_DIRECTORY "/apps/gnumeric/autoformat"
#define AUTOFORMAT_GCONF_EXTRA_DIRS AUTOFORMAT_GCONF_DIRECTORY "/extra-dirs"
#define AUTOFORMAT_GCONF_SYS_DIR AUTOFORMAT_GCONF_DIRECTORY "/sys-dir"
#define AUTOFORMAT_GCONF_USR_DIR AUTOFORMAT_GCONF_DIRECTORY "/usr-dir"

#define PRINTSETUP_GCONF_DIRECTORY "/apps/gnumeric/printsetup"
#define PRINTSETUP_GCONF_ALL_SHEETS PRINTSETUP_GCONF_DIRECTORY "/all-sheets"

#define PRINTING_GCONF_DIRECTORY "/apps/gnumeric/printing"
#define PRINTING_GCONF_PRINTER PRINTING_GCONF_DIRECTORY "/printer"
#define PRINTING_GCONF_BACKEND PRINTING_GCONF_DIRECTORY "/backend"
#define PRINTING_GCONF_FILENAME PRINTING_GCONF_DIRECTORY "/filename"
#define PRINTING_GCONF_COMMAND PRINTING_GCONF_DIRECTORY "/command"
#define PRINTING_GCONF_BACKEND_PRINTER PRINTING_GCONF_DIRECTORY "/backend.printer"

#define DIALOGS_GCONF_DIRECTORY "/apps/gnumeric/dialogs"
#define DIALOGS_GCONF_UNFOCUSED_RS DIALOGS_GCONF_DIRECTORY "/rs/unfocused"

/*
 *  schemas/gnumeric-general.schemas
 */

#define GNUMERIC_GCONF_UNDO_DIRECTORY "/apps/gnumeric/undo"
#define GNUMERIC_GCONF_UNDO_SIZE GNUMERIC_GCONF_UNDO_DIRECTORY "/size"
#define GNUMERIC_GCONF_UNDO_MAXNUM GNUMERIC_GCONF_UNDO_DIRECTORY "/maxnum"
#define GNUMERIC_GCONF_UNDO_SHOW_SHEET_NAME GNUMERIC_GCONF_UNDO_DIRECTORY "/show_sheet_name"
#define GNUMERIC_GCONF_UNDO_MAX_DESCRIPTOR_WIDTH GNUMERIC_GCONF_UNDO_DIRECTORY "/max_descriptor_width"

#define GNUMERIC_GCONF_FONT_DIRECTORY "/apps/gnumeric/core/defaultfont"
#define GNUMERIC_GCONF_FONT_NAME GNUMERIC_GCONF_FONT_DIRECTORY "/name"
#define GNUMERIC_GCONF_FONT_SIZE GNUMERIC_GCONF_FONT_DIRECTORY "/size"
#define GNUMERIC_GCONF_FONT_BOLD GNUMERIC_GCONF_FONT_DIRECTORY "/bold"
#define GNUMERIC_GCONF_FONT_ITALIC GNUMERIC_GCONF_FONT_DIRECTORY "/italic"

#define GNUMERIC_GCONF_FILE_DIRECTORY "/apps/gnumeric/core/file"
#define GNUMERIC_GCONF_FILE_HISTORY_N GNUMERIC_GCONF_FILE_DIRECTORY "/history/n"
#define GNUMERIC_GCONF_FILE_HISTORY_FILES GNUMERIC_GCONF_FILE_DIRECTORY "/history/files"
#define GNUMERIC_GCONF_FILE_IMPORT_USES_ALL_OP GNUMERIC_GCONF_FILE_DIRECTORY "/import/all-openers"
#define GNUMERIC_GCONF_FILE_OVERWRITE_DEFAULT GNUMERIC_GCONF_FILE_DIRECTORY "/save/def-overwrite"
#define GNUMERIC_GCONF_FILE_SINGLE_SHEET_SAVE GNUMERIC_GCONF_FILE_DIRECTORY "/save/single_sheet"

#define GNUMERIC_GCONF_WORKBOOK_NSHEETS "/apps/gnumeric/core/workbook/n-sheet"

#define GNUMERIC_GCONF_GUI_DIRECTORY "/apps/gnumeric/core/gui"
#define GNUMERIC_GCONF_GUI_RES_H GNUMERIC_GCONF_GUI_DIRECTORY "/screen/horizontaldpi"
#define GNUMERIC_GCONF_GUI_RES_V GNUMERIC_GCONF_GUI_DIRECTORY "/screen/verticaldpi"
#define GNUMERIC_GCONF_GUI_ED_AUTOCOMPLETE GNUMERIC_GCONF_GUI_DIRECTORY "/editing/autocomplete"
#define GNUMERIC_GCONF_GUI_ED_LIVESCROLLING GNUMERIC_GCONF_GUI_DIRECTORY "/editing/livescrolling"
#define GNUMERIC_GCONF_GUI_ED_RECALC_LAG GNUMERIC_GCONF_GUI_DIRECTORY "/editing/recalclag"
#define GNUMERIC_GCONF_GUI_WINDOW_X GNUMERIC_GCONF_GUI_DIRECTORY "/window/x"
#define GNUMERIC_GCONF_GUI_WINDOW_Y GNUMERIC_GCONF_GUI_DIRECTORY "/window/y"
#define GNUMERIC_GCONF_GUI_ZOOM GNUMERIC_GCONF_GUI_DIRECTORY "/window/zoom"

#define GNUMERIC_GCONF_XML_COMPRESSION "/apps/gnumeric/core/xml/compression-level"

#define GNUMERIC_GCONF_SORT_DIRECTORY "/apps/gnumeric/core/sort"
#define GNUMERIC_GCONF_SORT_DEFAULT_BY_CASE GNUMERIC_GCONF_SORT_DIRECTORY "/default/by-case"
#define GNUMERIC_GCONF_SORT_DEFAULT_RETAIN_FORM GNUMERIC_GCONF_SORT_DIRECTORY "/default/retain-formats"
#define GNUMERIC_GCONF_SORT_DEFAULT_ASCENDING GNUMERIC_GCONF_SORT_DIRECTORY "/default/ascending"
#define GNUMERIC_GCONF_SORT_DIALOG_MAX_INITIAL GNUMERIC_GCONF_SORT_DIRECTORY "/dialog/max-intial-clauses"

#include <gconf/gconf-client.h>

#endif /* GNUMERIC_GRAPH_H */
