/* A Bison parser, made by GNU Bison 1.875a.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     STRING = 258,
     QUOTED_STRING = 259,
     CONSTANT = 260,
     CELLREF = 261,
     GTE = 262,
     LTE = 263,
     NE = 264,
     SEPARATOR = 265,
     INVALID_TOKEN = 266,
     PLUS = 267,
     NEG = 268,
     SHEET_SEP = 269,
     RANGE_SEP = 270
   };
#endif
#define STRING 258
#define QUOTED_STRING 259
#define CONSTANT 260
#define CELLREF 261
#define GTE 262
#define LTE 263
#define NE 264
#define SEPARATOR 265
#define INVALID_TOKEN 266
#define PLUS 267
#define NEG 268
#define SHEET_SEP 269
#define RANGE_SEP 270




/* Copy the first part of user declarations.  */
#line 1 "parser.y"

/*
 * Gnumeric Parser
 *
 * (C) 1998-2001 the Free Software Foundation
 *
 * Author:
 *    Miguel de Icaza (miguel@gnu.org)
 *    Jody Goldberg (jody@gnome.org)
 *    Morten Welinder (terra@diku.dk)
 *    Almer S. Tigelaar (almer@gnome.org)
 */
#include <gnumeric-config.h>
#include "gnumeric.h"
#include "number-match.h"
#include "expr.h"
#include "expr-name.h"
#include "workbook.h"
#include "sheet.h"
#include "format.h"
#include "application.h"
#include "parse-util.h"
#include "gutils.h"
#include "auto-format.h"
#include "style.h"
#include "portability.h"
#include "str.h"

#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>
#include <libgnome/gnome-i18n.h>

#define YYDEBUG 1
/* ------------------------------------------------------------------------- */
/* Allocation with disposal-on-error */

/*
 * Defined: the stack itself will be kept in use.  This isn't much, btw.
 *   This setting is good for speed.
 *
 * Not defined: memory will be freed.  The is good for finding leaks in the
 * program.  (Here and elsewhere.)
 */
#define KEEP_DEALLOCATION_STACK_BETWEEN_CALLS

/*
 * If some dork enters "=1+2+2*(1+" we have already allocated space for
 * "1+2", "2", and "1" before the parser sees the syntax error and warps
 * us to the error production in the "line" non-terminal.
 *
 * To make sure we can clean up, we register every allocation.  On success,
 * nothing should be left (except the final expression which is unregistered),
 * but on failure we must free everything allocated.
 *
 * Note: there is some room left for optimisation here.  Talk to terra@diku.dk
 * before you set out to do it.
 */

static void
free_expr_list_list (GSList *list)
{
	GSList *l;
	for (l = list; l; l = l->next)
		expr_list_unref (l->data);
	g_slist_free (list);
}

typedef void (*ParseDeallocator) (void *);
static GPtrArray *deallocate_stack;

static void
deallocate_init (void)
{
	deallocate_stack = g_ptr_array_new ();
}

static void
deallocate_uninit (void)
{
#ifndef KEEP_DEALLOCATION_STACK_BETWEEN_CALLS
	g_ptr_array_free (deallocate_stack, TRUE);
	deallocate_stack = NULL;
#endif
}

static void
deallocate_all (void)
{
	int i;

	for (i = 0; i < (int)deallocate_stack->len; i += 2) {
		ParseDeallocator freer = g_ptr_array_index (deallocate_stack, i + 1);
		freer (g_ptr_array_index (deallocate_stack, i));
	}

	g_ptr_array_set_size (deallocate_stack, 0);
}

static void
deallocate_assert_empty (void)
{
	if (deallocate_stack->len == 0)
		return;

	g_warning ("deallocate_stack not empty as expected.");
	deallocate_all ();
}

static void *
register_allocation (void *data, ParseDeallocator freer)
{
	/* It's handy to be able to register and unregister NULLs.  */
	if (data) {
		int len;
		/*
		 * There are really only a few different freers, so we
		 * could encode the freer in the lower bits of the data
		 * pointer.  Unfortunately, no-one can predict how high
		 * Miguel would jump when he found out.
		 */
		len = deallocate_stack->len;
		g_ptr_array_set_size (deallocate_stack, len + 2);
		g_ptr_array_index (deallocate_stack, len) = data;
		g_ptr_array_index (deallocate_stack, len + 1) = freer;
	}

	/* Returning the pointer here improved readability of the caller.  */
	return data;
}

#define register_expr_allocation(expr) \
  register_allocation ((expr), (ParseDeallocator)&expr_tree_unref)

#define register_expr_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&expr_list_unref)

#define register_expr_list_list_allocation(list) \
  register_allocation ((list), (ParseDeallocator)&free_expr_list_list)

static void
unregister_allocation (void const *data)
{
	int pos;

	/* It's handy to be able to register and unregister NULLs.  */
	if (!data)
		return;

	pos = deallocate_stack->len - 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_set_size (deallocate_stack, pos);
		return;
	}

	/*
	 * Bummer.  In certain error cases, it is possible that the parser
	 * will reduce after it has discovered a token that will lead to an
	 * error.  "2/16/1800 00:00" (without the quotes) is an example.
	 * The first "00" is registered before the second division is
	 * reduced.
	 *
	 * This isn't a big deal -- we will just look at the entry just below
	 * the top.
	 */
	pos -= 2;
	if (pos >= 0 && data == g_ptr_array_index (deallocate_stack, pos)) {
		g_ptr_array_index (deallocate_stack, pos) =
			g_ptr_array_index (deallocate_stack, pos + 2);
		g_ptr_array_index (deallocate_stack, pos + 1) =
			g_ptr_array_index (deallocate_stack, pos + 3);

		g_ptr_array_set_size (deallocate_stack, pos + 2);
		return;
	}

	g_warning ("Unbalanced allocation registration");
}

/* ------------------------------------------------------------------------- */

#define ERROR -1

/* Bison/Yacc internals */
static int  yylex (void);
static int  yyerror (char *s);

typedef struct {
	/* The expression being parsed */
	char const *expr_text;

	/* A backup of the above, this will always point to the real
	 * expression beginning to calculate the offset in the expression
	 */
	char const *expr_backup;

	/* Location where the parsing is taking place */
	ParsePos const *pos;

	/* Locale info. */
	char decimal_point;
	char separator;
	char array_col_separator;

	/* flags */
	gboolean use_excel_reference_conventions;
	gboolean create_placeholder_for_unknown_func;
	gboolean force_absolute_col_references;
	gboolean force_absolute_row_references;
	gboolean force_explicit_sheet_references;

	/* The suggested format to use for this expression */
	StyleFormat **desired_fmt;
	ExprList *result;

	ParseError *error;
} ParserState;

/* The error returned from the */
static ParserState *state;

static ExprTree *
build_unary_op (Operation op, ExprTree *expr)
{
	unregister_allocation (expr);
	return register_expr_allocation (expr_tree_new_unary (op, expr));
}

static ExprTree *
build_binop (ExprTree *l, Operation op, ExprTree *r)
{
	unregister_allocation (r);
	unregister_allocation (l);
	return register_expr_allocation (expr_tree_new_binary (l, op, r));
}

static ExprTree *
build_array (GSList *cols)
{
	Value *array;
	GSList *row;
	int x, mx, y;

	if (!cols) {
		/* parser_error = PARSE_ERR_SYNTAX; */
		return NULL;
	}

	mx  = 0;
	row = cols->data;
	while (row) {
		mx++;
		row = row->next;
	}

	array = value_new_array_empty (mx, g_slist_length (cols));

	y = 0;
	while (cols) {
		row = cols->data;
		x = 0;
		while (row && x < mx) {
			ExprTree *expr = row->data;
			Value    *v = expr->constant.value;

			g_assert (expr->any.oper == OPER_CONSTANT);

			value_array_set (array, x, y, value_duplicate (v));

			x++;
			row = row->next;
		}
		if (x < mx || row) {
			/* parser_error = PARSE_ERR_SYNTAX; */
			value_release (array);
			return NULL;
		}
		y++;
		cols = cols->next;
	}

	return register_expr_allocation (expr_tree_new_constant (array));
}

static gboolean
parse_string_as_value (ExprTree *str)
{
	/*
	 * Try to parse the entered text as a basic value (empty, bool, int,
	 * float, err) if this succeeds, we store this as a Value otherwise, we
	 * return a string.
	 */
	char const *txt = str->constant.value->v_str.val->str;
	Value *v = format_match_simple (txt);

	if (v != NULL) {
		value_release (str->constant.value);
		str->constant.value = v;
		return TRUE;
	}
	return FALSE;
}

/**
 * parse_string_as_value_or_name :
 * @str : An expression with oper constant, whose value is a string.
 *
 * Check to see if a string is a name
 * if it is not check to see if it can be parsed as a value
 */
static ExprTree *
parse_string_as_value_or_name (ExprTree *str)
{
	NamedExpression *expr_name;

	expr_name = expr_name_lookup (state->pos, str->constant.value->v_str.val->str);
	if (expr_name != NULL) {
		unregister_allocation (str); expr_tree_unref (str);
		return register_expr_allocation (expr_tree_new_name (expr_name, NULL, NULL));
	}

	/* NOTE : parse_string_as_value modifies str in place */
	parse_string_as_value (str);
	return str;
}

static int
gnumeric_parse_error (ParserState *state, ParseErrorID id, char *message, int end, int relative_begin)
{
	if (state->error != NULL) {
		state->error->id         = id;
		state->error->message    = message;
		state->error->begin_char = (end - relative_begin);
		state->error->end_char   = end;
	}

	return ERROR;
}

static gboolean
force_explicit_sheet_references (ParserState *state, CellRef *ref)
{
	ref->sheet = state->pos->sheet;
	if (ref->sheet != NULL)
		return FALSE;

	gnumeric_parse_error (
		state, PERR_SHEET_IS_REQUIRED,
		g_strdup (_("Sheet name is required")),
		state->expr_text - state->expr_backup, 0);
	return TRUE;
}

/* Make byacc happier */
int yyparse (void);



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 360 "parser.y"
typedef union YYSTYPE {
	ExprTree *tree;
	CellRef  *cell;
	ExprList *list;
	Sheet	 *sheet;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 472 "parser.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 484 "parser.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  4
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   170

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  34
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  12
/* YYNRULES -- Number of rules. */
#define YYNRULES  51
/* YYNRULES -- Number of states. */
#define YYNSTATES  87

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   270

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,    25,    12,     2,
      26,    27,    18,    17,     2,    16,     2,    19,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    33,
      13,    15,    14,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    30,    32,    31,    24,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    28,     2,    29,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    20,    21,    22,
      23
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     6,     8,    12,    13,    15,    17,    19,
      21,    25,    29,    33,    37,    41,    45,    49,    53,    57,
      61,    65,    69,    73,    76,    79,    82,    86,    91,    94,
      99,   101,   103,   106,   112,   114,   115,   117,   120,   124,
     130,   132,   136,   139,   140,   142,   144,   146,   150,   154,
     155,   157
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      35,     0,    -1,    36,    37,    -1,     1,    -1,    36,    37,
      10,    -1,    -1,     5,    -1,     4,    -1,     3,    -1,    41,
      -1,    37,    17,    37,    -1,    37,    16,    37,    -1,    37,
      18,    37,    -1,    37,    19,    37,    -1,    37,    24,    37,
      -1,    37,    12,    37,    -1,    37,    15,    37,    -1,    37,
      13,    37,    -1,    37,    14,    37,    -1,    37,     7,    37,
      -1,    37,     9,    37,    -1,    37,     8,    37,    -1,    26,
      37,    27,    -1,    37,    25,    -1,    16,    37,    -1,    17,
      37,    -1,    28,    45,    29,    -1,     3,    26,    42,    27,
      -1,    39,    38,    -1,    30,    38,    31,    38,    -1,     3,
      -1,     4,    -1,    38,    22,    -1,    30,    38,    31,    38,
      22,    -1,    39,    -1,    -1,     6,    -1,    39,     6,    -1,
       6,    23,     6,    -1,    39,     6,    23,    40,     6,    -1,
      37,    -1,    37,    10,    42,    -1,    10,    42,    -1,    -1,
       5,    -1,    38,    -1,    43,    -1,    43,    10,    44,    -1,
      43,    32,    44,    -1,    -1,    44,    -1,    44,    33,    45,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   383,   383,   388,   396,   400,   403,   404,   405,   406,
     407,   408,   409,   410,   411,   412,   413,   414,   415,   416,
     417,   418,   419,   421,   422,   423,   425,   431,   450,   470,
     509,   510,   513,   529,   554,   555,   558,   568,   573,   593,
     608,   613,   619,   629,   632,   633,   636,   641,   654,   668,
     671,   676
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "STRING", "QUOTED_STRING", "CONSTANT", 
  "CELLREF", "GTE", "LTE", "NE", "SEPARATOR", "INVALID_TOKEN", "'&'", 
  "'<'", "'>'", "'='", "'-'", "'+'", "'*'", "'/'", "PLUS", "NEG", 
  "SHEET_SEP", "RANGE_SEP", "'^'", "'%'", "'('", "')'", "'{'", "'}'", 
  "'['", "']'", "'\\\\'", "';'", "$accept", "line", "opt_exp", "exp", 
  "string_opt_quote", "sheetref", "opt_sheetref", "cellref", "arg_list", 
  "array_exp", "array_row", "array_cols", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,    38,    60,    62,    61,    45,    43,    42,    47,
     267,   268,   269,   270,    94,    37,    40,    41,   123,   125,
      91,    93,    92,    59
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    34,    35,    35,    36,    36,    37,    37,    37,    37,
      37,    37,    37,    37,    37,    37,    37,    37,    37,    37,
      37,    37,    37,    37,    37,    37,    37,    37,    37,    37,
      38,    38,    39,    39,    40,    40,    41,    41,    41,    41,
      42,    42,    42,    42,    43,    43,    44,    44,    44,    44,
      45,    45
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     2,     1,     3,     0,     1,     1,     1,     1,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     2,     2,     2,     3,     4,     2,     4,
       1,     1,     2,     5,     1,     0,     1,     2,     3,     5,
       1,     3,     2,     0,     1,     1,     1,     3,     3,     0,
       1,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,     3,     0,     0,     1,     8,     7,     6,    36,     0,
       0,     0,    49,     0,     2,     0,     0,     9,    43,     0,
      24,    25,     0,    30,    31,    44,    45,    46,    50,     0,
       0,     0,     0,     0,     4,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    23,    32,    37,    28,    43,    40,
       0,    38,    22,    49,    49,    49,    26,     0,    19,    21,
      20,    15,    17,    18,    16,    11,    10,    12,    13,    14,
      35,    42,    43,    27,    47,    48,    51,    29,     0,    34,
       0,    41,    33,     0,    39,     0,     0
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     2,     3,    49,    15,    16,    80,    17,    50,    27,
      28,    29
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -38
static const short yypact[] =
{
       4,   -38,    19,    66,   -38,     5,    11,   -38,    17,    66,
      66,    66,    73,     9,   111,    16,    33,   -38,    58,    38,
      35,    35,    90,   -38,   -38,   -38,   -38,    -4,    32,    20,
      36,    66,    66,    66,   -38,    66,    66,    66,    66,    66,
      66,    66,    66,    66,   -38,   -38,    62,   -38,    58,   130,
      54,   -38,   -38,    73,    73,    73,   -38,     9,    -2,    -2,
      -2,   143,    -2,    -2,    -2,   145,   145,    35,    35,    35,
      -1,   -38,    58,   -38,   -38,   -38,   -38,    65,     9,   -38,
      83,   -38,   -38,    59,   -38,     9,    65
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -38,   -38,   -38,    15,   -12,    21,   -38,   -38,   -37,   -38,
      26,    40
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -32
static const yysigned_char yytable[] =
{
      26,    30,    23,    24,    47,     1,    53,    -5,    -5,    -5,
      -5,    71,    23,    24,    39,    40,    41,    42,    14,     4,
      -5,    -5,    43,    44,    20,    21,    22,   -30,    54,    78,
      -5,    18,    -5,   -31,    -5,    81,    23,    24,    45,    46,
      19,    26,    26,    26,    51,    77,    58,    59,    60,    56,
      61,    62,    63,    64,    65,    66,    67,    68,    69,    43,
      44,     5,     6,     7,     8,    55,    83,    57,    48,     5,
       6,     7,     8,    86,     9,    10,    23,    24,    25,    74,
      75,    73,     9,    10,    11,    70,    12,    82,    13,    84,
      85,    79,    11,     0,    12,    76,    13,    31,    32,    33,
       0,     0,    35,    36,    37,    38,    39,    40,    41,    42,
       0,     0,     0,     0,    43,    44,     0,    52,    31,    32,
      33,    34,     0,    35,    36,    37,    38,    39,    40,    41,
      42,     0,     0,     0,     0,    43,    44,    31,    32,    33,
      72,     0,    35,    36,    37,    38,    39,    40,    41,    42,
      31,    32,    33,     0,    43,    44,    36,    37,    38,    39,
      40,    41,    42,    41,    42,     0,     0,    43,    44,    43,
      44
};

static const yysigned_char yycheck[] =
{
      12,    13,     3,     4,    16,     1,    10,     3,     4,     5,
       6,    48,     3,     4,    16,    17,    18,    19,     3,     0,
      16,    17,    24,    25,     9,    10,    11,    22,    32,    30,
      26,    26,    28,    22,    30,    72,     3,     4,    22,     6,
      23,    53,    54,    55,     6,    57,    31,    32,    33,    29,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    24,
      25,     3,     4,     5,     6,    33,    78,    31,    10,     3,
       4,     5,     6,    85,    16,    17,     3,     4,     5,    53,
      54,    27,    16,    17,    26,    23,    28,    22,    30,     6,
      31,    70,    26,    -1,    28,    55,    30,     7,     8,     9,
      -1,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
      -1,    -1,    -1,    -1,    24,    25,    -1,    27,     7,     8,
       9,    10,    -1,    12,    13,    14,    15,    16,    17,    18,
      19,    -1,    -1,    -1,    -1,    24,    25,     7,     8,     9,
      10,    -1,    12,    13,    14,    15,    16,    17,    18,    19,
       7,     8,     9,    -1,    24,    25,    13,    14,    15,    16,
      17,    18,    19,    18,    19,    -1,    -1,    24,    25,    24,
      25
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     1,    35,    36,     0,     3,     4,     5,     6,    16,
      17,    26,    28,    30,    37,    38,    39,    41,    26,    23,
      37,    37,    37,     3,     4,     5,    38,    43,    44,    45,
      38,     7,     8,     9,    10,    12,    13,    14,    15,    16,
      17,    18,    19,    24,    25,    22,     6,    38,    10,    37,
      42,     6,    27,    10,    32,    33,    29,    31,    37,    37,
      37,    37,    37,    37,    37,    37,    37,    37,    37,    37,
      23,    42,    10,    27,    44,    44,    45,    38,    30,    39,
      40,    42,    22,    38,     6,    31,    38
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 383 "parser.y"
    {
		unregister_allocation (yyvsp[0].tree);
		state->result = expr_list_prepend (yyvsp[-1].list, yyvsp[0].tree);
	}
    break;

  case 3:
#line 388 "parser.y"
    {
		if (state->result != NULL) {
			expr_list_unref (state->result);
			state->result = NULL;
		}
	}
    break;

  case 4:
#line 396 "parser.y"
    {
	       unregister_allocation (yyvsp[-1].tree);
	       yyval.list = expr_list_prepend (yyvsp[-2].list, yyvsp[-1].tree);
	}
    break;

  case 5:
#line 400 "parser.y"
    { yyval.list = NULL; }
    break;

  case 6:
#line 403 "parser.y"
    { yyval.tree = yyvsp[0].tree; }
    break;

  case 7:
#line 404 "parser.y"
    { yyval.tree = yyvsp[0].tree; }
    break;

  case 8:
#line 405 "parser.y"
    { yyval.tree = parse_string_as_value_or_name (yyvsp[0].tree); }
    break;

  case 9:
#line 406 "parser.y"
    { yyval.tree = yyvsp[0].tree; }
    break;

  case 10:
#line 407 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_ADD,       yyvsp[0].tree); }
    break;

  case 11:
#line 408 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_SUB,       yyvsp[0].tree); }
    break;

  case 12:
#line 409 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_MULT,      yyvsp[0].tree); }
    break;

  case 13:
#line 410 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_DIV,       yyvsp[0].tree); }
    break;

  case 14:
#line 411 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_EXP,       yyvsp[0].tree); }
    break;

  case 15:
#line 412 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_CONCAT,    yyvsp[0].tree); }
    break;

  case 16:
#line 413 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_EQUAL,     yyvsp[0].tree); }
    break;

  case 17:
#line 414 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_LT,        yyvsp[0].tree); }
    break;

  case 18:
#line 415 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_GT,        yyvsp[0].tree); }
    break;

  case 19:
#line 416 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_GTE,       yyvsp[0].tree); }
    break;

  case 20:
#line 417 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_NOT_EQUAL, yyvsp[0].tree); }
    break;

  case 21:
#line 418 "parser.y"
    { yyval.tree = build_binop (yyvsp[-2].tree, OPER_LTE,       yyvsp[0].tree); }
    break;

  case 22:
#line 419 "parser.y"
    { yyval.tree = yyvsp[-1].tree; }
    break;

  case 23:
#line 421 "parser.y"
    { yyval.tree = build_unary_op (OPER_PERCENT, yyvsp[-1].tree); }
    break;

  case 24:
#line 422 "parser.y"
    { yyval.tree = build_unary_op (OPER_UNARY_NEG, yyvsp[0].tree); }
    break;

  case 25:
#line 423 "parser.y"
    { yyval.tree = build_unary_op (OPER_UNARY_PLUS, yyvsp[0].tree); }
    break;

  case 26:
#line 425 "parser.y"
    {
		unregister_allocation (yyvsp[-1].list);
		yyval.tree = build_array (yyvsp[-1].list);
		free_expr_list_list (yyvsp[-1].list);
	}
    break;

  case 27:
#line 431 "parser.y"
    {
		char const *name = yyvsp[-3].tree->constant.value->v_str.val->str;
		FunctionDefinition *f = func_lookup_by_name (name,
			state->pos->wb);

		/* THINK TODO: Do we want to make this workbook-local??  */
		if (f == NULL && state->create_placeholder_for_unknown_func)
			f = function_add_placeholder (name, "");

		unregister_allocation (yyvsp[-1].list);
		unregister_allocation (yyvsp[-3].tree); expr_tree_unref (yyvsp[-3].tree);

		if (f == NULL) {
			expr_list_unref (yyvsp[-1].list);
			YYERROR;
		} else {
			yyval.tree = register_expr_allocation (expr_tree_new_funcall (f, yyvsp[-1].list));
		}
	}
    break;

  case 28:
#line 450 "parser.y"
    {
		NamedExpression *expr_name;
		char *name = yyvsp[0].tree->constant.value->v_str.val->str;
		ParsePos pos = *state->pos;

		pos.sheet = yyvsp[-1].sheet;
		expr_name = expr_name_lookup (&pos, name);
		if (expr_name == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_EXPRESSION,
				g_strdup_printf (_("Name '%s' does not exist in sheet '%s'"),
						name, yyvsp[-1].sheet->name_quoted),
				state->expr_text - state->expr_backup + 1, strlen (name));

			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
			return retval;
		} else
			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
	        yyval.tree = register_expr_allocation (expr_tree_new_name (expr_name, yyvsp[-1].sheet, NULL));
	}
    break;

  case 29:
#line 470 "parser.y"
    {
		NamedExpression *expr_name;
		char *name = yyvsp[0].tree->constant.value->v_str.val->str;
		char *wb_name = yyvsp[-2].tree->constant.value->v_str.val->str;
		ParsePos pos = *state->pos;

		pos.sheet = NULL;
		pos.wb = application_workbook_get_by_name (wb_name);

		if (pos.wb == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_EXPRESSION,
				g_strdup_printf (_("Unknown workbook '%s'"), wb_name), 
				state->expr_text - state->expr_backup + 1, strlen (name));

			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
			unregister_allocation (yyvsp[-2].tree); expr_tree_unref (yyvsp[-2].tree);
			return retval;
		}

		expr_name = expr_name_lookup (&pos, name);
		if (expr_name == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_EXPRESSION,
				g_strdup_printf (_("Name '%s' does not exist in workbook '%s'"),
						name, wb_name),
				state->expr_text - state->expr_backup + 1, strlen (name));

			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
			unregister_allocation (yyvsp[-2].tree); expr_tree_unref (yyvsp[-2].tree);
			return retval;
		} else {
			unregister_allocation (yyvsp[0].tree); expr_tree_unref (yyvsp[0].tree);
			unregister_allocation (yyvsp[-2].tree); expr_tree_unref (yyvsp[-2].tree);
		}
	        yyval.tree = register_expr_allocation (expr_tree_new_name (expr_name, NULL, pos.wb));
	}
    break;

  case 32:
#line 513 "parser.y"
    {
	        char  *name = yyvsp[-1].tree->constant.value->v_str.val->str;
		Sheet *sheet = workbook_sheet_by_name (state->pos->wb, name);
		if (sheet == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_SHEET,
				g_strdup_printf (_("Unknown sheet '%s'"), name),
				state->expr_text - state->expr_backup, strlen (name));

			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
			return retval;
		} else
			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
	        yyval.sheet = sheet;
	}
    break;

  case 33:
#line 529 "parser.y"
    {
		Workbook * wb =
		    application_workbook_get_by_name (yyvsp[-3].tree->constant.value->v_str.val->str);
		Sheet *sheet = NULL;
		char *sheetname = yyvsp[-1].tree->constant.value->v_str.val->str;

		if (wb != NULL)
			sheet = workbook_sheet_by_name (wb, sheetname);

		unregister_allocation (yyvsp[-3].tree); expr_tree_unref (yyvsp[-3].tree);
		if (sheet == NULL) {
			int retval = gnumeric_parse_error (
				state, PERR_UNKNOWN_SHEET,
				g_strdup_printf (_("Unknown sheet '%s'"), sheetname),
				state->expr_text - state->expr_backup, strlen (sheetname));

			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);
			return retval;
		} else
			unregister_allocation (yyvsp[-1].tree); expr_tree_unref (yyvsp[-1].tree);

	        yyval.sheet = sheet;
        }
    break;

  case 35:
#line 555 "parser.y"
    { yyval.sheet = NULL; }
    break;

  case 36:
#line 558 "parser.y"
    {
		if (state->force_explicit_sheet_references &&
		    force_explicit_sheet_references (state, &yyvsp[0].tree->var.ref)) {
			unregister_allocation (yyvsp[0].tree);
			expr_tree_unref (yyvsp[0].tree);
			return ERROR;
		}
	        yyval.tree = yyvsp[0].tree;
	}
    break;

  case 37:
#line 568 "parser.y"
    {
		yyvsp[0].tree->var.ref.sheet = yyvsp[-1].sheet;
	        yyval.tree = yyvsp[0].tree;
	}
    break;

  case 38:
#line 573 "parser.y"
    {
		unregister_allocation (yyvsp[0].tree);
		unregister_allocation (yyvsp[-2].tree);

		if (state->force_explicit_sheet_references &&
		    (force_explicit_sheet_references (state, &yyvsp[-2].tree->var.ref) ||
		     force_explicit_sheet_references (state, &yyvsp[0].tree->var.ref))) {
			expr_tree_unref (yyvsp[0].tree);
			expr_tree_unref (yyvsp[-2].tree);
			return ERROR;
		}

		yyval.tree = register_expr_allocation
			(expr_tree_new_constant
			 (value_new_cellrange (&(yyvsp[-2].tree->var.ref), &(yyvsp[0].tree->var.ref),
					       state->pos->eval.col, state->pos->eval.row)));
		expr_tree_unref (yyvsp[0].tree);
		expr_tree_unref (yyvsp[-2].tree);
	}
    break;

  case 39:
#line 593 "parser.y"
    {
		unregister_allocation (yyvsp[0].tree);
		unregister_allocation (yyvsp[-3].tree);
		yyvsp[-3].tree->var.ref.sheet = yyvsp[-4].sheet;
		yyvsp[0].tree->var.ref.sheet = yyvsp[-1].sheet ? yyvsp[-1].sheet : yyvsp[-4].sheet;
		yyval.tree = register_expr_allocation
			(expr_tree_new_constant
			 (value_new_cellrange (&(yyvsp[-3].tree->var.ref), &(yyvsp[0].tree->var.ref),
					       state->pos->eval.col, state->pos->eval.row)));

		expr_tree_unref (yyvsp[0].tree);
		expr_tree_unref (yyvsp[-3].tree);
	}
    break;

  case 40:
#line 608 "parser.y"
    {
		unregister_allocation (yyvsp[0].tree);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].tree);
		register_expr_list_allocation (yyval.list);
        }
    break;

  case 41:
#line 613 "parser.y"
    {
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].tree);
		yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].tree);
		register_expr_list_allocation (yyval.list);
	}
    break;

  case 42:
#line 619 "parser.y"
    {
		GSList *tmp = yyvsp[0].list;
		unregister_allocation (yyvsp[0].list);

		if (tmp == NULL)
			tmp = g_slist_prepend (NULL, expr_tree_new_constant (value_new_empty ()));

		yyval.list = g_slist_prepend (tmp, expr_tree_new_constant (value_new_empty ()));
		register_expr_list_allocation (yyval.list);
	}
    break;

  case 43:
#line 629 "parser.y"
    { yyval.list = NULL; }
    break;

  case 44:
#line 632 "parser.y"
    { yyval.tree = yyvsp[0].tree; }
    break;

  case 45:
#line 633 "parser.y"
    { parse_string_as_value (yyvsp[0].tree); yyval.tree = yyvsp[0].tree; }
    break;

  case 46:
#line 636 "parser.y"
    {
		unregister_allocation (yyvsp[0].tree);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].tree);
		register_expr_list_allocation (yyval.list);
        }
    break;

  case 47:
#line 641 "parser.y"
    {
		if (state->array_col_separator == ',') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].tree);
			yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].tree);
			register_expr_list_allocation (yyval.list);
		} else {
			return gnumeric_parse_error (
				state, PERR_INVALID_ARRAY_SEPARATOR,
				g_strdup_printf (_("The character %c cannot be used to separate array elements"),
				state->array_col_separator), state->expr_text - state->expr_backup + 1, 1);
		}
	}
    break;

  case 48:
#line 654 "parser.y"
    {
		if (state->array_col_separator == '\\') {
			unregister_allocation (yyvsp[0].list);
			unregister_allocation (yyvsp[-2].tree);
			yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].tree);
			register_expr_list_allocation (yyval.list);
		} else {
			/* FIXME: Is this the right error to display? */
			return gnumeric_parse_error (
				state, PERR_INVALID_ARRAY_SEPARATOR,
				g_strdup_printf (_("The character %c cannot be used to separate array elements"),
				state->array_col_separator), state->expr_text - state->expr_backup + 1, 1);
		}
	}
    break;

  case 49:
#line 668 "parser.y"
    { yyval.list = NULL; }
    break;

  case 50:
#line 671 "parser.y"
    {
		unregister_allocation (yyvsp[0].list);
		yyval.list = g_slist_prepend (NULL, yyvsp[0].list);
		register_expr_list_list_allocation (yyval.list);
        }
    break;

  case 51:
#line 676 "parser.y"
    {
		unregister_allocation (yyvsp[0].list);
		unregister_allocation (yyvsp[-2].list);
		yyval.list = g_slist_prepend (yyvsp[0].list, yyvsp[-2].list);
		register_expr_list_list_allocation (yyval.list);
	}
    break;


    }

/* Line 999 of yacc.c.  */
#line 1907 "parser.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 683 "parser.y"

/**
 * parse_ref_or_string :
 * @string: the string to try.
 *
 * Attempt to parse the text as a cellref, if it fails
 * return a string.
 * DO NOT attempt to do higher level lookups here.
 *     - sheet names
 *     - function names
 *     - expression names
 *     - value parsing
 * must all be handled by the parser not the lexer.
 */
static int
parse_ref_or_string (char const *string)
{
	CellRef   ref;
	Value *v = NULL;
	char const * res;

	res = cellref_get (&ref, string, &state->pos->eval);
	if (res != NULL && *res == '\0') {
		if (state->force_absolute_col_references &&
		    ref.col_relative) {
			ref.col += state->pos->eval.col;
			ref.col_relative = FALSE;
		}
		if (state->force_absolute_row_references &&
		    ref.row_relative) {
			ref.row += state->pos->eval.row;
			ref.row_relative = FALSE;
		}
		yylval.tree = register_expr_allocation (expr_tree_new_var (&ref));
		return CELLREF;
	}

	v = value_new_string (string);
	yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
	return STRING;
}

/**
 * find_char:
 * @str:
 * @c:
 *
 * Returns a pointer to character c in str.
 * Callers should check whether p is '\0'!
 **/
static char const *
find_char (char const *str, char c)
{
	for (; *str && *str != c; str++)
		if (*str == '\\' && str[1])
			str++;
	return str;
}

static char const *
find_matching_close (char const *str, char const **res)
{
	for (; *str; str++) {
		if (*str == '(') {
			char const *tmp = str;
			str = find_matching_close (str + 1, res);
			if (*str != ')' && *res == NULL) {
				*res = tmp;
				return str;
			}
		} else if (*str == ')')
			return str;
		else if (*str == '\'' || *str == '\"')
			str = find_char (str + 1, *str);
	}

	return str;
}

int
yylex (void)
{
	int c;
	char const *start;
	gboolean is_number = FALSE;

        while (isspace ((unsigned char)*state->expr_text))
                state->expr_text++;

	start = state->expr_text;
	c = (unsigned char) (*state->expr_text++);

	if (c == '(' || c == ')')
		return c;

	if (state->use_excel_reference_conventions) {
		if (c == ':')
			return RANGE_SEP;
		if (c == '!')
			return SHEET_SEP;
	} else {
		/* Treat '..' as range sep (A1..C3) */
		if (c == '.' && *state->expr_text == '.') {
			state->expr_text++;
			return RANGE_SEP;
		}
		if (c == ':')
			return SHEET_SEP;
	}

	if (c == state->separator)
		return SEPARATOR;

	if (c == state->decimal_point) {
		/* Could be a number or a stand alone  */
		if (!isdigit ((unsigned char)(*state->expr_text)))
			return c;
		is_number = TRUE;
	} else if (isdigit (c)) {
		while (isdigit ((c = (unsigned char)(*state->expr_text++))))
			;
		is_number = TRUE;
	}

	if (is_number) {
		Value *v = NULL;

		if (c == state->decimal_point || tolower (c) == 'e') {
			/* This is float */
			char *end;
			double d;

			errno = 0;
			d = strtod (start, &end);
			if (start == end) {
				g_warning ("%s is not a double, but was expected to be one", start);
			}  else if (errno != ERANGE) {
				v = value_new_float ((gnum_float)d);
				state->expr_text = end;
			} else if (tolower (c) != 'e') {
				gnumeric_parse_error (
					state, PERR_OUT_OF_RANGE,
					g_strdup (_("The number is out of range")),
					state->expr_text - state->expr_backup, end - start);
				return INVALID_TOKEN;
			} else {
				/* For an exponent it's hard to highlight the
				 * right region w/o it turning into an ugly
				 * hack, for now the cursor is put at the end.
				 */
				gnumeric_parse_error (
					state, PERR_OUT_OF_RANGE,
					g_strdup (_("The number is out of range")),
					0, 0);
				return INVALID_TOKEN;
			}
		} else {
			/* This could be a row range ref or an integer */
			char *end;
			long l;

			errno = 0;
			l = strtol (start, &end, 10);
			if (start == end) {
				g_warning ("%s is not an integer, but was expected to be one", start);
			} else if (errno != ERANGE) {
				/* Check for a Row range ref (3:4 == A3:IV4) */
				if (*end == ':' && l < SHEET_MAX_COLS) {
				    /* TODO : adjust parser to allow returning
				     * a range, not just a cellref
				     */
				}
				v = value_new_int (l);
				state->expr_text = end;
			} else if (l == LONG_MIN || l == LONG_MAX) {
				double d;

				errno = 0;
				d = strtod (start, &end);
				if (errno != ERANGE) {
					v = value_new_float ((gnum_float)d);
					state->expr_text = end;
				} else {
					gnumeric_parse_error (
						state, PERR_OUT_OF_RANGE,
						g_strdup (_("The number is out of range")),
						state->expr_text - state->expr_backup, end - start);
					return INVALID_TOKEN;
				}
			}
		}

		/* Very odd string,  Could be a bound problem.  Trigger an error */
		if (v == NULL)
			return c;

		yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
		return CONSTANT;
	}

	switch (c){
	case '\'':
	case '"': {
		char const *p;
		char *string, *s;
		char quotes_end = c;
		Value *v;

 		p = state->expr_text;
 		state->expr_text = find_char (state->expr_text, quotes_end);
		if (!*state->expr_text) {
  			gnumeric_parse_error (
  				state, PERR_MISSING_CLOSING_QUOTE,
				g_strdup (_("Could not find matching closing quote")),
  				(p - state->expr_backup) + 1, 1);
			return INVALID_TOKEN;
		}

		s = string = (char *) alloca (1 + state->expr_text - p);
		while (p != state->expr_text){
			if (*p== '\\'){
				p++;
				*s++ = *p++;
			} else
				*s++ = *p++;
		}
		*s = 0;
		state->expr_text++;

		v = value_new_string (string);
		yylval.tree = register_expr_allocation (expr_tree_new_constant (v));
		return QUOTED_STRING;
	}
	}

	if (isalpha ((unsigned char)c) || c == '_' || c == '$'){
		char const *start = state->expr_text - 1;
		char *str;
		int  len;

		while (isalnum ((unsigned char)*state->expr_text) || *state->expr_text == '_' ||
		       *state->expr_text == '$' ||
		       (state->use_excel_reference_conventions && *state->expr_text == '.'))
			state->expr_text++;

		len = state->expr_text - start;
		str = alloca (len + 1);
		strncpy (str, start, len);
		str [len] = 0;
		return parse_ref_or_string (str);
	}

	if (c == '\n' || c == 0)
		return 0;

	if (c == '<'){
		if (*state->expr_text == '='){
			state->expr_text++;
			return LTE;
		}
		if (*state->expr_text == '>'){
			state->expr_text++;
			return NE;
		}
		return c;
	}

	if (c == '>'){
		if (*state->expr_text == '='){
			state->expr_text++;
			return GTE;
		}
		return c;
	}

	return c;
}

int
yyerror (char *s)
{
#if 0
	printf ("Error: %s\n", s);
#endif
	return 0;
}

/**
 * expr_parse_str:
 *
 * @expr_text   : The string to parse.
 * @flags       : See parse-utils for descriptions
 * @desired_fmt : optionally NULL ptr to the best format for result
 * @error       : optionally NULL ptr to store details of error.
 *
 * Parse a string. if @error is non-null it will be assumed that the
 * caller has passed a pointer to a ParseError struct AND that it will
 * take responsibility for freeing that struct and it's contents.
 * with parse_error_free.
 **/
ExprTree *
expr_parse_str (char const *expr_text, ParsePos const *pos,
		GnmExprParserFlags flags,
		StyleFormat **desired_fmt,
	        ParseError *error)
{
	ExprTree *expr;
	ParserState pstate;

	g_return_val_if_fail (expr_text != NULL, NULL);

	pstate.expr_text   = expr_text;
	pstate.expr_backup = expr_text;
	pstate.pos	   = pos;

	pstate.decimal_point	   = format_get_decimal ();
	pstate.separator 	   = format_get_arg_sep ();
	pstate.array_col_separator = format_get_col_sep ();

	pstate.use_excel_reference_conventions	   	= !(flags & GNM_PARSER_USE_APPLIX_REFERENCE_CONVENTIONS);
	pstate.create_placeholder_for_unknown_func	= flags & GNM_PARSER_CREATE_PLACEHOLDER_FOR_UNKNOWN_FUNC;
	pstate.force_absolute_col_references		= flags & GNM_PARSER_FORCE_ABSOLUTE_COL_REFERENCES;
	pstate.force_absolute_row_references		= flags & GNM_PARSER_FORCE_ABSOLUTE_ROW_REFERENCES;
	pstate.force_explicit_sheet_references		= flags & GNM_PARSER_FORCE_EXPLICIT_SHEET_REFERENCES;

	pstate.result = NULL;
	pstate.desired_fmt = desired_fmt;
	if (pstate.desired_fmt)
		*pstate.desired_fmt = NULL;

	pstate.error = error;
	
	if (deallocate_stack == NULL)
		deallocate_init ();

	g_return_val_if_fail (pstate.pos != NULL, NULL);
	g_return_val_if_fail (pstate.expr_text != NULL, NULL);
	g_return_val_if_fail (state == NULL, NULL);

	state = &pstate;
	yyparse ();
	state = NULL;

	if (pstate.result != NULL) {
		deallocate_assert_empty ();

#if 0
		/* If this happens, something is very wrong */
		if (pstate.error != NULL && pstate.error->message != NULL) {
			g_warning ("An error occurred and the ExprTree is non-null! This should not happen");
			g_warning ("Error message is %s (%d, %d)", pstate.error->message, pstate.error->begin_char,
					pstate.error->end_char);
		}
#endif

		if (desired_fmt != NULL) {
			StyleFormat *format;
			EvalPos tmp;

			tmp.sheet = pos->sheet;
			tmp.eval = pos->eval;
			format = auto_style_format_suggest (pstate.result->data, &tmp);
			if (format != NULL) {
				/* Override the format that came from a
				 * constant somewhere inside.
				 */
				if (*desired_fmt != NULL)
					style_format_unref (*desired_fmt);
				*desired_fmt = format;
			}
		}

		/* Do we have multiple expressions */
		if (pstate.result->next != NULL) {
			if (flags & GNM_PARSER_PERMIT_MULTIPLE_EXPRESSIONS)
				expr = expr_tree_new_set (g_slist_reverse (pstate.result));
			else {
				expr_list_unref (pstate.result);
				gnumeric_parse_error (&pstate, PERR_MULTIPLE_EXPRESSIONS,
					g_strdup (_("Multiple expressions are not supported in this context")),
					(pstate.expr_text - pstate.expr_backup) + 1,
					(pstate.expr_text - pstate.expr_backup));
				expr = NULL;
			}
		} else {
			/* Free the list, do not unref the content */
			expr = pstate.result->data;
			expr_list_free (pstate.result);
		}
	} else {
		/* If there is no error message, attempt to be more detailed */
		if (pstate.error != NULL && pstate.error->message == NULL) {
			char const *last_token = pstate.expr_text - 1;

			if (*last_token == '\0') {
				char const *str = pstate.expr_backup;
				char const *res = NULL;
				char const *last = find_matching_close (str, &res);

				if (*last)
					gnumeric_parse_error (&pstate, PERR_MISSING_PAREN_OPEN,
						g_strdup (_("Could not find matching opening parenthesis")),
						(last - str) + 2, 1);
				else if (res != NULL)
					gnumeric_parse_error (&pstate, PERR_MISSING_PAREN_CLOSE,
						g_strdup (_("Could not find matching closing parenthesis")),
						(res - str) + 2, 1);
				else
					gnumeric_parse_error (&pstate, PERR_INVALID_EXPRESSION,
						g_strdup (_("Invalid expression")),
						(pstate.expr_text - pstate.expr_backup) + 1,
						(pstate.expr_text - pstate.expr_backup));
			} else
				gnumeric_parse_error (&pstate, PERR_UNEXPECTED_TOKEN,
					g_strdup_printf (_("Unexpected token %c"), *last_token),
					(last_token - pstate.expr_backup) + 1, 1);
		}

		deallocate_all ();
		if (desired_fmt != NULL && *desired_fmt != NULL) {
			style_format_unref (*desired_fmt);
			*desired_fmt = NULL;
		}

		expr = NULL;
	}

	deallocate_uninit ();

	return expr;
}


