/********************************************************************\
 * gnc-helpers.h -- gnucash g-wrap helper functions                 *
 * Copyright (C) 2000 Linas Vepstas                                 *
 *                                                                  *
 * This program is free software; you can redistribute it and/or    *
 * modify it under the terms of the GNU General Public License as   *
 * published by the Free Software Foundation; either version 2 of   *
 * the License, or (at your option) any later version.              *
 *                                                                  *
 * This program is distributed in the hope that it will be useful,  *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of   *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the    *
 * GNU General Public License for more details.                     *
 *                                                                  *
 * You should have received a copy of the GNU General Public License*
 * along with this program; if not, contact:                        *
 *                                                                  *
 * Free Software Foundation           Voice:  +1-617-542-5942       *
 * 59 Temple Place - Suite 330        Fax:    +1-617-542-2652       *
 * Boston, MA  02111-1307,  USA       gnu@gnu.org                   *
 *                                                                  *
\********************************************************************/

#ifndef __GNC_HELPERS__
#define __GNC_HELPERS__

#include <guile/gh.h>
#include <glib.h>

#include "gnc-common.h"
#include "gnc-commodity.h"
#include "gnc-ui-util.h"
#include "Transaction.h"
#include "GNCId.h"
#include "Query.h"

SCM gnc_glist_to_scm_list(GList *glist, SCM wct);
GList* gnc_scm_list_to_glist(SCM wcp_list);

SCM gnc_glist_scm_map(SCM wct, SCM thunk, GList *glist);
void gnc_glist_scm_for_each(SCM wct, SCM thunk, GList *glist);

int  gnc_guid_type(GUID guid);

GUID      gnc_account_get_guid(Account *account);
Account * gnc_account_lookup(GUID guid);

GUID          gnc_trans_get_guid(Transaction *trans);
Transaction * gnc_trans_lookup(GUID guid);

GUID    gnc_split_get_guid(Split *split);
Split * gnc_split_lookup(GUID guid);

int gnc_trans_is_common_currency(Transaction *trans, gnc_commodity * currency);

Timespec gnc_transaction_get_date_posted(Transaction *t);
Timespec gnc_transaction_get_date_entered(Transaction *t);

Timespec gnc_split_get_date_reconciled(Split *s);

void gnc_transaction_set_date_posted(Transaction *t, const Timespec d);
void gnc_transaction_set_date_entered(Transaction *t, const Timespec d);

void gnc_transaction_set_date(Transaction *t, Timespec ts);

char * gnc_gettext_helper(const char *string);


/* Helpers for various types */

SCM      gnc_timespec2timepair(Timespec t);
Timespec gnc_timepair2timespec(SCM x);
int      gnc_timepair_p(SCM x);

SCM  gnc_guid2scm(GUID guid);
GUID gnc_scm2guid(SCM guid_scm);
int  gnc_guid_p(SCM guid_scm);

/* These two functions convert a query object into a scheme
 * representation of the query and vice-versa. They do not
 * simply convert a query pointer to a g-wrapped query pointer! */
SCM gnc_query2scm (Query *q);
Query * gnc_scm2query (SCM query_scm);

SCM  gnc_printinfo2scm(GNCPrintAmountInfo info);
GNCPrintAmountInfo gnc_scm2printinfo(SCM info_scm);
int  gnc_printinfo_p(SCM info_scm);

/* See Group.h for info about traversals. */

gboolean gnc_scmGroupStagedTransactionTraversal(AccountGroup *grp,
                                                unsigned int stage,
                                                SCM thunk);

gboolean gnc_scmAccountStagedTransactionTraversal(Account *a,
                                                  unsigned int stage,
                                                  SCM thunk);

SCM gnc_gint64_to_scm(const gint64 x);
gint64 gnc_scm_to_gint64(SCM num);
int gnc_gh_gint64_p(SCM num);

SCM gnc_numeric_to_scm(gnc_numeric arg);
gnc_numeric gnc_scm_to_numeric(SCM arg);
int gnc_numeric_p(SCM arg);

/* utilities for type conversions */

#endif
