/* braille.h
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _BRAILLE_H
#define _BRAILLE_H

#define MAXBRCELL	256
#define MAXBRDISP	8

typedef enum {bec_raw_byte, bec_key_bits, bec_key_codes, bec_switch_pad, bec_sensor} BRAILLE_EVENT_CODE;
typedef enum {st_unknown, st_optical, st_mechanical} SENSOR_TECHNOLOGY;
typedef enum {bdt_undefined, bdt_main, bdt_status, bdt_aux_horizontal, bdt_aux_vertical} BRL_DISP_TYPE;

typedef union
{
	unsigned char	RawByte;
	unsigned long	KeyBits;    		/* fired every time one of the key changed status */
	char*					KeyCodes;				/* fired only when all keys are released */
	
	struct
	{
		unsigned long			SwitchBits;
		char*							SwitchCodes;
	} SwitchPad;
	
	struct
	{		
		short 											Bank;
		short 											Value;
		short 											AssociatedDisplay;
		SENSOR_TECHNOLOGY						Technology;		
		char* 											SensorCodes;
	} Sensor;
	
	
	/* !!! TBI !!! MORE	IF NEEDED !!! */

} BRAILLE_EVENT_DATA;

typedef void (*BRL_DEV_CALLBACK) (BRAILLE_EVENT_CODE Code, BRAILLE_EVENT_DATA *Data);

typedef struct
{
	short 							StartCell;
	short 							Width;	
	BRL_DISP_TYPE 			Type;		
}  BRL_DISPLAY;

typedef void (*BRL_DEV_CLOSE_DEVICE_PROC) ();
typedef int (*BRL_DEV_SEND_DOTS_PROC) (unsigned char *Dots, short Length, short Blocking);

typedef enum {bit_bits, bit_make_break_codes, bit_make_codes} BRL_INPUT_TYPE ;

typedef struct
{
	short							CellCount;
	short							DisplayCount;
	BRL_DISPLAY				Displays[MAXBRDISP];
	BRL_INPUT_TYPE		InputType;	
	short 						KeyCount;		
	short							SwitchCount;
	short							SensorBankCount;

	/* ... !!! MORE !!! */
	BRL_DEV_CLOSE_DEVICE_PROC			close_device;
	BRL_DEV_SEND_DOTS_PROC				send_dots;		
	
} BRL_DEVICE;

/* typedef int (*BRL_DEV_OPEN_DEVICE_PROC) (char* DeviceName, short Port,  BRL_DEVICE *Device, BRL_DEV_CALLBACK DeviceCallback); */

typedef struct
{
	unsigned long		Attribute;
	unsigned char		Mask;
	unsigned char 	Dots;
} ATTR_MAPPING;
		
typedef void (*BRAILLE_EVENT_PROC) (BRAILLE_EVENT_CODE EventCode, BRAILLE_EVENT_DATA *EventData);

/* *** API Functions *** */

void brl_init();
void brl_terminate();

/* int brl_load_translation_table (char *FileName); */
/* int brl_text_to_braille (char *Text, unsigned char *Dots, short MaxLen); */
/* int bra_map_attribute_to_dots */

/* unsigned char brl_get_cursor_shape(); */
/* void brl_set_cursor_shape(unsigned char NewShape); */

/* unsigned char brl_get_cursor_mask(); */
/* void brl_set_cursor_mask (unsigned char NewMask); */

/* short brl_get_braille_style (); */
/* void brl_set_braille_style (short NewStyle); */

/* short brl_get_attr_style (); */
/* void brl_set_attr_style (short NewStyle); */

/* int brl_get_text */
/* int brl_set_text (short Display, short Offset, char *Text, short Length); */
/* int bla_get_attr */
/* int brl_set_attr (short Display, short Offset, unsigned long *Attr, short Length); */
/* int brl_get_cursor_pos &Display, &Position */
/* int brl_set_cursor_pos (short Display, short Position); */

/* void brl_clear(); */
/* void brl_update (); */

/* int brl_get_dots */
/* void brl_clear_displays (); */

/* DEVICE LEVEL */

int  brl_open_device  (char* DeviceName, int Port, BRAILLE_EVENT_PROC BrailleEventProc);	
int  brl_get_device   (BRL_DEVICE *Device);
void brl_close_device ();

void  brl_clear_all();
void  brl_clear_display (short Display);
void  brl_set_dots (short Display, short StartCell, unsigned char *newDots, short CellCount, short Offset, short CursorPosition);
void  brl_update_dots (short Blocking);
short brl_get_disp_id (char* Role, short No);

/* LOWEST LEVEL */

int brl_send_raw_data (unsigned char *Bytes, int Count, short Blocking);



/* !!! TBI !!! monitor window support */

#endif
