// $Id: options.cc,v 1.28 2001/02/10 12:39:23 cactus Exp $
/*
  Gnomoku Copyright (C) 1998-1999 NAGY Andrs <nagya@telnet.hu>
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License version 2
  (included in the RadioActive distribution in doc/GPL) as published by
  the Free Software Foundation.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include "config.h"

#include "options.h"
#include <vector>

using namespace Gtk;
using namespace Gnome;

// OPTIONS
Options::Options(op_t &optype_, string &v1_, string &v2_, bool &beep_):
    e4(_("Beep on your turn")),
    
    optype(optype_),
    v1(v1_),
    v2(v2_),
    beep(beep_)
{
    set_title(_("Options"));
    set_border_width(10);
    set_policy(false, false, false);
    set_wmclass("options", "Gnomoku");
    set_position(GTK_WIN_POS_MOUSE);
    show.connect(slot(this, &Options::update));
    
    // Labels
    Label* l1 = manage(new Label(_("Opponent type")));
    l1->set_alignment(0, .5);

    Label* l2 = manage(new Label(_("Host name")));
    l2->set_alignment(0, .5);

    Label* l3 = manage(new Label(_("Port number")));
    l3->set_alignment(0, .5);
    
    // Text entries
    e2.set_max_length(40);
    e3.set_max_length(5);

    // Dropdown list
    Menu* menu = manage(new Menu);
    MenuItem* item;
    item = manage(new MenuItem(_("Computer AI")));
    item->activate.connect(bind(slot(this, &Options::op_change),
				OP_AI));
    menu->append(*item);
    
    item = manage(new MenuItem(_("Net, I'm the client")));
    item->activate.connect(bind(slot(this, &Options::op_change),
				OP_CLIENT));
    menu->append(*item);
    
    item = manage(new MenuItem(_("Net, I'm the server")));
    item->activate.connect(bind(slot(this, &Options::op_change),
				OP_SERVER));
    menu->append(*item);

    menu->show_all();
    combo.set_menu(*menu);
    
    Table* table = new Table(4, 3, false);
    table->set_row_spacings(10);
    table->set_col_spacings(10);
    table->attach(*l1, 0, 1, 0, 1);
    table->attach(combo, 1, 2, 0, 1);
    table->attach(*l2, 0, 1, 1, 2);
    table->attach(e2, 1, 2, 1, 2);
    table->attach(*l3, 0, 1, 2, 3);
    table->attach(e3, 1, 2, 2, 3);
    table->attach(e4, 1, 2, 3, 4);

    // Buttons
    append_button (_("OK"),     GNOME_STOCK_BUTTON_OK);
    append_button (_("Cancel"), GNOME_STOCK_BUTTON_CANCEL);
    set_default(0);
    set_close(true);
    clicked.connect(slot(this, &Options::button_clicked));    

    get_vbox()->add(*table);
    show_all();
}

void Options::update()
{
    switch (optype)
    {
    case OP_AI:
	combo.set_history(0);
	break;
    case OP_CLIENT:
	combo.set_history(1);
	break;
    case OP_SERVER:
	combo.set_history(2);
	break;
    }
    
    e2.set_text(v1);
    e3.set_text(v2);
    e4.set_active(beep);
}

void Options::button_clicked(int button)
{
    if (button == 0)
    {
	optype = optype_cache;
	v1 = e2.get_text();
	v2 = e3.get_text();
	beep = e4.get_active();
	changed();
    }
}

void Options::op_change(op_t op)
{
    optype_cache = op;
}

gint Options::delete_event_impl(GdkEventAny *)
{
    hide();
    return false;
}
