// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGNOMEVFSMM_MIME_APPLICATION_H
#define _LIBGNOMEVFSMM_MIME_APPLICATION_H

#include <glibmm.h>

/* Copyright 2003 gnome-vfsmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgnomevfs/gnome-vfs-mime-handlers.h>
#include <libgnomevfs/gnome-vfs-application-registry.h>

#include <libgnomevfsmm/enums.h>
#include <libgnomevfsmm/exception.h>


namespace Gnome
{

namespace Vfs
{

typedef Glib::ListHandle<Glib::ustring> ListHandleStrings;

//TODO: What is a MimeApplication? How can I get one. What could I do with one.
//TODO: Consider adding operator bool() to detect invalid instances.
class MimeApplication
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef MimeApplication CppObjectType;
  typedef GnomeVFSMimeApplication BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  MimeApplication();

  // Use make_a_copy=true when getting it directly from a struct.
  explicit MimeApplication(GnomeVFSMimeApplication* castitem, bool make_a_copy = false);

  MimeApplication(const MimeApplication& src);
  MimeApplication& operator=(const MimeApplication& src);

  ~MimeApplication();

  GnomeVFSMimeApplication*       gobj()       { return gobject_; }
  const GnomeVFSMimeApplication* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  GnomeVFSMimeApplication* gobj_copy() const;

protected:
  GnomeVFSMimeApplication* gobject_;

private:


public:
  MimeApplication(const Glib::ustring& id);

  MimeApplication(const Glib::ustring& id, const Glib::ustring& name,
      const Glib::ustring& command, MimeApplicationArgumentType argument_type, 
      ListHandleStrings supported_uri_schemes, bool multiple_files, bool requires_terminal);

  //Test whether this is a valid instance.
  operator bool() const;

  /** Get the id of this applicaiton.
   * @return A string containing this application's id.
   */
  Glib::ustring get_id() const;
  
  /** Get the name of this application.
   * @return A string containing this application's name.
   */
  Glib::ustring get_name() const;
  
  /** Get the command for this application.
   * @return A string containing this application's command.
   */
  Glib::ustring get_command() const;
  
  /** Get the argument type for this application.
   * @return An enum representing this application's argument type.
   */
  MimeApplicationArgumentType get_argument_type() const;
  
  /** Get a list of this application's supported uri schemes.
   * @return A list of strings containing the uri schemes.
   */
  Glib::ListHandle<Glib::ustring> get_supported_uri_schemes() const;
  
  /** Test to see if this application can open multiple files.
   * @return <tt>true</tt> if this application has this ability; <tt>false</tt> otherwise.
   */
  bool can_open_multiple_files() const;
  
  /** Test to see if this application requires the terminal.
   * @return <tt>true</tt> if this application needs the terminal; <tt>false</tt> otherwise.
   */
  bool requires_terminal() const;

  //TODO: These don't seem to use g_strdup(), but they should.
  void set_id(const Glib::ustring& value);
  void set_name(const Glib::ustring& value);
  void set_command(const Glib::ustring& value);
  void set_argument_type(const MimeApplicationArgumentType& value);
  void set_supported_uri_schemes(const Glib::ListHandle<Glib::ustring>& value);

  void set_open_multiple_files(bool value = true);
  void set_requires_terminal(bool value = true);

  /*
   * Application Registry convenience functions
   */
  
  /** Checks whether this application is owned or not.
   * By user owned, this means that the application is not a system application located in the prerequisite /usr area, but rather in the user's area.
   * @param application C++ doesn't use this :).
   * @return <tt>true</tt> if this application is user owned, otherwise <tt>false</tt>.
   */
  bool is_user_owned();
  
  bool exists_in_registry();
  void remove_from_registry();
  
  /** This will save to the registry the application that will be associated with
   * a defined mime type.  The defined mime type is located within the
   * GnomeVFSMimeApplication structure.  Changes are not realized until the
   * gnome_vfs_application_registry_sync function is called.
   * @param application Application associated with the mime type.
   */
  void save_to_registry();
  
  ListHandleStrings get_keys();
  
  ListHandleStrings get_mime_types();
  void clear_mime_types();

  bool supports_mime_type(const Glib::ustring& mime_type);
  bool supports_uri_scheme(const Glib::ustring& uri_scheme);
  
  Glib::ustring get_value(const Glib::ustring& key);
  bool get_value(const Glib::ustring& key, bool& got_key);
  
  void set_value(const Glib::ustring& key, const Glib::ustring& value);
  void set_value(const Glib::ustring& key, bool value);
  void unset_key(const Glib::ustring& key);
  
  void add_mime_type(const Glib::ustring& mime_type);
  void remove_mime_type(const Glib::ustring& mime_type);

  /*
   * Mime Database convenience functions
   */
  void set_default(const Glib::ustring& mime_type) throw(exception);
  void add_to_short_list(const Glib::ustring& mime_type) throw(exception);
  void remove_from_short_list(const Glib::ustring& mime_type) throw(exception);

  //TODO: launch().


};

} // namespace Vfs
} // namespace Gnome


namespace Glib
{

  /** @relates Gnome::Vfs::MimeApplication
   * @param object The C instance
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   */
Gnome::Vfs::MimeApplication wrap(GnomeVFSMimeApplication* object, bool take_copy = false);

} // namespace Glib

#endif /* _LIBGNOMEVFSMM_MIME_APPLICATION_H */

