/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gnome-vfs-init.c - Initialization for the GNOME Virtual File System.

   Copyright (C) 1999 Free Software Foundation

   The Gnome Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Author: Ettore Perazzoli <ettore@gnu.org>
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gnome-vfs.h"
#include "gnome-vfs-backend.h"
#include "gnome-vfs-private.h"


static gboolean vfs_already_initialized = FALSE;
G_LOCK_DEFINE_STATIC (vfs_already_initialized);

gboolean gnome_vfs_init(void)
{
	gboolean retval;

	G_LOCK (vfs_already_initialized);

	if (! vfs_already_initialized) {
		retval = gnome_vfs_method_init ();
		if (retval)
			retval = gnome_vfs_process_init ();
		if (retval)
			retval = gnome_vfs_configuration_init ();
		if (retval) {
			gnome_vfs_backend_loadinit(NULL, NULL);
			retval = gnome_vfs_backend_init (TRUE);
		}
		if (retval)
			signal (SIGPIPE, SIG_IGN);
	} else {
		g_warning (_("GNOME VFS already initialized."));
		retval = TRUE;	/* Who cares after all.  */
	}

	vfs_already_initialized = TRUE;
	G_UNLOCK (vfs_already_initialized);

	return retval;
}

void
gnome_vfs_loadinit(gpointer app, gpointer modinfo)
{
	gnome_vfs_backend_loadinit(app, modinfo);
}

void
gnome_vfs_preinit(gpointer app, gpointer modinfo)
{
}

void
gnome_vfs_postinit(gpointer app, gpointer modinfo)
{
	G_LOCK (vfs_already_initialized);

	gnome_vfs_method_init();
	gnome_vfs_process_init();
	gnome_vfs_configuration_init();
	gnome_vfs_backend_init(FALSE);
	signal(SIGPIPE, SIG_IGN);

	vfs_already_initialized = TRUE;
	G_UNLOCK (vfs_already_initialized);
}
