/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gnome-vfs-job-slave.h - Slave thread for asynchronous GnomeVFSJobs
   (version for POSIX threads).

   Copyright (C) 1999 Free Software Foundation

   The Gnome Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Author: Ettore Perazzoli <ettore@comm2000.it> */

#ifndef _GNOME_VFS_JOB_SLAVE_PTHREAD_H
#define _GNOME_VFS_JOB_SLAVE_PTHREAD_H

typedef struct _GnomeVFSJobSlave GnomeVFSJobSlave;

#include <pthread.h>

#include "gnome-vfs-job.h"

struct _GnomeVFSJobSlave {
	GnomeVFSJob *job;
	pthread_t pthread;
	pthread_attr_t pthread_attr;
};


GnomeVFSJobSlave *gnome_vfs_job_slave_new (GnomeVFSJob *job);
void gnome_vfs_job_slave_cancel (GnomeVFSJobSlave *slave);
void gnome_vfs_job_slave_destroy (GnomeVFSJobSlave *slave);

#endif /* _GNOME_VFS_JOB_SLAVE_PTHREAD_H */
