/* sudoku-board.c generated by valac 0.32.0.42-62a2, the Vala compiler
 * generated from sudoku-board.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include "qqwing-wrapper.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_HOUSE (house_get_type ())

#define TYPE_CELL (cell_get_type ())
typedef struct _Cell Cell;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD,
	DIFFICULTY_CATEGORY_CUSTOM
} DifficultyCategory;

struct _SudokuBoardPrivate {
	gboolean* possible_in_row;
	gint possible_in_row_length1;
	gint possible_in_row_length2;
	gboolean* possible_in_col;
	gint possible_in_col_length1;
	gint possible_in_col_length2;
	gboolean* possible_in_block;
	gint possible_in_block_length1;
	gint possible_in_block_length2;
	gint possible_in_block_length3;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	gint n_earmarks;
	gdouble _previous_played_time;
	DifficultyCategory _difficulty_category;
	gint _block_rows;
	gint _block_cols;
	gint _rows;
	gint _cols;
	gint _filled;
	gint _fixed;
};

typedef enum  {
	HOUSE_ROW,
	HOUSE_COLUMN,
	HOUSE_BLOCK
} House;

struct _Cell {
	Coord coord;
	gint val;
};


static gpointer sudoku_board_parent_class = NULL;

GType sudoku_board_get_type (void) G_GNUC_CONST;
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
GType difficulty_category_get_type (void) G_GNUC_CONST;
#define SUDOKU_BOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_BOARD, SudokuBoardPrivate))
enum  {
	SUDOKU_BOARD_DUMMY_PROPERTY,
	SUDOKU_BOARD_PREVIOUS_PLAYED_TIME,
	SUDOKU_BOARD_DIFFICULTY_CATEGORY,
	SUDOKU_BOARD_BLOCK_ROWS,
	SUDOKU_BOARD_BLOCK_COLS,
	SUDOKU_BOARD_ROWS,
	SUDOKU_BOARD_COLS,
	SUDOKU_BOARD_MAX_VAL,
	SUDOKU_BOARD_BROKEN,
	SUDOKU_BOARD_FILLED,
	SUDOKU_BOARD_FIXED,
	SUDOKU_BOARD_SIZE,
	SUDOKU_BOARD_COMPLETE
};
gboolean sudoku_board_is_empty (SudokuBoard* self);
gint sudoku_board_get_filled (SudokuBoard* self);
gint sudoku_board_get_fixed (SudokuBoard* self);
gboolean sudoku_board_is_fully_filled (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
static void sudoku_board_set_cols (SudokuBoard* self, gint value);
static void sudoku_board_set_rows (SudokuBoard* self, gint value);
static void sudoku_board_set_block_rows (SudokuBoard* self, gint value);
static void sudoku_board_set_block_cols (SudokuBoard* self, gint value);
gint sudoku_board_get_max_val (SudokuBoard* self);
gint coord_hash (Coord* coord);
gboolean coord_equal (Coord* a, Coord* b);
void coord_init (Coord *self, gint row, gint col);
SudokuBoard* sudoku_board_clone (SudokuBoard* self);
gint sudoku_board_get_block_rows (SudokuBoard* self);
gint sudoku_board_get_block_cols (SudokuBoard* self);
static gint* _vala_array_dup1 (gint* self, int length);
static gboolean* _vala_array_dup2 (gboolean* self, int length);
static gboolean* _vala_array_dup3 (gboolean* self, int length);
static gboolean* _vala_array_dup4 (gboolean* self, int length);
static gboolean* _vala_array_dup5 (gboolean* self, int length);
static void sudoku_board_set_filled (SudokuBoard* self, gint value);
static void sudoku_board_set_fixed (SudokuBoard* self, gint value);
static gboolean* _vala_array_dup6 (gboolean* self, int length);
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
void sudoku_board_enable_earmark (SudokuBoard* self, gint row, gint column, gint digit);
void sudoku_board_disable_earmark (SudokuBoard* self, gint row, gint column, gint digit);
void sudoku_board_disable_all_earmarks (SudokuBoard* self, gint row, gint column);
gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self, gint row, gint column, gint digit);
gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col);
gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1);
static gint* _vala_array_dup7 (gint* self, int length);
gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1);
void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
static void sudoku_board_mark_breakages_for (SudokuBoard* self, GeeList* coords, gint val);
gboolean sudoku_board_get_complete (SudokuBoard* self);
void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
static void sudoku_board_remove_breakages_for (SudokuBoard* self, GeeList* coords, gint val);
GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val);
gint sudoku_board_count_solutions_limited (SudokuBoard* self);
gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val);
gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val);
gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val);
void sudoku_board_to_initial_state (SudokuBoard* self);
void sudoku_board_print (SudokuBoard* self, gint indent);
void sudoku_board_get_string (SudokuBoard* self);
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
static gint* _vala_array_dup8 (gint* self, int length);
GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self);
gboolean sudoku_board_is_finished (SudokuBoard* self);
const gchar* sudoku_saver_get_finishgame_dir (void);
gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
gboolean sudoku_board_get_broken (SudokuBoard* self);
gint sudoku_board_get_size (SudokuBoard* self);
static void sudoku_board_finalize (GObject* obj);
static void _vala_sudoku_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType house_get_type (void) G_GNUC_CONST;
GType cell_get_type (void) G_GNUC_CONST;
Cell* cell_dup (const Cell* self);
void cell_free (Cell* self);
void cell_init (Cell *self, Coord* coord, gint val);
gint cell_hash (Cell* cell);
gboolean cell_equal (Cell* a, Cell* b);
gchar* difficulty_category_to_string (DifficultyCategory self);
gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
DifficultyCategory difficulty_category_from_string (const gchar* input);


gboolean sudoku_board_is_empty (SudokuBoard* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 80 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_filled;
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = self->priv->_fixed;
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp1_ == _tmp2_) {
#line 254 "sudoku-board.c"
		gint _tmp3_ = 0;
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp3_ = self->priv->n_earmarks;
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = _tmp3_ == 0;
#line 260 "sudoku-board.c"
	} else {
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 264 "sudoku-board.c"
	}
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 82 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 270 "sudoku-board.c"
}


gboolean sudoku_board_is_fully_filled (SudokuBoard* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 85 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_filled;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_cols;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = self->priv->_rows;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_ == (_tmp1_ * _tmp2_);
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 291 "sudoku-board.c"
}


SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols) {
	SudokuBoard * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gboolean* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gboolean* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gboolean* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gboolean* _tmp25_ = NULL;
	GeeHashSet* _tmp68_ = NULL;
	GeeArrayList* _tmp69_ = NULL;
	GeeList* _tmp97_ = NULL;
	GeeList* _tmp98_ = NULL;
	GeeList* _tmp99_ = NULL;
	GeeArrayList* _tmp100_ = NULL;
	GeeList* _tmp128_ = NULL;
	GeeList* _tmp129_ = NULL;
	GeeList* _tmp130_ = NULL;
	GeeHashMap* _tmp131_ = NULL;
	GeeMap* _tmp186_ = NULL;
	GeeMap* _tmp187_ = NULL;
	GeeMap* _tmp188_ = NULL;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self = (SudokuBoard*) g_object_new (object_type, NULL);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = block_rows;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = block_cols;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_cols (self, _tmp0_ * _tmp1_);
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_rows (self, _tmp0_ * _tmp1_);
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = block_rows;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_block_rows (self, _tmp2_);
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = block_cols;
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_block_cols (self, _tmp3_);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = self->priv->_rows;
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = self->priv->_cols;
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = g_new0 (gint, _tmp4_ * _tmp5_);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->cells = (g_free (self->cells), NULL);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->cells = _tmp6_;
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->cells_length1 = _tmp4_;
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->cells_length2 = _tmp5_;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = self->priv->_rows;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = self->priv->_cols;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = g_new0 (gboolean, _tmp7_ * _tmp8_);
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed = (g_free (self->is_fixed), NULL);
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed = _tmp9_;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed_length1 = _tmp7_;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed_length2 = _tmp8_;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = self->priv->_rows;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = self->priv->_cols;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = g_new0 (gboolean, _tmp10_ * _tmp11_);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row = _tmp12_;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row_length1 = _tmp10_;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row_length2 = _tmp11_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = self->priv->_cols;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14_ = self->priv->_rows;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = g_new0 (gboolean, _tmp13_ * _tmp14_);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col = _tmp15_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col_length1 = _tmp13_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col_length2 = _tmp14_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = block_rows;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = block_cols;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = block_rows;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = block_cols;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp20_ = g_new0 (gboolean, (_tmp16_ * _tmp17_) * (_tmp18_ * _tmp19_));
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block = _tmp20_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block_length1 = _tmp16_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block_length2 = _tmp17_;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block_length3 = _tmp18_ * _tmp19_;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = self->priv->_rows;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = self->priv->_cols;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23_ = sudoku_board_get_max_val (self);
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24_ = _tmp23_;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp25_ = g_new0 (gboolean, (_tmp21_ * _tmp22_) * _tmp24_);
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks = _tmp25_;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks_length1 = _tmp21_;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks_length2 = _tmp22_;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks_length3 = _tmp24_;
#line 450 "sudoku-board.c"
	{
		gint l1 = 0;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 455 "sudoku-board.c"
		{
			gboolean _tmp26_ = FALSE;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp26_ = TRUE;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 462 "sudoku-board.c"
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp26_) {
#line 467 "sudoku-board.c"
					gint _tmp27_ = 0;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp27_ = l1;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp27_ + 1;
#line 473 "sudoku-board.c"
				}
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp26_ = FALSE;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp28_ = l1;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp29_ = self->priv->_rows;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp28_ < _tmp29_)) {
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 485 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 491 "sudoku-board.c"
					{
						gboolean _tmp30_ = FALSE;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp30_ = TRUE;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 498 "sudoku-board.c"
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint* _tmp34_ = NULL;
							gint _tmp34__length1 = 0;
							gint _tmp34__length2 = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gboolean* _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp38__length2 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gboolean _tmp41_ = FALSE;
							gboolean* _tmp42_ = NULL;
							gint _tmp42__length1 = 0;
							gint _tmp42__length2 = 0;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gboolean _tmp45_ = FALSE;
							gboolean* _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							gint _tmp46__length2 = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							gboolean _tmp49_ = FALSE;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp30_) {
#line 527 "sudoku-board.c"
								gint _tmp31_ = 0;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp31_ = l2;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp31_ + 1;
#line 533 "sudoku-board.c"
							}
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp30_ = FALSE;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp32_ = l2;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp33_ = self->priv->_cols;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp32_ < _tmp33_)) {
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 545 "sudoku-board.c"
							}
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp34_ = self->cells;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp34__length1 = self->cells_length1;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp34__length2 = self->cells_length2;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp35_ = l1;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp36_ = l2;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_] = 0;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp37_ = _tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_];
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp38_ = self->is_fixed;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp38__length1 = self->is_fixed_length1;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp38__length2 = self->is_fixed_length2;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp39_ = l1;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp40_ = l2;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_] = FALSE;
#line 121 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp42_ = self->priv->possible_in_row;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp42__length1 = self->priv->possible_in_row_length1;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp42__length2 = self->priv->possible_in_row_length2;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp43_ = l1;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp44_ = l2;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp42_[(_tmp43_ * _tmp42__length2) + _tmp44_] = TRUE;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp45_ = _tmp42_[(_tmp43_ * _tmp42__length2) + _tmp44_];
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp46_ = self->priv->possible_in_col;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp46__length1 = self->priv->possible_in_col_length1;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp46__length2 = self->priv->possible_in_col_length2;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp47_ = l2;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp48_ = l1;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_] = TRUE;
#line 123 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp49_ = _tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_];
#line 603 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
	{
		gint l1 = 0;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 614 "sudoku-board.c"
		{
			gboolean _tmp50_ = FALSE;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp50_ = TRUE;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 621 "sudoku-board.c"
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp50_) {
#line 626 "sudoku-board.c"
					gint _tmp51_ = 0;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp51_ = l1;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp51_ + 1;
#line 632 "sudoku-board.c"
				}
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp50_ = FALSE;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp52_ = l1;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp53_ = block_rows;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp52_ < _tmp53_)) {
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 644 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 650 "sudoku-board.c"
					{
						gboolean _tmp54_ = FALSE;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp54_ = TRUE;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 657 "sudoku-board.c"
							gint _tmp56_ = 0;
							gint _tmp57_ = 0;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp54_) {
#line 662 "sudoku-board.c"
								gint _tmp55_ = 0;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp55_ = l2;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp55_ + 1;
#line 668 "sudoku-board.c"
							}
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp54_ = FALSE;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp56_ = l2;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp57_ = block_cols;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp56_ < _tmp57_)) {
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 680 "sudoku-board.c"
							}
							{
								gint l3 = 0;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l3 = 0;
#line 686 "sudoku-board.c"
								{
									gboolean _tmp58_ = FALSE;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp58_ = TRUE;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									while (TRUE) {
#line 693 "sudoku-board.c"
										gint _tmp60_ = 0;
										gint _tmp61_ = 0;
										gint _tmp62_ = 0;
										gboolean* _tmp63_ = NULL;
										gint _tmp63__length1 = 0;
										gint _tmp63__length2 = 0;
										gint _tmp63__length3 = 0;
										gint _tmp64_ = 0;
										gint _tmp65_ = 0;
										gint _tmp66_ = 0;
										gboolean _tmp67_ = FALSE;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										if (!_tmp58_) {
#line 707 "sudoku-board.c"
											gint _tmp59_ = 0;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											_tmp59_ = l3;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											l3 = _tmp59_ + 1;
#line 713 "sudoku-board.c"
										}
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp58_ = FALSE;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp60_ = l3;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp61_ = sudoku_board_get_max_val (self);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp62_ = _tmp61_;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										if (!(_tmp60_ < _tmp62_)) {
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											break;
#line 727 "sudoku-board.c"
										}
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63_ = self->priv->possible_in_block;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63__length1 = self->priv->possible_in_block_length1;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63__length2 = self->priv->possible_in_block_length2;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63__length3 = self->priv->possible_in_block_length3;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp64_ = l1;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp65_ = l2;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp66_ = l3;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63_[(((_tmp64_ * _tmp63__length2) + _tmp65_) * _tmp63__length3) + _tmp66_] = TRUE;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp67_ = _tmp63_[(((_tmp64_ * _tmp63__length2) + _tmp65_) * _tmp63__length3) + _tmp66_];
#line 747 "sudoku-board.c"
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->broken_coords);
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->broken_coords = (GeeSet*) _tmp68_;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp69_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_col);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_col = (GeeList*) _tmp69_;
#line 769 "sudoku-board.c"
	{
		gint col = 0;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 774 "sudoku-board.c"
		{
			gboolean _tmp70_ = FALSE;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp70_ = TRUE;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 781 "sudoku-board.c"
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				GeeList* _tmp74_ = NULL;
				GeeArrayList* _tmp75_ = NULL;
				GeeArrayList* _tmp76_ = NULL;
				GeeList* _tmp88_ = NULL;
				gint _tmp89_ = 0;
				GeeList* _tmp90_ = NULL;
				gint _tmp91_ = 0;
				gpointer _tmp92_ = NULL;
				GeeList* _tmp93_ = NULL;
				GeeList* _tmp94_ = NULL;
				GeeList* _tmp95_ = NULL;
				GeeList* _tmp96_ = NULL;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp70_) {
#line 798 "sudoku-board.c"
					gint _tmp71_ = 0;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp71_ = col;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp71_ + 1;
#line 804 "sudoku-board.c"
				}
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp70_ = FALSE;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp72_ = col;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp73_ = self->priv->_cols;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp72_ < _tmp73_)) {
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 816 "sudoku-board.c"
				}
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp74_ = self->coords_for_col;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp75_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp76_ = _tmp75_;
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_add ((GeeCollection*) _tmp74_, (GeeList*) _tmp76_);
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp76_);
#line 828 "sudoku-board.c"
				{
					gint row = 0;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 833 "sudoku-board.c"
					{
						gboolean _tmp77_ = FALSE;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp77_ = TRUE;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 840 "sudoku-board.c"
							gint _tmp79_ = 0;
							gint _tmp80_ = 0;
							GeeList* _tmp81_ = NULL;
							gint _tmp82_ = 0;
							gpointer _tmp83_ = NULL;
							GeeList* _tmp84_ = NULL;
							gint _tmp85_ = 0;
							gint _tmp86_ = 0;
							Coord _tmp87_ = {0};
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp77_) {
#line 852 "sudoku-board.c"
								gint _tmp78_ = 0;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp78_ = row;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp78_ + 1;
#line 858 "sudoku-board.c"
							}
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp77_ = FALSE;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp79_ = row;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp80_ = self->priv->_rows;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp79_ < _tmp80_)) {
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 870 "sudoku-board.c"
							}
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp81_ = self->coords_for_col;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp82_ = col;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp83_ = gee_list_get (_tmp81_, _tmp82_);
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp84_ = (GeeList*) _tmp83_;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp85_ = row;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp86_ = col;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp87_, _tmp85_, _tmp86_);
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							gee_collection_add ((GeeCollection*) _tmp84_, &_tmp87_);
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp84_);
#line 890 "sudoku-board.c"
						}
					}
				}
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp88_ = self->coords_for_col;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp89_ = col;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp90_ = self->coords_for_col;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp91_ = col;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp92_ = gee_list_get (_tmp90_, _tmp91_);
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp93_ = (GeeList*) _tmp92_;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp94_ = gee_list_get_read_only_view (_tmp93_);
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp95_ = _tmp94_;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp96_ = _tmp95_;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_list_set (_tmp88_, _tmp89_, _tmp96_);
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp96_);
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp93_);
#line 918 "sudoku-board.c"
			}
		}
	}
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp97_ = self->coords_for_col;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp98_ = gee_list_get_read_only_view (_tmp97_);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp99_ = _tmp98_;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_col);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_col = _tmp99_;
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp100_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_row);
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_row = (GeeList*) _tmp100_;
#line 938 "sudoku-board.c"
	{
		gint row = 0;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		row = 0;
#line 943 "sudoku-board.c"
		{
			gboolean _tmp101_ = FALSE;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp101_ = TRUE;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 950 "sudoku-board.c"
				gint _tmp103_ = 0;
				gint _tmp104_ = 0;
				GeeList* _tmp105_ = NULL;
				GeeArrayList* _tmp106_ = NULL;
				GeeArrayList* _tmp107_ = NULL;
				GeeList* _tmp119_ = NULL;
				gint _tmp120_ = 0;
				GeeList* _tmp121_ = NULL;
				gint _tmp122_ = 0;
				gpointer _tmp123_ = NULL;
				GeeList* _tmp124_ = NULL;
				GeeList* _tmp125_ = NULL;
				GeeList* _tmp126_ = NULL;
				GeeList* _tmp127_ = NULL;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp101_) {
#line 967 "sudoku-board.c"
					gint _tmp102_ = 0;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp102_ = row;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					row = _tmp102_ + 1;
#line 973 "sudoku-board.c"
				}
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp101_ = FALSE;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp103_ = row;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp104_ = self->priv->_rows;
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp103_ < _tmp104_)) {
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 985 "sudoku-board.c"
				}
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp105_ = self->coords_for_row;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp106_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp107_ = _tmp106_;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_add ((GeeCollection*) _tmp105_, (GeeList*) _tmp107_);
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp107_);
#line 997 "sudoku-board.c"
				{
					gint col = 0;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					col = 0;
#line 1002 "sudoku-board.c"
					{
						gboolean _tmp108_ = FALSE;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp108_ = TRUE;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1009 "sudoku-board.c"
							gint _tmp110_ = 0;
							gint _tmp111_ = 0;
							GeeList* _tmp112_ = NULL;
							gint _tmp113_ = 0;
							gpointer _tmp114_ = NULL;
							GeeList* _tmp115_ = NULL;
							gint _tmp116_ = 0;
							gint _tmp117_ = 0;
							Coord _tmp118_ = {0};
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp108_) {
#line 1021 "sudoku-board.c"
								gint _tmp109_ = 0;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp109_ = col;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								col = _tmp109_ + 1;
#line 1027 "sudoku-board.c"
							}
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp108_ = FALSE;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp110_ = col;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp111_ = self->priv->_cols;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp110_ < _tmp111_)) {
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1039 "sudoku-board.c"
							}
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp112_ = self->coords_for_row;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp113_ = row;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp114_ = gee_list_get (_tmp112_, _tmp113_);
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp115_ = (GeeList*) _tmp114_;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp116_ = row;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp117_ = col;
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp118_, _tmp116_, _tmp117_);
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							gee_collection_add ((GeeCollection*) _tmp115_, &_tmp118_);
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp115_);
#line 1059 "sudoku-board.c"
						}
					}
				}
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp119_ = self->coords_for_row;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp120_ = row;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp121_ = self->coords_for_row;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp122_ = row;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp123_ = gee_list_get (_tmp121_, _tmp122_);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp124_ = (GeeList*) _tmp123_;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp125_ = gee_list_get_read_only_view (_tmp124_);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp126_ = _tmp125_;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp127_ = _tmp126_;
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_list_set (_tmp119_, _tmp120_, _tmp127_);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp127_);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp124_);
#line 1087 "sudoku-board.c"
			}
		}
	}
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp128_ = self->coords_for_row;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp129_ = gee_list_get_read_only_view (_tmp128_);
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp130_ = _tmp129_;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_row);
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_row = _tmp130_;
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp131_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_block);
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_block = (GeeMap*) _tmp131_;
#line 1107 "sudoku-board.c"
	{
		gint col = 0;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 1112 "sudoku-board.c"
		{
			gboolean _tmp132_ = FALSE;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp132_ = TRUE;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1119 "sudoku-board.c"
				gint _tmp134_ = 0;
				gint _tmp135_ = 0;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp132_) {
#line 1124 "sudoku-board.c"
					gint _tmp133_ = 0;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp133_ = col;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp133_ + 1;
#line 1130 "sudoku-board.c"
				}
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp132_ = FALSE;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp134_ = col;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp135_ = block_cols;
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp134_ < _tmp135_)) {
#line 156 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1142 "sudoku-board.c"
				}
				{
					gint row = 0;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 1148 "sudoku-board.c"
					{
						gboolean _tmp136_ = FALSE;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp136_ = TRUE;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1155 "sudoku-board.c"
							gint _tmp138_ = 0;
							gint _tmp139_ = 0;
							GeeMap* _tmp140_ = NULL;
							gint _tmp141_ = 0;
							gint _tmp142_ = 0;
							Coord _tmp143_ = {0};
							GeeArrayList* _tmp144_ = NULL;
							GeeArrayList* _tmp145_ = NULL;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp136_) {
#line 1166 "sudoku-board.c"
								gint _tmp137_ = 0;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp137_ = row;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp137_ + 1;
#line 1172 "sudoku-board.c"
							}
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp136_ = FALSE;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp138_ = row;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp139_ = block_rows;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp138_ < _tmp139_)) {
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1184 "sudoku-board.c"
							}
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp140_ = self->coords_for_block;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp141_ = row;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp142_ = col;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp143_, _tmp141_, _tmp142_);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp144_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp145_ = _tmp144_;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							gee_map_set (_tmp140_, &_tmp143_, (GeeList*) _tmp145_);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp145_);
#line 1202 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 1213 "sudoku-board.c"
		{
			gboolean _tmp146_ = FALSE;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp146_ = TRUE;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1220 "sudoku-board.c"
				gint _tmp148_ = 0;
				gint _tmp149_ = 0;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp146_) {
#line 1225 "sudoku-board.c"
					gint _tmp147_ = 0;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp147_ = col;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp147_ + 1;
#line 1231 "sudoku-board.c"
				}
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp146_ = FALSE;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp148_ = col;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp149_ = self->priv->_cols;
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp148_ < _tmp149_)) {
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1243 "sudoku-board.c"
				}
				{
					gint row = 0;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 1249 "sudoku-board.c"
					{
						gboolean _tmp150_ = FALSE;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp150_ = TRUE;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1256 "sudoku-board.c"
							gint _tmp152_ = 0;
							gint _tmp153_ = 0;
							GeeMap* _tmp154_ = NULL;
							gint _tmp155_ = 0;
							gint _tmp156_ = 0;
							gint _tmp157_ = 0;
							gint _tmp158_ = 0;
							Coord _tmp159_ = {0};
							gpointer _tmp160_ = NULL;
							GeeList* _tmp161_ = NULL;
							gint _tmp162_ = 0;
							gint _tmp163_ = 0;
							Coord _tmp164_ = {0};
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp150_) {
#line 1272 "sudoku-board.c"
								gint _tmp151_ = 0;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp151_ = row;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp151_ + 1;
#line 1278 "sudoku-board.c"
							}
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp150_ = FALSE;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp152_ = row;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp153_ = self->priv->_rows;
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp152_ < _tmp153_)) {
#line 161 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1290 "sudoku-board.c"
							}
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp154_ = self->coords_for_block;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp155_ = row;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp156_ = block_rows;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp157_ = col;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp158_ = block_cols;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp159_, _tmp155_ / _tmp156_, _tmp157_ / _tmp158_);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp160_ = gee_map_get (_tmp154_, &_tmp159_);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp161_ = (GeeList*) _tmp160_;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp162_ = row;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp163_ = col;
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp164_, _tmp162_, _tmp163_);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							gee_collection_add ((GeeCollection*) _tmp161_, &_tmp164_);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp161_);
#line 1318 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 1329 "sudoku-board.c"
		{
			gboolean _tmp165_ = FALSE;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp165_ = TRUE;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1336 "sudoku-board.c"
				gint _tmp167_ = 0;
				gint _tmp168_ = 0;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp165_) {
#line 1341 "sudoku-board.c"
					gint _tmp166_ = 0;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp166_ = col;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp166_ + 1;
#line 1347 "sudoku-board.c"
				}
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp165_ = FALSE;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp167_ = col;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp168_ = block_cols;
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp167_ < _tmp168_)) {
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1359 "sudoku-board.c"
				}
				{
					gint row = 0;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 1365 "sudoku-board.c"
					{
						gboolean _tmp169_ = FALSE;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp169_ = TRUE;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1372 "sudoku-board.c"
							gint _tmp171_ = 0;
							gint _tmp172_ = 0;
							GeeMap* _tmp173_ = NULL;
							gint _tmp174_ = 0;
							gint _tmp175_ = 0;
							Coord _tmp176_ = {0};
							GeeMap* _tmp177_ = NULL;
							gint _tmp178_ = 0;
							gint _tmp179_ = 0;
							Coord _tmp180_ = {0};
							gpointer _tmp181_ = NULL;
							GeeList* _tmp182_ = NULL;
							GeeList* _tmp183_ = NULL;
							GeeList* _tmp184_ = NULL;
							GeeList* _tmp185_ = NULL;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp169_) {
#line 1390 "sudoku-board.c"
								gint _tmp170_ = 0;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp170_ = row;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp170_ + 1;
#line 1396 "sudoku-board.c"
							}
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp169_ = FALSE;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp171_ = row;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp172_ = block_rows;
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp171_ < _tmp172_)) {
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1408 "sudoku-board.c"
							}
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp173_ = self->coords_for_block;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp174_ = row;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp175_ = col;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp176_, _tmp174_, _tmp175_);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp177_ = self->coords_for_block;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp178_ = row;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp179_ = col;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp180_, _tmp178_, _tmp179_);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp181_ = gee_map_get (_tmp177_, &_tmp180_);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp182_ = (GeeList*) _tmp181_;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp183_ = gee_list_get_read_only_view (_tmp182_);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp184_ = _tmp183_;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp185_ = _tmp184_;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							gee_map_set (_tmp173_, &_tmp176_, _tmp185_);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp185_);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp182_);
#line 1442 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp186_ = self->coords_for_block;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp187_ = gee_map_get_read_only_view (_tmp186_);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp188_ = _tmp187_;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_block);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_block = _tmp188_;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return self;
#line 1461 "sudoku-board.c"
}


SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols) {
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return sudoku_board_construct (TYPE_SUDOKU_BOARD, block_rows, block_cols);
#line 1468 "sudoku-board.c"
}


static gint* _vala_array_dup1 (gint* self, int length) {
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gint));
#line 1475 "sudoku-board.c"
}


static gboolean* _vala_array_dup2 (gboolean* self, int length) {
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1482 "sudoku-board.c"
}


static gboolean* _vala_array_dup3 (gboolean* self, int length) {
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1489 "sudoku-board.c"
}


static gboolean* _vala_array_dup4 (gboolean* self, int length) {
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1496 "sudoku-board.c"
}


static gboolean* _vala_array_dup5 (gboolean* self, int length) {
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1503 "sudoku-board.c"
}


static gboolean* _vala_array_dup6 (gboolean* self, int length) {
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1510 "sudoku-board.c"
}


SudokuBoard* sudoku_board_clone (SudokuBoard* self) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuBoard* _tmp2_ = NULL;
	gint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gboolean* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gboolean* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp6__length2 = 0;
	gboolean* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp7__length2 = 0;
	gboolean* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	gboolean* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gboolean* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gboolean* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp11__length2 = 0;
	gint _tmp11__length3 = 0;
	gboolean* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp12__length2 = 0;
	gint _tmp12__length3 = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GeeSet* _tmp16_ = NULL;
	GeeSet* _tmp17_ = NULL;
	gboolean* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp18__length2 = 0;
	gint _tmp18__length3 = 0;
	gboolean* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gint _tmp19__length2 = 0;
	gint _tmp19__length3 = 0;
	DifficultyCategory _tmp20_ = 0;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_rows;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_block_cols;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = sudoku_board_new (_tmp0_, _tmp1_);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board = _tmp2_;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->cells;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length1 = self->cells_length1;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length2 = self->cells_length2;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : ((gpointer) _tmp3_);
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4__length1 = _tmp3__length1;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4__length2 = _tmp3__length2;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->cells = (g_free (board->cells), NULL);
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->cells = _tmp4_;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->cells_length1 = _tmp4__length1;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->cells_length2 = _tmp4__length2;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = self->is_fixed;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5__length1 = self->is_fixed_length1;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5__length2 = self->is_fixed_length2;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1 * _tmp5__length2) : ((gpointer) _tmp5_);
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6__length1 = _tmp5__length1;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6__length2 = _tmp5__length2;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed = (g_free (board->is_fixed), NULL);
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed = _tmp6_;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed_length1 = _tmp6__length1;
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed_length2 = _tmp6__length2;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = self->priv->possible_in_row;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7__length1 = self->priv->possible_in_row_length1;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7__length2 = self->priv->possible_in_row_length2;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup3 (_tmp7_, _tmp7__length1 * _tmp7__length2) : ((gpointer) _tmp7_);
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8__length1 = _tmp7__length1;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8__length2 = _tmp7__length2;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row = (g_free (board->priv->possible_in_row), NULL);
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row = _tmp8_;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row_length1 = _tmp8__length1;
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row_length2 = _tmp8__length2;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = self->priv->possible_in_col;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length1 = self->priv->possible_in_col_length1;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length2 = self->priv->possible_in_col_length2;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup4 (_tmp9_, _tmp9__length1 * _tmp9__length2) : ((gpointer) _tmp9_);
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10__length1 = _tmp9__length1;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10__length2 = _tmp9__length2;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col = (g_free (board->priv->possible_in_col), NULL);
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col = _tmp10_;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col_length1 = _tmp10__length1;
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col_length2 = _tmp10__length2;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = self->priv->possible_in_block;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11__length1 = self->priv->possible_in_block_length1;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11__length2 = self->priv->possible_in_block_length2;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11__length3 = self->priv->possible_in_block_length3;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup5 (_tmp11_, (_tmp11__length1 * _tmp11__length2) * _tmp11__length3) : ((gpointer) _tmp11_);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12__length1 = _tmp11__length1;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12__length2 = _tmp11__length2;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12__length3 = _tmp11__length3;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block = (g_free (board->priv->possible_in_block), NULL);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block = _tmp12_;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block_length1 = _tmp12__length1;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block_length2 = _tmp12__length2;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block_length3 = _tmp12__length3;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = self->priv->_filled;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_filled (board, _tmp13_);
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14_ = self->priv->_fixed;
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_fixed (board, _tmp14_);
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = self->priv->n_earmarks;
#line 181 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->n_earmarks = _tmp15_;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = board->broken_coords;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = self->broken_coords;
#line 182 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	gee_collection_add_all ((GeeCollection*) _tmp16_, (GeeCollection*) _tmp17_);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = self->priv->earmarks;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18__length1 = self->priv->earmarks_length1;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18__length2 = self->priv->earmarks_length2;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18__length3 = self->priv->earmarks_length3;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup6 (_tmp18_, (_tmp18__length1 * _tmp18__length2) * _tmp18__length3) : ((gpointer) _tmp18_);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19__length1 = _tmp18__length1;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19__length2 = _tmp18__length2;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19__length3 = _tmp18__length3;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->earmarks = (g_free (board->priv->earmarks), NULL);
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->earmarks = _tmp19_;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->earmarks_length1 = _tmp19__length1;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->earmarks_length2 = _tmp19__length2;
#line 183 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->earmarks_length3 = _tmp19__length3;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp20_ = self->priv->_difficulty_category;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_difficulty_category (board, _tmp20_);
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = board;
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 1734 "sudoku-board.c"
}


void sudoku_board_enable_earmark (SudokuBoard* self, gint row, gint column, gint digit) {
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp0__length3 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp11_ = 0;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->earmarks;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->priv->earmarks_length1;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->priv->earmarks_length2;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length3 = self->priv->earmarks_length3;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = column;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = digit;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp0_[(((_tmp1_ * _tmp0__length2) + _tmp2_) * _tmp0__length3) + (_tmp3_ - 1)];
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp4_) {
#line 1768 "sudoku-board.c"
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp5__length3 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_ = 0;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = self->priv->earmarks;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = self->priv->earmarks_length1;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length2 = self->priv->earmarks_length2;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length3 = self->priv->earmarks_length3;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = row;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = column;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = digit;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)] = TRUE;
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp9_ = _tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)];
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp10_ = self->priv->n_earmarks;
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		self->priv->n_earmarks = _tmp10_ + 1;
#line 1800 "sudoku-board.c"
	}
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = self->priv->n_earmarks;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_vala_warn_if_fail (_tmp11_ > 0, "n_earmarks > 0");
#line 1806 "sudoku-board.c"
}


void sudoku_board_disable_earmark (SudokuBoard* self, gint row, gint column, gint digit) {
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp0__length3 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp11_ = 0;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->earmarks;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->priv->earmarks_length1;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->priv->earmarks_length2;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length3 = self->priv->earmarks_length3;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = column;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = digit;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp0_[(((_tmp1_ * _tmp0__length2) + _tmp2_) * _tmp0__length3) + (_tmp3_ - 1)];
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp4_) {
#line 1840 "sudoku-board.c"
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp5__length3 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_ = 0;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = self->priv->earmarks;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = self->priv->earmarks_length1;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length2 = self->priv->earmarks_length2;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length3 = self->priv->earmarks_length3;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = row;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = column;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = digit;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)] = FALSE;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp9_ = _tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)];
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp10_ = self->priv->n_earmarks;
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		self->priv->n_earmarks = _tmp10_ - 1;
#line 1872 "sudoku-board.c"
	}
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = self->priv->n_earmarks;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_vala_warn_if_fail (_tmp11_ >= 0, "n_earmarks >= 0");
#line 1878 "sudoku-board.c"
}


void sudoku_board_disable_all_earmarks (SudokuBoard* self, gint row, gint column) {
	gint _tmp13_ = 0;
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 1886 "sudoku-board.c"
	{
		gint i = 0;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		i = 1;
#line 1891 "sudoku-board.c"
		{
			gboolean _tmp0_ = FALSE;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = TRUE;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1898 "sudoku-board.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gboolean* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp5__length2 = 0;
				gint _tmp5__length3 = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gboolean _tmp9_ = FALSE;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp0_) {
#line 1912 "sudoku-board.c"
					gint _tmp1_ = 0;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp1_ = i;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					i = _tmp1_ + 1;
#line 1918 "sudoku-board.c"
				}
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp0_ = FALSE;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp2_ = i;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = sudoku_board_get_max_val (self);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = _tmp3_;
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp2_ <= _tmp4_)) {
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1932 "sudoku-board.c"
				}
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5_ = self->priv->earmarks;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5__length1 = self->priv->earmarks_length1;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5__length2 = self->priv->earmarks_length2;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5__length3 = self->priv->earmarks_length3;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6_ = row;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = column;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_ = i;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = _tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)];
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp9_) {
#line 1952 "sudoku-board.c"
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp10_ = row;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp11_ = column;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp12_ = i;
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					sudoku_board_disable_earmark (self, _tmp10_, _tmp11_, _tmp12_);
#line 1964 "sudoku-board.c"
				}
			}
		}
	}
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = self->priv->n_earmarks;
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_vala_warn_if_fail (_tmp13_ >= 0, "n_earmarks >= 0");
#line 1973 "sudoku-board.c"
}


gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self, gint row, gint column, gint digit) {
	gboolean result = FALSE;
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp0__length3 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->earmarks;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->priv->earmarks_length1;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->priv->earmarks_length2;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length3 = self->priv->earmarks_length3;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = column;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = digit;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp0_[(((_tmp1_ * _tmp0__length2) + _tmp2_) * _tmp0__length3) + (_tmp3_ - 1)];
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp4_;
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2009 "sudoku-board.c"
}


gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = val;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	val = _tmp0_ - 1;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->priv->possible_in_row;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length1 = self->priv->possible_in_row_length1;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length2 = self->priv->possible_in_row_length2;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = row;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = val;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp6_) {
#line 2044 "sudoku-board.c"
		gboolean* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = self->priv->possible_in_col;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7__length1 = self->priv->possible_in_col_length1;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7__length2 = self->priv->possible_in_col_length2;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = col;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp9_ = val;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = _tmp10_;
#line 2065 "sudoku-board.c"
	} else {
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = FALSE;
#line 2069 "sudoku-board.c"
	}
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp2_) {
#line 2073 "sudoku-board.c"
		gboolean* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp11__length2 = 0;
		gint _tmp11__length3 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gboolean _tmp17_ = FALSE;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11_ = self->priv->possible_in_block;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11__length1 = self->priv->possible_in_block_length1;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11__length2 = self->priv->possible_in_block_length2;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11__length3 = self->priv->possible_in_block_length3;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp12_ = row;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp13_ = self->priv->_block_cols;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp14_ = col;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp15_ = self->priv->_block_rows;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp16_ = val;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp17_ = _tmp11_[((((_tmp12_ / _tmp13_) * _tmp11__length2) + (_tmp14_ / _tmp15_)) * _tmp11__length3) + _tmp16_];
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = _tmp17_;
#line 2106 "sudoku-board.c"
	} else {
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = FALSE;
#line 2110 "sudoku-board.c"
	}
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp1_;
#line 225 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2116 "sudoku-board.c"
}


gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = row;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = col;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = sudoku_board_get_possibilities (self, _tmp0_, _tmp1_, &_tmp2_);
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4__length1 = _tmp2_;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = _tmp2_;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = (g_free (_tmp4_), NULL);
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp5_;
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2149 "sudoku-board.c"
}


static gint* _vala_array_dup7 (gint* self, int length) {
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gint));
#line 2156 "sudoku-board.c"
}


gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint* possibilities = NULL;
	gint* _tmp6_ = NULL;
	gint possibilities_length1 = 0;
	gint _possibilities_size_ = 0;
	gint count = 0;
	gint* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gint* _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gint* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp3_ != 0) {
#line 2196 "sudoku-board.c"
		gint* _tmp4_ = NULL;
		gint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = g_new0 (gint, 0);
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = _tmp4_;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = 0;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		if (result_length1) {
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			*result_length1 = _tmp5__length1;
#line 2210 "sudoku-board.c"
		}
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		result = _tmp5_;
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		return result;
#line 2216 "sudoku-board.c"
	}
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = g_new0 (gint, 9);
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = _tmp6_;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities_length1 = 9;
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_possibilities_size_ = possibilities_length1;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	count = 0;
#line 2228 "sudoku-board.c"
	{
		gint l = 0;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l = 1;
#line 2233 "sudoku-board.c"
		{
			gboolean _tmp7_ = FALSE;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = TRUE;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 2240 "sudoku-board.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gboolean _tmp15_ = FALSE;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp7_) {
#line 2250 "sudoku-board.c"
					gint _tmp8_ = 0;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp8_ = l;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l = _tmp8_ + 1;
#line 2256 "sudoku-board.c"
				}
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = FALSE;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = l;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp10_ = sudoku_board_get_max_val (self);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp11_ = _tmp10_;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp9_ <= _tmp11_)) {
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 2270 "sudoku-board.c"
				}
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp12_ = row;
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = col;
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp14_ = l;
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp15_ = sudoku_board_is_possible (self, _tmp12_, _tmp13_, _tmp14_);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp15_) {
#line 2282 "sudoku-board.c"
					gint* _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp16_ = possibilities;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp16__length1 = possibilities_length1;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp17_ = count;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp18_ = l;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp16_[_tmp17_] = _tmp18_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp19_ = _tmp16_[_tmp17_];
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp20_ = count;
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					count = _tmp20_ + 1;
#line 2305 "sudoku-board.c"
				}
			}
		}
	}
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = possibilities;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21__length1 = possibilities_length1;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = count;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23_ = ((_tmp21_ + 0) != NULL) ? _vala_array_dup7 (_tmp21_ + 0, _tmp22_ - 0) : ((gpointer) (_tmp21_ + 0));
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23__length1 = _tmp22_ - 0;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24_ = _tmp23_;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24__length1 = _tmp23__length1;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length1) {
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		*result_length1 = _tmp24__length1;
#line 2328 "sudoku-board.c"
	}
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp24_;
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = (g_free (possibilities), NULL);
#line 249 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2336 "sudoku-board.c"
}


gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1) {
	gboolean* result = NULL;
	gboolean* possibilities = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean* _tmp2_ = NULL;
	gint possibilities_length1 = 0;
	gint _possibilities_size_ = 0;
	gboolean* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = sudoku_board_get_max_val (self);
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_;
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = g_new0 (gboolean, _tmp1_);
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = _tmp2_;
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities_length1 = _tmp1_;
#line 254 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_possibilities_size_ = possibilities_length1;
#line 2364 "sudoku-board.c"
	{
		gint l = 0;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l = 1;
#line 2369 "sudoku-board.c"
		{
			gboolean _tmp3_ = FALSE;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = TRUE;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 2376 "sudoku-board.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gboolean* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp3_) {
#line 2390 "sudoku-board.c"
					gint _tmp4_ = 0;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp4_ = l;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l = _tmp4_ + 1;
#line 2396 "sudoku-board.c"
				}
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = FALSE;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5_ = l;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6_ = sudoku_board_get_max_val (self);
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = _tmp6_;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp5_ <= _tmp7_)) {
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 2410 "sudoku-board.c"
				}
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_ = possibilities;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8__length1 = possibilities_length1;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = l;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp10_ = row;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp11_ = col;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp12_ = l;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = sudoku_board_is_possible (self, _tmp10_, _tmp11_, _tmp12_);
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_[_tmp9_ - 1] = _tmp13_;
#line 257 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp14_ = _tmp8_[_tmp9_ - 1];
#line 2430 "sudoku-board.c"
			}
		}
	}
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = possibilities;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15__length1 = possibilities_length1;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length1) {
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		*result_length1 = _tmp15__length1;
#line 2442 "sudoku-board.c"
	}
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp15_;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2448 "sudoku-board.c"
}


void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Coord _tmp4_ = {0};
#line 262 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = row;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_block_rows;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->priv->_block_cols;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	coord_init (&_tmp4_, _tmp0_ / _tmp1_, _tmp2_ / _tmp3_);
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	*result = _tmp4_;
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return;
#line 2474 "sudoku-board.c"
}


void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp21__length2 = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gboolean _tmp27_ = FALSE;
	gboolean* _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	gint _tmp29__length2 = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gboolean _tmp32_ = FALSE;
	gboolean* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gint _tmp38__length2 = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gboolean _tmp41_ = FALSE;
	gboolean* _tmp47_ = NULL;
	gint _tmp47__length1 = 0;
	gint _tmp47__length2 = 0;
	gint _tmp47__length3 = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	gboolean _tmp53_ = FALSE;
	gint _tmp63_ = 0;
	gboolean* _tmp64_ = NULL;
	gint _tmp64__length1 = 0;
	gint _tmp64__length2 = 0;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gboolean _tmp67_ = FALSE;
	gboolean* _tmp68_ = NULL;
	gint _tmp68__length1 = 0;
	gint _tmp68__length2 = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	gboolean _tmp71_ = FALSE;
	gboolean* _tmp72_ = NULL;
	gint _tmp72__length1 = 0;
	gint _tmp72__length2 = 0;
	gint _tmp72__length3 = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	gint _tmp77_ = 0;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = val;
#line 270 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_vala_assert (_tmp0_ > 0, "val > 0");
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = val;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = sudoku_board_get_max_val (self);
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_;
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_vala_assert (_tmp1_ <= _tmp3_, "val <= max_val");
#line 274 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = is_fixed;
#line 274 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp4_) {
#line 2571 "sudoku-board.c"
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = self->is_fixed;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = self->is_fixed_length1;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length2 = self->is_fixed_length2;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = row;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = col;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_vala_assert (!_tmp8_, "!this.is_fixed[row, col]");
#line 2592 "sudoku-board.c"
	}
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = self->cells;
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length1 = self->cells_length1;
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length2 = self->cells_length2;
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = row;
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = col;
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp12_ != 0) {
#line 2608 "sudoku-board.c"
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp13_ = row;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp14_ = col;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp15_ = is_fixed;
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove (self, _tmp13_, _tmp14_, _tmp15_);
#line 2620 "sudoku-board.c"
	}
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = self->cells;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16__length1 = self->cells_length1;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16__length2 = self->cells_length2;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = row;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = col;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = val;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_] = _tmp19_;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp20_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = self->is_fixed;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21__length1 = self->is_fixed_length1;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21__length2 = self->is_fixed_length2;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = row;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23_ = col;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24_ = is_fixed;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp24_;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp25_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp26_ = self->priv->_filled;
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_filled (self, _tmp26_ + 1);
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp27_ = is_fixed;
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp27_) {
#line 2662 "sudoku-board.c"
		gint _tmp28_ = 0;
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp28_ = self->priv->_fixed;
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_fixed (self, _tmp28_ + 1);
#line 2668 "sudoku-board.c"
	}
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp29_ = self->priv->possible_in_row;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp29__length1 = self->priv->possible_in_row_length1;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp29__length2 = self->priv->possible_in_row_length2;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp30_ = row;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp31_ = val;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + (_tmp31_ - 1)];
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp32_) {
#line 2684 "sudoku-board.c"
		GeeList* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gpointer _tmp35_ = NULL;
		GeeList* _tmp36_ = NULL;
		gint _tmp37_ = 0;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp33_ = self->coords_for_row;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp34_ = row;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp35_ = gee_list_get (_tmp33_, _tmp34_);
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp36_ = (GeeList*) _tmp35_;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp37_ = val;
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp36_, _tmp37_);
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp36_);
#line 2704 "sudoku-board.c"
	}
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp38_ = self->priv->possible_in_col;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp38__length1 = self->priv->possible_in_col_length1;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp38__length2 = self->priv->possible_in_col_length2;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp39_ = col;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp40_ = val;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + (_tmp40_ - 1)];
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp41_) {
#line 2720 "sudoku-board.c"
		GeeList* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gpointer _tmp44_ = NULL;
		GeeList* _tmp45_ = NULL;
		gint _tmp46_ = 0;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp42_ = self->coords_for_col;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp43_ = col;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp44_ = gee_list_get (_tmp42_, _tmp43_);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp45_ = (GeeList*) _tmp44_;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp46_ = val;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp45_, _tmp46_);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp45_);
#line 2740 "sudoku-board.c"
	}
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp47_ = self->priv->possible_in_block;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp47__length1 = self->priv->possible_in_block_length1;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp47__length2 = self->priv->possible_in_block_length2;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp47__length3 = self->priv->possible_in_block_length3;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp48_ = row;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp49_ = self->priv->_block_cols;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp50_ = col;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp51_ = self->priv->_block_rows;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp52_ = val;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp53_ = _tmp47_[((((_tmp48_ / _tmp49_) * _tmp47__length2) + (_tmp50_ / _tmp51_)) * _tmp47__length3) + (_tmp52_ - 1)];
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp53_) {
#line 2764 "sudoku-board.c"
		GeeMap* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		Coord _tmp59_ = {0};
		gpointer _tmp60_ = NULL;
		GeeList* _tmp61_ = NULL;
		gint _tmp62_ = 0;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp54_ = self->coords_for_block;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp55_ = row;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp56_ = self->priv->_block_cols;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp57_ = col;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp58_ = self->priv->_block_rows;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp59_, _tmp55_ / _tmp56_, _tmp57_ / _tmp58_);
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp60_ = gee_map_get (_tmp54_, &_tmp59_);
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp61_ = (GeeList*) _tmp60_;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp62_ = val;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp61_, _tmp62_);
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp61_);
#line 2796 "sudoku-board.c"
	}
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp63_ = val;
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	val = _tmp63_ - 1;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp64_ = self->priv->possible_in_row;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp64__length1 = self->priv->possible_in_row_length1;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp64__length2 = self->priv->possible_in_row_length2;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp65_ = row;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp66_ = val;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp64_[(_tmp65_ * _tmp64__length2) + _tmp66_] = FALSE;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp67_ = _tmp64_[(_tmp65_ * _tmp64__length2) + _tmp66_];
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68_ = self->priv->possible_in_col;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68__length1 = self->priv->possible_in_col_length1;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68__length2 = self->priv->possible_in_col_length2;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp69_ = col;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp70_ = val;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68_[(_tmp69_ * _tmp68__length2) + _tmp70_] = FALSE;
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp71_ = _tmp68_[(_tmp69_ * _tmp68__length2) + _tmp70_];
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72_ = self->priv->possible_in_block;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72__length1 = self->priv->possible_in_block_length1;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72__length2 = self->priv->possible_in_block_length2;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72__length3 = self->priv->possible_in_block_length3;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp73_ = row;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp74_ = self->priv->_block_cols;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp75_ = col;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp76_ = self->priv->_block_rows;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp77_ = val;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72_[((((_tmp73_ / _tmp74_) * _tmp72__length2) + (_tmp75_ / _tmp76_)) * _tmp72__length3) + _tmp77_] = FALSE;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp78_ = _tmp72_[((((_tmp73_ / _tmp74_) * _tmp72__length2) + (_tmp75_ / _tmp76_)) * _tmp72__length3) + _tmp77_];
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp79_ = sudoku_board_get_complete (self);
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp80_ = _tmp79_;
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp80_) {
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_signal_emit_by_name (self, "completed");
#line 2860 "sudoku-board.c"
	}
}


void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val) {
	gint _tmp0_ = 0;
#line 306 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = val;
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp0_ == 0) {
#line 2873 "sudoku-board.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
#line 309 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = row;
#line 309 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = col;
#line 309 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove (self, _tmp1_, _tmp2_, FALSE);
#line 2882 "sudoku-board.c"
	} else {
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = val;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		if (_tmp4_ > 0) {
#line 2890 "sudoku-board.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp5_ = val;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = sudoku_board_get_max_val (self);
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = _tmp6_;
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = _tmp5_ <= _tmp7_;
#line 2902 "sudoku-board.c"
		} else {
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = FALSE;
#line 2906 "sudoku-board.c"
		}
#line 310 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		if (_tmp3_) {
#line 2910 "sudoku-board.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = row;
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = col;
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp10_ = val;
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			sudoku_board_insert (self, _tmp8_, _tmp9_, _tmp10_, FALSE);
#line 2922 "sudoku-board.c"
		} else {
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			g_assert_not_reached ();
#line 2926 "sudoku-board.c"
		}
	}
}


gint sudoku_board_get (SudokuBoard* self, gint row, gint col) {
	gint result = 0;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 316 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp3_;
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2958 "sudoku-board.c"
}


void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint previous_val = 0;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GeeSet* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Coord _tmp20_ = {0};
	gboolean _tmp21_ = FALSE;
	gint _tmp126_ = 0;
	gboolean _tmp127_ = FALSE;
#line 321 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp3_ == 0) {
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		return;
#line 3008 "sudoku-board.c"
	}
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = is_fixed;
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp4_) {
#line 3014 "sudoku-board.c"
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = self->is_fixed;
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = self->is_fixed_length1;
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length2 = self->is_fixed_length2;
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = row;
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = col;
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_vala_assert (!_tmp8_, "!this.is_fixed[row, col]");
#line 3035 "sudoku-board.c"
	}
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = self->cells;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length1 = self->cells_length1;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length2 = self->cells_length2;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = row;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = col;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	previous_val = _tmp12_;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = self->cells;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13__length1 = self->cells_length1;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13__length2 = self->cells_length2;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14_ = row;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = col;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_] = 0;
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = self->broken_coords;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = row;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = col;
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	coord_init (&_tmp20_, _tmp18_, _tmp19_);
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = gee_collection_contains ((GeeCollection*) _tmp17_, &_tmp20_);
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp21_) {
#line 3077 "sudoku-board.c"
		GeeList* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gpointer _tmp24_ = NULL;
		GeeList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		GeeList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gpointer _tmp29_ = NULL;
		GeeList* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		GeeMap* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		Coord _tmp37_ = {0};
		gpointer _tmp38_ = NULL;
		GeeList* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		GeeSet* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Coord _tmp44_ = {0};
		GeeList* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gpointer _tmp47_ = NULL;
		GeeList* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		GeeList* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		gpointer _tmp52_ = NULL;
		GeeList* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		GeeMap* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		Coord _tmp60_ = {0};
		gpointer _tmp61_ = NULL;
		GeeList* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		gboolean* _tmp64_ = NULL;
		gint _tmp64__length1 = 0;
		gint _tmp64__length2 = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		GeeList* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gpointer _tmp69_ = NULL;
		GeeList* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		GeeSet* _tmp72_ = NULL;
		GeeSet* _tmp73_ = NULL;
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gboolean _tmp76_ = FALSE;
		gboolean* _tmp77_ = NULL;
		gint _tmp77__length1 = 0;
		gint _tmp77__length2 = 0;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		GeeList* _tmp80_ = NULL;
		gint _tmp81_ = 0;
		gpointer _tmp82_ = NULL;
		GeeList* _tmp83_ = NULL;
		gint _tmp84_ = 0;
		GeeSet* _tmp85_ = NULL;
		GeeSet* _tmp86_ = NULL;
		gint _tmp87_ = 0;
		gint _tmp88_ = 0;
		gboolean _tmp89_ = FALSE;
		gboolean* _tmp90_ = NULL;
		gint _tmp90__length1 = 0;
		gint _tmp90__length2 = 0;
		gint _tmp90__length3 = 0;
		gint _tmp91_ = 0;
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		gint _tmp94_ = 0;
		gint _tmp95_ = 0;
		GeeMap* _tmp96_ = NULL;
		gint _tmp97_ = 0;
		gint _tmp98_ = 0;
		gint _tmp99_ = 0;
		gint _tmp100_ = 0;
		Coord _tmp101_ = {0};
		gpointer _tmp102_ = NULL;
		GeeList* _tmp103_ = NULL;
		gint _tmp104_ = 0;
		GeeSet* _tmp105_ = NULL;
		GeeSet* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
		gboolean _tmp109_ = FALSE;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp22_ = self->coords_for_row;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp23_ = row;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp24_ = gee_list_get (_tmp22_, _tmp23_);
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp25_ = (GeeList*) _tmp24_;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp26_ = previous_val;
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove_breakages_for (self, _tmp25_, _tmp26_);
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp25_);
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp27_ = self->coords_for_col;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp28_ = col;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp29_ = gee_list_get (_tmp27_, _tmp28_);
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp30_ = (GeeList*) _tmp29_;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp31_ = previous_val;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove_breakages_for (self, _tmp30_, _tmp31_);
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp30_);
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp32_ = self->coords_for_block;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp33_ = row;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp34_ = self->priv->_block_rows;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp35_ = col;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp36_ = self->priv->_block_cols;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp37_, _tmp33_ / _tmp34_, _tmp35_ / _tmp36_);
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp38_ = gee_map_get (_tmp32_, &_tmp37_);
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp39_ = (GeeList*) _tmp38_;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp40_ = previous_val;
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove_breakages_for (self, _tmp39_, _tmp40_);
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp39_);
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp41_ = self->broken_coords;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp42_ = row;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp43_ = col;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp44_, _tmp42_, _tmp43_);
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		gee_collection_remove ((GeeCollection*) _tmp41_, &_tmp44_);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp45_ = self->coords_for_row;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp46_ = row;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp47_ = gee_list_get (_tmp45_, _tmp46_);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp48_ = (GeeList*) _tmp47_;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp49_ = previous_val;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp48_, _tmp49_);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp48_);
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp50_ = self->coords_for_col;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp51_ = col;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp52_ = gee_list_get (_tmp50_, _tmp51_);
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp53_ = (GeeList*) _tmp52_;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp54_ = previous_val;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp53_, _tmp54_);
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp53_);
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp55_ = self->coords_for_block;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp56_ = row;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp57_ = self->priv->_block_rows;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp58_ = col;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp59_ = self->priv->_block_cols;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp60_, _tmp56_ / _tmp57_, _tmp58_ / _tmp59_);
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp61_ = gee_map_get (_tmp55_, &_tmp60_);
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp62_ = (GeeList*) _tmp61_;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp63_ = previous_val;
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp62_, _tmp63_);
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp62_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64_ = self->priv->possible_in_row;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64__length1 = self->priv->possible_in_row_length1;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64__length2 = self->priv->possible_in_row_length2;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp65_ = row;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp66_ = previous_val;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp67_ = self->coords_for_row;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp68_ = row;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp69_ = gee_list_get (_tmp67_, _tmp68_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp70_ = (GeeList*) _tmp69_;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp71_ = previous_val;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp72_ = sudoku_board_get_occurances (self, _tmp70_, _tmp71_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp73_ = _tmp72_;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp74_ = gee_collection_get_size ((GeeCollection*) _tmp73_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp75_ = _tmp74_;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64_[(_tmp65_ * _tmp64__length2) + (_tmp66_ - 1)] = _tmp75_ == 0;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp76_ = _tmp64_[(_tmp65_ * _tmp64__length2) + (_tmp66_ - 1)];
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp73_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp70_);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77_ = self->priv->possible_in_col;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77__length1 = self->priv->possible_in_col_length1;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77__length2 = self->priv->possible_in_col_length2;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp78_ = col;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp79_ = previous_val;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp80_ = self->coords_for_col;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp81_ = col;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp82_ = gee_list_get (_tmp80_, _tmp81_);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp83_ = (GeeList*) _tmp82_;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp84_ = previous_val;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp85_ = sudoku_board_get_occurances (self, _tmp83_, _tmp84_);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp86_ = _tmp85_;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp87_ = gee_collection_get_size ((GeeCollection*) _tmp86_);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp88_ = _tmp87_;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77_[(_tmp78_ * _tmp77__length2) + (_tmp79_ - 1)] = _tmp88_ == 0;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp89_ = _tmp77_[(_tmp78_ * _tmp77__length2) + (_tmp79_ - 1)];
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp86_);
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp83_);
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90_ = self->priv->possible_in_block;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90__length1 = self->priv->possible_in_block_length1;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90__length2 = self->priv->possible_in_block_length2;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90__length3 = self->priv->possible_in_block_length3;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp91_ = row;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp92_ = self->priv->_block_cols;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp93_ = col;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp94_ = self->priv->_block_rows;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp95_ = previous_val;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp96_ = self->coords_for_block;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp97_ = row;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp98_ = self->priv->_block_rows;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp99_ = col;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp100_ = self->priv->_block_cols;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp101_, _tmp97_ / _tmp98_, _tmp99_ / _tmp100_);
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp102_ = gee_map_get (_tmp96_, &_tmp101_);
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp103_ = (GeeList*) _tmp102_;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp104_ = previous_val;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp105_ = sudoku_board_get_occurances (self, _tmp103_, _tmp104_);
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp106_ = _tmp105_;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp107_ = gee_collection_get_size ((GeeCollection*) _tmp106_);
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp108_ = _tmp107_;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90_[((((_tmp91_ / _tmp92_) * _tmp90__length2) + (_tmp93_ / _tmp94_)) * _tmp90__length3) + (_tmp95_ - 1)] = _tmp108_ == 0;
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp109_ = _tmp90_[((((_tmp91_ / _tmp92_) * _tmp90__length2) + (_tmp93_ / _tmp94_)) * _tmp90__length3) + (_tmp95_ - 1)];
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp106_);
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp103_);
#line 3407 "sudoku-board.c"
	} else {
		gint _tmp110_ = 0;
		gboolean* _tmp111_ = NULL;
		gint _tmp111__length1 = 0;
		gint _tmp111__length2 = 0;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		gboolean _tmp114_ = FALSE;
		gboolean* _tmp115_ = NULL;
		gint _tmp115__length1 = 0;
		gint _tmp115__length2 = 0;
		gint _tmp116_ = 0;
		gint _tmp117_ = 0;
		gboolean _tmp118_ = FALSE;
		gboolean* _tmp119_ = NULL;
		gint _tmp119__length1 = 0;
		gint _tmp119__length2 = 0;
		gint _tmp119__length3 = 0;
		gint _tmp120_ = 0;
		gint _tmp121_ = 0;
		gint _tmp122_ = 0;
		gint _tmp123_ = 0;
		gint _tmp124_ = 0;
		gboolean _tmp125_ = FALSE;
#line 354 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp110_ = previous_val;
#line 354 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		previous_val = _tmp110_ - 1;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111_ = self->priv->possible_in_row;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111__length1 = self->priv->possible_in_row_length1;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111__length2 = self->priv->possible_in_row_length2;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp112_ = row;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp113_ = previous_val;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_] = TRUE;
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp114_ = _tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_];
#line 357 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115_ = self->priv->possible_in_col;
#line 357 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115__length1 = self->priv->possible_in_col_length1;
#line 357 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115__length2 = self->priv->possible_in_col_length2;
#line 357 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp116_ = col;
#line 357 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp117_ = previous_val;
#line 357 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_] = TRUE;
#line 357 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp118_ = _tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_];
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119_ = self->priv->possible_in_block;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119__length1 = self->priv->possible_in_block_length1;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119__length2 = self->priv->possible_in_block_length2;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119__length3 = self->priv->possible_in_block_length3;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp120_ = row;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp121_ = self->priv->_block_cols;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp122_ = col;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp123_ = self->priv->_block_rows;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp124_ = previous_val;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119_[((((_tmp120_ / _tmp121_) * _tmp119__length2) + (_tmp122_ / _tmp123_)) * _tmp119__length3) + _tmp124_] = TRUE;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp125_ = _tmp119_[((((_tmp120_ / _tmp121_) * _tmp119__length2) + (_tmp122_ / _tmp123_)) * _tmp119__length3) + _tmp124_];
#line 3486 "sudoku-board.c"
	}
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp126_ = self->priv->_filled;
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_filled (self, _tmp126_ - 1);
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp127_ = is_fixed;
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp127_) {
#line 3496 "sudoku-board.c"
		gint _tmp128_ = 0;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp128_ = self->priv->_fixed;
#line 364 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_fixed (self, _tmp128_ - 1);
#line 3502 "sudoku-board.c"
	}
}


gint sudoku_board_count_solutions_limited (SudokuBoard* self) {
	gint result = 0;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = qqwing_count_solutions_limited ((gint*) _tmp0_);
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp1_;
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3527 "sudoku-board.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return self ? g_object_ref (self) : NULL;
#line 3534 "sudoku-board.c"
}


GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val) {
	GeeSet* result = NULL;
	GeeSet* occurances = NULL;
	GeeHashSet* _tmp0_ = NULL;
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (coords != NULL, NULL);
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	occurances = (GeeSet*) _tmp0_;
#line 3550 "sudoku-board.c"
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp1_ = NULL;
		GeeList* _tmp2_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _coord_index = 0;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = coords;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_list = _tmp2_;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp3_ = _coord_list;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = _tmp4_;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_size = _tmp5_;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_index = -1;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		while (TRUE) {
#line 3578 "sudoku-board.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Coord coord = {0};
			GeeList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			Coord* _tmp12_ = NULL;
			Coord _tmp13_ = {0};
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			Coord _tmp15_ = {0};
			gint _tmp16_ = 0;
			Coord _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = _coord_index;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_coord_index = _tmp6_ + 1;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = _coord_index;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = _coord_size;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				break;
#line 3609 "sudoku-board.c"
			}
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = _coord_list;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp10_ = _coord_index;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp12_ = (Coord*) _tmp11_;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp13_ = *_tmp12_;
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_coord_free0 (_tmp12_);
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			coord = _tmp13_;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14_ = self->cells;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length1 = self->cells_length1;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length2 = self->cells_length2;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp15_ = coord;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp16_ = _tmp15_.row;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp17_ = coord;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp18_ = _tmp17_.col;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp20_ = val;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			if (_tmp19_ == _tmp20_) {
#line 3645 "sudoku-board.c"
				GeeSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp21_ = occurances;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp22_ = coord;
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_add ((GeeCollection*) _tmp21_, &_tmp22_);
#line 3654 "sudoku-board.c"
			}
		}
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_coord_list);
#line 3659 "sudoku-board.c"
	}
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = occurances;
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3665 "sudoku-board.c"
}


gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
#line 382 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->coords_for_row;
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (GeeList*) _tmp2_;
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = val;
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp5_;
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = _tmp7_;
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = _tmp8_ != 0;
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp6_);
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp3_);
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp9_;
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3711 "sudoku-board.c"
}


gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->coords_for_col;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = col;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (GeeList*) _tmp2_;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = val;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp5_;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = _tmp7_;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = _tmp8_ != 0;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp6_);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp3_);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp9_;
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3757 "sudoku-board.c"
}


gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val) {
	gboolean result = FALSE;
	GeeMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (block != NULL, FALSE);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->coords_for_block;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = *block;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (GeeList*) _tmp2_;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = val;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp5_;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = _tmp7_;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = _tmp8_ != 0;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp6_);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp3_);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp9_;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3805 "sudoku-board.c"
}


static void sudoku_board_remove_breakages_for (SudokuBoard* self, GeeList* coords, gint val) {
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (coords != NULL);
#line 3814 "sudoku-board.c"
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _coord_index = 0;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = coords;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_list = _tmp1_;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = _coord_list;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = _tmp3_;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_size = _tmp4_;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_index = -1;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		while (TRUE) {
#line 3842 "sudoku-board.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Coord coord = {0};
			GeeList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Coord* _tmp11_ = NULL;
			Coord _tmp12_ = {0};
			gboolean _tmp13_ = FALSE;
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			Coord _tmp15_ = {0};
			gint _tmp16_ = 0;
			Coord _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp5_ = _coord_index;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_coord_index = _tmp5_ + 1;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = _coord_index;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = _coord_size;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				break;
#line 3874 "sudoku-board.c"
			}
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = _coord_list;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = _coord_index;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp11_ = (Coord*) _tmp10_;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp12_ = *_tmp11_;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_coord_free0 (_tmp11_);
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			coord = _tmp12_;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14_ = self->cells;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length1 = self->cells_length1;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length2 = self->cells_length2;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp15_ = coord;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp16_ = _tmp15_.row;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp17_ = coord;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp18_ = _tmp17_.col;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp20_ = val;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			if (_tmp19_ == _tmp20_) {
#line 3910 "sudoku-board.c"
				GeeSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
				gboolean _tmp23_ = FALSE;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp21_ = self->broken_coords;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp22_ = coord;
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp23_ = gee_collection_contains ((GeeCollection*) _tmp21_, &_tmp22_);
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = _tmp23_;
#line 3922 "sudoku-board.c"
			} else {
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = FALSE;
#line 3926 "sudoku-board.c"
			}
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			if (_tmp13_) {
#line 3930 "sudoku-board.c"
				GeeSet* _tmp24_ = NULL;
				Coord _tmp25_ = {0};
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp24_ = self->broken_coords;
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp25_ = coord;
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_remove ((GeeCollection*) _tmp24_, &_tmp25_);
#line 3939 "sudoku-board.c"
			}
		}
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_coord_list);
#line 3944 "sudoku-board.c"
	}
}


static void sudoku_board_mark_breakages_for (SudokuBoard* self, GeeList* coords, gint val) {
	GeeSet* occurances = NULL;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (coords != NULL);
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = coords;
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = val;
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = sudoku_board_get_occurances (self, _tmp0_, _tmp1_);
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	occurances = _tmp2_;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = occurances;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = _tmp4_;
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp5_ != 1) {
#line 3977 "sudoku-board.c"
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
#line 409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = self->broken_coords;
#line 409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = occurances;
#line 409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp7_);
#line 3986 "sudoku-board.c"
	}
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (occurances);
#line 3990 "sudoku-board.c"
}


void sudoku_board_to_initial_state (SudokuBoard* self) {
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 3997 "sudoku-board.c"
	{
		gint l1 = 0;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 4002 "sudoku-board.c"
		{
			gboolean _tmp0_ = FALSE;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = TRUE;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4009 "sudoku-board.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp0_) {
#line 4014 "sudoku-board.c"
					gint _tmp1_ = 0;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp1_ = l1;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp1_ + 1;
#line 4020 "sudoku-board.c"
				}
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp0_ = FALSE;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp2_ = l1;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = self->priv->_rows;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp2_ < _tmp3_)) {
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4032 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 4038 "sudoku-board.c"
					{
						gboolean _tmp4_ = FALSE;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp4_ = TRUE;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4045 "sudoku-board.c"
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gboolean* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gboolean _tmp11_ = FALSE;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp4_) {
#line 4056 "sudoku-board.c"
								gint _tmp5_ = 0;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp5_ = l2;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp5_ + 1;
#line 4062 "sudoku-board.c"
							}
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp4_ = FALSE;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp6_ = l2;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = self->priv->_cols;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp6_ < _tmp7_)) {
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4074 "sudoku-board.c"
							}
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = self->is_fixed;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8__length1 = self->is_fixed_length1;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8__length2 = self->is_fixed_length2;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = l1;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l2;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp11_) {
#line 4090 "sudoku-board.c"
								gint _tmp12_ = 0;
								gint _tmp13_ = 0;
#line 417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp12_ = l1;
#line 417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp13_ = l2;
#line 417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								sudoku_board_remove (self, _tmp12_, _tmp13_, FALSE);
#line 4099 "sudoku-board.c"
							}
						}
					}
				}
			}
		}
	}
}


void sudoku_board_print (SudokuBoard* self, gint indent) {
	FILE* _tmp22_ = NULL;
#line 420 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 4114 "sudoku-board.c"
	{
		gint l1 = 0;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 4119 "sudoku-board.c"
		{
			gboolean _tmp0_ = FALSE;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = TRUE;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4126 "sudoku-board.c"
				gint _tmp2_ = 0;
				FILE* _tmp21_ = NULL;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp0_) {
#line 4131 "sudoku-board.c"
					gint _tmp1_ = 0;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp1_ = l1;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp1_ + 1;
#line 4137 "sudoku-board.c"
				}
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp0_ = FALSE;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp2_ = l1;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp2_ < 9)) {
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4147 "sudoku-board.c"
				}
				{
					gint i = 0;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					i = 0;
#line 4153 "sudoku-board.c"
					{
						gboolean _tmp3_ = FALSE;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp3_ = TRUE;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4160 "sudoku-board.c"
							gint _tmp5_ = 0;
							gint _tmp6_ = 0;
							FILE* _tmp7_ = NULL;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp3_) {
#line 4166 "sudoku-board.c"
								gint _tmp4_ = 0;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp4_ = i;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								i = _tmp4_ + 1;
#line 4172 "sudoku-board.c"
							}
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp3_ = FALSE;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = i;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp6_ = indent;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp5_ < _tmp6_)) {
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4184 "sudoku-board.c"
							}
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = stdout;
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							fprintf (_tmp7_, " ");
#line 4190 "sudoku-board.c"
						}
					}
				}
				{
					gint l2 = 0;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 4198 "sudoku-board.c"
					{
						gboolean _tmp8_ = FALSE;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp8_ = TRUE;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4205 "sudoku-board.c"
							gint _tmp10_ = 0;
							gint* _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp8_) {
#line 4215 "sudoku-board.c"
								gint _tmp9_ = 0;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp9_ = l2;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp9_ + 1;
#line 4221 "sudoku-board.c"
							}
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = FALSE;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l2;
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp10_ < 9)) {
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4231 "sudoku-board.c"
							}
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = self->cells;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11__length1 = self->cells_length1;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11__length2 = self->cells_length2;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = l1;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp13_ = l2;
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp14_ != 0) {
#line 4247 "sudoku-board.c"
								FILE* _tmp15_ = NULL;
								gint* _tmp16_ = NULL;
								gint _tmp16__length1 = 0;
								gint _tmp16__length2 = 0;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp15_ = stdout;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16_ = self->cells;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16__length1 = self->cells_length1;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16__length2 = self->cells_length2;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp17_ = l1;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18_ = l2;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								fprintf (_tmp15_, "%d ", _tmp19_);
#line 4271 "sudoku-board.c"
							} else {
								FILE* _tmp20_ = NULL;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp20_ = stdout;
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								fprintf (_tmp20_, "  ");
#line 4278 "sudoku-board.c"
							}
						}
					}
				}
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp21_ = stdout;
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				fprintf (_tmp21_, "\n");
#line 4287 "sudoku-board.c"
			}
		}
	}
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = stdout;
#line 435 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	fflush (_tmp22_);
#line 4295 "sudoku-board.c"
}


void sudoku_board_get_string (SudokuBoard* self) {
	FILE* _tmp0_ = NULL;
	FILE* _tmp18_ = NULL;
#line 438 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = stdout;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	fprintf (_tmp0_, "[ ");
#line 4308 "sudoku-board.c"
	{
		gint l1 = 0;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 4313 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4320 "sudoku-board.c"
				gint _tmp3_ = 0;
				FILE* _tmp4_ = NULL;
				FILE* _tmp15_ = NULL;
				gint _tmp16_ = 0;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4327 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = l1;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp2_ + 1;
#line 4333 "sudoku-board.c"
				}
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = l1;
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ < 9)) {
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4343 "sudoku-board.c"
				}
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = stdout;
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				fprintf (_tmp4_, "[ ");
#line 4349 "sudoku-board.c"
				{
					gint l2 = 0;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 4354 "sudoku-board.c"
					{
						gboolean _tmp5_ = FALSE;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp5_ = TRUE;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4361 "sudoku-board.c"
							gint _tmp7_ = 0;
							FILE* _tmp8_ = NULL;
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp5_) {
#line 4373 "sudoku-board.c"
								gint _tmp6_ = 0;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp6_ = l2;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp6_ + 1;
#line 4379 "sudoku-board.c"
							}
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = FALSE;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = l2;
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp7_ < 9)) {
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4389 "sudoku-board.c"
							}
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = stdout;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = self->cells;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length1 = self->cells_length1;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length2 = self->cells_length2;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l1;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = l2;
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							fprintf (_tmp8_, "%d", _tmp12_);
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp13_ = l2;
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp13_ != 8) {
#line 4411 "sudoku-board.c"
								FILE* _tmp14_ = NULL;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14_ = stdout;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								fprintf (_tmp14_, ",");
#line 4417 "sudoku-board.c"
							}
						}
					}
				}
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp15_ = stdout;
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				fprintf (_tmp15_, " ]");
#line 451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp16_ = l1;
#line 451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp16_ != 8) {
#line 4430 "sudoku-board.c"
					FILE* _tmp17_ = NULL;
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp17_ = stdout;
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					fprintf (_tmp17_, ",");
#line 4436 "sudoku-board.c"
				}
			}
		}
	}
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = stdout;
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	fprintf (_tmp18_, " ]");
#line 4445 "sudoku-board.c"
}


gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state) {
	gchar* result = NULL;
	gchar* board_string = NULL;
	gchar* _tmp0_ = NULL;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = g_strdup ("");
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board_string = _tmp0_;
#line 4459 "sudoku-board.c"
	{
		gint i = 0;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		i = 0;
#line 4464 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4471 "sudoku-board.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4476 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = i;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					i = _tmp2_ + 1;
#line 4482 "sudoku-board.c"
				}
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = i;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = self->priv->_rows;
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4494 "sudoku-board.c"
				}
				{
					gint j = 0;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					j = 0;
#line 4500 "sudoku-board.c"
					{
						gboolean _tmp5_ = FALSE;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp5_ = TRUE;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4507 "sudoku-board.c"
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gboolean* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gboolean _tmp12_ = FALSE;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp5_) {
#line 4518 "sudoku-board.c"
								gint _tmp6_ = 0;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp6_ = j;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								j = _tmp6_ + 1;
#line 4524 "sudoku-board.c"
							}
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = FALSE;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = j;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = self->priv->_cols;
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp7_ < _tmp8_)) {
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4536 "sudoku-board.c"
							}
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = self->is_fixed;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length1 = self->is_fixed_length1;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length2 = self->is_fixed_length2;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = i;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = j;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp12_) {
#line 4552 "sudoku-board.c"
								const gchar* _tmp13_ = NULL;
								gint* _tmp14_ = NULL;
								gint _tmp14__length1 = 0;
								gint _tmp14__length2 = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gchar* _tmp18_ = NULL;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_ = NULL;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp13_ = board_string;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14_ = self->cells;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14__length1 = self->cells_length1;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14__length2 = self->cells_length2;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp15_ = i;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16_ = j;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18_ = g_strdup_printf ("%i", _tmp17_);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp19_ = _tmp18_;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp20_ = g_strconcat (_tmp13_, _tmp19_, NULL);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (board_string);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								board_string = _tmp20_;
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (_tmp19_);
#line 4589 "sudoku-board.c"
							} else {
								gchar* _tmp21_ = NULL;
								gboolean _tmp22_ = FALSE;
								const gchar* _tmp29_ = NULL;
								gchar* _tmp30_ = NULL;
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp22_ = get_original_state;
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								if (_tmp22_) {
#line 4599 "sudoku-board.c"
									gchar* _tmp23_ = NULL;
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp23_ = g_strdup ("0");
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_g_free0 (_tmp21_);
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp21_ = _tmp23_;
#line 4607 "sudoku-board.c"
								} else {
									gint* _tmp24_ = NULL;
									gint _tmp24__length1 = 0;
									gint _tmp24__length2 = 0;
									gint _tmp25_ = 0;
									gint _tmp26_ = 0;
									gint _tmp27_ = 0;
									gchar* _tmp28_ = NULL;
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp24_ = self->cells;
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp24__length1 = self->cells_length1;
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp24__length2 = self->cells_length2;
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp25_ = i;
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp26_ = j;
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp28_ = g_strdup_printf ("%i", _tmp27_);
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_g_free0 (_tmp21_);
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp21_ = _tmp28_;
#line 4634 "sudoku-board.c"
								}
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp29_ = board_string;
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp30_ = g_strconcat (_tmp29_, _tmp21_, NULL);
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (board_string);
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								board_string = _tmp30_;
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (_tmp21_);
#line 4646 "sudoku-board.c"
							}
						}
					}
				}
			}
		}
	}
#line 470 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = board_string;
#line 470 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4658 "sudoku-board.c"
}


static gint* _vala_array_dup8 (gint* self, int length) {
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gint));
#line 4665 "sudoku-board.c"
}


gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup8 (_tmp0_, _tmp0__length1 * _tmp0__length2) : ((gpointer) _tmp0_);
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1__length1 = _tmp0__length1;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1__length2 = _tmp0__length2;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2__length1 = _tmp1__length1;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2__length2 = _tmp1__length2;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length1) {
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		*result_length1 = _tmp2__length1;
#line 4704 "sudoku-board.c"
	}
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length2) {
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		*result_length2 = _tmp2__length2;
#line 4710 "sudoku-board.c"
	}
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp2_;
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4716 "sudoku-board.c"
}


GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self) {
	GeeHashMap* result = NULL;
	GeeHashMap* possibilities = NULL;
	GeeHashMap* _tmp0_ = NULL;
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = _tmp0_;
#line 4730 "sudoku-board.c"
	{
		gint l1 = 0;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 4735 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4742 "sudoku-board.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4747 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = l1;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp2_ + 1;
#line 4753 "sudoku-board.c"
				}
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = l1;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = self->priv->_rows;
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4765 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 4771 "sudoku-board.c"
					{
						gboolean _tmp5_ = FALSE;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp5_ = TRUE;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4778 "sudoku-board.c"
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp5_) {
#line 4789 "sudoku-board.c"
								gint _tmp6_ = 0;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp6_ = l2;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp6_ + 1;
#line 4795 "sudoku-board.c"
							}
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = FALSE;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = l2;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = self->priv->_cols;
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp7_ < _tmp8_)) {
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4807 "sudoku-board.c"
							}
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = self->cells;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length1 = self->cells_length1;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length2 = self->cells_length2;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l1;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = l2;
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp12_ == 0) {
#line 4823 "sudoku-board.c"
								GeeList* possArrayList = NULL;
								GeeArrayList* _tmp13_ = NULL;
								gint* possArray = NULL;
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint* _tmp17_ = NULL;
								gint possArray_length1 = 0;
								gint _possArray_size_ = 0;
								gint* _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								GeeHashMap* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								Coord _tmp24_ = {0};
								GeeList* _tmp25_ = NULL;
#line 487 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp13_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
#line 487 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								possArrayList = (GeeList*) _tmp13_;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14_ = l1;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp15_ = l2;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp17_ = sudoku_board_get_possibilities (self, _tmp14_, _tmp15_, &_tmp16_);
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								possArray = _tmp17_;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								possArray_length1 = _tmp16_;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_possArray_size_ = possArray_length1;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18_ = possArray;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18__length1 = possArray_length1;
#line 4860 "sudoku-board.c"
								{
									gint* i_collection = NULL;
									gint i_collection_length1 = 0;
									gint _i_collection_size_ = 0;
									gint i_it = 0;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									i_collection = _tmp18_;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									i_collection_length1 = _tmp18__length1;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									for (i_it = 0; i_it < _tmp18__length1; i_it = i_it + 1) {
#line 4872 "sudoku-board.c"
										gint i = 0;
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										i = i_collection[i_it];
#line 4876 "sudoku-board.c"
										{
											GeeList* _tmp19_ = NULL;
											gint _tmp20_ = 0;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											_tmp19_ = possArrayList;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											_tmp20_ = i;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											gee_collection_add ((GeeCollection*) _tmp19_, (gpointer) ((gintptr) _tmp20_));
#line 4886 "sudoku-board.c"
										}
									}
								}
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp21_ = possibilities;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp22_ = l1;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp23_ = l2;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								coord_init (&_tmp24_, _tmp22_, _tmp23_);
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp25_ = possArrayList;
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, &_tmp24_, _tmp25_);
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								possArray = (g_free (possArray), NULL);
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_g_object_unref0 (possArrayList);
#line 4906 "sudoku-board.c"
							}
						}
					}
				}
			}
		}
	}
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = possibilities;
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4918 "sudoku-board.c"
}


gboolean sudoku_board_is_finished (SudokuBoard* self) {
	gboolean result = FALSE;
	gchar* board_string = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* finishgame_file = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GFile* file = NULL;
	GFile* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = sudoku_board_to_string (self, TRUE);
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = g_strconcat (_tmp1_, ".save", NULL);
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_free0 (_tmp1_);
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board_string = _tmp3_;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = sudoku_saver_get_finishgame_dir ();
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = _tmp4_;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, board_string, NULL);
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	finishgame_file = _tmp6_;
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = g_file_new_for_path (finishgame_file);
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	file = _tmp7_;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = g_file_query_exists (file, NULL);
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp8_;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (file);
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_free0 (finishgame_file);
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_free0 (board_string);
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4974 "sudoku-board.c"
}


gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_ = NULL;
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = g_strdup ("");
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	s = _tmp0_;
#line 4988 "sudoku-board.c"
	{
		gint i = 0;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		i = 1;
#line 4993 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 5000 "sudoku-board.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp6__length2 = 0;
				gint _tmp6__length3 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gboolean _tmp10_ = FALSE;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 5014 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = i;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					i = _tmp2_ + 1;
#line 5020 "sudoku-board.c"
				}
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = i;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = sudoku_board_get_max_val (self);
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5_ = _tmp4_;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ <= _tmp5_)) {
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 5034 "sudoku-board.c"
				}
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6_ = self->priv->earmarks;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6__length1 = self->priv->earmarks_length1;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6__length2 = self->priv->earmarks_length2;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6__length3 = self->priv->earmarks_length3;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = row;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_ = col;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = i;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp10_ = _tmp6_[(((_tmp7_ * _tmp6__length2) + _tmp8_) * _tmp6__length3) + (_tmp9_ - 1)];
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp10_) {
#line 5054 "sudoku-board.c"
					const gchar* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp11_ = s;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp12_ = i;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp13_ = g_strdup_printf ("%i", _tmp12_);
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp14_ = _tmp13_;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_g_free0 (s);
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					s = _tmp15_;
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_g_free0 (_tmp14_);
#line 5076 "sudoku-board.c"
				}
			}
		}
	}
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = s;
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5085 "sudoku-board.c"
}


gdouble sudoku_board_get_previous_played_time (SudokuBoard* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_previous_played_time;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5100 "sudoku-board.c"
}


void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_previous_played_time = _tmp0_;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "previous-played-time");
#line 5114 "sudoku-board.c"
}


DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self) {
	DifficultyCategory result;
	DifficultyCategory _tmp0_ = 0;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_difficulty_category;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5129 "sudoku-board.c"
}


void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value) {
	DifficultyCategory _tmp0_ = 0;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_difficulty_category = _tmp0_;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "difficulty-category");
#line 5143 "sudoku-board.c"
}


gint sudoku_board_get_block_rows (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_rows;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5158 "sudoku-board.c"
}


static void sudoku_board_set_block_rows (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_block_rows = _tmp0_;
#line 42 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "block-rows");
#line 5172 "sudoku-board.c"
}


gint sudoku_board_get_block_cols (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_cols;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5187 "sudoku-board.c"
}


static void sudoku_board_set_block_cols (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_block_cols = _tmp0_;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "block-cols");
#line 5201 "sudoku-board.c"
}


gint sudoku_board_get_rows (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_rows;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5216 "sudoku-board.c"
}


static void sudoku_board_set_rows (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_rows = _tmp0_;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "rows");
#line 5230 "sudoku-board.c"
}


gint sudoku_board_get_cols (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_cols;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5245 "sudoku-board.c"
}


static void sudoku_board_set_cols (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_cols = _tmp0_;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "cols");
#line 5259 "sudoku-board.c"
}


gint sudoku_board_get_max_val (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_rows;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_block_cols;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_ * _tmp1_;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5277 "sudoku-board.c"
}


gboolean sudoku_board_get_broken (SudokuBoard* self) {
	gboolean result;
	GeeSet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->broken_coords;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp2_ != 0;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5298 "sudoku-board.c"
}


gint sudoku_board_get_filled (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_filled;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5313 "sudoku-board.c"
}


static void sudoku_board_set_filled (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_filled = _tmp0_;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "filled");
#line 5327 "sudoku-board.c"
}


gint sudoku_board_get_fixed (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_fixed;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5342 "sudoku-board.c"
}


static void sudoku_board_set_fixed (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_fixed = _tmp0_;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "fixed");
#line 5356 "sudoku-board.c"
}


gint sudoku_board_get_size (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_rows;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_cols;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_ * _tmp1_;
#line 72 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5374 "sudoku-board.c"
}


gboolean sudoku_board_get_complete (SudokuBoard* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_filled;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = self->priv->_cols;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->priv->_rows;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp1_ == (_tmp2_ * _tmp3_)) {
#line 5394 "sudoku-board.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = sudoku_board_get_broken (self);
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = _tmp4_;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = !_tmp5_;
#line 5403 "sudoku-board.c"
	} else {
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 5407 "sudoku-board.c"
	}
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5413 "sudoku-board.c"
}


static void sudoku_board_class_init (SudokuBoardClass * klass) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_type_class_add_private (klass, sizeof (SudokuBoardPrivate));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_board_get_property;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_board_set_property;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_board_finalize;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_PREVIOUS_PLAYED_TIME, g_param_spec_double ("previous-played-time", "previous-played-time", "previous-played-time", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_DIFFICULTY_CATEGORY, g_param_spec_enum ("difficulty-category", "difficulty-category", "difficulty-category", TYPE_DIFFICULTY_CATEGORY, DIFFICULTY_CATEGORY_UNKNOWN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_ROWS, g_param_spec_int ("block-rows", "block-rows", "block-rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_COLS, g_param_spec_int ("block-cols", "block-cols", "block-cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_ROWS, g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COLS, g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_MAX_VAL, g_param_spec_int ("max-val", "max-val", "max-val", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BROKEN, g_param_spec_boolean ("broken", "broken", "broken", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FILLED, g_param_spec_int ("filled", "filled", "filled", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FIXED, g_param_spec_int ("fixed", "fixed", "fixed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COMPLETE, g_param_spec_boolean ("complete", "complete", "complete", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_signal_new ("completed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 5454 "sudoku-board.c"
}


static void sudoku_board_instance_init (SudokuBoard * self) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv = SUDOKU_BOARD_GET_PRIVATE (self);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_previous_played_time = (gdouble) 0;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_difficulty_category = DIFFICULTY_CATEGORY_UNKNOWN;
#line 5465 "sudoku-board.c"
}


static void sudoku_board_finalize (GObject* obj) {
	SudokuBoard * self;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_BOARD, SudokuBoard);
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->cells = (g_free (self->cells), NULL);
#line 29 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed = (g_free (self->is_fixed), NULL);
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
#line 34 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->broken_coords);
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_col);
#line 99 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_row);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_block);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (sudoku_board_parent_class)->finalize (obj);
#line 5495 "sudoku-board.c"
}


GType sudoku_board_get_type (void) {
	static volatile gsize sudoku_board_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_board_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuBoard), 0, (GInstanceInitFunc) sudoku_board_instance_init, NULL };
		GType sudoku_board_type_id;
		sudoku_board_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuBoard", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_board_type_id__volatile, sudoku_board_type_id);
	}
	return sudoku_board_type_id__volatile;
}


static void _vala_sudoku_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	switch (property_id) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_double (value, sudoku_board_get_previous_played_time (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_enum (value, sudoku_board_get_difficulty_category (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BLOCK_ROWS:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_block_rows (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BLOCK_COLS:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_block_cols (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_ROWS:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_rows (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_COLS:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_cols (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_MAX_VAL:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_max_val (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BROKEN:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_boolean (value, sudoku_board_get_broken (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_FILLED:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_filled (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_FIXED:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_fixed (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_SIZE:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_size (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_COMPLETE:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_boolean (value, sudoku_board_get_complete (self));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5588 "sudoku-board.c"
		default:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5594 "sudoku-board.c"
	}
}


static void _vala_sudoku_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	switch (property_id) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_previous_played_time (self, g_value_get_double (value));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_difficulty_category (self, g_value_get_enum (value));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BLOCK_ROWS:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_block_rows (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BLOCK_COLS:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_block_cols (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_ROWS:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_rows (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_COLS:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_cols (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_FILLED:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_filled (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_FIXED:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_fixed (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5652 "sudoku-board.c"
		default:
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5658 "sudoku-board.c"
	}
}


GType house_get_type (void) {
	static volatile gsize house_type_id__volatile = 0;
	if (g_once_init_enter (&house_type_id__volatile)) {
		static const GEnumValue values[] = {{HOUSE_ROW, "HOUSE_ROW", "row"}, {HOUSE_COLUMN, "HOUSE_COLUMN", "column"}, {HOUSE_BLOCK, "HOUSE_BLOCK", "block"}, {0, NULL, NULL}};
		GType house_type_id;
		house_type_id = g_enum_register_static ("House", values);
		g_once_init_leave (&house_type_id__volatile, house_type_id);
	}
	return house_type_id__volatile;
}


void coord_init (Coord *self, gint row, gint col) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	memset (self, 0, sizeof (Coord));
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = row;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	(*self).row = _tmp0_;
#line 533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = col;
#line 533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	(*self).col = _tmp1_;
#line 5688 "sudoku-board.c"
}


gint coord_hash (Coord* coord) {
	gint result = 0;
	Coord _tmp0_ = {0};
	gint _tmp1_ = 0;
	Coord _tmp2_ = {0};
	gint _tmp3_ = 0;
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (coord != NULL, 0);
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = *coord;
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_.row;
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = *coord;
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_.col;
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = (_tmp1_ * 33) ^ _tmp3_;
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5712 "sudoku-board.c"
}


gboolean coord_equal (Coord* a, Coord* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Coord _tmp1_ = {0};
	gint _tmp2_ = 0;
	Coord _tmp3_ = {0};
	gint _tmp4_ = 0;
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = *a;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_.row;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = *b;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_.row;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp2_ == _tmp4_) {
#line 5737 "sudoku-board.c"
		Coord _tmp5_ = {0};
		gint _tmp6_ = 0;
		Coord _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = *a;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = _tmp5_.col;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = *b;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = _tmp7_.col;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = _tmp6_ == _tmp8_;
#line 5752 "sudoku-board.c"
	} else {
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 5756 "sudoku-board.c"
	}
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5762 "sudoku-board.c"
}


Coord* coord_dup (const Coord* self) {
	Coord* dup;
#line 525 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	dup = g_new0 (Coord, 1);
#line 525 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	memcpy (dup, self, sizeof (Coord));
#line 525 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return dup;
#line 5774 "sudoku-board.c"
}


void coord_free (Coord* self) {
#line 525 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_free (self);
#line 5781 "sudoku-board.c"
}


GType coord_get_type (void) {
	static volatile gsize coord_type_id__volatile = 0;
	if (g_once_init_enter (&coord_type_id__volatile)) {
		GType coord_type_id;
		coord_type_id = g_boxed_type_register_static ("Coord", (GBoxedCopyFunc) coord_dup, (GBoxedFreeFunc) coord_free);
		g_once_init_leave (&coord_type_id__volatile, coord_type_id);
	}
	return coord_type_id__volatile;
}


void cell_init (Cell *self, Coord* coord, gint val) {
	Coord _tmp0_ = {0};
	gint _tmp1_ = 0;
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (coord != NULL);
#line 552 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	memset (self, 0, sizeof (Cell));
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = *coord;
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	(*self).coord = _tmp0_;
#line 555 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = val;
#line 555 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	(*self).val = _tmp1_;
#line 5811 "sudoku-board.c"
}


gint cell_hash (Cell* cell) {
	gint result = 0;
	Cell _tmp0_ = {0};
	Coord _tmp1_ = {0};
	gint _tmp2_ = 0;
	Cell _tmp3_ = {0};
	gint _tmp4_ = 0;
#line 558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (cell != NULL, 0);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = *cell;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_.coord;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = coord_hash (&_tmp1_);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = *cell;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_.val;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = (_tmp2_ * 33) ^ _tmp4_;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5838 "sudoku-board.c"
}


gboolean cell_equal (Cell* a, Cell* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Cell _tmp1_ = {0};
	Coord _tmp2_ = {0};
	Cell _tmp3_ = {0};
	Coord _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = *a;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_.coord;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = *b;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_.coord;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = coord_equal (&_tmp2_, &_tmp4_);
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp5_) {
#line 5866 "sudoku-board.c"
		Cell _tmp6_ = {0};
		gint _tmp7_ = 0;
		Cell _tmp8_ = {0};
		gint _tmp9_ = 0;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = *a;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = _tmp6_.val;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = *b;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp9_ = _tmp8_.val;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = _tmp7_ == _tmp9_;
#line 5881 "sudoku-board.c"
	} else {
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 5885 "sudoku-board.c"
	}
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5891 "sudoku-board.c"
}


Cell* cell_dup (const Cell* self) {
	Cell* dup;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	dup = g_new0 (Cell, 1);
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	memcpy (dup, self, sizeof (Cell));
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return dup;
#line 5903 "sudoku-board.c"
}


void cell_free (Cell* self) {
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_free (self);
#line 5910 "sudoku-board.c"
}


GType cell_get_type (void) {
	static volatile gsize cell_type_id__volatile = 0;
	if (g_once_init_enter (&cell_type_id__volatile)) {
		GType cell_type_id;
		cell_type_id = g_boxed_type_register_static ("Cell", (GBoxedCopyFunc) cell_dup, (GBoxedFreeFunc) cell_free);
		g_once_init_leave (&cell_type_id__volatile, cell_type_id);
	}
	return cell_type_id__volatile;
}


gchar* difficulty_category_to_string (DifficultyCategory self) {
	gchar* result = NULL;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	switch (self) {
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_UNKNOWN:
#line 5931 "sudoku-board.c"
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = _ ("Unknown Difficulty");
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = g_strdup (_tmp0_);
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp1_;
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5943 "sudoku-board.c"
		}
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_EASY:
#line 5947 "sudoku-board.c"
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp2_ = _ ("Easy Difficulty");
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp3_;
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5959 "sudoku-board.c"
		}
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_MEDIUM:
#line 5963 "sudoku-board.c"
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp4_ = _ ("Medium Difficulty");
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp5_ = g_strdup (_tmp4_);
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp5_;
#line 587 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5975 "sudoku-board.c"
		}
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_HARD:
#line 5979 "sudoku-board.c"
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = _ ("Hard Difficulty");
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp7_;
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5991 "sudoku-board.c"
		}
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_VERY_HARD:
#line 5995 "sudoku-board.c"
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = _ ("Very Hard Difficulty");
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = g_strdup (_tmp8_);
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp9_;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 6007 "sudoku-board.c"
		}
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_CUSTOM:
#line 6011 "sudoku-board.c"
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
#line 593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp10_ = _ ("Custom Puzzle");
#line 593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp11_ = g_strdup (_tmp10_);
#line 593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp11_;
#line 593 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 6023 "sudoku-board.c"
		}
		default:
		{
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			g_assert_not_reached ();
#line 6029 "sudoku-board.c"
		}
	}
}


gchar* difficulty_category_to_untranslated_string (DifficultyCategory self) {
	gchar* result = NULL;
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	switch (self) {
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_UNKNOWN:
#line 6041 "sudoku-board.c"
		{
			gchar* _tmp0_ = NULL;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = g_strdup ("Unknown Difficulty");
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp0_;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 6050 "sudoku-board.c"
		}
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_EASY:
#line 6054 "sudoku-board.c"
		{
			gchar* _tmp1_ = NULL;
#line 606 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = g_strdup ("Easy Difficulty");
#line 606 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp1_;
#line 606 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 6063 "sudoku-board.c"
		}
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_MEDIUM:
#line 6067 "sudoku-board.c"
		{
			gchar* _tmp2_ = NULL;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp2_ = g_strdup ("Medium Difficulty");
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp2_;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 6076 "sudoku-board.c"
		}
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_HARD:
#line 6080 "sudoku-board.c"
		{
			gchar* _tmp3_ = NULL;
#line 610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = g_strdup ("Hard Difficulty");
#line 610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp3_;
#line 610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 6089 "sudoku-board.c"
		}
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_VERY_HARD:
#line 6093 "sudoku-board.c"
		{
			gchar* _tmp4_ = NULL;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp4_ = g_strdup ("Very Hard Difficulty");
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp4_;
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 6102 "sudoku-board.c"
		}
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_CUSTOM:
#line 6106 "sudoku-board.c"
		{
			gchar* _tmp5_ = NULL;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp5_ = g_strdup ("Custom Puzzle");
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp5_;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 6115 "sudoku-board.c"
		}
		default:
		{
#line 616 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			g_assert_not_reached ();
#line 6121 "sudoku-board.c"
		}
	}
}


DifficultyCategory difficulty_category_from_string (const gchar* input) {
	DifficultyCategory result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label0 = 0;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label1 = 0;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label2 = 0;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label3 = 0;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label4 = 0;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label5 = 0;
#line 620 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (input != NULL, 0);
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = input;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Unknown Difficulty")))) {
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6156 "sudoku-board.c"
			default:
			{
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_UNKNOWN;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6163 "sudoku-board.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("Easy Difficulty")))) {
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6169 "sudoku-board.c"
			default:
			{
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_EASY;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6176 "sudoku-board.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("Medium Difficulty")))) {
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6182 "sudoku-board.c"
			default:
			{
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_MEDIUM;
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6189 "sudoku-board.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("Hard Difficulty")))) {
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6195 "sudoku-board.c"
			default:
			{
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_HARD;
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6202 "sudoku-board.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("Very Hard Difficulty")))) {
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6208 "sudoku-board.c"
			default:
			{
#line 633 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_VERY_HARD;
#line 633 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6215 "sudoku-board.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("Custom Puzzle")))) {
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6221 "sudoku-board.c"
			default:
			{
#line 635 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_CUSTOM;
#line 635 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6228 "sudoku-board.c"
			}
		}
	} else {
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6234 "sudoku-board.c"
			default:
			{
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				g_warning ("sudoku-board.vala:637: Could not parse difficulty level. Falling back " \
"to Easy difficulty");
#line 638 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_EASY;
#line 638 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6243 "sudoku-board.c"
			}
		}
	}
}


GType difficulty_category_get_type (void) {
	static volatile gsize difficulty_category_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_category_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_CATEGORY_UNKNOWN, "DIFFICULTY_CATEGORY_UNKNOWN", "unknown"}, {DIFFICULTY_CATEGORY_EASY, "DIFFICULTY_CATEGORY_EASY", "easy"}, {DIFFICULTY_CATEGORY_MEDIUM, "DIFFICULTY_CATEGORY_MEDIUM", "medium"}, {DIFFICULTY_CATEGORY_HARD, "DIFFICULTY_CATEGORY_HARD", "hard"}, {DIFFICULTY_CATEGORY_VERY_HARD, "DIFFICULTY_CATEGORY_VERY_HARD", "very-hard"}, {DIFFICULTY_CATEGORY_CUSTOM, "DIFFICULTY_CATEGORY_CUSTOM", "custom"}, {0, NULL, NULL}};
		GType difficulty_category_type_id;
		difficulty_category_type_id = g_enum_register_static ("DifficultyCategory", values);
		g_once_init_leave (&difficulty_category_type_id__volatile, difficulty_category_type_id);
	}
	return difficulty_category_type_id__volatile;
}



